/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.instructions.cp;

import org.apache.commons.lang.StringUtils;
import org.apache.sysml.api.DMLScript;
import org.apache.sysml.api.mlcontext.ScriptType;
import org.apache.sysml.parser.Expression;
import org.apache.sysml.runtime.instructions.cp.ScalarObject;

public class BooleanObject
extends ScalarObject {
    private static final long serialVersionUID = -4506242165735516984L;
    private boolean _value;

    public BooleanObject(boolean val) {
        this(null, val);
    }

    public BooleanObject(String name, boolean val) {
        super(name, Expression.ValueType.BOOLEAN);
        this._value = val;
    }

    @Override
    public boolean getBooleanValue() {
        return this._value;
    }

    @Override
    public long getLongValue() {
        return this._value ? 1L : 0L;
    }

    @Override
    public double getDoubleValue() {
        return this._value ? 1.0 : 0.0;
    }

    @Override
    public String getStringValue() {
        return Boolean.toString(this._value).toUpperCase();
    }

    @Override
    public String getLanguageSpecificStringValue() {
        return DMLScript.SCRIPT_TYPE == ScriptType.DML ? Boolean.toString(this._value).toUpperCase() : StringUtils.capitalize((String)Boolean.toString(this._value));
    }

    @Override
    public Object getValue() {
        return this._value;
    }
}

