/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.instructions.cp;

import org.apache.sysml.parser.Expression;
import org.apache.sysml.runtime.DMLRuntimeException;
import org.apache.sysml.runtime.compress.CompressedMatrixBlock;
import org.apache.sysml.runtime.controlprogram.context.ExecutionContext;
import org.apache.sysml.runtime.functionobjects.Multiply;
import org.apache.sysml.runtime.functionobjects.Plus;
import org.apache.sysml.runtime.instructions.InstructionUtils;
import org.apache.sysml.runtime.instructions.cp.BinaryCPInstruction;
import org.apache.sysml.runtime.instructions.cp.CPInstruction;
import org.apache.sysml.runtime.instructions.cp.CPOperand;
import org.apache.sysml.runtime.matrix.data.MatrixBlock;
import org.apache.sysml.runtime.matrix.operators.AggregateBinaryOperator;
import org.apache.sysml.runtime.matrix.operators.AggregateOperator;
import org.apache.sysml.runtime.matrix.operators.Operator;

public class AggregateBinaryCPInstruction
extends BinaryCPInstruction {
    private AggregateBinaryCPInstruction(Operator op, CPOperand in1, CPOperand in2, CPOperand out, String opcode, String istr) {
        super(op, in1, in2, out, opcode, istr);
        this._cptype = CPInstruction.CPINSTRUCTION_TYPE.AggregateBinary;
    }

    public static AggregateBinaryCPInstruction parseInstruction(String str) throws DMLRuntimeException {
        CPOperand in1 = new CPOperand("", Expression.ValueType.UNKNOWN, Expression.DataType.UNKNOWN);
        CPOperand in2 = new CPOperand("", Expression.ValueType.UNKNOWN, Expression.DataType.UNKNOWN);
        CPOperand out = new CPOperand("", Expression.ValueType.UNKNOWN, Expression.DataType.UNKNOWN);
        String[] parts = InstructionUtils.getInstructionPartsWithValueType(str);
        String opcode = parts[0];
        if (!opcode.equalsIgnoreCase("ba+*")) {
            throw new DMLRuntimeException("AggregateBinaryInstruction.parseInstruction():: Unknown opcode " + opcode);
        }
        InstructionUtils.checkNumFields(parts, 4);
        in1.split(parts[1]);
        in2.split(parts[2]);
        out.split(parts[3]);
        int k = Integer.parseInt(parts[4]);
        AggregateOperator agg = new AggregateOperator(0.0, Plus.getPlusFnObject());
        AggregateBinaryOperator aggbin = new AggregateBinaryOperator(Multiply.getMultiplyFnObject(), agg, k);
        return new AggregateBinaryCPInstruction(aggbin, in1, in2, out, opcode, str);
    }

    @Override
    public void processInstruction(ExecutionContext ec) throws DMLRuntimeException {
        MatrixBlock matBlock1 = ec.getMatrixInput(this.input1.getName(), this.getExtendedOpcode());
        MatrixBlock matBlock2 = ec.getMatrixInput(this.input2.getName(), this.getExtendedOpcode());
        AggregateBinaryOperator ab_op = (AggregateBinaryOperator)this._optr;
        MatrixBlock main = matBlock2 instanceof CompressedMatrixBlock ? matBlock2 : matBlock1;
        MatrixBlock ret = (MatrixBlock)main.aggregateBinaryOperations(matBlock1, matBlock2, new MatrixBlock(), ab_op);
        ec.releaseMatrixInput(this.input1.getName(), this.getExtendedOpcode());
        ec.releaseMatrixInput(this.input2.getName(), this.getExtendedOpcode());
        ec.setMatrixOutput(this.output.getName(), ret, this.getExtendedOpcode());
    }
}

