/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.functionobjects;

import java.util.HashMap;
import org.apache.commons.math3.distribution.ChiSquaredDistribution;
import org.apache.commons.math3.distribution.ExponentialDistribution;
import org.apache.commons.math3.distribution.FDistribution;
import org.apache.commons.math3.distribution.NormalDistribution;
import org.apache.commons.math3.distribution.TDistribution;
import org.apache.commons.math3.exception.MathArithmeticException;
import org.apache.sysml.runtime.DMLRuntimeException;
import org.apache.sysml.runtime.functionobjects.ValueFunction;
import org.apache.sysml.runtime.util.UtilFunctions;

public class ParameterizedBuiltin
extends ValueFunction {
    private static final long serialVersionUID = -5966242955816522697L;
    public ParameterizedBuiltinCode bFunc;
    public ProbabilityDistributionCode distFunc;
    public static HashMap<String, ParameterizedBuiltinCode> String2ParameterizedBuiltinCode = new HashMap();
    public static HashMap<String, ProbabilityDistributionCode> String2DistCode;
    private static ParameterizedBuiltin normalObj;
    private static ParameterizedBuiltin expObj;
    private static ParameterizedBuiltin chisqObj;
    private static ParameterizedBuiltin fObj;
    private static ParameterizedBuiltin tObj;
    private static ParameterizedBuiltin inormalObj;
    private static ParameterizedBuiltin iexpObj;
    private static ParameterizedBuiltin ichisqObj;
    private static ParameterizedBuiltin ifObj;
    private static ParameterizedBuiltin itObj;

    private ParameterizedBuiltin(ParameterizedBuiltinCode bf) {
        this.bFunc = bf;
        this.distFunc = ProbabilityDistributionCode.INVALID;
    }

    private ParameterizedBuiltin(ParameterizedBuiltinCode bf, ProbabilityDistributionCode dist) {
        this.bFunc = bf;
        this.distFunc = dist;
    }

    public static ParameterizedBuiltin getParameterizedBuiltinFnObject(String str) throws DMLRuntimeException {
        return ParameterizedBuiltin.getParameterizedBuiltinFnObject(str, null);
    }

    public static ParameterizedBuiltin getParameterizedBuiltinFnObject(String str, String str2) throws DMLRuntimeException {
        ParameterizedBuiltinCode code = String2ParameterizedBuiltinCode.get(str);
        switch (code) {
            case CDF: {
                ProbabilityDistributionCode dcode = String2DistCode.get(str2.toLowerCase());
                switch (dcode) {
                    case NORMAL: {
                        if (normalObj == null) {
                            normalObj = new ParameterizedBuiltin(ParameterizedBuiltinCode.CDF, dcode);
                        }
                        return normalObj;
                    }
                    case EXP: {
                        if (expObj == null) {
                            expObj = new ParameterizedBuiltin(ParameterizedBuiltinCode.CDF, dcode);
                        }
                        return expObj;
                    }
                    case CHISQ: {
                        if (chisqObj == null) {
                            chisqObj = new ParameterizedBuiltin(ParameterizedBuiltinCode.CDF, dcode);
                        }
                        return chisqObj;
                    }
                    case F: {
                        if (fObj == null) {
                            fObj = new ParameterizedBuiltin(ParameterizedBuiltinCode.CDF, dcode);
                        }
                        return fObj;
                    }
                    case T: {
                        if (tObj == null) {
                            tObj = new ParameterizedBuiltin(ParameterizedBuiltinCode.CDF, dcode);
                        }
                        return tObj;
                    }
                }
                throw new DMLRuntimeException("Invalid distribution code: " + (Object)((Object)dcode));
            }
            case INVCDF: {
                ProbabilityDistributionCode distcode = String2DistCode.get(str2.toLowerCase());
                switch (distcode) {
                    case NORMAL: {
                        if (inormalObj == null) {
                            inormalObj = new ParameterizedBuiltin(ParameterizedBuiltinCode.INVCDF, distcode);
                        }
                        return inormalObj;
                    }
                    case EXP: {
                        if (iexpObj == null) {
                            iexpObj = new ParameterizedBuiltin(ParameterizedBuiltinCode.INVCDF, distcode);
                        }
                        return iexpObj;
                    }
                    case CHISQ: {
                        if (ichisqObj == null) {
                            ichisqObj = new ParameterizedBuiltin(ParameterizedBuiltinCode.INVCDF, distcode);
                        }
                        return ichisqObj;
                    }
                    case F: {
                        if (ifObj == null) {
                            ifObj = new ParameterizedBuiltin(ParameterizedBuiltinCode.INVCDF, distcode);
                        }
                        return ifObj;
                    }
                    case T: {
                        if (itObj == null) {
                            itObj = new ParameterizedBuiltin(ParameterizedBuiltinCode.INVCDF, distcode);
                        }
                        return itObj;
                    }
                }
                throw new DMLRuntimeException("Invalid distribution code: " + (Object)((Object)distcode));
            }
            case RMEMPTY: {
                return new ParameterizedBuiltin(ParameterizedBuiltinCode.RMEMPTY);
            }
            case REPLACE: {
                return new ParameterizedBuiltin(ParameterizedBuiltinCode.REPLACE);
            }
            case REXPAND: {
                return new ParameterizedBuiltin(ParameterizedBuiltinCode.REXPAND);
            }
            case TRANSFORMAPPLY: {
                return new ParameterizedBuiltin(ParameterizedBuiltinCode.TRANSFORMAPPLY);
            }
            case TRANSFORMDECODE: {
                return new ParameterizedBuiltin(ParameterizedBuiltinCode.TRANSFORMDECODE);
            }
        }
        throw new DMLRuntimeException("Invalid parameterized builtin code: " + (Object)((Object)code));
    }

    @Override
    public double execute(HashMap<String, String> params) throws DMLRuntimeException {
        switch (this.bFunc) {
            case CDF: 
            case INVCDF: {
                switch (this.distFunc) {
                    case NORMAL: 
                    case EXP: 
                    case CHISQ: 
                    case F: 
                    case T: {
                        return this.computeFromDistribution(this.distFunc, params, this.bFunc == ParameterizedBuiltinCode.INVCDF);
                    }
                }
                throw new DMLRuntimeException("Unsupported distribution (" + (Object)((Object)this.distFunc) + ").");
            }
        }
        throw new DMLRuntimeException("ParameterizedBuiltin.execute(): Unknown operation: " + (Object)((Object)this.bFunc));
    }

    private double computeFromDistribution(ProbabilityDistributionCode dcode, HashMap<String, String> params, boolean inverse) throws MathArithmeticException, DMLRuntimeException {
        double val = Double.parseDouble(params.get("target"));
        boolean lowertail = true;
        if (params.get("lower.tail") != null) {
            lowertail = Boolean.parseBoolean(params.get("lower.tail"));
        }
        ExponentialDistribution distFunction = null;
        switch (dcode) {
            case NORMAL: {
                double mean = 0.0;
                double sd = 1.0;
                String mean_s = params.get("mean");
                String sd_s = params.get("sd");
                if (mean_s != null) {
                    mean = Double.parseDouble(mean_s);
                }
                if (sd_s != null) {
                    sd = Double.parseDouble(sd_s);
                }
                if (sd <= 0.0) {
                    throw new DMLRuntimeException("Standard deviation for Normal distribution must be positive (" + sd + ")");
                }
                distFunction = new NormalDistribution(mean, sd);
                break;
            }
            case EXP: {
                double exp_rate = 1.0;
                if (params.get("rate") != null) {
                    exp_rate = Double.parseDouble(params.get("rate"));
                }
                if (exp_rate <= 0.0) {
                    throw new DMLRuntimeException("Rate for Exponential distribution must be positive (" + exp_rate + ")");
                }
                distFunction = new ExponentialDistribution(1.0 / exp_rate);
                break;
            }
            case CHISQ: {
                if (params.get("df") == null) {
                    throw new DMLRuntimeException("Degrees of freedom must be specified for chi-squared distribution (e.g., q=qchisq(0.5, df=20); p=pchisq(target=q, df=1.2))");
                }
                int df = UtilFunctions.parseToInt(params.get("df"));
                if (df <= 0) {
                    throw new DMLRuntimeException("Degrees of Freedom for chi-squared distribution must be positive (" + df + ")");
                }
                distFunction = new ChiSquaredDistribution((double)df);
                break;
            }
            case F: {
                if (params.get("df1") == null || params.get("df2") == null) {
                    throw new DMLRuntimeException("Degrees of freedom must be specified for F distribution (e.g., q = qf(target=0.5, df1=20, df2=30); p=pf(target=q, df1=20, df2=30))");
                }
                int df1 = UtilFunctions.parseToInt(params.get("df1"));
                int df2 = UtilFunctions.parseToInt(params.get("df2"));
                if (df1 <= 0 || df2 <= 0) {
                    throw new DMLRuntimeException("Degrees of Freedom for F distribution must be positive (" + df1 + "," + df2 + ")");
                }
                distFunction = new FDistribution((double)df1, (double)df2);
                break;
            }
            case T: {
                if (params.get("df") == null) {
                    throw new DMLRuntimeException("Degrees of freedom is needed to compute probabilities from t distribution (e.g., q = qt(target=0.5, df=10); p = pt(target=q, df=10))");
                }
                int t_df = UtilFunctions.parseToInt(params.get("df"));
                if (t_df <= 0) {
                    throw new DMLRuntimeException("Degrees of Freedom for t distribution must be positive (" + t_df + ")");
                }
                distFunction = new TDistribution((double)t_df);
                break;
            }
            default: {
                throw new DMLRuntimeException("Invalid distribution code: " + (Object)((Object)dcode));
            }
        }
        double ret = Double.NaN;
        ret = inverse ? distFunction.inverseCumulativeProbability(val) : (lowertail ? distFunction.cumulativeProbability(val) : 1.0 - distFunction.cumulativeProbability(val));
        return ret;
    }

    static {
        String2ParameterizedBuiltinCode.put("cdf", ParameterizedBuiltinCode.CDF);
        String2ParameterizedBuiltinCode.put("invcdf", ParameterizedBuiltinCode.INVCDF);
        String2ParameterizedBuiltinCode.put("rmempty", ParameterizedBuiltinCode.RMEMPTY);
        String2ParameterizedBuiltinCode.put("replace", ParameterizedBuiltinCode.REPLACE);
        String2ParameterizedBuiltinCode.put("rexpand", ParameterizedBuiltinCode.REXPAND);
        String2ParameterizedBuiltinCode.put("transformapply", ParameterizedBuiltinCode.TRANSFORMAPPLY);
        String2ParameterizedBuiltinCode.put("transformdecode", ParameterizedBuiltinCode.TRANSFORMDECODE);
        String2DistCode = new HashMap();
        String2DistCode.put("normal", ProbabilityDistributionCode.NORMAL);
        String2DistCode.put("exp", ProbabilityDistributionCode.EXP);
        String2DistCode.put("chisq", ProbabilityDistributionCode.CHISQ);
        String2DistCode.put("f", ProbabilityDistributionCode.F);
        String2DistCode.put("t", ProbabilityDistributionCode.T);
        normalObj = null;
        expObj = null;
        chisqObj = null;
        fObj = null;
        tObj = null;
        inormalObj = null;
        iexpObj = null;
        ichisqObj = null;
        ifObj = null;
        itObj = null;
    }

    public static enum ProbabilityDistributionCode {
        INVALID,
        NORMAL,
        EXP,
        CHISQ,
        F,
        T;

    }

    public static enum ParameterizedBuiltinCode {
        CDF,
        INVCDF,
        RMEMPTY,
        REPLACE,
        REXPAND,
        TRANSFORMAPPLY,
        TRANSFORMDECODE;

    }
}

