/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.controlprogram.parfor;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.hadoop.io.Writable;
import org.apache.spark.TaskContext;
import org.apache.spark.api.java.function.PairFlatMapFunction;
import org.apache.spark.util.LongAccumulator;
import org.apache.sysml.runtime.DMLRuntimeException;
import org.apache.sysml.runtime.codegen.CodegenUtils;
import org.apache.sysml.runtime.controlprogram.ParForProgramBlock;
import org.apache.sysml.runtime.controlprogram.caching.CacheableData;
import org.apache.sysml.runtime.controlprogram.caching.MatrixObject;
import org.apache.sysml.runtime.controlprogram.parfor.ParForBody;
import org.apache.sysml.runtime.controlprogram.parfor.ParWorker;
import org.apache.sysml.runtime.controlprogram.parfor.ProgramConverter;
import org.apache.sysml.runtime.controlprogram.parfor.RemoteParForUtils;
import org.apache.sysml.runtime.controlprogram.parfor.Task;
import org.apache.sysml.runtime.controlprogram.parfor.stat.InfrastructureAnalyzer;
import org.apache.sysml.runtime.controlprogram.parfor.util.IDHandler;
import org.apache.sysml.runtime.controlprogram.parfor.util.PairWritableBlock;
import org.apache.sysml.runtime.controlprogram.parfor.util.PairWritableCell;
import org.apache.sysml.runtime.instructions.cp.IntObject;
import org.apache.sysml.runtime.matrix.MatrixCharacteristics;
import org.apache.sysml.runtime.matrix.data.MatrixBlock;
import org.apache.sysml.runtime.matrix.data.OutputInfo;
import org.apache.sysml.runtime.util.LocalFileUtils;
import scala.Tuple2;

public class RemoteDPParForSparkWorker
extends ParWorker
implements PairFlatMapFunction<Iterator<Tuple2<Long, Iterable<Writable>>>, Long, String> {
    private static final long serialVersionUID = 30223759283155139L;
    private final String _prog;
    private final HashMap<String, byte[]> _clsMap;
    private final boolean _caching;
    private final String _inputVar;
    private final String _iterVar;
    private final OutputInfo _oinfo;
    private final int _rlen;
    private final int _clen;
    private final int _brlen;
    private final int _bclen;
    private final boolean _tSparseCol;
    private final ParForProgramBlock.PDataPartitionFormat _dpf;
    private final LongAccumulator _aTasks;
    private final LongAccumulator _aIters;

    public RemoteDPParForSparkWorker(String program, HashMap<String, byte[]> clsMap, String inputVar, String iterVar, boolean cpCaching, MatrixCharacteristics mc, boolean tSparseCol, ParForProgramBlock.PartitionFormat dpf, OutputInfo oinfo, LongAccumulator atasks, LongAccumulator aiters) throws DMLRuntimeException {
        this._prog = program;
        this._clsMap = clsMap;
        this._caching = cpCaching;
        this._inputVar = inputVar;
        this._iterVar = iterVar;
        this._oinfo = oinfo;
        this._aTasks = atasks;
        this._aIters = aiters;
        this._rlen = (int)dpf.getNumRows(mc);
        this._clen = (int)dpf.getNumColumns(mc);
        this._brlen = mc.getRowsPerBlock();
        this._bclen = mc.getColsPerBlock();
        this._tSparseCol = tSparseCol;
        this._dpf = dpf._dpf;
    }

    public Iterator<Tuple2<Long, String>> call(Iterator<Tuple2<Long, Iterable<Writable>>> arg0) throws Exception {
        ArrayList<Tuple2> ret = new ArrayList<Tuple2>();
        this.configureWorker(TaskContext.get().taskAttemptId());
        MatrixBlock partition = null;
        while (arg0.hasNext()) {
            Tuple2<Long, Iterable<Writable>> larg = arg0.next();
            partition = this._oinfo.equals(OutputInfo.BinaryBlockOutputInfo) ? this.collectBinaryBlock((Iterable)larg._2(), partition) : this.collectBinaryCellInput((Iterable)larg._2());
            MatrixObject mo = this._ec.getMatrixObject(this._inputVar);
            mo.setInMemoryPartition(partition);
            Task lTask = new Task(Task.TaskType.SET);
            lTask.addIteration(new IntObject(this._iterVar, (Long)larg._1()));
            long numIter = this.getExecutedIterations();
            super.executeTask(lTask);
            this._aTasks.add(1L);
            this._aIters.add((long)((int)(this.getExecutedIterations() - numIter)));
        }
        ArrayList<String> tmp = RemoteParForUtils.exportResultVariables(this._workerID, this._ec.getVariables(), this._resultVars);
        for (String val : tmp) {
            ret.add(new Tuple2((Object)this._workerID, (Object)val));
        }
        return ret.iterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void configureWorker(long ID) throws DMLRuntimeException, IOException {
        this._workerID = ID;
        Class<CodegenUtils> clazz = CodegenUtils.class;
        synchronized (CodegenUtils.class) {
            for (Map.Entry<String, byte[]> e : this._clsMap.entrySet()) {
                CodegenUtils.getClass(e.getKey(), e.getValue());
            }
            // ** MonitorExit[var3_2] (shouldn't be in output)
            ParForBody body = ProgramConverter.parseParForBody(this._prog, (int)this._workerID);
            this._childBlocks = body.getChildBlocks();
            this._ec = body.getEc();
            this._resultVars = body.getResultVarNames();
            this._numTasks = 0L;
            this._numIters = 0L;
            Class<CacheableData> clazz2 = CacheableData.class;
            synchronized (CacheableData.class) {
                if (!CacheableData.isCachingActive() && !InfrastructureAnalyzer.isLocalMode()) {
                    String uuid = IDHandler.createDistributedUniqueID();
                    LocalFileUtils.createWorkingDirectoryWithUUID(uuid);
                    CacheableData.initCaching(uuid);
                    CacheableData.cacheEvictionLocalFilePrefix = CacheableData.cacheEvictionLocalFilePrefix + "_" + this._workerID;
                    RemoteParForUtils.cleanupWorkingDirectoriesOnShutdown();
                }
                // ** MonitorExit[var4_3] (shouldn't be in output)
                super.pinResultVariables();
                if (!this._caching && !InfrastructureAnalyzer.isLocalMode()) {
                    CacheableData.disableCaching();
                }
                return;
            }
        }
    }

    private MatrixBlock collectBinaryBlock(Iterable<Writable> valueList, MatrixBlock reuse) throws IOException {
        if (valueList instanceof Collection && ((Collection)valueList).size() == 1) {
            return ((PairWritableBlock)valueList.iterator().next()).block;
        }
        MatrixBlock partition = reuse;
        try {
            if (this._tSparseCol) {
                partition = new MatrixBlock(this._clen, this._rlen, true);
            } else if (partition != null) {
                partition.reset(this._rlen, this._clen, false);
            } else {
                partition = new MatrixBlock(this._rlen, this._clen, false);
            }
            long lnnz = 0L;
            for (Writable val : valueList) {
                PairWritableBlock pval = (PairWritableBlock)val;
                int row_offset = (int)(pval.indexes.getRowIndex() - 1L) * this._brlen;
                int col_offset = (int)(pval.indexes.getColumnIndex() - 1L) * this._bclen;
                if (!partition.isInSparseFormat()) {
                    partition.copy(row_offset, row_offset + pval.block.getNumRows() - 1, col_offset, col_offset + pval.block.getNumColumns() - 1, pval.block, false);
                } else {
                    partition.appendToSparse(pval.block, row_offset, col_offset);
                }
                lnnz += pval.block.getNonZeros();
            }
            if (partition.isInSparseFormat() && this._clen > this._bclen) {
                partition.sortSparseRows();
            }
            partition.setNonZeros(lnnz);
            partition.examSparsity();
        }
        catch (DMLRuntimeException ex) {
            throw new IOException(ex);
        }
        return partition;
    }

    private MatrixBlock collectBinaryCellInput(Iterable<Writable> valueList) throws IOException {
        MatrixBlock partition = null;
        partition = this._tSparseCol ? new MatrixBlock(this._clen, this._rlen, true) : new MatrixBlock(this._rlen, this._clen, false);
        switch (this._dpf) {
            case ROW_WISE: {
                PairWritableCell pairValue;
                while (valueList.iterator().hasNext()) {
                    pairValue = (PairWritableCell)valueList.iterator().next();
                    if (pairValue.indexes.getColumnIndex() < 0L) continue;
                    partition.quickSetValue(0, (int)pairValue.indexes.getColumnIndex() - 1, pairValue.cell.getValue());
                }
                break;
            }
            case COLUMN_WISE: {
                PairWritableCell pairValue;
                while (valueList.iterator().hasNext()) {
                    pairValue = (PairWritableCell)valueList.iterator().next();
                    if (pairValue.indexes.getRowIndex() < 0L) continue;
                    if (this._tSparseCol) {
                        partition.appendValue(0, (int)pairValue.indexes.getRowIndex() - 1, pairValue.cell.getValue());
                        continue;
                    }
                    partition.quickSetValue((int)pairValue.indexes.getRowIndex() - 1, 0, pairValue.cell.getValue());
                }
                break;
            }
            default: {
                throw new IOException("Partition format not yet supported in fused partition-execute: " + (Object)((Object)this._dpf));
            }
        }
        try {
            if (partition.isInSparseFormat() && this._tSparseCol) {
                partition.sortSparseRows();
            }
            partition.recomputeNonZeros();
            partition.examSparsity();
        }
        catch (DMLRuntimeException ex) {
            throw new IOException(ex);
        }
        return partition;
    }
}

