/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.controlprogram;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.sysml.runtime.DMLRuntimeException;
import org.apache.sysml.runtime.controlprogram.parfor.ProgramConverter;
import org.apache.sysml.runtime.controlprogram.parfor.util.IDSequence;
import org.apache.sysml.runtime.instructions.cp.Data;

public class LocalVariableMap
implements Cloneable {
    private static String eol = System.getProperty("line.separator");
    private static String ELEMENT_DELIM = "\u236a";
    private static IDSequence _seq = new IDSequence();
    private HashMap<String, Data> localMap = null;
    private final long localID;

    public LocalVariableMap() {
        this.localMap = new HashMap();
        this.localID = _seq.getNextID();
    }

    public LocalVariableMap(LocalVariableMap vars) {
        this.localMap = new HashMap<String, Data>(vars.localMap);
        this.localID = _seq.getNextID();
    }

    public Set<String> keySet() {
        return this.localMap.keySet();
    }

    public Data get(String name) {
        return this.localMap.get(name);
    }

    public void put(String name, Data val) {
        this.localMap.put(name, val);
    }

    public void putAll(Map<String, Data> vals) {
        this.localMap.putAll(vals);
    }

    public Data remove(String name) {
        return this.localMap.remove(name);
    }

    public void removeAll() {
        this.localMap.clear();
    }

    public void removeAllIn(Set<String> blacklist) {
        this.localMap.entrySet().removeIf(e -> blacklist.contains(e.getKey()));
    }

    public void removeAllNotIn(Set<String> blacklist) {
        this.localMap.entrySet().removeIf(e -> !blacklist.contains(e.getKey()));
    }

    public boolean hasReferences(Data d) {
        return this.localMap.containsValue(d);
    }

    public String serialize() throws DMLRuntimeException {
        StringBuilder sb = new StringBuilder();
        int count = 0;
        for (Map.Entry<String, Data> e : this.localMap.entrySet()) {
            if (count != 0) {
                sb.append(ELEMENT_DELIM);
            }
            sb.append(ProgramConverter.serializeDataObject(e.getKey(), e.getValue()));
            ++count;
        }
        return sb.toString();
    }

    public static LocalVariableMap deserialize(String varStr) throws DMLRuntimeException {
        StringTokenizer st2 = new StringTokenizer(varStr, ELEMENT_DELIM);
        LocalVariableMap vars = new LocalVariableMap();
        while (st2.hasMoreTokens()) {
            String tmp = st2.nextToken().trim();
            Object[] tmp2 = ProgramConverter.parseDataObject(tmp);
            vars.put((String)tmp2[0], (Data)tmp2[1]);
        }
        return vars;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Local Variable Map ID = \"");
        sb.append(this.localID);
        sb.append("\":");
        sb.append(eol);
        for (Map.Entry<String, Data> pair : this.localMap.entrySet()) {
            sb.append("  ");
            sb.append(pair.getKey());
            sb.append(" = ");
            sb.append(pair.getValue());
            sb.append(eol);
        }
        return sb.toString();
    }

    public Object clone() {
        return new LocalVariableMap(this);
    }
}

