/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.controlprogram;

import java.util.ArrayList;
import java.util.Iterator;
import org.apache.sysml.api.DMLScript;
import org.apache.sysml.hops.Hop;
import org.apache.sysml.parser.Expression;
import org.apache.sysml.parser.ForStatementBlock;
import org.apache.sysml.runtime.DMLRuntimeException;
import org.apache.sysml.runtime.DMLScriptException;
import org.apache.sysml.runtime.controlprogram.Program;
import org.apache.sysml.runtime.controlprogram.ProgramBlock;
import org.apache.sysml.runtime.controlprogram.caching.MatrixObject;
import org.apache.sysml.runtime.controlprogram.context.ExecutionContext;
import org.apache.sysml.runtime.instructions.Instruction;
import org.apache.sysml.runtime.instructions.cp.IntObject;
import org.apache.sysml.runtime.instructions.cp.ScalarObject;
import org.apache.sysml.yarn.DMLAppMasterUtils;

public class ForProgramBlock
extends ProgramBlock {
    protected ArrayList<Instruction> _fromInstructions;
    protected ArrayList<Instruction> _toInstructions;
    protected ArrayList<Instruction> _incrementInstructions;
    protected ArrayList<Instruction> _exitInstructions = new ArrayList();
    protected ArrayList<ProgramBlock> _childBlocks = new ArrayList();
    protected String _iterPredVar;

    public ForProgramBlock(Program prog, String iterPredVar) {
        super(prog);
        this._iterPredVar = iterPredVar;
    }

    public ArrayList<Instruction> getFromInstructions() {
        return this._fromInstructions;
    }

    public void setFromInstructions(ArrayList<Instruction> instructions) {
        this._fromInstructions = instructions;
    }

    public ArrayList<Instruction> getToInstructions() {
        return this._toInstructions;
    }

    public void setToInstructions(ArrayList<Instruction> instructions) {
        this._toInstructions = instructions;
    }

    public ArrayList<Instruction> getIncrementInstructions() {
        return this._incrementInstructions;
    }

    public void setIncrementInstructions(ArrayList<Instruction> instructions) {
        this._incrementInstructions = instructions;
    }

    public ArrayList<Instruction> getExitInstructions() {
        return this._exitInstructions;
    }

    public void setExitInstructions(ArrayList<Instruction> inst) {
        this._exitInstructions = inst;
    }

    public void addProgramBlock(ProgramBlock childBlock) {
        this._childBlocks.add(childBlock);
    }

    public ArrayList<ProgramBlock> getChildBlocks() {
        return this._childBlocks;
    }

    public void setChildBlocks(ArrayList<ProgramBlock> pbs) {
        this._childBlocks = pbs;
    }

    public String getIterVar() {
        return this._iterPredVar;
    }

    public void setIterVar(String iterPredVar) {
        this._iterPredVar = iterPredVar;
    }

    @Override
    public void execute(ExecutionContext ec) throws DMLRuntimeException {
        IntObject incr;
        IntObject from = this.executePredicateInstructions(1, this._fromInstructions, ec);
        IntObject to = this.executePredicateInstructions(2, this._toInstructions, ec);
        IntObject intObject = this._incrementInstructions == null || this._incrementInstructions.isEmpty() ? new IntObject(from.getLongValue() <= to.getLongValue() ? 1L : -1L) : (incr = this.executePredicateInstructions(3, this._incrementInstructions, ec));
        if (incr.getLongValue() == 0L) {
            throw new DMLRuntimeException(this.printBlockErrorLocation() + "Expression for increment of variable '" + this._iterPredVar + "' must evaluate to a non-zero value.");
        }
        try {
            MatrixObject.UpdateType[] flags = this.prepareUpdateInPlaceVariables(ec, this._tid);
            SequenceIterator seqIter = new SequenceIterator(this._iterPredVar, from, to, incr);
            for (IntObject iterVar : seqIter) {
                ec.setVariable(this._iterPredVar, iterVar);
                for (int i = 0; i < this._childBlocks.size(); ++i) {
                    ec.updateDebugState(i);
                    this._childBlocks.get(i).execute(ec);
                }
            }
            this.resetUpdateInPlaceVariableFlags(ec, flags);
        }
        catch (DMLScriptException e) {
            throw e;
        }
        catch (Exception e) {
            throw new DMLRuntimeException(this.printBlockErrorLocation() + "Error evaluating for program block", e);
        }
        try {
            this.executeInstructions(this._exitInstructions, ec);
        }
        catch (Exception e) {
            throw new DMLRuntimeException(this.printBlockErrorLocation() + "Error evaluating for exit instructions", e);
        }
    }

    protected IntObject executePredicateInstructions(int pos, ArrayList<Instruction> instructions, ExecutionContext ec) throws DMLRuntimeException {
        IntObject tmp = null;
        IntObject ret = null;
        try {
            if (this._sb != null) {
                if (DMLScript.isActiveAM()) {
                    DMLAppMasterUtils.setupProgramBlockRemoteMaxMemory(this);
                }
                ForStatementBlock fsb = (ForStatementBlock)this._sb;
                Hop predHops = null;
                boolean recompile = false;
                if (pos == 1) {
                    predHops = fsb.getFromHops();
                    recompile = fsb.requiresFromRecompilation();
                } else if (pos == 2) {
                    predHops = fsb.getToHops();
                    recompile = fsb.requiresToRecompilation();
                } else if (pos == 3) {
                    predHops = fsb.getIncrementHops();
                    recompile = fsb.requiresIncrementRecompilation();
                }
                tmp = (IntObject)this.executePredicate(instructions, predHops, recompile, Expression.ValueType.INT, ec);
            } else {
                tmp = (IntObject)this.executePredicate(instructions, null, false, Expression.ValueType.INT, ec);
            }
        }
        catch (Exception ex) {
            String predNameStr = null;
            if (pos == 1) {
                predNameStr = "from";
            } else if (pos == 2) {
                predNameStr = "to";
            } else if (pos == 3) {
                predNameStr = "increment";
            }
            throw new DMLRuntimeException(this.printBlockErrorLocation() + "Error evaluating '" + predNameStr + "' predicate", ex);
        }
        ret = tmp instanceof IntObject ? tmp : new IntObject(tmp.getName(), ((ScalarObject)tmp).getLongValue());
        return ret;
    }

    @Override
    public String printBlockErrorLocation() {
        return "ERROR: Runtime error in for program block generated from for statement block between lines " + this._beginLine + " and " + this._endLine + " -- ";
    }

    protected class SequenceIterator
    implements Iterator<IntObject>,
    Iterable<IntObject> {
        private String _varName = null;
        private long _cur = -1L;
        private long _to = -1L;
        private long _incr = -1L;
        private boolean _inuse = false;

        protected SequenceIterator(String varName, IntObject from, IntObject to, IntObject incr) {
            this._varName = varName;
            this._cur = from.getLongValue();
            this._to = to.getLongValue();
            this._incr = incr.getLongValue();
        }

        @Override
        public boolean hasNext() {
            return this._incr > 0L ? this._cur <= this._to : this._cur >= this._to;
        }

        @Override
        public IntObject next() {
            IntObject ret = new IntObject(this._varName, this._cur);
            this._cur += this._incr;
            return ret;
        }

        @Override
        public Iterator<IntObject> iterator() {
            if (this._inuse) {
                throw new RuntimeException("Unsupported reuse of iterator.");
            }
            this._inuse = true;
            return this;
        }

        @Override
        public void remove() {
            throw new RuntimeException("Unsupported remove on iterator.");
        }
    }
}

