/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.controlprogram;

import java.util.ArrayList;
import java.util.HashMap;
import org.apache.sysml.conf.ConfigurationManager;
import org.apache.sysml.parser.DataIdentifier;
import org.apache.sysml.parser.Expression;
import org.apache.sysml.runtime.DMLRuntimeException;
import org.apache.sysml.runtime.controlprogram.ExternalFunctionProgramBlock;
import org.apache.sysml.runtime.controlprogram.Program;
import org.apache.sysml.runtime.controlprogram.caching.MatrixObject;
import org.apache.sysml.runtime.controlprogram.context.ExecutionContext;
import org.apache.sysml.runtime.controlprogram.parfor.util.IDSequence;
import org.apache.sysml.runtime.matrix.MatrixCharacteristics;
import org.apache.sysml.runtime.matrix.MatrixFormatMetaData;
import org.apache.sysml.runtime.matrix.data.InputInfo;
import org.apache.sysml.runtime.matrix.data.OutputInfo;
import org.apache.sysml.udf.ExternalFunctionInvocationInstruction;
import org.apache.sysml.udf.Matrix;

public class ExternalFunctionProgramBlockCP
extends ExternalFunctionProgramBlock {
    public static String DEFAULT_FILENAME = "ext_funct";
    private static IDSequence _defaultSeq = new IDSequence();

    public ExternalFunctionProgramBlockCP(Program prog, ArrayList<DataIdentifier> inputParams, ArrayList<DataIdentifier> outputParams, HashMap<String, String> otherParams, String baseDir) throws DMLRuntimeException {
        super(prog, inputParams, outputParams, baseDir);
        this._otherParams = new HashMap();
        this._otherParams.putAll(otherParams);
        this.createInstructions();
    }

    @Override
    public void execute(ExecutionContext ec) throws DMLRuntimeException {
        this._runID = _idSeq.getNextID();
        ExternalFunctionInvocationInstruction inst = null;
        for (int i = 0; i < this._inst.size(); ++i) {
            try {
                inst = (ExternalFunctionInvocationInstruction)this._inst.get(i);
                inst._namespace = this._namespace;
                inst._functionName = this._functionName;
                this.executeInstruction(ec, inst);
                continue;
            }
            catch (Exception e) {
                throw new DMLRuntimeException(this.printBlockErrorLocation() + "Error evaluating instruction " + i + " in external function programBlock. inst: " + inst.toString(), e);
            }
        }
        this.checkOutputParameters(ec.getVariables());
    }

    @Override
    public void executeInstruction(ExecutionContext ec, ExternalFunctionInvocationInstruction inst) throws DMLRuntimeException {
        super.executeInstruction(ec, inst);
    }

    @Override
    protected void createInstructions() {
        this._inst = new ArrayList();
        String className = (String)this._otherParams.get("classname");
        String configFile = (String)this._otherParams.get("configfile");
        if (className == null) {
            throw new RuntimeException(this.printBlockErrorLocation() + "classname" + " not provided!");
        }
        String inputParameterString = this.getParameterString(this.getInputParams());
        String outputParameterString = this.getParameterString(this.getOutputParams());
        ExternalFunctionInvocationInstruction einst = new ExternalFunctionInvocationInstruction(className, configFile, inputParameterString, outputParameterString);
        this._inst.add(einst);
    }

    @Override
    protected void modifyInputMatrix(Matrix m, MatrixObject mobj) {
        m.setMatrixObject(mobj);
    }

    @Override
    protected MatrixObject createOutputMatrixObject(Matrix m) {
        MatrixObject ret = m.getMatrixObject();
        if (ret == null) {
            MatrixCharacteristics mc = new MatrixCharacteristics(m.getNumRows(), m.getNumCols(), ConfigurationManager.getBlocksize(), ConfigurationManager.getBlocksize());
            MatrixFormatMetaData mfmd = new MatrixFormatMetaData(mc, OutputInfo.BinaryBlockOutputInfo, InputInfo.BinaryBlockInputInfo);
            ret = new MatrixObject(Expression.ValueType.DOUBLE, m.getFilePath(), mfmd);
        }
        if (ret.getFileName().equals(DEFAULT_FILENAME)) {
            ret.setFileName(this.createDefaultOutputFilePathAndName());
        }
        return ret;
    }

    public String createDefaultOutputFilePathAndName() {
        return this._baseDir + DEFAULT_FILENAME + _defaultSeq.getNextID();
    }

    @Override
    public String printBlockErrorLocation() {
        return "ERROR: Runtime error in external function program block (for CP) generated from external function statement block between lines " + this._beginLine + " and " + this._endLine + " -- ";
    }
}

