/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.codegen;

import java.io.Serializable;
import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.sysml.runtime.DMLRuntimeException;
import org.apache.sysml.runtime.codegen.LibSpoofPrimitives;
import org.apache.sysml.runtime.compress.CompressedMatrixBlock;
import org.apache.sysml.runtime.instructions.cp.ScalarObject;
import org.apache.sysml.runtime.matrix.data.LibMatrixReorg;
import org.apache.sysml.runtime.matrix.data.MatrixBlock;
import org.apache.sysml.runtime.util.DataConverter;
import org.apache.sysml.runtime.util.UtilFunctions;

public abstract class SpoofOperator
implements Serializable {
    private static final long serialVersionUID = 3834006998853573319L;
    private static final Log LOG = LogFactory.getLog((String)SpoofOperator.class.getName());
    protected static final long PAR_NUMCELL_THRESHOLD = 0x100000L;
    protected static final long PAR_MINFLOP_THRESHOLD = 0x200000L;

    public abstract MatrixBlock execute(ArrayList<MatrixBlock> var1, ArrayList<ScalarObject> var2, MatrixBlock var3) throws DMLRuntimeException;

    public MatrixBlock execute(ArrayList<MatrixBlock> inputs, ArrayList<ScalarObject> scalars, MatrixBlock out, int k) throws DMLRuntimeException {
        return this.execute(inputs, scalars, out);
    }

    public abstract String getSpoofType();

    public ScalarObject execute(ArrayList<MatrixBlock> inputs, ArrayList<ScalarObject> scalars) throws DMLRuntimeException {
        throw new RuntimeException("Invalid invocation in base class.");
    }

    public ScalarObject execute(ArrayList<MatrixBlock> inputs, ArrayList<ScalarObject> scalars, int k) throws DMLRuntimeException {
        return this.execute(inputs, scalars);
    }

    protected SideInput[] prepInputMatrices(ArrayList<MatrixBlock> inputs) throws DMLRuntimeException {
        return this.prepInputMatrices(inputs, 1, inputs.size() - 1, false, false);
    }

    protected SideInput[] prepInputMatrices(ArrayList<MatrixBlock> inputs, boolean denseOnly) throws DMLRuntimeException {
        return this.prepInputMatrices(inputs, 1, inputs.size() - 1, denseOnly, false);
    }

    protected SideInput[] prepInputMatrices(ArrayList<MatrixBlock> inputs, int offset, boolean denseOnly) throws DMLRuntimeException {
        return this.prepInputMatrices(inputs, offset, inputs.size() - offset, denseOnly, false);
    }

    protected SideInput[] prepInputMatrices(ArrayList<MatrixBlock> inputs, boolean denseOnly, boolean tB1) throws DMLRuntimeException {
        return this.prepInputMatrices(inputs, 1, inputs.size() - 1, denseOnly, tB1);
    }

    protected SideInput[] prepInputMatrices(ArrayList<MatrixBlock> inputs, int offset, int len, boolean denseOnly, boolean tB1) throws DMLRuntimeException {
        SideInput[] b = new SideInput[len];
        for (int i = offset; i < offset + len; ++i) {
            MatrixBlock in;
            if (inputs.get(i) instanceof CompressedMatrixBlock) {
                inputs.set(i, ((CompressedMatrixBlock)inputs.get(i)).decompress());
            }
            int clen = inputs.get(i).getNumColumns();
            MatrixBlock matrixBlock = in = tB1 && i == 1 ? LibMatrixReorg.transpose(inputs.get(i), new MatrixBlock(clen, inputs.get(i).getNumRows(), false)) : inputs.get(i);
            if (denseOnly && (in.isInSparseFormat() || !in.isAllocated())) {
                if (in.getNumColumns() == 1 && in.isEmptyBlock(false)) {
                    b[i - offset] = new SideInput(null, null, clen);
                    continue;
                }
                b[i - offset] = new SideInput(DataConverter.convertToDoubleVector(in), null, clen);
                LOG.warn((Object)(this.getClass().getName() + ": Converted " + in.getNumRows() + "x" + in.getNumColumns() + ", nnz=" + in.getNonZeros() + " sideways input matrix from sparse to dense."));
                continue;
            }
            b[i - offset] = in.isInSparseFormat() && in.isAllocated() ? new SideInput(null, in, clen) : new SideInput(in.getDenseBlock(), null, clen);
        }
        return b;
    }

    protected static SideInput[] createSparseSideInputs(SideInput[] input) {
        boolean containsSparse = false;
        for (int i = 0; i < input.length; ++i) {
            SideInput tmp = input[i];
            containsSparse |= tmp.mdat != null && tmp.mdat.isInSparseFormat() && !tmp.mdat.isEmptyBlock(false) && tmp.clen > 1;
        }
        if (!containsSparse) {
            return input;
        }
        SideInput[] ret = new SideInput[input.length];
        for (int i = 0; i < input.length; ++i) {
            SideInput tmp = input[i];
            ret[i] = tmp.mdat != null && tmp.mdat.isInSparseFormat() && !tmp.mdat.isEmptyBlock(false) && tmp.clen > 1 ? new SideInputSparse(tmp) : tmp;
        }
        return ret;
    }

    public static double[][] getDenseMatrices(SideInput[] inputs) {
        double[][] ret = new double[inputs.length][];
        for (int i = 0; i < inputs.length; ++i) {
            ret[i] = inputs[i].ddat;
        }
        return ret;
    }

    protected static double[] prepInputScalars(ArrayList<ScalarObject> scalarObjects) {
        double[] scalars = new double[scalarObjects.size()];
        for (int i = 0; i < scalarObjects.size(); ++i) {
            scalars[i] = scalarObjects.get(i).getDoubleValue();
        }
        return scalars;
    }

    public static long getTotalInputNnz(ArrayList<MatrixBlock> inputs) {
        return inputs.stream().mapToLong(in -> in.getNonZeros()).sum();
    }

    protected static double getValue(double[] data, double index) {
        int iindex = UtilFunctions.toInt(index);
        return SpoofOperator.getValue(data, iindex);
    }

    protected static double getValue(double[] data, int index) {
        return data != null ? data[index] : 0.0;
    }

    protected static double getValue(double[] data, int n, double rowIndex, double colIndex) {
        int irowIndex = UtilFunctions.toInt(rowIndex);
        int icolIndex = UtilFunctions.toInt(colIndex);
        return SpoofOperator.getValue(data, n, irowIndex, icolIndex);
    }

    protected static double getValue(double[] data, int n, int rowIndex, int colIndex) {
        return data != null ? data[rowIndex * n + colIndex] : 0.0;
    }

    protected static double getValue(SideInput data, double rowIndex) {
        int irowIndex = UtilFunctions.toInt(rowIndex);
        return SpoofOperator.getValue(data, irowIndex);
    }

    protected static double getValue(SideInput data, int rowIndex) {
        return data.ddat != null ? data.ddat[rowIndex] : (data.mdat != null ? data.mdat.quickGetValue(rowIndex, 0) : 0.0);
    }

    protected static double getValue(SideInput data, int n, double rowIndex, double colIndex) {
        int irowIndex = UtilFunctions.toInt(rowIndex);
        int icolIndex = UtilFunctions.toInt(colIndex);
        return SpoofOperator.getValue(data, n, irowIndex, icolIndex);
    }

    protected static double getValue(SideInput data, int n, int rowIndex, int colIndex) {
        return data.ddat != null ? data.ddat[rowIndex * n + colIndex] : (data instanceof SideInputSparse ? ((SideInputSparse)data).next(rowIndex, colIndex) : (data.mdat != null ? data.mdat.quickGetValue(rowIndex, colIndex) : 0.0));
    }

    protected static double[] getVector(SideInput data, int n, double rowIndex, double colIndex) {
        int irowIndex = UtilFunctions.toInt(rowIndex);
        int icolIndex = UtilFunctions.toInt(colIndex);
        return SpoofOperator.getVector(data, n, irowIndex, icolIndex);
    }

    protected static double[] getVector(SideInput data, int n, int rowIndex, int colIndex) {
        double[] c = LibSpoofPrimitives.allocVector(colIndex + 1, false);
        System.arraycopy(data.ddat, rowIndex * n, c, 0, colIndex + 1);
        return c;
    }

    public static class SideInputSparse
    extends SideInput {
        private int currRowIndex = -1;
        private int currColPos = 0;
        private int currLen = 0;
        private int[] indexes;
        private double[] values;

        public SideInputSparse(SideInput in) {
            super(in.ddat, in.mdat, in.clen);
        }

        public double next(int rowIndex, int colIndex) {
            if (this.mdat.getSparseBlock().isEmpty(rowIndex)) {
                return 0.0;
            }
            if (rowIndex > this.currRowIndex) {
                this.currRowIndex = rowIndex;
                this.currColPos = this.mdat.getSparseBlock().pos(this.currRowIndex);
                this.currLen = this.mdat.getSparseBlock().size(this.currRowIndex) + this.currColPos;
                this.indexes = this.mdat.getSparseBlock().indexes(this.currRowIndex);
                this.values = this.mdat.getSparseBlock().values(this.currRowIndex);
            }
            while (this.currColPos < this.currLen && this.indexes[this.currColPos] < colIndex) {
                ++this.currColPos;
            }
            return this.currColPos < this.currLen && this.indexes[this.currColPos] == colIndex ? this.values[this.currColPos] : 0.0;
        }
    }

    public static class SideInput {
        public final double[] ddat;
        public final MatrixBlock mdat;
        public final int clen;

        public SideInput(double[] ddata, MatrixBlock mdata, int clength) {
            this.ddat = ddata;
            this.mdat = mdata;
            this.clen = clength;
        }
    }
}

