/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.lops;

import org.apache.sysml.lops.Lop;
import org.apache.sysml.lops.LopProperties;
import org.apache.sysml.lops.LopsException;
import org.apache.sysml.lops.compile.JobType;
import org.apache.sysml.parser.Expression;

public class LeftIndex
extends Lop {
    private LixCacheType _type;

    public LeftIndex(Lop lhsInput, Lop rhsInput, Lop rowL, Lop rowU, Lop colL, Lop colU, Expression.DataType dt, Expression.ValueType vt, LopProperties.ExecType et) throws LopsException {
        super(Lop.Type.LeftIndex, dt, vt);
        this._type = LixCacheType.NONE;
        this.init(lhsInput, rhsInput, rowL, rowU, colL, colU, et);
    }

    public LeftIndex(Lop lhsInput, Lop rhsInput, Lop rowL, Lop rowU, Lop colL, Lop colU, Expression.DataType dt, Expression.ValueType vt, LopProperties.ExecType et, LixCacheType type) throws LopsException {
        super(Lop.Type.LeftIndex, dt, vt);
        this._type = type;
        this.init(lhsInput, rhsInput, rowL, rowU, colL, colU, et);
    }

    private void init(Lop lhsMatrix, Lop rhsMatrix, Lop rowL, Lop rowU, Lop colL, Lop colU, LopProperties.ExecType et) throws LopsException {
        this.addInput(lhsMatrix);
        this.addInput(rhsMatrix);
        this.addInput(rowL);
        this.addInput(rowU);
        this.addInput(colL);
        this.addInput(colU);
        lhsMatrix.addOutput(this);
        rhsMatrix.addOutput(this);
        rowL.addOutput(this);
        rowU.addOutput(this);
        colL.addOutput(this);
        colU.addOutput(this);
        boolean breaksAlignment = true;
        boolean aligner = false;
        boolean definesMRJob = false;
        if (et == LopProperties.ExecType.MR) {
            throw new LopsException(this.printErrorLocation() + "LeftIndexing lop is undefined for MR runtime");
        }
        this.lps.addCompatibility(JobType.INVALID);
        this.lps.setProperties(this.inputs, et, LopProperties.ExecLocation.ControlProgram, breaksAlignment, aligner, definesMRJob);
    }

    private String getOpcode() {
        if (this._type != LixCacheType.NONE) {
            return "mapLeftIndex";
        }
        return "leftIndex";
    }

    @Override
    public String getInstructions(String lhsInput, String rhsInput, String rowl, String rowu, String coll, String colu, String output) throws LopsException {
        StringBuilder sb = new StringBuilder();
        sb.append((Object)this.getExecType());
        sb.append("\u00b0");
        sb.append(this.getOpcode());
        sb.append("\u00b0");
        sb.append(this.getInputs().get(0).prepInputOperand(lhsInput));
        sb.append("\u00b0");
        if (this.getInputs().get(1).getDataType() == Expression.DataType.SCALAR) {
            sb.append(this.getInputs().get(1).prepScalarInputOperand(this.getExecType()));
        } else {
            sb.append(this.getInputs().get(1).prepInputOperand(rhsInput));
        }
        sb.append("\u00b0");
        sb.append(this.getInputs().get(2).prepScalarInputOperand(this.getExecType()));
        sb.append("\u00b0");
        sb.append(this.getInputs().get(3).prepScalarInputOperand(this.getExecType()));
        sb.append("\u00b0");
        sb.append(this.getInputs().get(4).prepScalarInputOperand(this.getExecType()));
        sb.append("\u00b0");
        sb.append(this.getInputs().get(5).prepScalarInputOperand(this.getExecType()));
        sb.append("\u00b0");
        sb.append(this.prepOutputOperand(output));
        if (this.getExecType() == LopProperties.ExecType.SPARK) {
            sb.append("\u00b0");
            sb.append(this._type.toString());
        }
        return sb.toString();
    }

    @Override
    public String toString() {
        return "leftIndex";
    }

    public static enum LixCacheType {
        RIGHT,
        LEFT,
        NONE;

    }
}

