/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.hops.globalopt;

import java.util.HashMap;
import java.util.Map;
import org.apache.sysml.hops.globalopt.Plan;
import org.apache.sysml.hops.globalopt.PlanSet;
import org.apache.sysml.hops.globalopt.gdfgraph.GDFNode;

public class MemoStructure {
    private HashMap<Long, PlanSet> _entries = new HashMap();
    private HashMap<Long, Long> _nodeIDs = new HashMap();

    public boolean constainsEntry(GDFNode node) {
        return this._entries.containsKey(node.getID());
    }

    public void putEntry(GDFNode node, PlanSet entry) {
        this._entries.put(node.getID(), entry);
        if (node.getHop() != null) {
            this._nodeIDs.put(node.getID(), node.getHop().getHopID());
        } else {
            this._nodeIDs.put(node.getID(), -1L);
        }
    }

    public PlanSet getEntry(GDFNode node) {
        return this._entries.get(node.getID());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("------------------------------------\n");
        sb.append("MEMO STRUCTURE (gdfnodeid, plans):  \n");
        sb.append("------------------------------------\n");
        for (Map.Entry<Long, PlanSet> e : this._entries.entrySet()) {
            sb.append("------------------------------------\n");
            sb.append("Node " + e.getKey() + " (hop " + this._nodeIDs.get(e.getKey()) + "):\n");
            for (Plan p : e.getValue().getPlans()) {
                sb.append(p.toString());
                sb.append("\n");
            }
        }
        return sb.toString();
    }
}

