/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.hops;

import java.util.HashMap;
import java.util.Map;
import org.apache.sysml.api.DMLScript;
import org.apache.sysml.conf.ConfigurationManager;
import org.apache.sysml.hops.Hop;
import org.apache.sysml.hops.HopsException;
import org.apache.sysml.hops.LiteralOp;
import org.apache.sysml.hops.MemoTable;
import org.apache.sysml.hops.OptimizerUtils;
import org.apache.sysml.hops.rewrite.HopRewriteUtils;
import org.apache.sysml.lops.DataGen;
import org.apache.sysml.lops.Lop;
import org.apache.sysml.lops.LopProperties;
import org.apache.sysml.lops.LopsException;
import org.apache.sysml.parser.DataIdentifier;
import org.apache.sysml.parser.Expression;
import org.apache.sysml.runtime.util.UtilFunctions;

public class DataGenOp
extends Hop
implements Hop.MultiThreadedHop {
    public static final long UNSPECIFIED_SEED = -1L;
    private Hop.DataGenMethod _op;
    private int _maxNumThreads = -1;
    private HashMap<String, Integer> _paramIndexMap = new HashMap();
    private DataIdentifier _id;
    private double _sparsity = -1.0;
    private String _baseDir;
    private double _incr = Double.MAX_VALUE;

    private DataGenOp() {
    }

    public DataGenOp(Hop.DataGenMethod mthd, DataIdentifier id, HashMap<String, Hop> inputParameters) {
        super(id.getName(), Expression.DataType.MATRIX, Expression.ValueType.DOUBLE);
        this._id = id;
        this._op = mthd;
        int index = 0;
        for (Map.Entry<String, Hop> e : inputParameters.entrySet()) {
            String s = e.getKey();
            Hop input = e.getValue();
            this.getInput().add(input);
            input.getParent().add(this);
            this._paramIndexMap.put(s, index);
            ++index;
        }
        Hop sparsityOp = inputParameters.get("sparsity");
        if (mthd == Hop.DataGenMethod.RAND && sparsityOp instanceof LiteralOp) {
            this._sparsity = Double.valueOf(((LiteralOp)sparsityOp).getName());
        }
        String scratch = ConfigurationManager.getScratchSpace();
        this._baseDir = scratch + "/" + "_p" + DMLScript.getUUID() + "/" + "/" + "_t0" + "/";
        this.refreshSizeInformation();
    }

    @Override
    public void checkArity() throws HopsException {
        int pz;
        int sz = this._input.size();
        HopsException.check(sz == (pz = this._paramIndexMap.size()), this, "has %d inputs but %d parameters", sz, pz);
    }

    @Override
    public String getOpString() {
        return "dg(" + this._op.toString().toLowerCase() + ")";
    }

    public Hop.DataGenMethod getOp() {
        return this._op;
    }

    @Override
    public void setMaxNumThreads(int k) {
        this._maxNumThreads = k;
    }

    @Override
    public int getMaxNumThreads() {
        return this._maxNumThreads;
    }

    @Override
    public boolean isGPUEnabled() {
        return false;
    }

    @Override
    public Lop constructLops() throws HopsException, LopsException {
        if (this.getLops() != null) {
            return this.getLops();
        }
        LopProperties.ExecType et = this.optFindExecType();
        HashMap<String, Lop> inputLops = new HashMap<String, Lop>();
        for (Map.Entry<String, Integer> cur : this._paramIndexMap.entrySet()) {
            if (cur.getKey().equals("rows") && this._dim1 > 0L) {
                inputLops.put(cur.getKey(), new LiteralOp(this._dim1).constructLops());
                continue;
            }
            if (cur.getKey().equals("cols") && this._dim2 > 0L) {
                inputLops.put(cur.getKey(), new LiteralOp(this._dim2).constructLops());
                continue;
            }
            inputLops.put(cur.getKey(), this.getInput().get(cur.getValue()).constructLops());
        }
        DataGen rnd = new DataGen(this._op, this._id, inputLops, this._baseDir, this.getDataType(), this.getValueType(), et);
        int k = OptimizerUtils.getConstrainedNumThreads(this._maxNumThreads);
        rnd.setNumThreads(k);
        rnd.getOutputParameters().setDimensions(this.getDim1(), this.getDim2(), this.getRowsInBlock() > 0L ? this.getRowsInBlock() : (long)ConfigurationManager.getBlocksize(), this.getColsInBlock() > 0L ? this.getColsInBlock() : (long)ConfigurationManager.getBlocksize(), this._op == Hop.DataGenMethod.RAND && et == LopProperties.ExecType.SPARK && this.getNnz() != 0L ? -1L : this.getNnz(), this.getUpdateType());
        this.setLineNumbers(rnd);
        this.setLops(rnd);
        this.constructAndSetLopsDataFlowProperties();
        return this.getLops();
    }

    @Override
    public boolean allowsAllExecTypes() {
        return true;
    }

    @Override
    protected double computeOutputMemEstimate(long dim1, long dim2, long nnz) {
        double ret = 0.0;
        ret = this._op == Hop.DataGenMethod.RAND && this._sparsity != -1.0 ? (this.hasConstantValue(0.0) ? (double)OptimizerUtils.estimateSizeEmptyBlock(dim1, dim2) : (double)OptimizerUtils.estimateSizeExactSparsity(dim1, dim2, this._sparsity)) : (double)OptimizerUtils.estimateSizeExactSparsity(dim1, dim2, 1.0);
        return ret;
    }

    @Override
    protected double computeIntermediateMemEstimate(long dim1, long dim2, long nnz) {
        if (this._op == Hop.DataGenMethod.RAND && this.dimsKnown()) {
            long numBlocks = (long)(Math.ceil((double)dim1 / (double)ConfigurationManager.getBlocksize()) * Math.ceil((double)dim2 / (double)ConfigurationManager.getBlocksize()));
            return 32.0 + (double)numBlocks * 8.0;
        }
        return 0.0;
    }

    @Override
    protected long[] inferOutputCharacteristics(MemoTable memo) {
        if ((this._op == Hop.DataGenMethod.RAND || this._op == Hop.DataGenMethod.SINIT) && OptimizerUtils.ALLOW_WORSTCASE_SIZE_EXPRESSION_EVALUATION) {
            long nnz;
            long dim1 = this.computeDimParameterInformation(this.getInput().get(this._paramIndexMap.get("rows")), memo);
            long dim2 = this.computeDimParameterInformation(this.getInput().get(this._paramIndexMap.get("cols")), memo);
            long l = nnz = this._sparsity >= 0.0 ? (long)(this._sparsity * (double)dim1 * (double)dim2) : -1L;
            if (dim1 > 0L && dim2 > 0L) {
                return new long[]{dim1, dim2, nnz};
            }
        } else if (this._op == Hop.DataGenMethod.SEQ) {
            long fromVal;
            long toVal;
            Hop from = this.getInput().get(this._paramIndexMap.get("from"));
            Hop to = this.getInput().get(this._paramIndexMap.get("to"));
            Hop incr = this.getInput().get(this._paramIndexMap.get("incr"));
            if (from instanceof LiteralOp && HopRewriteUtils.getDoubleValueSafe((LiteralOp)from) == 1.0 && incr instanceof LiteralOp && HopRewriteUtils.getDoubleValueSafe((LiteralOp)incr) == 1.0 && (toVal = this.computeDimParameterInformation(to, memo)) > 0L) {
                return new long[]{toVal, 1L, -1L};
            }
            if (to instanceof LiteralOp && HopRewriteUtils.getDoubleValueSafe((LiteralOp)to) == 1.0 && incr instanceof LiteralOp && HopRewriteUtils.getDoubleValueSafe((LiteralOp)incr) == -1.0 && (fromVal = this.computeDimParameterInformation(from, memo)) > 0L) {
                return new long[]{fromVal, 1L, -1L};
            }
        }
        return null;
    }

    @Override
    protected LopProperties.ExecType optFindExecType() throws HopsException {
        LopProperties.ExecType REMOTE;
        this.checkAndSetForcedPlatform();
        LopProperties.ExecType execType = REMOTE = OptimizerUtils.isSparkExecutionMode() ? LopProperties.ExecType.SPARK : LopProperties.ExecType.MR;
        if (this._etypeForced != null) {
            this._etype = this._etypeForced;
        } else {
            this._etype = OptimizerUtils.isMemoryBasedOptLevel() ? this.findExecTypeByMemEstimate() : (this.areDimsBelowThreshold() || this.isVector() ? LopProperties.ExecType.CP : REMOTE);
            this.checkAndSetInvalidCPDimsAndSize();
        }
        this.setRequiresRecompileIfNecessary();
        if (this._op == Hop.DataGenMethod.SINIT) {
            this._etype = LopProperties.ExecType.CP;
        }
        if (this._op == Hop.DataGenMethod.SAMPLE && this._etype == LopProperties.ExecType.MR) {
            this._etype = LopProperties.ExecType.CP;
        }
        return this._etype;
    }

    @Override
    public void refreshSizeInformation() {
        Hop input1 = null;
        Hop input2 = null;
        Hop input3 = null;
        if (this._op == Hop.DataGenMethod.RAND || this._op == Hop.DataGenMethod.SINIT) {
            input1 = this.getInput().get(this._paramIndexMap.get("rows"));
            input2 = this.getInput().get(this._paramIndexMap.get("cols"));
            this.refreshRowsParameterInformation(input1);
            this.refreshColsParameterInformation(input2);
        } else if (this._op == Hop.DataGenMethod.SEQ) {
            boolean incrKnown;
            input1 = this.getInput().get(this._paramIndexMap.get("from"));
            input2 = this.getInput().get(this._paramIndexMap.get("to"));
            input3 = this.getInput().get(this._paramIndexMap.get("incr"));
            double from = this.computeBoundsInformation(input1);
            boolean fromKnown = from != Double.MAX_VALUE;
            double to = this.computeBoundsInformation(input2);
            boolean toKnown = to != Double.MAX_VALUE;
            double incr = this.computeBoundsInformation(input3);
            boolean bl = incrKnown = incr != Double.MAX_VALUE;
            if (fromKnown && toKnown && incr == 1.0) {
                double d = incr = from >= to ? -1.0 : 1.0;
            }
            if (fromKnown && toKnown && incrKnown) {
                this.setDim1(UtilFunctions.getSeqLength(from, to, incr, false));
                this.setDim2(1L);
                this._incr = incr;
            }
        }
        this._nnz = this._op == Hop.DataGenMethod.RAND && this.hasConstantValue(0.0) ? 0L : (this.dimsKnown() && this._sparsity >= 0.0 ? (long)(this._sparsity * (double)this._dim1 * (double)this._dim2) : -1L);
    }

    public HashMap<String, Integer> getParamIndexMap() {
        return this._paramIndexMap;
    }

    public int getParamIndex(String key) {
        return this._paramIndexMap.get(key);
    }

    public boolean hasConstantValue() {
        if (this._op != Hop.DataGenMethod.RAND) {
            return false;
        }
        Hop min = this.getInput().get(this._paramIndexMap.get("min"));
        Hop max = this.getInput().get(this._paramIndexMap.get("max"));
        Hop sparsity = this.getInput().get(this._paramIndexMap.get("sparsity"));
        if (min instanceof LiteralOp && max instanceof LiteralOp && sparsity instanceof LiteralOp) {
            try {
                double minVal = HopRewriteUtils.getDoubleValue((LiteralOp)min);
                double maxVal = HopRewriteUtils.getDoubleValue((LiteralOp)max);
                double sp = HopRewriteUtils.getDoubleValue((LiteralOp)sparsity);
                return sp == 1.0 && minVal == maxVal;
            }
            catch (Exception ex) {
                return false;
            }
        }
        if (min == max && sparsity instanceof LiteralOp) {
            return HopRewriteUtils.getDoubleValueSafe((LiteralOp)sparsity) == 1.0;
        }
        return false;
    }

    public boolean hasConstantValue(double val) {
        if (this._op != Hop.DataGenMethod.RAND) {
            return false;
        }
        boolean ret = false;
        Hop min = this.getInput().get(this._paramIndexMap.get("min"));
        Hop max = this.getInput().get(this._paramIndexMap.get("max"));
        if (min instanceof LiteralOp && max instanceof LiteralOp) {
            double minVal = HopRewriteUtils.getDoubleValueSafe((LiteralOp)min);
            double maxVal = HopRewriteUtils.getDoubleValueSafe((LiteralOp)max);
            boolean bl = ret = minVal == val && maxVal == val;
        }
        if (ret && val != 0.0) {
            Hop sparsity = this.getInput().get(this._paramIndexMap.get("sparsity"));
            ret &= sparsity == null || sparsity instanceof LiteralOp && HopRewriteUtils.getDoubleValueSafe((LiteralOp)sparsity) == 1.0;
        }
        return ret;
    }

    public void setIncrementValue(double incr) {
        this._incr = incr;
    }

    public double getIncrementValue() {
        return this._incr;
    }

    public static long generateRandomSeed() {
        return System.nanoTime();
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        DataGenOp ret = new DataGenOp();
        ret.clone(this, false);
        ret._op = this._op;
        ret._id = this._id;
        ret._sparsity = this._sparsity;
        ret._baseDir = this._baseDir;
        ret._paramIndexMap = (HashMap)this._paramIndexMap.clone();
        ret._maxNumThreads = this._maxNumThreads;
        return ret;
    }

    @Override
    public boolean compare(Hop that) {
        boolean ret;
        if (!(that instanceof DataGenOp)) {
            return false;
        }
        DataGenOp that2 = (DataGenOp)that;
        boolean bl = ret = this._op == that2._op && this._sparsity == that2._sparsity && this._baseDir.equals(that2._baseDir) && this._paramIndexMap != null && that2._paramIndexMap != null && this._maxNumThreads == that2._maxNumThreads;
        if (ret) {
            for (Map.Entry<String, Integer> e : this._paramIndexMap.entrySet()) {
                String key1 = e.getKey();
                int pos1 = e.getValue();
                int pos2 = that2._paramIndexMap.get(key1);
                ret &= that2.getInput().get(pos2) != null && this.getInput().get(pos1) == that2.getInput().get(pos2);
            }
            if (this._op == Hop.DataGenMethod.RAND || this._op == Hop.DataGenMethod.SINIT) {
                Hop seed = this.getInput().get(this._paramIndexMap.get("seed"));
                Hop min = this.getInput().get(this._paramIndexMap.get("min"));
                Hop max = this.getInput().get(this._paramIndexMap.get("max"));
                if (seed.getName().equals(String.valueOf(-1L)) && min != max) {
                    ret = false;
                }
            }
        }
        return ret;
    }
}

