/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.hops;

import org.apache.sysml.api.DMLScript;
import org.apache.sysml.hops.AggBinaryOp;
import org.apache.sysml.hops.BinaryOp;
import org.apache.sysml.hops.DataOp;
import org.apache.sysml.hops.Hop;
import org.apache.sysml.hops.HopsException;
import org.apache.sysml.hops.LiteralOp;
import org.apache.sysml.hops.MemoTable;
import org.apache.sysml.hops.OptimizerUtils;
import org.apache.sysml.hops.rewrite.HopRewriteUtils;
import org.apache.sysml.lops.Aggregate;
import org.apache.sysml.lops.Binary;
import org.apache.sysml.lops.Group;
import org.apache.sysml.lops.Lop;
import org.apache.sysml.lops.LopProperties;
import org.apache.sysml.lops.LopsException;
import org.apache.sysml.lops.PartialAggregate;
import org.apache.sysml.lops.TernaryAggregate;
import org.apache.sysml.lops.UAggOuterChain;
import org.apache.sysml.lops.UnaryCP;
import org.apache.sysml.parser.Expression;
import org.apache.sysml.runtime.controlprogram.context.SparkExecutionContext;
import org.apache.sysml.runtime.matrix.MatrixCharacteristics;

public class AggUnaryOp
extends Hop
implements Hop.MultiThreadedHop {
    private static final boolean ALLOW_UNARYAGG_WO_FINAL_AGG = true;
    private Hop.AggOp _op;
    private Hop.Direction _direction;
    private int _maxNumThreads = -1;

    private AggUnaryOp() {
    }

    public AggUnaryOp(String l, Expression.DataType dt, Expression.ValueType vt, Hop.AggOp o, Hop.Direction idx, Hop inp) {
        super(l, dt, vt);
        this._op = o;
        this._direction = idx;
        this.getInput().add(0, inp);
        inp.getParent().add(this);
    }

    @Override
    public void checkArity() throws HopsException {
        HopsException.check(this._input.size() == 1, this, "should have arity 1 but has arity %d", this._input.size());
    }

    public Hop.AggOp getOp() {
        return this._op;
    }

    public void setOp(Hop.AggOp op) {
        this._op = op;
    }

    public Hop.Direction getDirection() {
        return this._direction;
    }

    public void setDirection(Hop.Direction direction) {
        this._direction = direction;
    }

    @Override
    public void setMaxNumThreads(int k) {
        this._maxNumThreads = k;
    }

    @Override
    public int getMaxNumThreads() {
        return this._maxNumThreads;
    }

    @Override
    public boolean isGPUEnabled() {
        if (!DMLScript.USE_ACCELERATOR) {
            return false;
        }
        try {
            if (this.isTernaryAggregateRewriteApplicable() || this.isUnaryAggregateOuterCPRewriteApplicable()) {
                return false;
            }
            if (this._op == Hop.AggOp.SUM && (this._direction == Hop.Direction.RowCol || this._direction == Hop.Direction.Row || this._direction == Hop.Direction.Col) || this._op == Hop.AggOp.SUM_SQ && (this._direction == Hop.Direction.RowCol || this._direction == Hop.Direction.Row || this._direction == Hop.Direction.Col) || this._op == Hop.AggOp.MAX && (this._direction == Hop.Direction.RowCol || this._direction == Hop.Direction.Row || this._direction == Hop.Direction.Col) || this._op == Hop.AggOp.MIN && (this._direction == Hop.Direction.RowCol || this._direction == Hop.Direction.Row || this._direction == Hop.Direction.Col) || this._op == Hop.AggOp.MEAN && (this._direction == Hop.Direction.RowCol || this._direction == Hop.Direction.Row || this._direction == Hop.Direction.Col) || this._op == Hop.AggOp.VAR && (this._direction == Hop.Direction.RowCol || this._direction == Hop.Direction.Row || this._direction == Hop.Direction.Col) || this._op == Hop.AggOp.PROD && this._direction == Hop.Direction.RowCol) {
                return true;
            }
        }
        catch (HopsException e) {
            throw new RuntimeException(e);
        }
        return false;
    }

    @Override
    public Lop constructLops() throws HopsException, LopsException {
        if (this.getLops() != null) {
            return this.getLops();
        }
        try {
            LopProperties.ExecType et = this.optFindExecType();
            Hop input = this.getInput().get(0);
            if (et == LopProperties.ExecType.CP || et == LopProperties.ExecType.GPU) {
                Lop agg1 = null;
                if (this.isTernaryAggregateRewriteApplicable()) {
                    agg1 = this.constructLopsTernaryAggregateRewrite(et);
                } else if (this.isUnaryAggregateOuterCPRewriteApplicable()) {
                    Aggregate.OperationTypes op = (Aggregate.OperationTypes)((Object)HopsAgg2Lops.get((Object)this._op));
                    PartialAggregate.DirectionTypes dir = (PartialAggregate.DirectionTypes)((Object)HopsDirection2Lops.get((Object)this._direction));
                    BinaryOp binput = (BinaryOp)this.getInput().get(0);
                    agg1 = new UAggOuterChain(binput.getInput().get(0).constructLops(), binput.getInput().get(1).constructLops(), op, dir, (Binary.OperationTypes)((Object)HopsOpOp2LopsB.get((Object)binput.getOp())), Expression.DataType.MATRIX, this.getValueType(), LopProperties.ExecType.CP);
                    PartialAggregate.setDimensionsBasedOnDirection(agg1, this.getDim1(), this.getDim2(), input.getRowsInBlock(), input.getColsInBlock(), dir);
                    if (this.getDataType() == Expression.DataType.SCALAR) {
                        UnaryCP unary1 = new UnaryCP(agg1, (UnaryCP.OperationTypes)((Object)HopsOpOp1LopsUS.get((Object)Hop.OpOp1.CAST_AS_SCALAR)), this.getDataType(), this.getValueType());
                        unary1.getOutputParameters().setDimensions(0L, 0L, 0L, 0L, -1L);
                        this.setLineNumbers(unary1);
                        this.setLops(unary1);
                    }
                } else {
                    int k = OptimizerUtils.getConstrainedNumThreads(this._maxNumThreads);
                    agg1 = new PartialAggregate(input.constructLops(), (Aggregate.OperationTypes)((Object)HopsAgg2Lops.get((Object)this._op)), (PartialAggregate.DirectionTypes)((Object)HopsDirection2Lops.get((Object)this._direction)), this.getDataType(), this.getValueType(), et, k);
                }
                this.setOutputDimensions(agg1);
                this.setLineNumbers(agg1);
                this.setLops(agg1);
                if (this.getDataType() == Expression.DataType.SCALAR) {
                    agg1.getOutputParameters().setDimensions(1L, 1L, this.getRowsInBlock(), this.getColsInBlock(), this.getNnz());
                }
            } else if (et == LopProperties.ExecType.MR) {
                Aggregate.OperationTypes op = (Aggregate.OperationTypes)((Object)HopsAgg2Lops.get((Object)this._op));
                PartialAggregate.DirectionTypes dir = (PartialAggregate.DirectionTypes)((Object)HopsDirection2Lops.get((Object)this._direction));
                Lop transform1 = null;
                if (this.isUnaryAggregateOuterRewriteApplicable()) {
                    BinaryOp binput = (BinaryOp)this.getInput().get(0);
                    transform1 = new UAggOuterChain(binput.getInput().get(0).constructLops(), binput.getInput().get(1).constructLops(), op, dir, (Binary.OperationTypes)((Object)HopsOpOp2LopsB.get((Object)binput.getOp())), Expression.DataType.MATRIX, this.getValueType(), LopProperties.ExecType.MR);
                    PartialAggregate.setDimensionsBasedOnDirection(transform1, this.getDim1(), this.getDim2(), input.getRowsInBlock(), input.getColsInBlock(), dir);
                } else {
                    transform1 = new PartialAggregate(input.constructLops(), op, dir, Expression.DataType.MATRIX, this.getValueType());
                    ((PartialAggregate)transform1).setDimensionsBasedOnDirection(this.getDim1(), this.getDim2(), input.getRowsInBlock(), input.getColsInBlock());
                }
                this.setLineNumbers(transform1);
                Lop aggregate = null;
                Group group1 = null;
                Aggregate agg1 = null;
                if (this.requiresAggregation(input, this._direction) || transform1 instanceof UAggOuterChain) {
                    group1 = new Group(transform1, Group.OperationTypes.Sort, Expression.DataType.MATRIX, this.getValueType());
                    group1.getOutputParameters().setDimensions(this.getDim1(), this.getDim2(), input.getRowsInBlock(), input.getColsInBlock(), this.getNnz());
                    this.setLineNumbers(group1);
                    agg1 = new Aggregate(group1, (Aggregate.OperationTypes)((Object)HopsAgg2Lops.get((Object)this._op)), Expression.DataType.MATRIX, this.getValueType(), et);
                    agg1.getOutputParameters().setDimensions(this.getDim1(), this.getDim2(), input.getRowsInBlock(), input.getColsInBlock(), this.getNnz());
                    agg1.setupCorrectionLocation(PartialAggregate.getCorrectionLocation(op, dir));
                    this.setLineNumbers(agg1);
                    aggregate = agg1;
                } else {
                    ((PartialAggregate)transform1).setDropCorrection();
                    aggregate = transform1;
                }
                this.setLops(aggregate);
                if (this.getDataType() == Expression.DataType.SCALAR) {
                    PartialAggregate.setDimensionsBasedOnDirection(transform1, input.getDim1(), input.getDim2(), input.getRowsInBlock(), input.getColsInBlock(), dir);
                    if (group1 != null && agg1 != null) {
                        group1.getOutputParameters().setDimensions(input.getDim1(), input.getDim2(), input.getRowsInBlock(), input.getColsInBlock(), this.getNnz());
                        agg1.getOutputParameters().setDimensions(1L, 1L, input.getRowsInBlock(), input.getColsInBlock(), this.getNnz());
                    }
                    UnaryCP unary1 = new UnaryCP(aggregate, (UnaryCP.OperationTypes)((Object)HopsOpOp1LopsUS.get((Object)Hop.OpOp1.CAST_AS_SCALAR)), this.getDataType(), this.getValueType());
                    unary1.getOutputParameters().setDimensions(0L, 0L, 0L, 0L, -1L);
                    this.setLineNumbers(unary1);
                    this.setLops(unary1);
                }
            } else if (et == LopProperties.ExecType.SPARK) {
                Aggregate.OperationTypes op = (Aggregate.OperationTypes)((Object)HopsAgg2Lops.get((Object)this._op));
                PartialAggregate.DirectionTypes dir = (PartialAggregate.DirectionTypes)((Object)HopsDirection2Lops.get((Object)this._direction));
                if (this.isTernaryAggregateRewriteApplicable()) {
                    Lop aggregate = this.constructLopsTernaryAggregateRewrite(et);
                    this.setOutputDimensions(aggregate);
                    this.setLineNumbers(aggregate);
                    this.setLops(aggregate);
                } else if (this.isUnaryAggregateOuterSPRewriteApplicable()) {
                    BinaryOp binput = (BinaryOp)this.getInput().get(0);
                    UAggOuterChain transform1 = new UAggOuterChain(binput.getInput().get(0).constructLops(), binput.getInput().get(1).constructLops(), op, dir, (Binary.OperationTypes)((Object)HopsOpOp2LopsB.get((Object)binput.getOp())), Expression.DataType.MATRIX, this.getValueType(), LopProperties.ExecType.SPARK);
                    PartialAggregate.setDimensionsBasedOnDirection(transform1, this.getDim1(), this.getDim2(), input.getRowsInBlock(), input.getColsInBlock(), dir);
                    this.setLineNumbers(transform1);
                    this.setLops(transform1);
                    if (this.getDataType() == Expression.DataType.SCALAR) {
                        UnaryCP unary1 = new UnaryCP(transform1, (UnaryCP.OperationTypes)((Object)HopsOpOp1LopsUS.get((Object)Hop.OpOp1.CAST_AS_SCALAR)), this.getDataType(), this.getValueType());
                        unary1.getOutputParameters().setDimensions(0L, 0L, 0L, 0L, -1L);
                        this.setLineNumbers(unary1);
                        this.setLops(unary1);
                    }
                } else {
                    boolean needAgg = this.requiresAggregation(input, this._direction);
                    AggBinaryOp.SparkAggType aggtype = this.getSparkUnaryAggregationType(needAgg);
                    PartialAggregate aggregate = new PartialAggregate(input.constructLops(), (Aggregate.OperationTypes)((Object)HopsAgg2Lops.get((Object)this._op)), (PartialAggregate.DirectionTypes)((Object)HopsDirection2Lops.get((Object)this._direction)), Expression.DataType.MATRIX, this.getValueType(), aggtype, et);
                    aggregate.setDimensionsBasedOnDirection(this.getDim1(), this.getDim2(), input.getRowsInBlock(), input.getColsInBlock());
                    this.setLineNumbers(aggregate);
                    this.setLops(aggregate);
                    if (this.getDataType() == Expression.DataType.SCALAR) {
                        UnaryCP unary1 = new UnaryCP(aggregate, (UnaryCP.OperationTypes)((Object)HopsOpOp1LopsUS.get((Object)Hop.OpOp1.CAST_AS_SCALAR)), this.getDataType(), this.getValueType());
                        unary1.getOutputParameters().setDimensions(0L, 0L, 0L, 0L, -1L);
                        this.setLineNumbers(unary1);
                        this.setLops(unary1);
                    }
                }
            }
        }
        catch (Exception e) {
            throw new HopsException(this.printErrorLocation() + "In AggUnary Hop, error constructing Lops ", e);
        }
        this.constructAndSetLopsDataFlowProperties();
        return this.getLops();
    }

    @Override
    public String getOpString() {
        String s = "ua(" + (String)HopsAgg2String.get((Object)this._op) + (String)HopsDirection2String.get((Object)this._direction) + ")";
        return s;
    }

    @Override
    public boolean allowsAllExecTypes() {
        return true;
    }

    @Override
    protected double computeOutputMemEstimate(long dim1, long dim2, long nnz) {
        double sparsity = -1.0;
        sparsity = this.isGPUEnabled() ? 1.0 : OptimizerUtils.getSparsity(dim1, dim2, nnz);
        return OptimizerUtils.estimateSizeExactSparsity(dim1, dim2, sparsity);
    }

    @Override
    protected double computeIntermediateMemEstimate(long dim1, long dim2, long nnz) {
        double val = 0.0;
        double sparsity = OptimizerUtils.getSparsity(dim1, dim2, nnz);
        switch (this._op) {
            case MAX: 
            case MIN: {
                if (this._direction != Hop.Direction.Col) break;
                val = dim2 * 4L;
                break;
            }
            case SUM: 
            case SUM_SQ: {
                if (this._direction == Hop.Direction.Col) {
                    val = OptimizerUtils.estimateSizeExactSparsity(2L, dim2, sparsity);
                    break;
                }
                if (this._direction != Hop.Direction.Row) break;
                val = OptimizerUtils.estimateSizeExactSparsity(dim1, 2L, 1.0);
                break;
            }
            case MEAN: {
                if (this._direction == Hop.Direction.Col) {
                    val = OptimizerUtils.estimateSizeExactSparsity(3L, dim2, sparsity);
                    break;
                }
                if (this._direction != Hop.Direction.Row) break;
                val = OptimizerUtils.estimateSizeExactSparsity(dim1, 3L, 1.0);
                break;
            }
            case VAR: {
                if (this.isGPUEnabled()) {
                    long in1dim1 = this.getInput().get(0).getDim1();
                    long in1dim2 = this.getInput().get(0).getDim2();
                    val = 2L * OptimizerUtils.estimateSize(in1dim1, in1dim2);
                    if (this._direction == Hop.Direction.Col) {
                        val += (double)OptimizerUtils.estimateSize(in1dim1, 1L);
                        break;
                    }
                    if (this._direction != Hop.Direction.Row) break;
                    val += (double)OptimizerUtils.estimateSize(1L, in1dim2);
                    break;
                }
                if (this._direction == Hop.Direction.Col) {
                    val = OptimizerUtils.estimateSizeExactSparsity(5L, dim2, sparsity);
                    break;
                }
                if (this._direction != Hop.Direction.Row) break;
                val = OptimizerUtils.estimateSizeExactSparsity(dim1, 5L, 1.0);
                break;
            }
            case MAXINDEX: 
            case MININDEX: {
                Hop hop = this.getInput().get(0);
                if (this.isUnaryAggregateOuterCPRewriteApplicable()) {
                    val = 3L * OptimizerUtils.estimateSizeExactSparsity(1L, hop._dim2, 1.0);
                    break;
                }
                val = OptimizerUtils.estimateSizeExactSparsity(dim1, 2L, 1.0);
                break;
            }
            default: {
                val = 0.0;
            }
        }
        return val;
    }

    @Override
    protected long[] inferOutputCharacteristics(MemoTable memo) {
        long[] ret = null;
        Hop input = this.getInput().get(0);
        MatrixCharacteristics mc = memo.getAllInputStats(input);
        if (this._direction == Hop.Direction.Col && mc.colsKnown()) {
            ret = new long[]{1L, mc.getCols(), -1L};
        } else if (this._direction == Hop.Direction.Row && mc.rowsKnown()) {
            ret = new long[]{mc.getRows(), 1L, -1L};
        }
        return ret;
    }

    @Override
    protected LopProperties.ExecType optFindExecType() throws HopsException {
        LopProperties.ExecType REMOTE;
        this.checkAndSetForcedPlatform();
        LopProperties.ExecType execType = REMOTE = OptimizerUtils.isSparkExecutionMode() ? LopProperties.ExecType.SPARK : LopProperties.ExecType.MR;
        if (this._etypeForced != null) {
            this._etype = this._etypeForced;
        } else {
            this._etype = OptimizerUtils.isMemoryBasedOptLevel() ? this.findExecTypeByMemEstimate() : (this.getInput().get(0).areDimsBelowThreshold() || this.getInput().get(0).isVector() ? LopProperties.ExecType.CP : REMOTE);
            this.checkAndSetInvalidCPDimsAndSize();
        }
        if (!(this._etype != LopProperties.ExecType.CP || this._etypeForced == LopProperties.ExecType.CP || this.getInput().get(0) instanceof DataOp || this.getInput().get(0).getParent().size() != 1 && this.requiresAggregation(this.getInput().get(0), this._direction) || this.getInput().get(0).optFindExecType() != LopProperties.ExecType.SPARK)) {
            this._etype = LopProperties.ExecType.SPARK;
        }
        this.setRequiresRecompileIfNecessary();
        return this._etype;
    }

    private boolean requiresAggregation(Hop input, Hop.Direction dir) {
        boolean noAggRequired = input.getDim1() > 1L && input.getDim1() <= input.getRowsInBlock() && dir == Hop.Direction.Col || input.getDim2() > 1L && input.getDim2() <= input.getColsInBlock() && dir == Hop.Direction.Row;
        return !noAggRequired;
    }

    private AggBinaryOp.SparkAggType getSparkUnaryAggregationType(boolean agg) {
        if (!agg) {
            return AggBinaryOp.SparkAggType.NONE;
        }
        if (this.getDataType() == Expression.DataType.SCALAR || this.dimsKnown() && this.getDim1() <= this.getRowsInBlock() && this.getDim2() <= this.getColsInBlock()) {
            return AggBinaryOp.SparkAggType.SINGLE_BLOCK;
        }
        return AggBinaryOp.SparkAggType.MULTI_BLOCK;
    }

    private boolean isTernaryAggregateRewriteApplicable() throws HopsException {
        Hop input1;
        boolean ret = false;
        if (OptimizerUtils.ALLOW_SUM_PRODUCT_REWRITES && this._op == Hop.AggOp.SUM && (this._direction == Hop.Direction.RowCol || this._direction == Hop.Direction.Col) && (input1 = this.getInput().get(0)).getParent().size() == 1 && input1 instanceof BinaryOp) {
            BinaryOp binput1 = (BinaryOp)input1;
            if (binput1.getOp() == Hop.OpOp2.POW && binput1.getInput().get(1) instanceof LiteralOp) {
                LiteralOp lit = (LiteralOp)binput1.getInput().get(1);
                ret = HopRewriteUtils.getIntValueSafe(lit) == 3L;
            } else if (binput1.getOp() == Hop.OpOp2.MULT && input1.optFindExecType() != LopProperties.ExecType.MR) {
                Hop input11 = input1.getInput().get(0);
                Hop input12 = input1.getInput().get(1);
                ret = input11 instanceof BinaryOp && ((BinaryOp)input11).getOp() == Hop.OpOp2.MULT ? HopRewriteUtils.isEqualSize(input11.getInput().get(0), input1) && HopRewriteUtils.isEqualSize(input11.getInput().get(1), input1) && HopRewriteUtils.isEqualSize(input12, input1) : (input12 instanceof BinaryOp && ((BinaryOp)input12).getOp() == Hop.OpOp2.MULT ? HopRewriteUtils.isEqualSize(input12.getInput().get(0), input1) && HopRewriteUtils.isEqualSize(input12.getInput().get(1), input1) && HopRewriteUtils.isEqualSize(input11, input1) : HopRewriteUtils.isEqualSize(input11, input12));
            }
        }
        return ret;
    }

    private static boolean isCompareOperator(Hop.OpOp2 opOp2) {
        return opOp2 == Hop.OpOp2.LESS || opOp2 == Hop.OpOp2.LESSEQUAL || opOp2 == Hop.OpOp2.GREATER || opOp2 == Hop.OpOp2.GREATEREQUAL || opOp2 == Hop.OpOp2.EQUAL || opOp2 == Hop.OpOp2.NOTEQUAL;
    }

    private boolean isUnaryAggregateOuterRewriteApplicable() {
        boolean ret = false;
        Hop input = this.getInput().get(0);
        if (input instanceof BinaryOp && ((BinaryOp)input).isOuterVectorOperator()) {
            double factor = AggUnaryOp.isCompareOperator(((BinaryOp)input).getOp()) && (this._direction == Hop.Direction.Row || this._direction == Hop.Direction.Col || this._direction == Hop.Direction.RowCol) && this._op == Hop.AggOp.SUM ? 2.0 : 1.0;
            factor += !(!AggUnaryOp.isCompareOperator(((BinaryOp)input).getOp()) || this._direction != Hop.Direction.Row && this._direction != Hop.Direction.Col || this._op != Hop.AggOp.MAXINDEX && this._op != Hop.AggOp.MININDEX) ? 1.0 : 0.0;
            Hop right = input.getInput().get(1);
            if (right.dimsKnown() && factor * (double)OptimizerUtils.estimateSize(right.getDim1(), right.getDim2()) < OptimizerUtils.getRemoteMemBudgetMap(true) || !right.dimsKnown() && factor * right.getOutputMemEstimate() < OptimizerUtils.getRemoteMemBudgetMap(true)) {
                ret = true;
            }
        }
        return ret;
    }

    private boolean isUnaryAggregateOuterSPRewriteApplicable() {
        boolean ret = false;
        Hop input = this.getInput().get(0);
        if (input instanceof BinaryOp && ((BinaryOp)input).isOuterVectorOperator()) {
            double size;
            Hop right = input.getInput().get(1);
            double d = size = right.dimsKnown() ? (double)OptimizerUtils.estimateSize(right.getDim1(), right.getDim2()) : right.getOutputMemEstimate();
            if (this._op == Hop.AggOp.MAXINDEX || this._op == Hop.AggOp.MININDEX) {
                double memBudgetExec = SparkExecutionContext.getBroadcastMemoryBudget();
                double memBudgetLocal = OptimizerUtils.getLocalMemBudget();
                ret = 2.0 * size < memBudgetExec && 2.0 * size < memBudgetLocal;
            } else if (OptimizerUtils.checkSparkBroadcastMemoryBudget(size)) {
                ret = true;
            }
        }
        return ret;
    }

    private boolean isUnaryAggregateOuterCPRewriteApplicable() {
        boolean ret = false;
        Hop input = this.getInput().get(0);
        if (input instanceof BinaryOp && ((BinaryOp)input).isOuterVectorOperator() && (this._op == Hop.AggOp.MAXINDEX || this._op == Hop.AggOp.MININDEX || this._op == Hop.AggOp.SUM) && AggUnaryOp.isCompareOperator(((BinaryOp)input).getOp())) {
            ret = true;
        }
        return ret;
    }

    private Lop constructLopsTernaryAggregateRewrite(LopProperties.ExecType et) throws HopsException, LopsException {
        Hop b112;
        BinaryOp input1 = (BinaryOp)this.getInput().get(0);
        Hop input11 = input1.getInput().get(0);
        Hop input12 = input1.getInput().get(1);
        Lop in1 = null;
        Lop in2 = null;
        Lop in3 = null;
        boolean handled = false;
        if (input1.getOp() == Hop.OpOp2.POW) {
            assert (HopRewriteUtils.isLiteralOfValue(input12, 3.0)) : "this case can only occur with a power of 3";
            in2 = in1 = input11.constructLops();
            in3 = in1;
            handled = true;
        } else if (input11 instanceof BinaryOp) {
            BinaryOp b11 = (BinaryOp)input11;
            switch (b11.getOp()) {
                case MULT: {
                    in1 = input11.getInput().get(0).constructLops();
                    in2 = input11.getInput().get(1).constructLops();
                    in3 = input12.constructLops();
                    handled = true;
                    break;
                }
                case POW: {
                    b112 = b11.getInput().get(1);
                    if (input12 instanceof BinaryOp && ((BinaryOp)input12).getOp() == Hop.OpOp2.MULT || !HopRewriteUtils.isLiteralOfValue(b112, 2.0)) break;
                    in2 = in1 = b11.getInput().get(0).constructLops();
                    in3 = input12.constructLops();
                    handled = true;
                    break;
                }
            }
        } else if (input12 instanceof BinaryOp) {
            BinaryOp b12 = (BinaryOp)input12;
            switch (b12.getOp()) {
                case MULT: {
                    in1 = input11.constructLops();
                    in2 = input12.getInput().get(0).constructLops();
                    in3 = input12.getInput().get(1).constructLops();
                    handled = true;
                    break;
                }
                case POW: {
                    b112 = b12.getInput().get(1);
                    if (!HopRewriteUtils.isLiteralOfValue(b112, 2.0)) break;
                    in2 = in1 = b12.getInput().get(0).constructLops();
                    in3 = input11.constructLops();
                    handled = true;
                    break;
                }
            }
        }
        if (!handled) {
            in1 = input11.constructLops();
            in2 = input12.constructLops();
            in3 = new LiteralOp(1L).constructLops();
        }
        int k = OptimizerUtils.getConstrainedNumThreads(this._maxNumThreads);
        LopProperties.ExecType et_input = input1.optFindExecType();
        et_input = et_input == LopProperties.ExecType.GPU ? LopProperties.ExecType.CP : et_input;
        PartialAggregate.DirectionTypes dir = (PartialAggregate.DirectionTypes)((Object)HopsDirection2Lops.get((Object)this._direction));
        return new TernaryAggregate(in1, in2, in3, Aggregate.OperationTypes.KahanSum, Binary.OperationTypes.MULTIPLY, dir, this.getDataType(), Expression.ValueType.DOUBLE, et_input, k);
    }

    @Override
    public void refreshSizeInformation() {
        if (this.getDataType() != Expression.DataType.SCALAR) {
            Hop input = this.getInput().get(0);
            if (this._direction == Hop.Direction.Col) {
                this.setDim1(1L);
                this.setDim2(input.getDim2());
            } else if (this._direction == Hop.Direction.Row) {
                this.setDim1(input.getDim1());
                this.setDim2(1L);
            }
        }
    }

    @Override
    public boolean isTransposeSafe() {
        boolean ret = this._direction == Hop.Direction.RowCol && (this._op == Hop.AggOp.SUM || this._op == Hop.AggOp.SUM_SQ || this._op == Hop.AggOp.MIN || this._op == Hop.AggOp.MAX || this._op == Hop.AggOp.PROD || this._op == Hop.AggOp.MEAN || this._op == Hop.AggOp.VAR);
        return ret;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        AggUnaryOp ret = new AggUnaryOp();
        ret.clone(this, false);
        ret._op = this._op;
        ret._direction = this._direction;
        ret._maxNumThreads = this._maxNumThreads;
        return ret;
    }

    @Override
    public boolean compare(Hop that) {
        if (!(that instanceof AggUnaryOp)) {
            return false;
        }
        AggUnaryOp that2 = (AggUnaryOp)that;
        return this._op == that2._op && this._direction == that2._direction && this._maxNumThreads == that2._maxNumThreads && this.getInput().get(0) == that2.getInput().get(0);
    }
}

