/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.api.mlcontext;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.sysml.parser.Expression;

public class FrameSchema {
    private List<Expression.ValueType> schema = null;

    public FrameSchema() {
    }

    public FrameSchema(List<Expression.ValueType> schema) {
        this.schema = schema;
    }

    public FrameSchema(String schema) {
        this.schema = this.schemaStringToListOfValueTypes(schema);
    }

    public List<Expression.ValueType> getSchema() {
        return this.schema;
    }

    public void setSchema(List<Expression.ValueType> schema) {
        this.schema = schema;
    }

    public void setSchemaAsString(String schema) {
        this.schema = this.schemaStringToListOfValueTypes(schema);
    }

    private List<Expression.ValueType> schemaStringToListOfValueTypes(String schemaString) {
        if (StringUtils.isBlank((CharSequence)schemaString)) {
            return null;
        }
        String[] cols = schemaString.split(",");
        ArrayList<Expression.ValueType> list = new ArrayList<Expression.ValueType>();
        for (String col : cols) {
            list.add(Expression.ValueType.valueOf(col.toUpperCase()));
        }
        return list;
    }

    public String getSchemaAsString() {
        if (this.schema == null || this.schema.size() == 0) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.schema.size(); ++i) {
            Expression.ValueType vt = this.schema.get(i);
            sb.append((Object)vt);
            if (i + 1 >= this.schema.size()) continue;
            sb.append(",");
        }
        return sb.toString();
    }
}

