/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.api.dl;

import java.io.File;
import org.apache.sysml.api.dl.CaffeLayer;
import org.apache.sysml.api.dl.CaffeNetwork;
import org.apache.sysml.api.dl.VisualizeDMLGenerator;
import org.apache.sysml.runtime.DMLRuntimeException;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxesRunTime;

public abstract class VisualizeDMLGenerator$class {
    public static void setTensorBoardLogDir(VisualizeDMLGenerator $this, String log) {
        $this._tensorboardLogDir_$eq(log);
    }

    public static String tensorboardLogDir(VisualizeDMLGenerator $this) {
        if ($this._tensorboardLogDir() == null) {
            $this._tensorboardLogDir_$eq(File.createTempFile("temp", ((Object)BoxesRunTime.boxToLong((long)System.nanoTime())).toString()).getAbsolutePath());
        }
        return $this._tensorboardLogDir();
    }

    public static void visualizeLoss(VisualizeDMLGenerator $this) {
        $this.checkTensorBoardDependency();
        $this.doVisualize_$eq(true);
        VisualizeDMLGenerator$class.visualize($this, " ", " ", "training_loss", "iter", "training_loss", true);
        VisualizeDMLGenerator$class.visualize($this, " ", " ", "training_accuracy", "iter", "training_accuracy", true);
        VisualizeDMLGenerator$class.visualize($this, " ", " ", "validation_loss", "iter", "validation_loss", false);
        VisualizeDMLGenerator$class.visualize($this, " ", " ", "validation_accuracy", "iter", "validation_accuracy", false);
    }

    public static void checkTensorBoardDependency(VisualizeDMLGenerator $this) {
        try {
            if (!$this.doVisualize()) {
                Class.forName("com.google.protobuf.GeneratedMessageV3");
            }
            return;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new DMLRuntimeException("To use visualize() feature, you will have to include protobuf-java-3.2.0.jar in your classpath. Hint: you can download the jar from http://central.maven.org/maven2/com/google/protobuf/protobuf-java/3.2.0/protobuf-java-3.2.0.jar");
        }
    }

    private static StringBuilder visualize(VisualizeDMLGenerator $this, String layerName, String varType, String aggFn, String x, String y, boolean isTraining) {
        StringBuilder dmlScript = isTraining ? $this.visTrainingDMLScript() : $this.visValidationDMLScript();
        dmlScript.append(new StringBuilder().append((Object)"viz_counter1 = visualize(").append((Object)$this.commaSep((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{$this.asDMLString(layerName), $this.asDMLString(varType), $this.asDMLString(aggFn), x, y, $this.asDMLString($this.tensorboardLogDir())}))).append((Object)");\n").toString());
        return dmlScript.append("viz_counter = viz_counter + viz_counter1\n");
    }

    public static void visualizeLayer(VisualizeDMLGenerator $this, CaffeNetwork net, String layerName, String varType, String aggFn) {
        block10: {
            String string;
            block6: {
                String string2;
                CaffeLayer l;
                block9: {
                    block8: {
                        block7: {
                            block5: {
                                $this.checkTensorBoardDependency();
                                $this.doVisualize_$eq(true);
                                if (((SeqLike)net.getLayers().filter((Function1)new Serializable($this, layerName){
                                    public static final long serialVersionUID = 0L;
                                    private final String layerName$1;

                                    public final boolean apply(String x$1) {
                                        return x$1.equals(this.layerName$1);
                                    }
                                    {
                                        this.layerName$1 = layerName$1;
                                    }
                                })).size() == 0) {
                                    throw new DMLRuntimeException(new StringBuilder().append((Object)"Cannot visualize the layer:").append((Object)layerName).toString());
                                }
                                l = net.getCaffeLayer(layerName);
                                string2 = varType;
                                if (!"weight".equals(string2)) break block5;
                                string = l.weight();
                                break block6;
                            }
                            if (!"bias".equals(string2)) break block7;
                            string = l.bias();
                            break block6;
                        }
                        if (!"dweight".equals(string2)) break block8;
                        string = l.dWeight();
                        break block6;
                    }
                    if (!"dbias".equals(string2)) break block9;
                    string = l.dBias();
                    break block6;
                }
                if (!"output".equals(string2)) break block10;
                string = l.out();
            }
            String dmlVar = string;
            if (dmlVar == null) {
                throw new DMLRuntimeException(new StringBuilder().append((Object)"Cannot visualize the variable of type:").append((Object)varType).toString());
            }
            VisualizeDMLGenerator$class.visualize($this, layerName, varType, aggFn, "iter", new StringBuilder().append((Object)aggFn).append((Object)"(").append((Object)dmlVar).append((Object)")").toString(), true);
            VisualizeDMLGenerator$class.visualize($this, layerName, varType, aggFn, "iter", new StringBuilder().append((Object)aggFn).append((Object)"(").append((Object)dmlVar).append((Object)")").toString(), false);
            return;
        }
        throw new DMLRuntimeException(new StringBuilder().append((Object)"Cannot visualize the variable of type:").append((Object)varType).toString());
    }

    public static void appendTrainingVisualizationBody(VisualizeDMLGenerator $this, StringBuilder dmlScript, int numTabs) {
        if ($this.doVisualize()) {
            $this.tabDMLScript(dmlScript, numTabs).append($this.visTrainingDMLScript().toString());
        }
    }

    public static void appendValidationVisualizationBody(VisualizeDMLGenerator $this, StringBuilder dmlScript, int numTabs) {
        if ($this.doVisualize()) {
            $this.tabDMLScript(dmlScript, numTabs).append($this.visValidationDMLScript().toString());
        }
    }

    public static void $init$(VisualizeDMLGenerator $this) {
        $this.doVisualize_$eq(false);
        $this._tensorboardLogDir_$eq(null);
        $this.org$apache$sysml$api$dl$VisualizeDMLGenerator$_setter_$visTrainingDMLScript_$eq(new StringBuilder());
        $this.org$apache$sysml$api$dl$VisualizeDMLGenerator$_setter_$visValidationDMLScript_$eq(new StringBuilder());
    }
}

