/*
 * Decompiled with CFR 0.152.
 */
package jcuda.jcusparse;

import jcuda.CudaException;
import jcuda.LibUtils;
import jcuda.LogLevel;
import jcuda.Pointer;
import jcuda.cuComplex;
import jcuda.cuDoubleComplex;
import jcuda.jcusparse.bsric02Info;
import jcuda.jcusparse.bsrilu02Info;
import jcuda.jcusparse.bsrsm2Info;
import jcuda.jcusparse.bsrsv2Info;
import jcuda.jcusparse.csrgemm2Info;
import jcuda.jcusparse.csric02Info;
import jcuda.jcusparse.csrilu02Info;
import jcuda.jcusparse.csrsv2Info;
import jcuda.jcusparse.csru2csrInfo;
import jcuda.jcusparse.cusparseColorInfo;
import jcuda.jcusparse.cusparseHandle;
import jcuda.jcusparse.cusparseHybMat;
import jcuda.jcusparse.cusparseMatDescr;
import jcuda.jcusparse.cusparseSolveAnalysisInfo;
import jcuda.jcusparse.cusparseStatus;
import jcuda.runtime.JCuda;
import jcuda.runtime.cudaStream_t;

public class JCusparse {
    private static boolean initialized = false;
    private static boolean exceptionsEnabled = false;

    private JCusparse() {
    }

    public static void initialize() {
        if (!initialized) {
            String libraryBaseName = "JCusparse-" + JCuda.getJCudaVersion();
            String libraryName = LibUtils.createPlatformLibraryName(libraryBaseName);
            LibUtils.loadLibrary(libraryName, new String[0]);
            initialized = true;
        }
    }

    public static void setLogLevel(LogLevel logLevel) {
        JCusparse.setLogLevelNative(logLevel.ordinal());
    }

    private static native void setLogLevelNative(int var0);

    public static void setExceptionsEnabled(boolean enabled) {
        exceptionsEnabled = enabled;
    }

    private static int checkResult(int result) {
        if (exceptionsEnabled && result != 0) {
            throw new CudaException(cusparseStatus.stringFor(result));
        }
        return result;
    }

    private static int checkForError(int result) {
        if (exceptionsEnabled && result == -1) {
            throw new CudaException(cusparseStatus.stringFor(result));
        }
        return result;
    }

    public static int cusparseCreate(cusparseHandle handle) {
        return JCusparse.checkResult(JCusparse.cusparseCreateNative(handle));
    }

    private static native int cusparseCreateNative(cusparseHandle var0);

    public static int cusparseDestroy(cusparseHandle handle) {
        return JCusparse.checkResult(JCusparse.cusparseDestroyNative(handle));
    }

    private static native int cusparseDestroyNative(cusparseHandle var0);

    public static int cusparseGetVersion(cusparseHandle handle, int[] version) {
        return JCusparse.checkResult(JCusparse.cusparseGetVersionNative(handle, version));
    }

    private static native int cusparseGetVersionNative(cusparseHandle var0, int[] var1);

    public static int cusparseGetProperty(int type, int[] value) {
        return JCusparse.checkResult(JCusparse.cusparseGetPropertyNative(type, value));
    }

    private static native int cusparseGetPropertyNative(int var0, int[] var1);

    public static int cusparseSetStream(cusparseHandle handle, cudaStream_t streamId) {
        return JCusparse.checkResult(JCusparse.cusparseSetStreamNative(handle, streamId));
    }

    private static native int cusparseSetStreamNative(cusparseHandle var0, cudaStream_t var1);

    public static int cusparseGetStream(cusparseHandle handle, cudaStream_t streamId) {
        return JCusparse.checkResult(JCusparse.cusparseGetStreamNative(handle, streamId));
    }

    private static native int cusparseGetStreamNative(cusparseHandle var0, cudaStream_t var1);

    public static int cusparseGetPointerMode(cusparseHandle handle, int[] mode) {
        return JCusparse.checkResult(JCusparse.cusparseGetPointerModeNative(handle, mode));
    }

    private static native int cusparseGetPointerModeNative(cusparseHandle var0, int[] var1);

    public static int cusparseSetPointerMode(cusparseHandle handle, int mode) {
        return JCusparse.checkResult(JCusparse.cusparseSetPointerModeNative(handle, mode));
    }

    private static native int cusparseSetPointerModeNative(cusparseHandle var0, int var1);

    public static int cusparseCreateMatDescr(cusparseMatDescr descrA) {
        return JCusparse.checkResult(JCusparse.cusparseCreateMatDescrNative(descrA));
    }

    private static native int cusparseCreateMatDescrNative(cusparseMatDescr var0);

    public static int cusparseDestroyMatDescr(cusparseMatDescr descrA) {
        return JCusparse.checkResult(JCusparse.cusparseDestroyMatDescrNative(descrA));
    }

    private static native int cusparseDestroyMatDescrNative(cusparseMatDescr var0);

    public static int cusparseCopyMatDescr(cusparseMatDescr dest, cusparseMatDescr src) {
        return JCusparse.checkResult(JCusparse.cusparseCopyMatDescrNative(dest, src));
    }

    private static native int cusparseCopyMatDescrNative(cusparseMatDescr var0, cusparseMatDescr var1);

    public static int cusparseSetMatType(cusparseMatDescr descrA, int type) {
        return JCusparse.checkResult(JCusparse.cusparseSetMatTypeNative(descrA, type));
    }

    private static native int cusparseSetMatTypeNative(cusparseMatDescr var0, int var1);

    public static int cusparseGetMatType(cusparseMatDescr descrA) {
        return JCusparse.checkResult(JCusparse.cusparseGetMatTypeNative(descrA));
    }

    private static native int cusparseGetMatTypeNative(cusparseMatDescr var0);

    public static int cusparseSetMatFillMode(cusparseMatDescr descrA, int fillMode) {
        return JCusparse.checkResult(JCusparse.cusparseSetMatFillModeNative(descrA, fillMode));
    }

    private static native int cusparseSetMatFillModeNative(cusparseMatDescr var0, int var1);

    public static int cusparseGetMatFillMode(cusparseMatDescr descrA) {
        return JCusparse.checkResult(JCusparse.cusparseGetMatFillModeNative(descrA));
    }

    private static native int cusparseGetMatFillModeNative(cusparseMatDescr var0);

    public static int cusparseSetMatDiagType(cusparseMatDescr descrA, int diagType) {
        return JCusparse.checkResult(JCusparse.cusparseSetMatDiagTypeNative(descrA, diagType));
    }

    private static native int cusparseSetMatDiagTypeNative(cusparseMatDescr var0, int var1);

    public static int cusparseGetMatDiagType(cusparseMatDescr descrA) {
        return JCusparse.checkResult(JCusparse.cusparseGetMatDiagTypeNative(descrA));
    }

    private static native int cusparseGetMatDiagTypeNative(cusparseMatDescr var0);

    public static int cusparseSetMatIndexBase(cusparseMatDescr descrA, int base) {
        return JCusparse.checkResult(JCusparse.cusparseSetMatIndexBaseNative(descrA, base));
    }

    private static native int cusparseSetMatIndexBaseNative(cusparseMatDescr var0, int var1);

    public static int cusparseGetMatIndexBase(cusparseMatDescr descrA) {
        return JCusparse.checkResult(JCusparse.cusparseGetMatIndexBaseNative(descrA));
    }

    private static native int cusparseGetMatIndexBaseNative(cusparseMatDescr var0);

    public static int cusparseCreateSolveAnalysisInfo(cusparseSolveAnalysisInfo info) {
        return JCusparse.checkResult(JCusparse.cusparseCreateSolveAnalysisInfoNative(info));
    }

    private static native int cusparseCreateSolveAnalysisInfoNative(cusparseSolveAnalysisInfo var0);

    public static int cusparseDestroySolveAnalysisInfo(cusparseSolveAnalysisInfo info) {
        return JCusparse.checkResult(JCusparse.cusparseDestroySolveAnalysisInfoNative(info));
    }

    private static native int cusparseDestroySolveAnalysisInfoNative(cusparseSolveAnalysisInfo var0);

    public static int cusparseGetLevelInfo(cusparseHandle handle, cusparseSolveAnalysisInfo info, int[] nlevels, Pointer levelPtr, Pointer levelInd) {
        return JCusparse.checkResult(JCusparse.cusparseGetLevelInfoNative(handle, info, nlevels, levelPtr, levelInd));
    }

    private static native int cusparseGetLevelInfoNative(cusparseHandle var0, cusparseSolveAnalysisInfo var1, int[] var2, Pointer var3, Pointer var4);

    public static int cusparseCreateCsrsv2Info(csrsv2Info info) {
        return JCusparse.checkResult(JCusparse.cusparseCreateCsrsv2InfoNative(info));
    }

    private static native int cusparseCreateCsrsv2InfoNative(csrsv2Info var0);

    public static int cusparseDestroyCsrsv2Info(csrsv2Info info) {
        return JCusparse.checkResult(JCusparse.cusparseDestroyCsrsv2InfoNative(info));
    }

    private static native int cusparseDestroyCsrsv2InfoNative(csrsv2Info var0);

    public static int cusparseCreateCsric02Info(csric02Info info) {
        return JCusparse.checkResult(JCusparse.cusparseCreateCsric02InfoNative(info));
    }

    private static native int cusparseCreateCsric02InfoNative(csric02Info var0);

    public static int cusparseDestroyCsric02Info(csric02Info info) {
        return JCusparse.checkResult(JCusparse.cusparseDestroyCsric02InfoNative(info));
    }

    private static native int cusparseDestroyCsric02InfoNative(csric02Info var0);

    public static int cusparseCreateBsric02Info(bsric02Info info) {
        return JCusparse.checkResult(JCusparse.cusparseCreateBsric02InfoNative(info));
    }

    private static native int cusparseCreateBsric02InfoNative(bsric02Info var0);

    public static int cusparseDestroyBsric02Info(bsric02Info info) {
        return JCusparse.checkResult(JCusparse.cusparseDestroyBsric02InfoNative(info));
    }

    private static native int cusparseDestroyBsric02InfoNative(bsric02Info var0);

    public static int cusparseCreateCsrilu02Info(csrilu02Info info) {
        return JCusparse.checkResult(JCusparse.cusparseCreateCsrilu02InfoNative(info));
    }

    private static native int cusparseCreateCsrilu02InfoNative(csrilu02Info var0);

    public static int cusparseDestroyCsrilu02Info(csrilu02Info info) {
        return JCusparse.checkResult(JCusparse.cusparseDestroyCsrilu02InfoNative(info));
    }

    private static native int cusparseDestroyCsrilu02InfoNative(csrilu02Info var0);

    public static int cusparseCreateBsrilu02Info(bsrilu02Info info) {
        return JCusparse.checkResult(JCusparse.cusparseCreateBsrilu02InfoNative(info));
    }

    private static native int cusparseCreateBsrilu02InfoNative(bsrilu02Info var0);

    public static int cusparseDestroyBsrilu02Info(bsrilu02Info info) {
        return JCusparse.checkResult(JCusparse.cusparseDestroyBsrilu02InfoNative(info));
    }

    private static native int cusparseDestroyBsrilu02InfoNative(bsrilu02Info var0);

    public static int cusparseCreateBsrsv2Info(bsrsv2Info info) {
        return JCusparse.checkResult(JCusparse.cusparseCreateBsrsv2InfoNative(info));
    }

    private static native int cusparseCreateBsrsv2InfoNative(bsrsv2Info var0);

    public static int cusparseDestroyBsrsv2Info(bsrsv2Info info) {
        return JCusparse.checkResult(JCusparse.cusparseDestroyBsrsv2InfoNative(info));
    }

    private static native int cusparseDestroyBsrsv2InfoNative(bsrsv2Info var0);

    public static int cusparseCreateBsrsm2Info(bsrsm2Info info) {
        return JCusparse.checkResult(JCusparse.cusparseCreateBsrsm2InfoNative(info));
    }

    private static native int cusparseCreateBsrsm2InfoNative(bsrsm2Info var0);

    public static int cusparseDestroyBsrsm2Info(bsrsm2Info info) {
        return JCusparse.checkResult(JCusparse.cusparseDestroyBsrsm2InfoNative(info));
    }

    private static native int cusparseDestroyBsrsm2InfoNative(bsrsm2Info var0);

    public static int cusparseCreateHybMat(cusparseHybMat hybA) {
        return JCusparse.checkResult(JCusparse.cusparseCreateHybMatNative(hybA));
    }

    private static native int cusparseCreateHybMatNative(cusparseHybMat var0);

    public static int cusparseDestroyHybMat(cusparseHybMat hybA) {
        return JCusparse.checkResult(JCusparse.cusparseDestroyHybMatNative(hybA));
    }

    private static native int cusparseDestroyHybMatNative(cusparseHybMat var0);

    public static int cusparseCreateCsru2csrInfo(csru2csrInfo info) {
        return JCusparse.checkResult(JCusparse.cusparseCreateCsru2csrInfoNative(info));
    }

    private static native int cusparseCreateCsru2csrInfoNative(csru2csrInfo var0);

    public static int cusparseDestroyCsru2csrInfo(csru2csrInfo info) {
        return JCusparse.checkResult(JCusparse.cusparseDestroyCsru2csrInfoNative(info));
    }

    private static native int cusparseDestroyCsru2csrInfoNative(csru2csrInfo var0);

    public static int cusparseCreateColorInfo(cusparseColorInfo info) {
        return JCusparse.checkResult(JCusparse.cusparseCreateColorInfoNative(info));
    }

    private static native int cusparseCreateColorInfoNative(cusparseColorInfo var0);

    public static int cusparseDestroyColorInfo(cusparseColorInfo info) {
        return JCusparse.checkResult(JCusparse.cusparseDestroyColorInfoNative(info));
    }

    private static native int cusparseDestroyColorInfoNative(cusparseColorInfo var0);

    public static int cusparseSetColorAlgs(cusparseColorInfo info, int alg) {
        return JCusparse.checkResult(JCusparse.cusparseSetColorAlgsNative(info, alg));
    }

    private static native int cusparseSetColorAlgsNative(cusparseColorInfo var0, int var1);

    public static int cusparseGetColorAlgs(cusparseColorInfo info, int[] alg) {
        return JCusparse.checkResult(JCusparse.cusparseGetColorAlgsNative(info, alg));
    }

    private static native int cusparseGetColorAlgsNative(cusparseColorInfo var0, int[] var1);

    public static int cusparseSaxpyi(cusparseHandle handle, int nnz, Pointer alpha, Pointer xVal, Pointer xInd, Pointer y, int idxBase) {
        return JCusparse.checkResult(JCusparse.cusparseSaxpyiNative(handle, nnz, alpha, xVal, xInd, y, idxBase));
    }

    private static native int cusparseSaxpyiNative(cusparseHandle var0, int var1, Pointer var2, Pointer var3, Pointer var4, Pointer var5, int var6);

    public static int cusparseDaxpyi(cusparseHandle handle, int nnz, Pointer alpha, Pointer xVal, Pointer xInd, Pointer y, int idxBase) {
        return JCusparse.checkResult(JCusparse.cusparseDaxpyiNative(handle, nnz, alpha, xVal, xInd, y, idxBase));
    }

    private static native int cusparseDaxpyiNative(cusparseHandle var0, int var1, Pointer var2, Pointer var3, Pointer var4, Pointer var5, int var6);

    public static int cusparseCaxpyi(cusparseHandle handle, int nnz, Pointer alpha, Pointer xVal, Pointer xInd, Pointer y, int idxBase) {
        return JCusparse.checkResult(JCusparse.cusparseCaxpyiNative(handle, nnz, alpha, xVal, xInd, y, idxBase));
    }

    private static native int cusparseCaxpyiNative(cusparseHandle var0, int var1, Pointer var2, Pointer var3, Pointer var4, Pointer var5, int var6);

    public static int cusparseZaxpyi(cusparseHandle handle, int nnz, Pointer alpha, Pointer xVal, Pointer xInd, Pointer y, int idxBase) {
        return JCusparse.checkResult(JCusparse.cusparseZaxpyiNative(handle, nnz, alpha, xVal, xInd, y, idxBase));
    }

    private static native int cusparseZaxpyiNative(cusparseHandle var0, int var1, Pointer var2, Pointer var3, Pointer var4, Pointer var5, int var6);

    public static int cusparseSdoti(cusparseHandle handle, int nnz, Pointer xVal, Pointer xInd, Pointer y, Pointer resultDevHostPtr, int idxBase) {
        return JCusparse.checkResult(JCusparse.cusparseSdotiNative(handle, nnz, xVal, xInd, y, resultDevHostPtr, idxBase));
    }

    private static native int cusparseSdotiNative(cusparseHandle var0, int var1, Pointer var2, Pointer var3, Pointer var4, Pointer var5, int var6);

    public static int cusparseDdoti(cusparseHandle handle, int nnz, Pointer xVal, Pointer xInd, Pointer y, Pointer resultDevHostPtr, int idxBase) {
        return JCusparse.checkResult(JCusparse.cusparseDdotiNative(handle, nnz, xVal, xInd, y, resultDevHostPtr, idxBase));
    }

    private static native int cusparseDdotiNative(cusparseHandle var0, int var1, Pointer var2, Pointer var3, Pointer var4, Pointer var5, int var6);

    public static int cusparseCdoti(cusparseHandle handle, int nnz, Pointer xVal, Pointer xInd, Pointer y, Pointer resultDevHostPtr, int idxBase) {
        return JCusparse.checkResult(JCusparse.cusparseCdotiNative(handle, nnz, xVal, xInd, y, resultDevHostPtr, idxBase));
    }

    private static native int cusparseCdotiNative(cusparseHandle var0, int var1, Pointer var2, Pointer var3, Pointer var4, Pointer var5, int var6);

    public static int cusparseZdoti(cusparseHandle handle, int nnz, Pointer xVal, Pointer xInd, Pointer y, Pointer resultDevHostPtr, int idxBase) {
        return JCusparse.checkResult(JCusparse.cusparseZdotiNative(handle, nnz, xVal, xInd, y, resultDevHostPtr, idxBase));
    }

    private static native int cusparseZdotiNative(cusparseHandle var0, int var1, Pointer var2, Pointer var3, Pointer var4, Pointer var5, int var6);

    public static int cusparseCdotci(cusparseHandle handle, int nnz, Pointer xVal, Pointer xInd, Pointer y, Pointer resultDevHostPtr, int idxBase) {
        return JCusparse.checkResult(JCusparse.cusparseCdotciNative(handle, nnz, xVal, xInd, y, resultDevHostPtr, idxBase));
    }

    private static native int cusparseCdotciNative(cusparseHandle var0, int var1, Pointer var2, Pointer var3, Pointer var4, Pointer var5, int var6);

    public static int cusparseZdotci(cusparseHandle handle, int nnz, Pointer xVal, Pointer xInd, Pointer y, Pointer resultDevHostPtr, int idxBase) {
        return JCusparse.checkResult(JCusparse.cusparseZdotciNative(handle, nnz, xVal, xInd, y, resultDevHostPtr, idxBase));
    }

    private static native int cusparseZdotciNative(cusparseHandle var0, int var1, Pointer var2, Pointer var3, Pointer var4, Pointer var5, int var6);

    public static int cusparseSgthr(cusparseHandle handle, int nnz, Pointer y, Pointer xVal, Pointer xInd, int idxBase) {
        return JCusparse.checkResult(JCusparse.cusparseSgthrNative(handle, nnz, y, xVal, xInd, idxBase));
    }

    private static native int cusparseSgthrNative(cusparseHandle var0, int var1, Pointer var2, Pointer var3, Pointer var4, int var5);

    public static int cusparseDgthr(cusparseHandle handle, int nnz, Pointer y, Pointer xVal, Pointer xInd, int idxBase) {
        return JCusparse.checkResult(JCusparse.cusparseDgthrNative(handle, nnz, y, xVal, xInd, idxBase));
    }

    private static native int cusparseDgthrNative(cusparseHandle var0, int var1, Pointer var2, Pointer var3, Pointer var4, int var5);

    public static int cusparseCgthr(cusparseHandle handle, int nnz, Pointer y, Pointer xVal, Pointer xInd, int idxBase) {
        return JCusparse.checkResult(JCusparse.cusparseCgthrNative(handle, nnz, y, xVal, xInd, idxBase));
    }

    private static native int cusparseCgthrNative(cusparseHandle var0, int var1, Pointer var2, Pointer var3, Pointer var4, int var5);

    public static int cusparseZgthr(cusparseHandle handle, int nnz, Pointer y, Pointer xVal, Pointer xInd, int idxBase) {
        return JCusparse.checkResult(JCusparse.cusparseZgthrNative(handle, nnz, y, xVal, xInd, idxBase));
    }

    private static native int cusparseZgthrNative(cusparseHandle var0, int var1, Pointer var2, Pointer var3, Pointer var4, int var5);

    public static int cusparseSgthrz(cusparseHandle handle, int nnz, Pointer y, Pointer xVal, Pointer xInd, int idxBase) {
        return JCusparse.checkResult(JCusparse.cusparseSgthrzNative(handle, nnz, y, xVal, xInd, idxBase));
    }

    private static native int cusparseSgthrzNative(cusparseHandle var0, int var1, Pointer var2, Pointer var3, Pointer var4, int var5);

    public static int cusparseDgthrz(cusparseHandle handle, int nnz, Pointer y, Pointer xVal, Pointer xInd, int idxBase) {
        return JCusparse.checkResult(JCusparse.cusparseDgthrzNative(handle, nnz, y, xVal, xInd, idxBase));
    }

    private static native int cusparseDgthrzNative(cusparseHandle var0, int var1, Pointer var2, Pointer var3, Pointer var4, int var5);

    public static int cusparseCgthrz(cusparseHandle handle, int nnz, Pointer y, Pointer xVal, Pointer xInd, int idxBase) {
        return JCusparse.checkResult(JCusparse.cusparseCgthrzNative(handle, nnz, y, xVal, xInd, idxBase));
    }

    private static native int cusparseCgthrzNative(cusparseHandle var0, int var1, Pointer var2, Pointer var3, Pointer var4, int var5);

    public static int cusparseZgthrz(cusparseHandle handle, int nnz, Pointer y, Pointer xVal, Pointer xInd, int idxBase) {
        return JCusparse.checkResult(JCusparse.cusparseZgthrzNative(handle, nnz, y, xVal, xInd, idxBase));
    }

    private static native int cusparseZgthrzNative(cusparseHandle var0, int var1, Pointer var2, Pointer var3, Pointer var4, int var5);

    public static int cusparseSsctr(cusparseHandle handle, int nnz, Pointer xVal, Pointer xInd, Pointer y, int idxBase) {
        return JCusparse.checkResult(JCusparse.cusparseSsctrNative(handle, nnz, xVal, xInd, y, idxBase));
    }

    private static native int cusparseSsctrNative(cusparseHandle var0, int var1, Pointer var2, Pointer var3, Pointer var4, int var5);

    public static int cusparseDsctr(cusparseHandle handle, int nnz, Pointer xVal, Pointer xInd, Pointer y, int idxBase) {
        return JCusparse.checkResult(JCusparse.cusparseDsctrNative(handle, nnz, xVal, xInd, y, idxBase));
    }

    private static native int cusparseDsctrNative(cusparseHandle var0, int var1, Pointer var2, Pointer var3, Pointer var4, int var5);

    public static int cusparseCsctr(cusparseHandle handle, int nnz, Pointer xVal, Pointer xInd, Pointer y, int idxBase) {
        return JCusparse.checkResult(JCusparse.cusparseCsctrNative(handle, nnz, xVal, xInd, y, idxBase));
    }

    private static native int cusparseCsctrNative(cusparseHandle var0, int var1, Pointer var2, Pointer var3, Pointer var4, int var5);

    public static int cusparseZsctr(cusparseHandle handle, int nnz, Pointer xVal, Pointer xInd, Pointer y, int idxBase) {
        return JCusparse.checkResult(JCusparse.cusparseZsctrNative(handle, nnz, xVal, xInd, y, idxBase));
    }

    private static native int cusparseZsctrNative(cusparseHandle var0, int var1, Pointer var2, Pointer var3, Pointer var4, int var5);

    public static int cusparseSroti(cusparseHandle handle, int nnz, Pointer xVal, Pointer xInd, Pointer y, Pointer c, Pointer s, int idxBase) {
        return JCusparse.checkResult(JCusparse.cusparseSrotiNative(handle, nnz, xVal, xInd, y, c, s, idxBase));
    }

    private static native int cusparseSrotiNative(cusparseHandle var0, int var1, Pointer var2, Pointer var3, Pointer var4, Pointer var5, Pointer var6, int var7);

    public static int cusparseDroti(cusparseHandle handle, int nnz, Pointer xVal, Pointer xInd, Pointer y, Pointer c, Pointer s, int idxBase) {
        return JCusparse.checkResult(JCusparse.cusparseDrotiNative(handle, nnz, xVal, xInd, y, c, s, idxBase));
    }

    private static native int cusparseDrotiNative(cusparseHandle var0, int var1, Pointer var2, Pointer var3, Pointer var4, Pointer var5, Pointer var6, int var7);

    public static int cusparseSgemvi(cusparseHandle handle, int transA, int m, int n, Pointer alpha, Pointer A, int lda, int nnz, Pointer xVal, Pointer xInd, Pointer beta, Pointer y, int idxBase, Pointer pBuffer) {
        return JCusparse.checkResult(JCusparse.cusparseSgemviNative(handle, transA, m, n, alpha, A, lda, nnz, xVal, xInd, beta, y, idxBase, pBuffer));
    }

    private static native int cusparseSgemviNative(cusparseHandle var0, int var1, int var2, int var3, Pointer var4, Pointer var5, int var6, int var7, Pointer var8, Pointer var9, Pointer var10, Pointer var11, int var12, Pointer var13);

    public static int cusparseSgemvi_bufferSize(cusparseHandle handle, int transA, int m, int n, int nnz, int[] pBufferSize) {
        return JCusparse.checkResult(JCusparse.cusparseSgemvi_bufferSizeNative(handle, transA, m, n, nnz, pBufferSize));
    }

    private static native int cusparseSgemvi_bufferSizeNative(cusparseHandle var0, int var1, int var2, int var3, int var4, int[] var5);

    public static int cusparseDgemvi(cusparseHandle handle, int transA, int m, int n, Pointer alpha, Pointer A, int lda, int nnz, Pointer xVal, Pointer xInd, Pointer beta, Pointer y, int idxBase, Pointer pBuffer) {
        return JCusparse.checkResult(JCusparse.cusparseDgemviNative(handle, transA, m, n, alpha, A, lda, nnz, xVal, xInd, beta, y, idxBase, pBuffer));
    }

    private static native int cusparseDgemviNative(cusparseHandle var0, int var1, int var2, int var3, Pointer var4, Pointer var5, int var6, int var7, Pointer var8, Pointer var9, Pointer var10, Pointer var11, int var12, Pointer var13);

    public static int cusparseDgemvi_bufferSize(cusparseHandle handle, int transA, int m, int n, int nnz, int[] pBufferSize) {
        return JCusparse.checkResult(JCusparse.cusparseDgemvi_bufferSizeNative(handle, transA, m, n, nnz, pBufferSize));
    }

    private static native int cusparseDgemvi_bufferSizeNative(cusparseHandle var0, int var1, int var2, int var3, int var4, int[] var5);

    public static int cusparseCgemvi(cusparseHandle handle, int transA, int m, int n, Pointer alpha, Pointer A, int lda, int nnz, Pointer xVal, Pointer xInd, Pointer beta, Pointer y, int idxBase, Pointer pBuffer) {
        return JCusparse.checkResult(JCusparse.cusparseCgemviNative(handle, transA, m, n, alpha, A, lda, nnz, xVal, xInd, beta, y, idxBase, pBuffer));
    }

    private static native int cusparseCgemviNative(cusparseHandle var0, int var1, int var2, int var3, Pointer var4, Pointer var5, int var6, int var7, Pointer var8, Pointer var9, Pointer var10, Pointer var11, int var12, Pointer var13);

    public static int cusparseCgemvi_bufferSize(cusparseHandle handle, int transA, int m, int n, int nnz, int[] pBufferSize) {
        return JCusparse.checkResult(JCusparse.cusparseCgemvi_bufferSizeNative(handle, transA, m, n, nnz, pBufferSize));
    }

    private static native int cusparseCgemvi_bufferSizeNative(cusparseHandle var0, int var1, int var2, int var3, int var4, int[] var5);

    public static int cusparseZgemvi(cusparseHandle handle, int transA, int m, int n, Pointer alpha, Pointer A, int lda, int nnz, Pointer xVal, Pointer xInd, Pointer beta, Pointer y, int idxBase, Pointer pBuffer) {
        return JCusparse.checkResult(JCusparse.cusparseZgemviNative(handle, transA, m, n, alpha, A, lda, nnz, xVal, xInd, beta, y, idxBase, pBuffer));
    }

    private static native int cusparseZgemviNative(cusparseHandle var0, int var1, int var2, int var3, Pointer var4, Pointer var5, int var6, int var7, Pointer var8, Pointer var9, Pointer var10, Pointer var11, int var12, Pointer var13);

    public static int cusparseZgemvi_bufferSize(cusparseHandle handle, int transA, int m, int n, int nnz, int[] pBufferSize) {
        return JCusparse.checkResult(JCusparse.cusparseZgemvi_bufferSizeNative(handle, transA, m, n, nnz, pBufferSize));
    }

    private static native int cusparseZgemvi_bufferSizeNative(cusparseHandle var0, int var1, int var2, int var3, int var4, int[] var5);

    public static int cusparseScsrmv(cusparseHandle handle, int transA, int m, int n, int nnz, Pointer alpha, cusparseMatDescr descrA, Pointer csrSortedValA, Pointer csrSortedRowPtrA, Pointer csrSortedColIndA, Pointer x, Pointer beta, Pointer y) {
        return JCusparse.checkResult(JCusparse.cusparseScsrmvNative(handle, transA, m, n, nnz, alpha, descrA, csrSortedValA, csrSortedRowPtrA, csrSortedColIndA, x, beta, y));
    }

    private static native int cusparseScsrmvNative(cusparseHandle var0, int var1, int var2, int var3, int var4, Pointer var5, cusparseMatDescr var6, Pointer var7, Pointer var8, Pointer var9, Pointer var10, Pointer var11, Pointer var12);

    public static int cusparseDcsrmv(cusparseHandle handle, int transA, int m, int n, int nnz, Pointer alpha, cusparseMatDescr descrA, Pointer csrSortedValA, Pointer csrSortedRowPtrA, Pointer csrSortedColIndA, Pointer x, Pointer beta, Pointer y) {
        return JCusparse.checkResult(JCusparse.cusparseDcsrmvNative(handle, transA, m, n, nnz, alpha, descrA, csrSortedValA, csrSortedRowPtrA, csrSortedColIndA, x, beta, y));
    }

    private static native int cusparseDcsrmvNative(cusparseHandle var0, int var1, int var2, int var3, int var4, Pointer var5, cusparseMatDescr var6, Pointer var7, Pointer var8, Pointer var9, Pointer var10, Pointer var11, Pointer var12);

    public static int cusparseCcsrmv(cusparseHandle handle, int transA, int m, int n, int nnz, Pointer alpha, cusparseMatDescr descrA, Pointer csrSortedValA, Pointer csrSortedRowPtrA, Pointer csrSortedColIndA, Pointer x, Pointer beta, Pointer y) {
        return JCusparse.checkResult(JCusparse.cusparseCcsrmvNative(handle, transA, m, n, nnz, alpha, descrA, csrSortedValA, csrSortedRowPtrA, csrSortedColIndA, x, beta, y));
    }

    private static native int cusparseCcsrmvNative(cusparseHandle var0, int var1, int var2, int var3, int var4, Pointer var5, cusparseMatDescr var6, Pointer var7, Pointer var8, Pointer var9, Pointer var10, Pointer var11, Pointer var12);

    public static int cusparseZcsrmv(cusparseHandle handle, int transA, int m, int n, int nnz, Pointer alpha, cusparseMatDescr descrA, Pointer csrSortedValA, Pointer csrSortedRowPtrA, Pointer csrSortedColIndA, Pointer x, Pointer beta, Pointer y) {
        return JCusparse.checkResult(JCusparse.cusparseZcsrmvNative(handle, transA, m, n, nnz, alpha, descrA, csrSortedValA, csrSortedRowPtrA, csrSortedColIndA, x, beta, y));
    }

    private static native int cusparseZcsrmvNative(cusparseHandle var0, int var1, int var2, int var3, int var4, Pointer var5, cusparseMatDescr var6, Pointer var7, Pointer var8, Pointer var9, Pointer var10, Pointer var11, Pointer var12);

    public static int cusparseCsrmvEx_bufferSize(cusparseHandle handle, int alg, int transA, int m, int n, int nnz, Pointer alpha, int alphatype, cusparseMatDescr descrA, Pointer csrValA, int csrValAtype, Pointer csrRowPtrA, Pointer csrColIndA, Pointer x, int xtype, Pointer beta, int betatype, Pointer y, int ytype, int executiontype, long[] bufferSizeInBytes) {
        return JCusparse.checkResult(JCusparse.cusparseCsrmvEx_bufferSizeNative(handle, alg, transA, m, n, nnz, alpha, alphatype, descrA, csrValA, csrValAtype, csrRowPtrA, csrColIndA, x, xtype, beta, betatype, y, ytype, executiontype, bufferSizeInBytes));
    }

    private static native int cusparseCsrmvEx_bufferSizeNative(cusparseHandle var0, int var1, int var2, int var3, int var4, int var5, Pointer var6, int var7, cusparseMatDescr var8, Pointer var9, int var10, Pointer var11, Pointer var12, Pointer var13, int var14, Pointer var15, int var16, Pointer var17, int var18, int var19, long[] var20);

    public static int cusparseCsrmvEx(cusparseHandle handle, int alg, int transA, int m, int n, int nnz, Pointer alpha, int alphatype, cusparseMatDescr descrA, Pointer csrValA, int csrValAtype, Pointer csrRowPtrA, Pointer csrColIndA, Pointer x, int xtype, Pointer beta, int betatype, Pointer y, int ytype, int executiontype, Pointer buffer) {
        return JCusparse.checkResult(JCusparse.cusparseCsrmvExNative(handle, alg, transA, m, n, nnz, alpha, alphatype, descrA, csrValA, csrValAtype, csrRowPtrA, csrColIndA, x, xtype, beta, betatype, y, ytype, executiontype, buffer));
    }

    private static native int cusparseCsrmvExNative(cusparseHandle var0, int var1, int var2, int var3, int var4, int var5, Pointer var6, int var7, cusparseMatDescr var8, Pointer var9, int var10, Pointer var11, Pointer var12, Pointer var13, int var14, Pointer var15, int var16, Pointer var17, int var18, int var19, Pointer var20);

    public static int cusparseScsrmv_mp(cusparseHandle handle, int transA, int m, int n, int nnz, Pointer alpha, cusparseMatDescr descrA, Pointer csrSortedValA, Pointer csrSortedRowPtrA, Pointer csrSortedColIndA, Pointer x, Pointer beta, Pointer y) {
        return JCusparse.checkResult(JCusparse.cusparseScsrmv_mpNative(handle, transA, m, n, nnz, alpha, descrA, csrSortedValA, csrSortedRowPtrA, csrSortedColIndA, x, beta, y));
    }

    private static native int cusparseScsrmv_mpNative(cusparseHandle var0, int var1, int var2, int var3, int var4, Pointer var5, cusparseMatDescr var6, Pointer var7, Pointer var8, Pointer var9, Pointer var10, Pointer var11, Pointer var12);

    public static int cusparseDcsrmv_mp(cusparseHandle handle, int transA, int m, int n, int nnz, Pointer alpha, cusparseMatDescr descrA, Pointer csrSortedValA, Pointer csrSortedRowPtrA, Pointer csrSortedColIndA, Pointer x, Pointer beta, Pointer y) {
        return JCusparse.checkResult(JCusparse.cusparseDcsrmv_mpNative(handle, transA, m, n, nnz, alpha, descrA, csrSortedValA, csrSortedRowPtrA, csrSortedColIndA, x, beta, y));
    }

    private static native int cusparseDcsrmv_mpNative(cusparseHandle var0, int var1, int var2, int var3, int var4, Pointer var5, cusparseMatDescr var6, Pointer var7, Pointer var8, Pointer var9, Pointer var10, Pointer var11, Pointer var12);

    public static int cusparseCcsrmv_mp(cusparseHandle handle, int transA, int m, int n, int nnz, Pointer alpha, cusparseMatDescr descrA, Pointer csrSortedValA, Pointer csrSortedRowPtrA, Pointer csrSortedColIndA, Pointer x, Pointer beta, Pointer y) {
        return JCusparse.checkResult(JCusparse.cusparseCcsrmv_mpNative(handle, transA, m, n, nnz, alpha, descrA, csrSortedValA, csrSortedRowPtrA, csrSortedColIndA, x, beta, y));
    }

    private static native int cusparseCcsrmv_mpNative(cusparseHandle var0, int var1, int var2, int var3, int var4, Pointer var5, cusparseMatDescr var6, Pointer var7, Pointer var8, Pointer var9, Pointer var10, Pointer var11, Pointer var12);

    public static int cusparseZcsrmv_mp(cusparseHandle handle, int transA, int m, int n, int nnz, Pointer alpha, cusparseMatDescr descrA, Pointer csrSortedValA, Pointer csrSortedRowPtrA, Pointer csrSortedColIndA, Pointer x, Pointer beta, Pointer y) {
        return JCusparse.checkResult(JCusparse.cusparseZcsrmv_mpNative(handle, transA, m, n, nnz, alpha, descrA, csrSortedValA, csrSortedRowPtrA, csrSortedColIndA, x, beta, y));
    }

    private static native int cusparseZcsrmv_mpNative(cusparseHandle var0, int var1, int var2, int var3, int var4, Pointer var5, cusparseMatDescr var6, Pointer var7, Pointer var8, Pointer var9, Pointer var10, Pointer var11, Pointer var12);

    public static int cusparseShybmv(cusparseHandle handle, int transA, Pointer alpha, cusparseMatDescr descrA, cusparseHybMat hybA, Pointer x, Pointer beta, Pointer y) {
        return JCusparse.checkResult(JCusparse.cusparseShybmvNative(handle, transA, alpha, descrA, hybA, x, beta, y));
    }

    private static native int cusparseShybmvNative(cusparseHandle var0, int var1, Pointer var2, cusparseMatDescr var3, cusparseHybMat var4, Pointer var5, Pointer var6, Pointer var7);

    public static int cusparseDhybmv(cusparseHandle handle, int transA, Pointer alpha, cusparseMatDescr descrA, cusparseHybMat hybA, Pointer x, Pointer beta, Pointer y) {
        return JCusparse.checkResult(JCusparse.cusparseDhybmvNative(handle, transA, alpha, descrA, hybA, x, beta, y));
    }

    private static native int cusparseDhybmvNative(cusparseHandle var0, int var1, Pointer var2, cusparseMatDescr var3, cusparseHybMat var4, Pointer var5, Pointer var6, Pointer var7);

    public static int cusparseChybmv(cusparseHandle handle, int transA, Pointer alpha, cusparseMatDescr descrA, cusparseHybMat hybA, Pointer x, Pointer beta, Pointer y) {
        return JCusparse.checkResult(JCusparse.cusparseChybmvNative(handle, transA, alpha, descrA, hybA, x, beta, y));
    }

    private static native int cusparseChybmvNative(cusparseHandle var0, int var1, Pointer var2, cusparseMatDescr var3, cusparseHybMat var4, Pointer var5, Pointer var6, Pointer var7);

    public static int cusparseZhybmv(cusparseHandle handle, int transA, Pointer alpha, cusparseMatDescr descrA, cusparseHybMat hybA, Pointer x, Pointer beta, Pointer y) {
        return JCusparse.checkResult(JCusparse.cusparseZhybmvNative(handle, transA, alpha, descrA, hybA, x, beta, y));
    }

    private static native int cusparseZhybmvNative(cusparseHandle var0, int var1, Pointer var2, cusparseMatDescr var3, cusparseHybMat var4, Pointer var5, Pointer var6, Pointer var7);

    public static int cusparseSbsrmv(cusparseHandle handle, int dirA, int transA, int mb, int nb, int nnzb, Pointer alpha, cusparseMatDescr descrA, Pointer bsrSortedValA, Pointer bsrSortedRowPtrA, Pointer bsrSortedColIndA, int blockDim, Pointer x, Pointer beta, Pointer y) {
        return JCusparse.checkResult(JCusparse.cusparseSbsrmvNative(handle, dirA, transA, mb, nb, nnzb, alpha, descrA, bsrSortedValA, bsrSortedRowPtrA, bsrSortedColIndA, blockDim, x, beta, y));
    }

    private static native int cusparseSbsrmvNative(cusparseHandle var0, int var1, int var2, int var3, int var4, int var5, Pointer var6, cusparseMatDescr var7, Pointer var8, Pointer var9, Pointer var10, int var11, Pointer var12, Pointer var13, Pointer var14);

    public static int cusparseDbsrmv(cusparseHandle handle, int dirA, int transA, int mb, int nb, int nnzb, Pointer alpha, cusparseMatDescr descrA, Pointer bsrSortedValA, Pointer bsrSortedRowPtrA, Pointer bsrSortedColIndA, int blockDim, Pointer x, Pointer beta, Pointer y) {
        return JCusparse.checkResult(JCusparse.cusparseDbsrmvNative(handle, dirA, transA, mb, nb, nnzb, alpha, descrA, bsrSortedValA, bsrSortedRowPtrA, bsrSortedColIndA, blockDim, x, beta, y));
    }

    private static native int cusparseDbsrmvNative(cusparseHandle var0, int var1, int var2, int var3, int var4, int var5, Pointer var6, cusparseMatDescr var7, Pointer var8, Pointer var9, Pointer var10, int var11, Pointer var12, Pointer var13, Pointer var14);

    public static int cusparseCbsrmv(cusparseHandle handle, int dirA, int transA, int mb, int nb, int nnzb, Pointer alpha, cusparseMatDescr descrA, Pointer bsrSortedValA, Pointer bsrSortedRowPtrA, Pointer bsrSortedColIndA, int blockDim, Pointer x, Pointer beta, Pointer y) {
        return JCusparse.checkResult(JCusparse.cusparseCbsrmvNative(handle, dirA, transA, mb, nb, nnzb, alpha, descrA, bsrSortedValA, bsrSortedRowPtrA, bsrSortedColIndA, blockDim, x, beta, y));
    }

    private static native int cusparseCbsrmvNative(cusparseHandle var0, int var1, int var2, int var3, int var4, int var5, Pointer var6, cusparseMatDescr var7, Pointer var8, Pointer var9, Pointer var10, int var11, Pointer var12, Pointer var13, Pointer var14);

    public static int cusparseZbsrmv(cusparseHandle handle, int dirA, int transA, int mb, int nb, int nnzb, Pointer alpha, cusparseMatDescr descrA, Pointer bsrSortedValA, Pointer bsrSortedRowPtrA, Pointer bsrSortedColIndA, int blockDim, Pointer x, Pointer beta, Pointer y) {
        return JCusparse.checkResult(JCusparse.cusparseZbsrmvNative(handle, dirA, transA, mb, nb, nnzb, alpha, descrA, bsrSortedValA, bsrSortedRowPtrA, bsrSortedColIndA, blockDim, x, beta, y));
    }

    private static native int cusparseZbsrmvNative(cusparseHandle var0, int var1, int var2, int var3, int var4, int var5, Pointer var6, cusparseMatDescr var7, Pointer var8, Pointer var9, Pointer var10, int var11, Pointer var12, Pointer var13, Pointer var14);

    public static int cusparseSbsrxmv(cusparseHandle handle, int dirA, int transA, int sizeOfMask, int mb, int nb, int nnzb, Pointer alpha, cusparseMatDescr descrA, Pointer bsrSortedValA, Pointer bsrSortedMaskPtrA, Pointer bsrSortedRowPtrA, Pointer bsrSortedEndPtrA, Pointer bsrSortedColIndA, int blockDim, Pointer x, Pointer beta, Pointer y) {
        return JCusparse.checkResult(JCusparse.cusparseSbsrxmvNative(handle, dirA, transA, sizeOfMask, mb, nb, nnzb, alpha, descrA, bsrSortedValA, bsrSortedMaskPtrA, bsrSortedRowPtrA, bsrSortedEndPtrA, bsrSortedColIndA, blockDim, x, beta, y));
    }

    private static native int cusparseSbsrxmvNative(cusparseHandle var0, int var1, int var2, int var3, int var4, int var5, int var6, Pointer var7, cusparseMatDescr var8, Pointer var9, Pointer var10, Pointer var11, Pointer var12, Pointer var13, int var14, Pointer var15, Pointer var16, Pointer var17);

    public static int cusparseDbsrxmv(cusparseHandle handle, int dirA, int transA, int sizeOfMask, int mb, int nb, int nnzb, Pointer alpha, cusparseMatDescr descrA, Pointer bsrSortedValA, Pointer bsrSortedMaskPtrA, Pointer bsrSortedRowPtrA, Pointer bsrSortedEndPtrA, Pointer bsrSortedColIndA, int blockDim, Pointer x, Pointer beta, Pointer y) {
        return JCusparse.checkResult(JCusparse.cusparseDbsrxmvNative(handle, dirA, transA, sizeOfMask, mb, nb, nnzb, alpha, descrA, bsrSortedValA, bsrSortedMaskPtrA, bsrSortedRowPtrA, bsrSortedEndPtrA, bsrSortedColIndA, blockDim, x, beta, y));
    }

    private static native int cusparseDbsrxmvNative(cusparseHandle var0, int var1, int var2, int var3, int var4, int var5, int var6, Pointer var7, cusparseMatDescr var8, Pointer var9, Pointer var10, Pointer var11, Pointer var12, Pointer var13, int var14, Pointer var15, Pointer var16, Pointer var17);

    public static int cusparseCbsrxmv(cusparseHandle handle, int dirA, int transA, int sizeOfMask, int mb, int nb, int nnzb, Pointer alpha, cusparseMatDescr descrA, Pointer bsrSortedValA, Pointer bsrSortedMaskPtrA, Pointer bsrSortedRowPtrA, Pointer bsrSortedEndPtrA, Pointer bsrSortedColIndA, int blockDim, Pointer x, Pointer beta, Pointer y) {
        return JCusparse.checkResult(JCusparse.cusparseCbsrxmvNative(handle, dirA, transA, sizeOfMask, mb, nb, nnzb, alpha, descrA, bsrSortedValA, bsrSortedMaskPtrA, bsrSortedRowPtrA, bsrSortedEndPtrA, bsrSortedColIndA, blockDim, x, beta, y));
    }

    private static native int cusparseCbsrxmvNative(cusparseHandle var0, int var1, int var2, int var3, int var4, int var5, int var6, Pointer var7, cusparseMatDescr var8, Pointer var9, Pointer var10, Pointer var11, Pointer var12, Pointer var13, int var14, Pointer var15, Pointer var16, Pointer var17);

    public static int cusparseZbsrxmv(cusparseHandle handle, int dirA, int transA, int sizeOfMask, int mb, int nb, int nnzb, Pointer alpha, cusparseMatDescr descrA, Pointer bsrSortedValA, Pointer bsrSortedMaskPtrA, Pointer bsrSortedRowPtrA, Pointer bsrSortedEndPtrA, Pointer bsrSortedColIndA, int blockDim, Pointer x, Pointer beta, Pointer y) {
        return JCusparse.checkResult(JCusparse.cusparseZbsrxmvNative(handle, dirA, transA, sizeOfMask, mb, nb, nnzb, alpha, descrA, bsrSortedValA, bsrSortedMaskPtrA, bsrSortedRowPtrA, bsrSortedEndPtrA, bsrSortedColIndA, blockDim, x, beta, y));
    }

    private static native int cusparseZbsrxmvNative(cusparseHandle var0, int var1, int var2, int var3, int var4, int var5, int var6, Pointer var7, cusparseMatDescr var8, Pointer var9, Pointer var10, Pointer var11, Pointer var12, Pointer var13, int var14, Pointer var15, Pointer var16, Pointer var17);

    public static int cusparseCsrsv_analysisEx(cusparseHandle handle, int transA, int m, int nnz, cusparseMatDescr descrA, Pointer csrSortedValA, int csrSortedValAtype, Pointer csrSortedRowPtrA, Pointer csrSortedColIndA, cusparseSolveAnalysisInfo info, int executiontype) {
        return JCusparse.checkResult(JCusparse.cusparseCsrsv_analysisExNative(handle, transA, m, nnz, descrA, csrSortedValA, csrSortedValAtype, csrSortedRowPtrA, csrSortedColIndA, info, executiontype));
    }

    private static native int cusparseCsrsv_analysisExNative(cusparseHandle var0, int var1, int var2, int var3, cusparseMatDescr var4, Pointer var5, int var6, Pointer var7, Pointer var8, cusparseSolveAnalysisInfo var9, int var10);

    public static int cusparseScsrsv_analysis(cusparseHandle handle, int transA, int m, int nnz, cusparseMatDescr descrA, Pointer csrSortedValA, Pointer csrSortedRowPtrA, Pointer csrSortedColIndA, cusparseSolveAnalysisInfo info) {
        return JCusparse.checkResult(JCusparse.cusparseScsrsv_analysisNative(handle, transA, m, nnz, descrA, csrSortedValA, csrSortedRowPtrA, csrSortedColIndA, info));
    }

    private static native int cusparseScsrsv_analysisNative(cusparseHandle var0, int var1, int var2, int var3, cusparseMatDescr var4, Pointer var5, Pointer var6, Pointer var7, cusparseSolveAnalysisInfo var8);

    public static int cusparseDcsrsv_analysis(cusparseHandle handle, int transA, int m, int nnz, cusparseMatDescr descrA, Pointer csrSortedValA, Pointer csrSortedRowPtrA, Pointer csrSortedColIndA, cusparseSolveAnalysisInfo info) {
        return JCusparse.checkResult(JCusparse.cusparseDcsrsv_analysisNative(handle, transA, m, nnz, descrA, csrSortedValA, csrSortedRowPtrA, csrSortedColIndA, info));
    }

    private static native int cusparseDcsrsv_analysisNative(cusparseHandle var0, int var1, int var2, int var3, cusparseMatDescr var4, Pointer var5, Pointer var6, Pointer var7, cusparseSolveAnalysisInfo var8);

    public static int cusparseCcsrsv_analysis(cusparseHandle handle, int transA, int m, int nnz, cusparseMatDescr descrA, Pointer csrSortedValA, Pointer csrSortedRowPtrA, Pointer csrSortedColIndA, cusparseSolveAnalysisInfo info) {
        return JCusparse.checkResult(JCusparse.cusparseCcsrsv_analysisNative(handle, transA, m, nnz, descrA, csrSortedValA, csrSortedRowPtrA, csrSortedColIndA, info));
    }

    private static native int cusparseCcsrsv_analysisNative(cusparseHandle var0, int var1, int var2, int var3, cusparseMatDescr var4, Pointer var5, Pointer var6, Pointer var7, cusparseSolveAnalysisInfo var8);

    public static int cusparseZcsrsv_analysis(cusparseHandle handle, int transA, int m, int nnz, cusparseMatDescr descrA, Pointer csrSortedValA, Pointer csrSortedRowPtrA, Pointer csrSortedColIndA, cusparseSolveAnalysisInfo info) {
        return JCusparse.checkResult(JCusparse.cusparseZcsrsv_analysisNative(handle, transA, m, nnz, descrA, csrSortedValA, csrSortedRowPtrA, csrSortedColIndA, info));
    }

    private static native int cusparseZcsrsv_analysisNative(cusparseHandle var0, int var1, int var2, int var3, cusparseMatDescr var4, Pointer var5, Pointer var6, Pointer var7, cusparseSolveAnalysisInfo var8);

    public static int cusparseCsrsv_solveEx(cusparseHandle handle, int transA, int m, Pointer alpha, int alphatype, cusparseMatDescr descrA, Pointer csrSortedValA, int csrSortedValAtype, Pointer csrSortedRowPtrA, Pointer csrSortedColIndA, cusparseSolveAnalysisInfo info, Pointer f, int ftype, Pointer x, int xtype, int executiontype) {
        return JCusparse.checkResult(JCusparse.cusparseCsrsv_solveExNative(handle, transA, m, alpha, alphatype, descrA, csrSortedValA, csrSortedValAtype, csrSortedRowPtrA, csrSortedColIndA, info, f, ftype, x, xtype, executiontype));
    }

    private static native int cusparseCsrsv_solveExNative(cusparseHandle var0, int var1, int var2, Pointer var3, int var4, cusparseMatDescr var5, Pointer var6, int var7, Pointer var8, Pointer var9, cusparseSolveAnalysisInfo var10, Pointer var11, int var12, Pointer var13, int var14, int var15);

    public static int cusparseScsrsv_solve(cusparseHandle handle, int transA, int m, Pointer alpha, cusparseMatDescr descrA, Pointer csrSortedValA, Pointer csrSortedRowPtrA, Pointer csrSortedColIndA, cusparseSolveAnalysisInfo info, Pointer f, Pointer x) {
        return JCusparse.checkResult(JCusparse.cusparseScsrsv_solveNative(handle, transA, m, alpha, descrA, csrSortedValA, csrSortedRowPtrA, csrSortedColIndA, info, f, x));
    }

    private static native int cusparseScsrsv_solveNative(cusparseHandle var0, int var1, int var2, Pointer var3, cusparseMatDescr var4, Pointer var5, Pointer var6, Pointer var7, cusparseSolveAnalysisInfo var8, Pointer var9, Pointer var10);

    public static int cusparseDcsrsv_solve(cusparseHandle handle, int transA, int m, Pointer alpha, cusparseMatDescr descrA, Pointer csrSortedValA, Pointer csrSortedRowPtrA, Pointer csrSortedColIndA, cusparseSolveAnalysisInfo info, Pointer f, Pointer x) {
        return JCusparse.checkResult(JCusparse.cusparseDcsrsv_solveNative(handle, transA, m, alpha, descrA, csrSortedValA, csrSortedRowPtrA, csrSortedColIndA, info, f, x));
    }

    private static native int cusparseDcsrsv_solveNative(cusparseHandle var0, int var1, int var2, Pointer var3, cusparseMatDescr var4, Pointer var5, Pointer var6, Pointer var7, cusparseSolveAnalysisInfo var8, Pointer var9, Pointer var10);

    public static int cusparseCcsrsv_solve(cusparseHandle handle, int transA, int m, Pointer alpha, cusparseMatDescr descrA, Pointer csrSortedValA, Pointer csrSortedRowPtrA, Pointer csrSortedColIndA, cusparseSolveAnalysisInfo info, Pointer f, Pointer x) {
        return JCusparse.checkResult(JCusparse.cusparseCcsrsv_solveNative(handle, transA, m, alpha, descrA, csrSortedValA, csrSortedRowPtrA, csrSortedColIndA, info, f, x));
    }

    private static native int cusparseCcsrsv_solveNative(cusparseHandle var0, int var1, int var2, Pointer var3, cusparseMatDescr var4, Pointer var5, Pointer var6, Pointer var7, cusparseSolveAnalysisInfo var8, Pointer var9, Pointer var10);

    public static int cusparseZcsrsv_solve(cusparseHandle handle, int transA, int m, Pointer alpha, cusparseMatDescr descrA, Pointer csrSortedValA, Pointer csrSortedRowPtrA, Pointer csrSortedColIndA, cusparseSolveAnalysisInfo info, Pointer f, Pointer x) {
        return JCusparse.checkResult(JCusparse.cusparseZcsrsv_solveNative(handle, transA, m, alpha, descrA, csrSortedValA, csrSortedRowPtrA, csrSortedColIndA, info, f, x));
    }

    private static native int cusparseZcsrsv_solveNative(cusparseHandle var0, int var1, int var2, Pointer var3, cusparseMatDescr var4, Pointer var5, Pointer var6, Pointer var7, cusparseSolveAnalysisInfo var8, Pointer var9, Pointer var10);

    public static int cusparseXcsrsv2_zeroPivot(cusparseHandle handle, csrsv2Info info, Pointer position) {
        return JCusparse.checkResult(JCusparse.cusparseXcsrsv2_zeroPivotNative(handle, info, position));
    }

    private static native int cusparseXcsrsv2_zeroPivotNative(cusparseHandle var0, csrsv2Info var1, Pointer var2);

    public static int cusparseScsrsv2_bufferSize(cusparseHandle handle, int transA, int m, int nnz, cusparseMatDescr descrA, Pointer csrSortedValA, Pointer csrSortedRowPtrA, Pointer csrSortedColIndA, csrsv2Info info, int[] pBufferSizeInBytes) {
        return JCusparse.checkResult(JCusparse.cusparseScsrsv2_bufferSizeNative(handle, transA, m, nnz, descrA, csrSortedValA, csrSortedRowPtrA, csrSortedColIndA, info, pBufferSizeInBytes));
    }

    private static native int cusparseScsrsv2_bufferSizeNative(cusparseHandle var0, int var1, int var2, int var3, cusparseMatDescr var4, Pointer var5, Pointer var6, Pointer var7, csrsv2Info var8, int[] var9);

    public static int cusparseDcsrsv2_bufferSize(cusparseHandle handle, int transA, int m, int nnz, cusparseMatDescr descrA, Pointer csrSortedValA, Pointer csrSortedRowPtrA, Pointer csrSortedColIndA, csrsv2Info info, int[] pBufferSizeInBytes) {
        return JCusparse.checkResult(JCusparse.cusparseDcsrsv2_bufferSizeNative(handle, transA, m, nnz, descrA, csrSortedValA, csrSortedRowPtrA, csrSortedColIndA, info, pBufferSizeInBytes));
    }

    private static native int cusparseDcsrsv2_bufferSizeNative(cusparseHandle var0, int var1, int var2, int var3, cusparseMatDescr var4, Pointer var5, Pointer var6, Pointer var7, csrsv2Info var8, int[] var9);

    public static int cusparseCcsrsv2_bufferSize(cusparseHandle handle, int transA, int m, int nnz, cusparseMatDescr descrA, Pointer csrSortedValA, Pointer csrSortedRowPtrA, Pointer csrSortedColIndA, csrsv2Info info, int[] pBufferSizeInBytes) {
        return JCusparse.checkResult(JCusparse.cusparseCcsrsv2_bufferSizeNative(handle, transA, m, nnz, descrA, csrSortedValA, csrSortedRowPtrA, csrSortedColIndA, info, pBufferSizeInBytes));
    }

    private static native int cusparseCcsrsv2_bufferSizeNative(cusparseHandle var0, int var1, int var2, int var3, cusparseMatDescr var4, Pointer var5, Pointer var6, Pointer var7, csrsv2Info var8, int[] var9);

    public static int cusparseZcsrsv2_bufferSize(cusparseHandle handle, int transA, int m, int nnz, cusparseMatDescr descrA, Pointer csrSortedValA, Pointer csrSortedRowPtrA, Pointer csrSortedColIndA, csrsv2Info info, int[] pBufferSizeInBytes) {
        return JCusparse.checkResult(JCusparse.cusparseZcsrsv2_bufferSizeNative(handle, transA, m, nnz, descrA, csrSortedValA, csrSortedRowPtrA, csrSortedColIndA, info, pBufferSizeInBytes));
    }

    private static native int cusparseZcsrsv2_bufferSizeNative(cusparseHandle var0, int var1, int var2, int var3, cusparseMatDescr var4, Pointer var5, Pointer var6, Pointer var7, csrsv2Info var8, int[] var9);

    public static int cusparseScsrsv2_bufferSizeExt(cusparseHandle handle, int transA, int m, int nnz, cusparseMatDescr descrA, Pointer csrSortedValA, Pointer csrSortedRowPtrA, Pointer csrSortedColIndA, csrsv2Info info, int[] pBufferSize) {
        return JCusparse.checkResult(JCusparse.cusparseScsrsv2_bufferSizeExtNative(handle, transA, m, nnz, descrA, csrSortedValA, csrSortedRowPtrA, csrSortedColIndA, info, pBufferSize));
    }

    private static native int cusparseScsrsv2_bufferSizeExtNative(cusparseHandle var0, int var1, int var2, int var3, cusparseMatDescr var4, Pointer var5, Pointer var6, Pointer var7, csrsv2Info var8, int[] var9);

    public static int cusparseDcsrsv2_bufferSizeExt(cusparseHandle handle, int transA, int m, int nnz, cusparseMatDescr descrA, Pointer csrSortedValA, Pointer csrSortedRowPtrA, Pointer csrSortedColIndA, csrsv2Info info, int[] pBufferSize) {
        return JCusparse.checkResult(JCusparse.cusparseDcsrsv2_bufferSizeExtNative(handle, transA, m, nnz, descrA, csrSortedValA, csrSortedRowPtrA, csrSortedColIndA, info, pBufferSize));
    }

    private static native int cusparseDcsrsv2_bufferSizeExtNative(cusparseHandle var0, int var1, int var2, int var3, cusparseMatDescr var4, Pointer var5, Pointer var6, Pointer var7, csrsv2Info var8, int[] var9);

    public static int cusparseCcsrsv2_bufferSizeExt(cusparseHandle handle, int transA, int m, int nnz, cusparseMatDescr descrA, Pointer csrSortedValA, Pointer csrSortedRowPtrA, Pointer csrSortedColIndA, csrsv2Info info, int[] pBufferSize) {
        return JCusparse.checkResult(JCusparse.cusparseCcsrsv2_bufferSizeExtNative(handle, transA, m, nnz, descrA, csrSortedValA, csrSortedRowPtrA, csrSortedColIndA, info, pBufferSize));
    }

    private static native int cusparseCcsrsv2_bufferSizeExtNative(cusparseHandle var0, int var1, int var2, int var3, cusparseMatDescr var4, Pointer var5, Pointer var6, Pointer var7, csrsv2Info var8, int[] var9);

    public static int cusparseZcsrsv2_bufferSizeExt(cusparseHandle handle, int transA, int m, int nnz, cusparseMatDescr descrA, Pointer csrSortedValA, Pointer csrSortedRowPtrA, Pointer csrSortedColIndA, csrsv2Info info, int[] pBufferSize) {
        return JCusparse.checkResult(JCusparse.cusparseZcsrsv2_bufferSizeExtNative(handle, transA, m, nnz, descrA, csrSortedValA, csrSortedRowPtrA, csrSortedColIndA, info, pBufferSize));
    }

    private static native int cusparseZcsrsv2_bufferSizeExtNative(cusparseHandle var0, int var1, int var2, int var3, cusparseMatDescr var4, Pointer var5, Pointer var6, Pointer var7, csrsv2Info var8, int[] var9);

    public static int cusparseScsrsv2_analysis(cusparseHandle handle, int transA, int m, int nnz, cusparseMatDescr descrA, Pointer csrSortedValA, Pointer csrSortedRowPtrA, Pointer csrSortedColIndA, csrsv2Info info, int policy, Pointer pBuffer) {
        return JCusparse.checkResult(JCusparse.cusparseScsrsv2_analysisNative(handle, transA, m, nnz, descrA, csrSortedValA, csrSortedRowPtrA, csrSortedColIndA, info, policy, pBuffer));
    }

    private static native int cusparseScsrsv2_analysisNative(cusparseHandle var0, int var1, int var2, int var3, cusparseMatDescr var4, Pointer var5, Pointer var6, Pointer var7, csrsv2Info var8, int var9, Pointer var10);

    public static int cusparseDcsrsv2_analysis(cusparseHandle handle, int transA, int m, int nnz, cusparseMatDescr descrA, Pointer csrSortedValA, Pointer csrSortedRowPtrA, Pointer csrSortedColIndA, csrsv2Info info, int policy, Pointer pBuffer) {
        return JCusparse.checkResult(JCusparse.cusparseDcsrsv2_analysisNative(handle, transA, m, nnz, descrA, csrSortedValA, csrSortedRowPtrA, csrSortedColIndA, info, policy, pBuffer));
    }

    private static native int cusparseDcsrsv2_analysisNative(cusparseHandle var0, int var1, int var2, int var3, cusparseMatDescr var4, Pointer var5, Pointer var6, Pointer var7, csrsv2Info var8, int var9, Pointer var10);

    public static int cusparseCcsrsv2_analysis(cusparseHandle handle, int transA, int m, int nnz, cusparseMatDescr descrA, Pointer csrSortedValA, Pointer csrSortedRowPtrA, Pointer csrSortedColIndA, csrsv2Info info, int policy, Pointer pBuffer) {
        return JCusparse.checkResult(JCusparse.cusparseCcsrsv2_analysisNative(handle, transA, m, nnz, descrA, csrSortedValA, csrSortedRowPtrA, csrSortedColIndA, info, policy, pBuffer));
    }

    private static native int cusparseCcsrsv2_analysisNative(cusparseHandle var0, int var1, int var2, int var3, cusparseMatDescr var4, Pointer var5, Pointer var6, Pointer var7, csrsv2Info var8, int var9, Pointer var10);

    public static int cusparseZcsrsv2_analysis(cusparseHandle handle, int transA, int m, int nnz, cusparseMatDescr descrA, Pointer csrSortedValA, Pointer csrSortedRowPtrA, Pointer csrSortedColIndA, csrsv2Info info, int policy, Pointer pBuffer) {
        return JCusparse.checkResult(JCusparse.cusparseZcsrsv2_analysisNative(handle, transA, m, nnz, descrA, csrSortedValA, csrSortedRowPtrA, csrSortedColIndA, info, policy, pBuffer));
    }

    private static native int cusparseZcsrsv2_analysisNative(cusparseHandle var0, int var1, int var2, int var3, cusparseMatDescr var4, Pointer var5, Pointer var6, Pointer var7, csrsv2Info var8, int var9, Pointer var10);

    public static int cusparseScsrsv2_solve(cusparseHandle handle, int transA, int m, int nnz, Pointer alpha, cusparseMatDescr descrA, Pointer csrSortedValA, Pointer csrSortedRowPtrA, Pointer csrSortedColIndA, csrsv2Info info, Pointer f, Pointer x, int policy, Pointer pBuffer) {
        return JCusparse.checkResult(JCusparse.cusparseScsrsv2_solveNative(handle, transA, m, nnz, alpha, descrA, csrSortedValA, csrSortedRowPtrA, csrSortedColIndA, info, f, x, policy, pBuffer));
    }

    private static native int cusparseScsrsv2_solveNative(cusparseHandle var0, int var1, int var2, int var3, Pointer var4, cusparseMatDescr var5, Pointer var6, Pointer var7, Pointer var8, csrsv2Info var9, Pointer var10, Pointer var11, int var12, Pointer var13);

    public static int cusparseDcsrsv2_solve(cusparseHandle handle, int transA, int m, int nnz, Pointer alpha, cusparseMatDescr descrA, Pointer csrSortedValA, Pointer csrSortedRowPtrA, Pointer csrSortedColIndA, csrsv2Info info, Pointer f, Pointer x, int policy, Pointer pBuffer) {
        return JCusparse.checkResult(JCusparse.cusparseDcsrsv2_solveNative(handle, transA, m, nnz, alpha, descrA, csrSortedValA, csrSortedRowPtrA, csrSortedColIndA, info, f, x, policy, pBuffer));
    }

    private static native int cusparseDcsrsv2_solveNative(cusparseHandle var0, int var1, int var2, int var3, Pointer var4, cusparseMatDescr var5, Pointer var6, Pointer var7, Pointer var8, csrsv2Info var9, Pointer var10, Pointer var11, int var12, Pointer var13);

    public static int cusparseCcsrsv2_solve(cusparseHandle handle, int transA, int m, int nnz, Pointer alpha, cusparseMatDescr descrA, Pointer csrSortedValA, Pointer csrSortedRowPtrA, Pointer csrSortedColIndA, csrsv2Info info, Pointer f, Pointer x, int policy, Pointer pBuffer) {
        return JCusparse.checkResult(JCusparse.cusparseCcsrsv2_solveNative(handle, transA, m, nnz, alpha, descrA, csrSortedValA, csrSortedRowPtrA, csrSortedColIndA, info, f, x, policy, pBuffer));
    }

    private static native int cusparseCcsrsv2_solveNative(cusparseHandle var0, int var1, int var2, int var3, Pointer var4, cusparseMatDescr var5, Pointer var6, Pointer var7, Pointer var8, csrsv2Info var9, Pointer var10, Pointer var11, int var12, Pointer var13);

    public static int cusparseZcsrsv2_solve(cusparseHandle handle, int transA, int m, int nnz, Pointer alpha, cusparseMatDescr descrA, Pointer csrSortedValA, Pointer csrSortedRowPtrA, Pointer csrSortedColIndA, csrsv2Info info, Pointer f, Pointer x, int policy, Pointer pBuffer) {
        return JCusparse.checkResult(JCusparse.cusparseZcsrsv2_solveNative(handle, transA, m, nnz, alpha, descrA, csrSortedValA, csrSortedRowPtrA, csrSortedColIndA, info, f, x, policy, pBuffer));
    }

    private static native int cusparseZcsrsv2_solveNative(cusparseHandle var0, int var1, int var2, int var3, Pointer var4, cusparseMatDescr var5, Pointer var6, Pointer var7, Pointer var8, csrsv2Info var9, Pointer var10, Pointer var11, int var12, Pointer var13);

    public static int cusparseXbsrsv2_zeroPivot(cusparseHandle handle, bsrsv2Info info, Pointer position) {
        return JCusparse.checkResult(JCusparse.cusparseXbsrsv2_zeroPivotNative(handle, info, position));
    }

    private static native int cusparseXbsrsv2_zeroPivotNative(cusparseHandle var0, bsrsv2Info var1, Pointer var2);

    public static int cusparseSbsrsv2_bufferSize(cusparseHandle handle, int dirA, int transA, int mb, int nnzb, cusparseMatDescr descrA, Pointer bsrSortedValA, Pointer bsrSortedRowPtrA, Pointer bsrSortedColIndA, int blockDim, bsrsv2Info info, int[] pBufferSizeInBytes) {
        return JCusparse.checkResult(JCusparse.cusparseSbsrsv2_bufferSizeNative(handle, dirA, transA, mb, nnzb, descrA, bsrSortedValA, bsrSortedRowPtrA, bsrSortedColIndA, blockDim, info, pBufferSizeInBytes));
    }

    private static native int cusparseSbsrsv2_bufferSizeNative(cusparseHandle var0, int var1, int var2, int var3, int var4, cusparseMatDescr var5, Pointer var6, Pointer var7, Pointer var8, int var9, bsrsv2Info var10, int[] var11);

    public static int cusparseDbsrsv2_bufferSize(cusparseHandle handle, int dirA, int transA, int mb, int nnzb, cusparseMatDescr descrA, Pointer bsrSortedValA, Pointer bsrSortedRowPtrA, Pointer bsrSortedColIndA, int blockDim, bsrsv2Info info, int[] pBufferSizeInBytes) {
        return JCusparse.checkResult(JCusparse.cusparseDbsrsv2_bufferSizeNative(handle, dirA, transA, mb, nnzb, descrA, bsrSortedValA, bsrSortedRowPtrA, bsrSortedColIndA, blockDim, info, pBufferSizeInBytes));
    }

    private static native int cusparseDbsrsv2_bufferSizeNative(cusparseHandle var0, int var1, int var2, int var3, int var4, cusparseMatDescr var5, Pointer var6, Pointer var7, Pointer var8, int var9, bsrsv2Info var10, int[] var11);

    public static int cusparseCbsrsv2_bufferSize(cusparseHandle handle, int dirA, int transA, int mb, int nnzb, cusparseMatDescr descrA, Pointer bsrSortedValA, Pointer bsrSortedRowPtrA, Pointer bsrSortedColIndA, int blockDim, bsrsv2Info info, int[] pBufferSizeInBytes) {
        return JCusparse.checkResult(JCusparse.cusparseCbsrsv2_bufferSizeNative(handle, dirA, transA, mb, nnzb, descrA, bsrSortedValA, bsrSortedRowPtrA, bsrSortedColIndA, blockDim, info, pBufferSizeInBytes));
    }

    private static native int cusparseCbsrsv2_bufferSizeNative(cusparseHandle var0, int var1, int var2, int var3, int var4, cusparseMatDescr var5, Pointer var6, Pointer var7, Pointer var8, int var9, bsrsv2Info var10, int[] var11);

    public static int cusparseZbsrsv2_bufferSize(cusparseHandle handle, int dirA, int transA, int mb, int nnzb, cusparseMatDescr descrA, Pointer bsrSortedValA, Pointer bsrSortedRowPtrA, Pointer bsrSortedColIndA, int blockDim, bsrsv2Info info, int[] pBufferSizeInBytes) {
        return JCusparse.checkResult(JCusparse.cusparseZbsrsv2_bufferSizeNative(handle, dirA, transA, mb, nnzb, descrA, bsrSortedValA, bsrSortedRowPtrA, bsrSortedColIndA, blockDim, info, pBufferSizeInBytes));
    }

    private static native int cusparseZbsrsv2_bufferSizeNative(cusparseHandle var0, int var1, int var2, int var3, int var4, cusparseMatDescr var5, Pointer var6, Pointer var7, Pointer var8, int var9, bsrsv2Info var10, int[] var11);

    public static int cusparseSbsrsv2_bufferSizeExt(cusparseHandle handle, int dirA, int transA, int mb, int nnzb, cusparseMatDescr descrA, Pointer bsrSortedValA, Pointer bsrSortedRowPtrA, Pointer bsrSortedColIndA, int blockSize, bsrsv2Info info, int[] pBufferSize) {
        return JCusparse.checkResult(JCusparse.cusparseSbsrsv2_bufferSizeExtNative(handle, dirA, transA, mb, nnzb, descrA, bsrSortedValA, bsrSortedRowPtrA, bsrSortedColIndA, blockSize, info, pBufferSize));
    }

    private static native int cusparseSbsrsv2_bufferSizeExtNative(cusparseHandle var0, int var1, int var2, int var3, int var4, cusparseMatDescr var5, Pointer var6, Pointer var7, Pointer var8, int var9, bsrsv2Info var10, int[] var11);

    public static int cusparseDbsrsv2_bufferSizeExt(cusparseHandle handle, int dirA, int transA, int mb, int nnzb, cusparseMatDescr descrA, Pointer bsrSortedValA, Pointer bsrSortedRowPtrA, Pointer bsrSortedColIndA, int blockSize, bsrsv2Info info, int[] pBufferSize) {
        return JCusparse.checkResult(JCusparse.cusparseDbsrsv2_bufferSizeExtNative(handle, dirA, transA, mb, nnzb, descrA, bsrSortedValA, bsrSortedRowPtrA, bsrSortedColIndA, blockSize, info, pBufferSize));
    }

    private static native int cusparseDbsrsv2_bufferSizeExtNative(cusparseHandle var0, int var1, int var2, int var3, int var4, cusparseMatDescr var5, Pointer var6, Pointer var7, Pointer var8, int var9, bsrsv2Info var10, int[] var11);

    public static int cusparseCbsrsv2_bufferSizeExt(cusparseHandle handle, int dirA, int transA, int mb, int nnzb, cusparseMatDescr descrA, Pointer bsrSortedValA, Pointer bsrSortedRowPtrA, Pointer bsrSortedColIndA, int blockSize, bsrsv2Info info, int[] pBufferSize) {
        return JCusparse.checkResult(JCusparse.cusparseCbsrsv2_bufferSizeExtNative(handle, dirA, transA, mb, nnzb, descrA, bsrSortedValA, bsrSortedRowPtrA, bsrSortedColIndA, blockSize, info, pBufferSize));
    }

    private static native int cusparseCbsrsv2_bufferSizeExtNative(cusparseHandle var0, int var1, int var2, int var3, int var4, cusparseMatDescr var5, Pointer var6, Pointer var7, Pointer var8, int var9, bsrsv2Info var10, int[] var11);

    public static int cusparseZbsrsv2_bufferSizeExt(cusparseHandle handle, int dirA, int transA, int mb, int nnzb, cusparseMatDescr descrA, Pointer bsrSortedValA, Pointer bsrSortedRowPtrA, Pointer bsrSortedColIndA, int blockSize, bsrsv2Info info, int[] pBufferSize) {
        return JCusparse.checkResult(JCusparse.cusparseZbsrsv2_bufferSizeExtNative(handle, dirA, transA, mb, nnzb, descrA, bsrSortedValA, bsrSortedRowPtrA, bsrSortedColIndA, blockSize, info, pBufferSize));
    }

    private static native int cusparseZbsrsv2_bufferSizeExtNative(cusparseHandle var0, int var1, int var2, int var3, int var4, cusparseMatDescr var5, Pointer var6, Pointer var7, Pointer var8, int var9, bsrsv2Info var10, int[] var11);

    public static int cusparseSbsrsv2_analysis(cusparseHandle handle, int dirA, int transA, int mb, int nnzb, cusparseMatDescr descrA, Pointer bsrSortedValA, Pointer bsrSortedRowPtrA, Pointer bsrSortedColIndA, int blockDim, bsrsv2Info info, int policy, Pointer pBuffer) {
        return JCusparse.checkResult(JCusparse.cusparseSbsrsv2_analysisNative(handle, dirA, transA, mb, nnzb, descrA, bsrSortedValA, bsrSortedRowPtrA, bsrSortedColIndA, blockDim, info, policy, pBuffer));
    }

    private static native int cusparseSbsrsv2_analysisNative(cusparseHandle var0, int var1, int var2, int var3, int var4, cusparseMatDescr var5, Pointer var6, Pointer var7, Pointer var8, int var9, bsrsv2Info var10, int var11, Pointer var12);

    public static int cusparseDbsrsv2_analysis(cusparseHandle handle, int dirA, int transA, int mb, int nnzb, cusparseMatDescr descrA, Pointer bsrSortedValA, Pointer bsrSortedRowPtrA, Pointer bsrSortedColIndA, int blockDim, bsrsv2Info info, int policy, Pointer pBuffer) {
        return JCusparse.checkResult(JCusparse.cusparseDbsrsv2_analysisNative(handle, dirA, transA, mb, nnzb, descrA, bsrSortedValA, bsrSortedRowPtrA, bsrSortedColIndA, blockDim, info, policy, pBuffer));
    }

    private static native int cusparseDbsrsv2_analysisNative(cusparseHandle var0, int var1, int var2, int var3, int var4, cusparseMatDescr var5, Pointer var6, Pointer var7, Pointer var8, int var9, bsrsv2Info var10, int var11, Pointer var12);

    public static int cusparseCbsrsv2_analysis(cusparseHandle handle, int dirA, int transA, int mb, int nnzb, cusparseMatDescr descrA, Pointer bsrSortedValA, Pointer bsrSortedRowPtrA, Pointer bsrSortedColIndA, int blockDim, bsrsv2Info info, int policy, Pointer pBuffer) {
        return JCusparse.checkResult(JCusparse.cusparseCbsrsv2_analysisNative(handle, dirA, transA, mb, nnzb, descrA, bsrSortedValA, bsrSortedRowPtrA, bsrSortedColIndA, blockDim, info, policy, pBuffer));
    }

    private static native int cusparseCbsrsv2_analysisNative(cusparseHandle var0, int var1, int var2, int var3, int var4, cusparseMatDescr var5, Pointer var6, Pointer var7, Pointer var8, int var9, bsrsv2Info var10, int var11, Pointer var12);

    public static int cusparseZbsrsv2_analysis(cusparseHandle handle, int dirA, int transA, int mb, int nnzb, cusparseMatDescr descrA, Pointer bsrSortedValA, Pointer bsrSortedRowPtrA, Pointer bsrSortedColIndA, int blockDim, bsrsv2Info info, int policy, Pointer pBuffer) {
        return JCusparse.checkResult(JCusparse.cusparseZbsrsv2_analysisNative(handle, dirA, transA, mb, nnzb, descrA, bsrSortedValA, bsrSortedRowPtrA, bsrSortedColIndA, blockDim, info, policy, pBuffer));
    }

    private static native int cusparseZbsrsv2_analysisNative(cusparseHandle var0, int var1, int var2, int var3, int var4, cusparseMatDescr var5, Pointer var6, Pointer var7, Pointer var8, int var9, bsrsv2Info var10, int var11, Pointer var12);

    public static int cusparseSbsrsv2_solve(cusparseHandle handle, int dirA, int transA, int mb, int nnzb, Pointer alpha, cusparseMatDescr descrA, Pointer bsrSortedValA, Pointer bsrSortedRowPtrA, Pointer bsrSortedColIndA, int blockDim, bsrsv2Info info, Pointer f, Pointer x, int policy, Pointer pBuffer) {
        return JCusparse.checkResult(JCusparse.cusparseSbsrsv2_solveNative(handle, dirA, transA, mb, nnzb, alpha, descrA, bsrSortedValA, bsrSortedRowPtrA, bsrSortedColIndA, blockDim, info, f, x, policy, pBuffer));
    }

    private static native int cusparseSbsrsv2_solveNative(cusparseHandle var0, int var1, int var2, int var3, int var4, Pointer var5, cusparseMatDescr var6, Pointer var7, Pointer var8, Pointer var9, int var10, bsrsv2Info var11, Pointer var12, Pointer var13, int var14, Pointer var15);

    public static int cusparseDbsrsv2_solve(cusparseHandle handle, int dirA, int transA, int mb, int nnzb, Pointer alpha, cusparseMatDescr descrA, Pointer bsrSortedValA, Pointer bsrSortedRowPtrA, Pointer bsrSortedColIndA, int blockDim, bsrsv2Info info, Pointer f, Pointer x, int policy, Pointer pBuffer) {
        return JCusparse.checkResult(JCusparse.cusparseDbsrsv2_solveNative(handle, dirA, transA, mb, nnzb, alpha, descrA, bsrSortedValA, bsrSortedRowPtrA, bsrSortedColIndA, blockDim, info, f, x, policy, pBuffer));
    }

    private static native int cusparseDbsrsv2_solveNative(cusparseHandle var0, int var1, int var2, int var3, int var4, Pointer var5, cusparseMatDescr var6, Pointer var7, Pointer var8, Pointer var9, int var10, bsrsv2Info var11, Pointer var12, Pointer var13, int var14, Pointer var15);

    public static int cusparseCbsrsv2_solve(cusparseHandle handle, int dirA, int transA, int mb, int nnzb, Pointer alpha, cusparseMatDescr descrA, Pointer bsrSortedValA, Pointer bsrSortedRowPtrA, Pointer bsrSortedColIndA, int blockDim, bsrsv2Info info, Pointer f, Pointer x, int policy, Pointer pBuffer) {
        return JCusparse.checkResult(JCusparse.cusparseCbsrsv2_solveNative(handle, dirA, transA, mb, nnzb, alpha, descrA, bsrSortedValA, bsrSortedRowPtrA, bsrSortedColIndA, blockDim, info, f, x, policy, pBuffer));
    }

    private static native int cusparseCbsrsv2_solveNative(cusparseHandle var0, int var1, int var2, int var3, int var4, Pointer var5, cusparseMatDescr var6, Pointer var7, Pointer var8, Pointer var9, int var10, bsrsv2Info var11, Pointer var12, Pointer var13, int var14, Pointer var15);

    public static int cusparseZbsrsv2_solve(cusparseHandle handle, int dirA, int transA, int mb, int nnzb, Pointer alpha, cusparseMatDescr descrA, Pointer bsrSortedValA, Pointer bsrSortedRowPtrA, Pointer bsrSortedColIndA, int blockDim, bsrsv2Info info, Pointer f, Pointer x, int policy, Pointer pBuffer) {
        return JCusparse.checkResult(JCusparse.cusparseZbsrsv2_solveNative(handle, dirA, transA, mb, nnzb, alpha, descrA, bsrSortedValA, bsrSortedRowPtrA, bsrSortedColIndA, blockDim, info, f, x, policy, pBuffer));
    }

    private static native int cusparseZbsrsv2_solveNative(cusparseHandle var0, int var1, int var2, int var3, int var4, Pointer var5, cusparseMatDescr var6, Pointer var7, Pointer var8, Pointer var9, int var10, bsrsv2Info var11, Pointer var12, Pointer var13, int var14, Pointer var15);

    public static int cusparseShybsv_analysis(cusparseHandle handle, int transA, cusparseMatDescr descrA, cusparseHybMat hybA, cusparseSolveAnalysisInfo info) {
        return JCusparse.checkResult(JCusparse.cusparseShybsv_analysisNative(handle, transA, descrA, hybA, info));
    }

    private static native int cusparseShybsv_analysisNative(cusparseHandle var0, int var1, cusparseMatDescr var2, cusparseHybMat var3, cusparseSolveAnalysisInfo var4);

    public static int cusparseDhybsv_analysis(cusparseHandle handle, int transA, cusparseMatDescr descrA, cusparseHybMat hybA, cusparseSolveAnalysisInfo info) {
        return JCusparse.checkResult(JCusparse.cusparseDhybsv_analysisNative(handle, transA, descrA, hybA, info));
    }

    private static native int cusparseDhybsv_analysisNative(cusparseHandle var0, int var1, cusparseMatDescr var2, cusparseHybMat var3, cusparseSolveAnalysisInfo var4);

    public static int cusparseChybsv_analysis(cusparseHandle handle, int transA, cusparseMatDescr descrA, cusparseHybMat hybA, cusparseSolveAnalysisInfo info) {
        return JCusparse.checkResult(JCusparse.cusparseChybsv_analysisNative(handle, transA, descrA, hybA, info));
    }

    private static native int cusparseChybsv_analysisNative(cusparseHandle var0, int var1, cusparseMatDescr var2, cusparseHybMat var3, cusparseSolveAnalysisInfo var4);

    public static int cusparseZhybsv_analysis(cusparseHandle handle, int transA, cusparseMatDescr descrA, cusparseHybMat hybA, cusparseSolveAnalysisInfo info) {
        return JCusparse.checkResult(JCusparse.cusparseZhybsv_analysisNative(handle, transA, descrA, hybA, info));
    }

    private static native int cusparseZhybsv_analysisNative(cusparseHandle var0, int var1, cusparseMatDescr var2, cusparseHybMat var3, cusparseSolveAnalysisInfo var4);

    public static int cusparseShybsv_solve(cusparseHandle handle, int trans, Pointer alpha, cusparseMatDescr descra, cusparseHybMat hybA, cusparseSolveAnalysisInfo info, Pointer f, Pointer x) {
        return JCusparse.checkResult(JCusparse.cusparseShybsv_solveNative(handle, trans, alpha, descra, hybA, info, f, x));
    }

    private static native int cusparseShybsv_solveNative(cusparseHandle var0, int var1, Pointer var2, cusparseMatDescr var3, cusparseHybMat var4, cusparseSolveAnalysisInfo var5, Pointer var6, Pointer var7);

    public static int cusparseChybsv_solve(cusparseHandle handle, int trans, Pointer alpha, cusparseMatDescr descra, cusparseHybMat hybA, cusparseSolveAnalysisInfo info, Pointer f, Pointer x) {
        return JCusparse.checkResult(JCusparse.cusparseChybsv_solveNative(handle, trans, alpha, descra, hybA, info, f, x));
    }

    private static native int cusparseChybsv_solveNative(cusparseHandle var0, int var1, Pointer var2, cusparseMatDescr var3, cusparseHybMat var4, cusparseSolveAnalysisInfo var5, Pointer var6, Pointer var7);

    public static int cusparseDhybsv_solve(cusparseHandle handle, int trans, Pointer alpha, cusparseMatDescr descra, cusparseHybMat hybA, cusparseSolveAnalysisInfo info, Pointer f, Pointer x) {
        return JCusparse.checkResult(JCusparse.cusparseDhybsv_solveNative(handle, trans, alpha, descra, hybA, info, f, x));
    }

    private static native int cusparseDhybsv_solveNative(cusparseHandle var0, int var1, Pointer var2, cusparseMatDescr var3, cusparseHybMat var4, cusparseSolveAnalysisInfo var5, Pointer var6, Pointer var7);

    public static int cusparseZhybsv_solve(cusparseHandle handle, int trans, Pointer alpha, cusparseMatDescr descra, cusparseHybMat hybA, cusparseSolveAnalysisInfo info, Pointer f, Pointer x) {
        return JCusparse.checkResult(JCusparse.cusparseZhybsv_solveNative(handle, trans, alpha, descra, hybA, info, f, x));
    }

    private static native int cusparseZhybsv_solveNative(cusparseHandle var0, int var1, Pointer var2, cusparseMatDescr var3, cusparseHybMat var4, cusparseSolveAnalysisInfo var5, Pointer var6, Pointer var7);

    public static int cusparseScsrmm(cusparseHandle handle, int transA, int m, int n, int k, int nnz, Pointer alpha, cusparseMatDescr descrA, Pointer csrSortedValA, Pointer csrSortedRowPtrA, Pointer csrSortedColIndA, Pointer B, int ldb, Pointer beta, Pointer C, int ldc) {
        return JCusparse.checkResult(JCusparse.cusparseScsrmmNative(handle, transA, m, n, k, nnz, alpha, descrA, csrSortedValA, csrSortedRowPtrA, csrSortedColIndA, B, ldb, beta, C, ldc));
    }

    private static native int cusparseScsrmmNative(cusparseHandle var0, int var1, int var2, int var3, int var4, int var5, Pointer var6, cusparseMatDescr var7, Pointer var8, Pointer var9, Pointer var10, Pointer var11, int var12, Pointer var13, Pointer var14, int var15);

    public static int cusparseDcsrmm(cusparseHandle handle, int transA, int m, int n, int k, int nnz, Pointer alpha, cusparseMatDescr descrA, Pointer csrSortedValA, Pointer csrSortedRowPtrA, Pointer csrSortedColIndA, Pointer B, int ldb, Pointer beta, Pointer C, int ldc) {
        return JCusparse.checkResult(JCusparse.cusparseDcsrmmNative(handle, transA, m, n, k, nnz, alpha, descrA, csrSortedValA, csrSortedRowPtrA, csrSortedColIndA, B, ldb, beta, C, ldc));
    }

    private static native int cusparseDcsrmmNative(cusparseHandle var0, int var1, int var2, int var3, int var4, int var5, Pointer var6, cusparseMatDescr var7, Pointer var8, Pointer var9, Pointer var10, Pointer var11, int var12, Pointer var13, Pointer var14, int var15);

    public static int cusparseCcsrmm(cusparseHandle handle, int transA, int m, int n, int k, int nnz, Pointer alpha, cusparseMatDescr descrA, Pointer csrSortedValA, Pointer csrSortedRowPtrA, Pointer csrSortedColIndA, Pointer B, int ldb, Pointer beta, Pointer C, int ldc) {
        return JCusparse.checkResult(JCusparse.cusparseCcsrmmNative(handle, transA, m, n, k, nnz, alpha, descrA, csrSortedValA, csrSortedRowPtrA, csrSortedColIndA, B, ldb, beta, C, ldc));
    }

    private static native int cusparseCcsrmmNative(cusparseHandle var0, int var1, int var2, int var3, int var4, int var5, Pointer var6, cusparseMatDescr var7, Pointer var8, Pointer var9, Pointer var10, Pointer var11, int var12, Pointer var13, Pointer var14, int var15);

    public static int cusparseZcsrmm(cusparseHandle handle, int transA, int m, int n, int k, int nnz, Pointer alpha, cusparseMatDescr descrA, Pointer csrSortedValA, Pointer csrSortedRowPtrA, Pointer csrSortedColIndA, Pointer B, int ldb, Pointer beta, Pointer C, int ldc) {
        return JCusparse.checkResult(JCusparse.cusparseZcsrmmNative(handle, transA, m, n, k, nnz, alpha, descrA, csrSortedValA, csrSortedRowPtrA, csrSortedColIndA, B, ldb, beta, C, ldc));
    }

    private static native int cusparseZcsrmmNative(cusparseHandle var0, int var1, int var2, int var3, int var4, int var5, Pointer var6, cusparseMatDescr var7, Pointer var8, Pointer var9, Pointer var10, Pointer var11, int var12, Pointer var13, Pointer var14, int var15);

    public static int cusparseScsrmm2(cusparseHandle handle, int transA, int transB, int m, int n, int k, int nnz, Pointer alpha, cusparseMatDescr descrA, Pointer csrSortedValA, Pointer csrSortedRowPtrA, Pointer csrSortedColIndA, Pointer B, int ldb, Pointer beta, Pointer C, int ldc) {
        return JCusparse.checkResult(JCusparse.cusparseScsrmm2Native(handle, transA, transB, m, n, k, nnz, alpha, descrA, csrSortedValA, csrSortedRowPtrA, csrSortedColIndA, B, ldb, beta, C, ldc));
    }

    private static native int cusparseScsrmm2Native(cusparseHandle var0, int var1, int var2, int var3, int var4, int var5, int var6, Pointer var7, cusparseMatDescr var8, Pointer var9, Pointer var10, Pointer var11, Pointer var12, int var13, Pointer var14, Pointer var15, int var16);

    public static int cusparseDcsrmm2(cusparseHandle handle, int transA, int transB, int m, int n, int k, int nnz, Pointer alpha, cusparseMatDescr descrA, Pointer csrSortedValA, Pointer csrSortedRowPtrA, Pointer csrSortedColIndA, Pointer B, int ldb, Pointer beta, Pointer C, int ldc) {
        return JCusparse.checkResult(JCusparse.cusparseDcsrmm2Native(handle, transA, transB, m, n, k, nnz, alpha, descrA, csrSortedValA, csrSortedRowPtrA, csrSortedColIndA, B, ldb, beta, C, ldc));
    }

    private static native int cusparseDcsrmm2Native(cusparseHandle var0, int var1, int var2, int var3, int var4, int var5, int var6, Pointer var7, cusparseMatDescr var8, Pointer var9, Pointer var10, Pointer var11, Pointer var12, int var13, Pointer var14, Pointer var15, int var16);

    public static int cusparseCcsrmm2(cusparseHandle handle, int transA, int transB, int m, int n, int k, int nnz, Pointer alpha, cusparseMatDescr descrA, Pointer csrSortedValA, Pointer csrSortedRowPtrA, Pointer csrSortedColIndA, Pointer B, int ldb, Pointer beta, Pointer C, int ldc) {
        return JCusparse.checkResult(JCusparse.cusparseCcsrmm2Native(handle, transA, transB, m, n, k, nnz, alpha, descrA, csrSortedValA, csrSortedRowPtrA, csrSortedColIndA, B, ldb, beta, C, ldc));
    }

    private static native int cusparseCcsrmm2Native(cusparseHandle var0, int var1, int var2, int var3, int var4, int var5, int var6, Pointer var7, cusparseMatDescr var8, Pointer var9, Pointer var10, Pointer var11, Pointer var12, int var13, Pointer var14, Pointer var15, int var16);

    public static int cusparseZcsrmm2(cusparseHandle handle, int transA, int transB, int m, int n, int k, int nnz, Pointer alpha, cusparseMatDescr descrA, Pointer csrSortedValA, Pointer csrSortedRowPtrA, Pointer csrSortedColIndA, Pointer B, int ldb, Pointer beta, Pointer C, int ldc) {
        return JCusparse.checkResult(JCusparse.cusparseZcsrmm2Native(handle, transA, transB, m, n, k, nnz, alpha, descrA, csrSortedValA, csrSortedRowPtrA, csrSortedColIndA, B, ldb, beta, C, ldc));
    }

    private static native int cusparseZcsrmm2Native(cusparseHandle var0, int var1, int var2, int var3, int var4, int var5, int var6, Pointer var7, cusparseMatDescr var8, Pointer var9, Pointer var10, Pointer var11, Pointer var12, int var13, Pointer var14, Pointer var15, int var16);

    public static int cusparseSbsrmm(cusparseHandle handle, int dirA, int transA, int transB, int mb, int n, int kb, int nnzb, Pointer alpha, cusparseMatDescr descrA, Pointer bsrSortedValA, Pointer bsrSortedRowPtrA, Pointer bsrSortedColIndA, int blockSize, Pointer B, int ldb, Pointer beta, Pointer C, int ldc) {
        return JCusparse.checkResult(JCusparse.cusparseSbsrmmNative(handle, dirA, transA, transB, mb, n, kb, nnzb, alpha, descrA, bsrSortedValA, bsrSortedRowPtrA, bsrSortedColIndA, blockSize, B, ldb, beta, C, ldc));
    }

    private static native int cusparseSbsrmmNative(cusparseHandle var0, int var1, int var2, int var3, int var4, int var5, int var6, int var7, Pointer var8, cusparseMatDescr var9, Pointer var10, Pointer var11, Pointer var12, int var13, Pointer var14, int var15, Pointer var16, Pointer var17, int var18);

    public static int cusparseDbsrmm(cusparseHandle handle, int dirA, int transA, int transB, int mb, int n, int kb, int nnzb, Pointer alpha, cusparseMatDescr descrA, Pointer bsrSortedValA, Pointer bsrSortedRowPtrA, Pointer bsrSortedColIndA, int blockSize, Pointer B, int ldb, Pointer beta, Pointer C, int ldc) {
        return JCusparse.checkResult(JCusparse.cusparseDbsrmmNative(handle, dirA, transA, transB, mb, n, kb, nnzb, alpha, descrA, bsrSortedValA, bsrSortedRowPtrA, bsrSortedColIndA, blockSize, B, ldb, beta, C, ldc));
    }

    private static native int cusparseDbsrmmNative(cusparseHandle var0, int var1, int var2, int var3, int var4, int var5, int var6, int var7, Pointer var8, cusparseMatDescr var9, Pointer var10, Pointer var11, Pointer var12, int var13, Pointer var14, int var15, Pointer var16, Pointer var17, int var18);

    public static int cusparseCbsrmm(cusparseHandle handle, int dirA, int transA, int transB, int mb, int n, int kb, int nnzb, Pointer alpha, cusparseMatDescr descrA, Pointer bsrSortedValA, Pointer bsrSortedRowPtrA, Pointer bsrSortedColIndA, int blockSize, Pointer B, int ldb, Pointer beta, Pointer C, int ldc) {
        return JCusparse.checkResult(JCusparse.cusparseCbsrmmNative(handle, dirA, transA, transB, mb, n, kb, nnzb, alpha, descrA, bsrSortedValA, bsrSortedRowPtrA, bsrSortedColIndA, blockSize, B, ldb, beta, C, ldc));
    }

    private static native int cusparseCbsrmmNative(cusparseHandle var0, int var1, int var2, int var3, int var4, int var5, int var6, int var7, Pointer var8, cusparseMatDescr var9, Pointer var10, Pointer var11, Pointer var12, int var13, Pointer var14, int var15, Pointer var16, Pointer var17, int var18);

    public static int cusparseZbsrmm(cusparseHandle handle, int dirA, int transA, int transB, int mb, int n, int kb, int nnzb, Pointer alpha, cusparseMatDescr descrA, Pointer bsrSortedValA, Pointer bsrSortedRowPtrA, Pointer bsrSortedColIndA, int blockSize, Pointer B, int ldb, Pointer beta, Pointer C, int ldc) {
        return JCusparse.checkResult(JCusparse.cusparseZbsrmmNative(handle, dirA, transA, transB, mb, n, kb, nnzb, alpha, descrA, bsrSortedValA, bsrSortedRowPtrA, bsrSortedColIndA, blockSize, B, ldb, beta, C, ldc));
    }

    private static native int cusparseZbsrmmNative(cusparseHandle var0, int var1, int var2, int var3, int var4, int var5, int var6, int var7, Pointer var8, cusparseMatDescr var9, Pointer var10, Pointer var11, Pointer var12, int var13, Pointer var14, int var15, Pointer var16, Pointer var17, int var18);

    public static int cusparseSgemmi(cusparseHandle handle, int m, int n, int k, int nnz, Pointer alpha, Pointer A, int lda, Pointer cscValB, Pointer cscColPtrB, Pointer cscRowIndB, Pointer beta, Pointer C, int ldc) {
        return JCusparse.checkResult(JCusparse.cusparseSgemmiNative(handle, m, n, k, nnz, alpha, A, lda, cscValB, cscColPtrB, cscRowIndB, beta, C, ldc));
    }

    private static native int cusparseSgemmiNative(cusparseHandle var0, int var1, int var2, int var3, int var4, Pointer var5, Pointer var6, int var7, Pointer var8, Pointer var9, Pointer var10, Pointer var11, Pointer var12, int var13);

    public static int cusparseDgemmi(cusparseHandle handle, int m, int n, int k, int nnz, Pointer alpha, Pointer A, int lda, Pointer cscValB, Pointer cscColPtrB, Pointer cscRowIndB, Pointer beta, Pointer C, int ldc) {
        return JCusparse.checkResult(JCusparse.cusparseDgemmiNative(handle, m, n, k, nnz, alpha, A, lda, cscValB, cscColPtrB, cscRowIndB, beta, C, ldc));
    }

    private static native int cusparseDgemmiNative(cusparseHandle var0, int var1, int var2, int var3, int var4, Pointer var5, Pointer var6, int var7, Pointer var8, Pointer var9, Pointer var10, Pointer var11, Pointer var12, int var13);

    public static int cusparseCgemmi(cusparseHandle handle, int m, int n, int k, int nnz, Pointer alpha, Pointer A, int lda, Pointer cscValB, Pointer cscColPtrB, Pointer cscRowIndB, Pointer beta, Pointer C, int ldc) {
        return JCusparse.checkResult(JCusparse.cusparseCgemmiNative(handle, m, n, k, nnz, alpha, A, lda, cscValB, cscColPtrB, cscRowIndB, beta, C, ldc));
    }

    private static native int cusparseCgemmiNative(cusparseHandle var0, int var1, int var2, int var3, int var4, Pointer var5, Pointer var6, int var7, Pointer var8, Pointer var9, Pointer var10, Pointer var11, Pointer var12, int var13);

    public static int cusparseZgemmi(cusparseHandle handle, int m, int n, int k, int nnz, Pointer alpha, Pointer A, int lda, Pointer cscValB, Pointer cscColPtrB, Pointer cscRowIndB, Pointer beta, Pointer C, int ldc) {
        return JCusparse.checkResult(JCusparse.cusparseZgemmiNative(handle, m, n, k, nnz, alpha, A, lda, cscValB, cscColPtrB, cscRowIndB, beta, C, ldc));
    }

    private static native int cusparseZgemmiNative(cusparseHandle var0, int var1, int var2, int var3, int var4, Pointer var5, Pointer var6, int var7, Pointer var8, Pointer var9, Pointer var10, Pointer var11, Pointer var12, int var13);

    public static int cusparseScsrsm_analysis(cusparseHandle handle, int transA, int m, int nnz, cusparseMatDescr descrA, Pointer csrSortedValA, Pointer csrSortedRowPtrA, Pointer csrSortedColIndA, cusparseSolveAnalysisInfo info) {
        return JCusparse.checkResult(JCusparse.cusparseScsrsm_analysisNative(handle, transA, m, nnz, descrA, csrSortedValA, csrSortedRowPtrA, csrSortedColIndA, info));
    }

    private static native int cusparseScsrsm_analysisNative(cusparseHandle var0, int var1, int var2, int var3, cusparseMatDescr var4, Pointer var5, Pointer var6, Pointer var7, cusparseSolveAnalysisInfo var8);

    public static int cusparseDcsrsm_analysis(cusparseHandle handle, int transA, int m, int nnz, cusparseMatDescr descrA, Pointer csrSortedValA, Pointer csrSortedRowPtrA, Pointer csrSortedColIndA, cusparseSolveAnalysisInfo info) {
        return JCusparse.checkResult(JCusparse.cusparseDcsrsm_analysisNative(handle, transA, m, nnz, descrA, csrSortedValA, csrSortedRowPtrA, csrSortedColIndA, info));
    }

    private static native int cusparseDcsrsm_analysisNative(cusparseHandle var0, int var1, int var2, int var3, cusparseMatDescr var4, Pointer var5, Pointer var6, Pointer var7, cusparseSolveAnalysisInfo var8);

    public static int cusparseCcsrsm_analysis(cusparseHandle handle, int transA, int m, int nnz, cusparseMatDescr descrA, Pointer csrSortedValA, Pointer csrSortedRowPtrA, Pointer csrSortedColIndA, cusparseSolveAnalysisInfo info) {
        return JCusparse.checkResult(JCusparse.cusparseCcsrsm_analysisNative(handle, transA, m, nnz, descrA, csrSortedValA, csrSortedRowPtrA, csrSortedColIndA, info));
    }

    private static native int cusparseCcsrsm_analysisNative(cusparseHandle var0, int var1, int var2, int var3, cusparseMatDescr var4, Pointer var5, Pointer var6, Pointer var7, cusparseSolveAnalysisInfo var8);

    public static int cusparseZcsrsm_analysis(cusparseHandle handle, int transA, int m, int nnz, cusparseMatDescr descrA, Pointer csrSortedValA, Pointer csrSortedRowPtrA, Pointer csrSortedColIndA, cusparseSolveAnalysisInfo info) {
        return JCusparse.checkResult(JCusparse.cusparseZcsrsm_analysisNative(handle, transA, m, nnz, descrA, csrSortedValA, csrSortedRowPtrA, csrSortedColIndA, info));
    }

    private static native int cusparseZcsrsm_analysisNative(cusparseHandle var0, int var1, int var2, int var3, cusparseMatDescr var4, Pointer var5, Pointer var6, Pointer var7, cusparseSolveAnalysisInfo var8);

    public static int cusparseScsrsm_solve(cusparseHandle handle, int transA, int m, int n, Pointer alpha, cusparseMatDescr descrA, Pointer csrSortedValA, Pointer csrSortedRowPtrA, Pointer csrSortedColIndA, cusparseSolveAnalysisInfo info, Pointer F, int ldf, Pointer X2, int ldx) {
        return JCusparse.checkResult(JCusparse.cusparseScsrsm_solveNative(handle, transA, m, n, alpha, descrA, csrSortedValA, csrSortedRowPtrA, csrSortedColIndA, info, F, ldf, X2, ldx));
    }

    private static native int cusparseScsrsm_solveNative(cusparseHandle var0, int var1, int var2, int var3, Pointer var4, cusparseMatDescr var5, Pointer var6, Pointer var7, Pointer var8, cusparseSolveAnalysisInfo var9, Pointer var10, int var11, Pointer var12, int var13);

    public static int cusparseDcsrsm_solve(cusparseHandle handle, int transA, int m, int n, Pointer alpha, cusparseMatDescr descrA, Pointer csrSortedValA, Pointer csrSortedRowPtrA, Pointer csrSortedColIndA, cusparseSolveAnalysisInfo info, Pointer F, int ldf, Pointer X2, int ldx) {
        return JCusparse.checkResult(JCusparse.cusparseDcsrsm_solveNative(handle, transA, m, n, alpha, descrA, csrSortedValA, csrSortedRowPtrA, csrSortedColIndA, info, F, ldf, X2, ldx));
    }

    private static native int cusparseDcsrsm_solveNative(cusparseHandle var0, int var1, int var2, int var3, Pointer var4, cusparseMatDescr var5, Pointer var6, Pointer var7, Pointer var8, cusparseSolveAnalysisInfo var9, Pointer var10, int var11, Pointer var12, int var13);

    public static int cusparseCcsrsm_solve(cusparseHandle handle, int transA, int m, int n, Pointer alpha, cusparseMatDescr descrA, Pointer csrSortedValA, Pointer csrSortedRowPtrA, Pointer csrSortedColIndA, cusparseSolveAnalysisInfo info, Pointer F, int ldf, Pointer X2, int ldx) {
        return JCusparse.checkResult(JCusparse.cusparseCcsrsm_solveNative(handle, transA, m, n, alpha, descrA, csrSortedValA, csrSortedRowPtrA, csrSortedColIndA, info, F, ldf, X2, ldx));
    }

    private static native int cusparseCcsrsm_solveNative(cusparseHandle var0, int var1, int var2, int var3, Pointer var4, cusparseMatDescr var5, Pointer var6, Pointer var7, Pointer var8, cusparseSolveAnalysisInfo var9, Pointer var10, int var11, Pointer var12, int var13);

    public static int cusparseZcsrsm_solve(cusparseHandle handle, int transA, int m, int n, Pointer alpha, cusparseMatDescr descrA, Pointer csrSortedValA, Pointer csrSortedRowPtrA, Pointer csrSortedColIndA, cusparseSolveAnalysisInfo info, Pointer F, int ldf, Pointer X2, int ldx) {
        return JCusparse.checkResult(JCusparse.cusparseZcsrsm_solveNative(handle, transA, m, n, alpha, descrA, csrSortedValA, csrSortedRowPtrA, csrSortedColIndA, info, F, ldf, X2, ldx));
    }

    private static native int cusparseZcsrsm_solveNative(cusparseHandle var0, int var1, int var2, int var3, Pointer var4, cusparseMatDescr var5, Pointer var6, Pointer var7, Pointer var8, cusparseSolveAnalysisInfo var9, Pointer var10, int var11, Pointer var12, int var13);

    public static int cusparseXbsrsm2_zeroPivot(cusparseHandle handle, bsrsm2Info info, Pointer position) {
        return JCusparse.checkResult(JCusparse.cusparseXbsrsm2_zeroPivotNative(handle, info, position));
    }

    private static native int cusparseXbsrsm2_zeroPivotNative(cusparseHandle var0, bsrsm2Info var1, Pointer var2);

    public static int cusparseSbsrsm2_bufferSize(cusparseHandle handle, int dirA, int transA, int transXY, int mb, int n, int nnzb, cusparseMatDescr descrA, Pointer bsrSortedVal, Pointer bsrSortedRowPtr, Pointer bsrSortedColInd, int blockSize, bsrsm2Info info, int[] pBufferSizeInBytes) {
        return JCusparse.checkResult(JCusparse.cusparseSbsrsm2_bufferSizeNative(handle, dirA, transA, transXY, mb, n, nnzb, descrA, bsrSortedVal, bsrSortedRowPtr, bsrSortedColInd, blockSize, info, pBufferSizeInBytes));
    }

    private static native int cusparseSbsrsm2_bufferSizeNative(cusparseHandle var0, int var1, int var2, int var3, int var4, int var5, int var6, cusparseMatDescr var7, Pointer var8, Pointer var9, Pointer var10, int var11, bsrsm2Info var12, int[] var13);

    public static int cusparseDbsrsm2_bufferSize(cusparseHandle handle, int dirA, int transA, int transXY, int mb, int n, int nnzb, cusparseMatDescr descrA, Pointer bsrSortedVal, Pointer bsrSortedRowPtr, Pointer bsrSortedColInd, int blockSize, bsrsm2Info info, int[] pBufferSizeInBytes) {
        return JCusparse.checkResult(JCusparse.cusparseDbsrsm2_bufferSizeNative(handle, dirA, transA, transXY, mb, n, nnzb, descrA, bsrSortedVal, bsrSortedRowPtr, bsrSortedColInd, blockSize, info, pBufferSizeInBytes));
    }

    private static native int cusparseDbsrsm2_bufferSizeNative(cusparseHandle var0, int var1, int var2, int var3, int var4, int var5, int var6, cusparseMatDescr var7, Pointer var8, Pointer var9, Pointer var10, int var11, bsrsm2Info var12, int[] var13);

    public static int cusparseCbsrsm2_bufferSize(cusparseHandle handle, int dirA, int transA, int transXY, int mb, int n, int nnzb, cusparseMatDescr descrA, Pointer bsrSortedVal, Pointer bsrSortedRowPtr, Pointer bsrSortedColInd, int blockSize, bsrsm2Info info, int[] pBufferSizeInBytes) {
        return JCusparse.checkResult(JCusparse.cusparseCbsrsm2_bufferSizeNative(handle, dirA, transA, transXY, mb, n, nnzb, descrA, bsrSortedVal, bsrSortedRowPtr, bsrSortedColInd, blockSize, info, pBufferSizeInBytes));
    }

    private static native int cusparseCbsrsm2_bufferSizeNative(cusparseHandle var0, int var1, int var2, int var3, int var4, int var5, int var6, cusparseMatDescr var7, Pointer var8, Pointer var9, Pointer var10, int var11, bsrsm2Info var12, int[] var13);

    public static int cusparseZbsrsm2_bufferSize(cusparseHandle handle, int dirA, int transA, int transXY, int mb, int n, int nnzb, cusparseMatDescr descrA, Pointer bsrSortedVal, Pointer bsrSortedRowPtr, Pointer bsrSortedColInd, int blockSize, bsrsm2Info info, int[] pBufferSizeInBytes) {
        return JCusparse.checkResult(JCusparse.cusparseZbsrsm2_bufferSizeNative(handle, dirA, transA, transXY, mb, n, nnzb, descrA, bsrSortedVal, bsrSortedRowPtr, bsrSortedColInd, blockSize, info, pBufferSizeInBytes));
    }

    private static native int cusparseZbsrsm2_bufferSizeNative(cusparseHandle var0, int var1, int var2, int var3, int var4, int var5, int var6, cusparseMatDescr var7, Pointer var8, Pointer var9, Pointer var10, int var11, bsrsm2Info var12, int[] var13);

    public static int cusparseSbsrsm2_bufferSizeExt(cusparseHandle handle, int dirA, int transA, int transB, int mb, int n, int nnzb, cusparseMatDescr descrA, Pointer bsrSortedVal, Pointer bsrSortedRowPtr, Pointer bsrSortedColInd, int blockSize, bsrsm2Info info, int[] pBufferSize) {
        return JCusparse.checkResult(JCusparse.cusparseSbsrsm2_bufferSizeExtNative(handle, dirA, transA, transB, mb, n, nnzb, descrA, bsrSortedVal, bsrSortedRowPtr, bsrSortedColInd, blockSize, info, pBufferSize));
    }

    private static native int cusparseSbsrsm2_bufferSizeExtNative(cusparseHandle var0, int var1, int var2, int var3, int var4, int var5, int var6, cusparseMatDescr var7, Pointer var8, Pointer var9, Pointer var10, int var11, bsrsm2Info var12, int[] var13);

    public static int cusparseDbsrsm2_bufferSizeExt(cusparseHandle handle, int dirA, int transA, int transB, int mb, int n, int nnzb, cusparseMatDescr descrA, Pointer bsrSortedVal, Pointer bsrSortedRowPtr, Pointer bsrSortedColInd, int blockSize, bsrsm2Info info, int[] pBufferSize) {
        return JCusparse.checkResult(JCusparse.cusparseDbsrsm2_bufferSizeExtNative(handle, dirA, transA, transB, mb, n, nnzb, descrA, bsrSortedVal, bsrSortedRowPtr, bsrSortedColInd, blockSize, info, pBufferSize));
    }

    private static native int cusparseDbsrsm2_bufferSizeExtNative(cusparseHandle var0, int var1, int var2, int var3, int var4, int var5, int var6, cusparseMatDescr var7, Pointer var8, Pointer var9, Pointer var10, int var11, bsrsm2Info var12, int[] var13);

    public static int cusparseCbsrsm2_bufferSizeExt(cusparseHandle handle, int dirA, int transA, int transB, int mb, int n, int nnzb, cusparseMatDescr descrA, Pointer bsrSortedVal, Pointer bsrSortedRowPtr, Pointer bsrSortedColInd, int blockSize, bsrsm2Info info, int[] pBufferSize) {
        return JCusparse.checkResult(JCusparse.cusparseCbsrsm2_bufferSizeExtNative(handle, dirA, transA, transB, mb, n, nnzb, descrA, bsrSortedVal, bsrSortedRowPtr, bsrSortedColInd, blockSize, info, pBufferSize));
    }

    private static native int cusparseCbsrsm2_bufferSizeExtNative(cusparseHandle var0, int var1, int var2, int var3, int var4, int var5, int var6, cusparseMatDescr var7, Pointer var8, Pointer var9, Pointer var10, int var11, bsrsm2Info var12, int[] var13);

    public static int cusparseZbsrsm2_bufferSizeExt(cusparseHandle handle, int dirA, int transA, int transB, int mb, int n, int nnzb, cusparseMatDescr descrA, Pointer bsrSortedVal, Pointer bsrSortedRowPtr, Pointer bsrSortedColInd, int blockSize, bsrsm2Info info, int[] pBufferSize) {
        return JCusparse.checkResult(JCusparse.cusparseZbsrsm2_bufferSizeExtNative(handle, dirA, transA, transB, mb, n, nnzb, descrA, bsrSortedVal, bsrSortedRowPtr, bsrSortedColInd, blockSize, info, pBufferSize));
    }

    private static native int cusparseZbsrsm2_bufferSizeExtNative(cusparseHandle var0, int var1, int var2, int var3, int var4, int var5, int var6, cusparseMatDescr var7, Pointer var8, Pointer var9, Pointer var10, int var11, bsrsm2Info var12, int[] var13);

    public static int cusparseSbsrsm2_analysis(cusparseHandle handle, int dirA, int transA, int transXY, int mb, int n, int nnzb, cusparseMatDescr descrA, Pointer bsrSortedVal, Pointer bsrSortedRowPtr, Pointer bsrSortedColInd, int blockSize, bsrsm2Info info, int policy, Pointer pBuffer) {
        return JCusparse.checkResult(JCusparse.cusparseSbsrsm2_analysisNative(handle, dirA, transA, transXY, mb, n, nnzb, descrA, bsrSortedVal, bsrSortedRowPtr, bsrSortedColInd, blockSize, info, policy, pBuffer));
    }

    private static native int cusparseSbsrsm2_analysisNative(cusparseHandle var0, int var1, int var2, int var3, int var4, int var5, int var6, cusparseMatDescr var7, Pointer var8, Pointer var9, Pointer var10, int var11, bsrsm2Info var12, int var13, Pointer var14);

    public static int cusparseDbsrsm2_analysis(cusparseHandle handle, int dirA, int transA, int transXY, int mb, int n, int nnzb, cusparseMatDescr descrA, Pointer bsrSortedVal, Pointer bsrSortedRowPtr, Pointer bsrSortedColInd, int blockSize, bsrsm2Info info, int policy, Pointer pBuffer) {
        return JCusparse.checkResult(JCusparse.cusparseDbsrsm2_analysisNative(handle, dirA, transA, transXY, mb, n, nnzb, descrA, bsrSortedVal, bsrSortedRowPtr, bsrSortedColInd, blockSize, info, policy, pBuffer));
    }

    private static native int cusparseDbsrsm2_analysisNative(cusparseHandle var0, int var1, int var2, int var3, int var4, int var5, int var6, cusparseMatDescr var7, Pointer var8, Pointer var9, Pointer var10, int var11, bsrsm2Info var12, int var13, Pointer var14);

    public static int cusparseCbsrsm2_analysis(cusparseHandle handle, int dirA, int transA, int transXY, int mb, int n, int nnzb, cusparseMatDescr descrA, Pointer bsrSortedVal, Pointer bsrSortedRowPtr, Pointer bsrSortedColInd, int blockSize, bsrsm2Info info, int policy, Pointer pBuffer) {
        return JCusparse.checkResult(JCusparse.cusparseCbsrsm2_analysisNative(handle, dirA, transA, transXY, mb, n, nnzb, descrA, bsrSortedVal, bsrSortedRowPtr, bsrSortedColInd, blockSize, info, policy, pBuffer));
    }

    private static native int cusparseCbsrsm2_analysisNative(cusparseHandle var0, int var1, int var2, int var3, int var4, int var5, int var6, cusparseMatDescr var7, Pointer var8, Pointer var9, Pointer var10, int var11, bsrsm2Info var12, int var13, Pointer var14);

    public static int cusparseZbsrsm2_analysis(cusparseHandle handle, int dirA, int transA, int transXY, int mb, int n, int nnzb, cusparseMatDescr descrA, Pointer bsrSortedVal, Pointer bsrSortedRowPtr, Pointer bsrSortedColInd, int blockSize, bsrsm2Info info, int policy, Pointer pBuffer) {
        return JCusparse.checkResult(JCusparse.cusparseZbsrsm2_analysisNative(handle, dirA, transA, transXY, mb, n, nnzb, descrA, bsrSortedVal, bsrSortedRowPtr, bsrSortedColInd, blockSize, info, policy, pBuffer));
    }

    private static native int cusparseZbsrsm2_analysisNative(cusparseHandle var0, int var1, int var2, int var3, int var4, int var5, int var6, cusparseMatDescr var7, Pointer var8, Pointer var9, Pointer var10, int var11, bsrsm2Info var12, int var13, Pointer var14);

    public static int cusparseSbsrsm2_solve(cusparseHandle handle, int dirA, int transA, int transXY, int mb, int n, int nnzb, Pointer alpha, cusparseMatDescr descrA, Pointer bsrSortedVal, Pointer bsrSortedRowPtr, Pointer bsrSortedColInd, int blockSize, bsrsm2Info info, Pointer F, int ldf, Pointer X2, int ldx, int policy, Pointer pBuffer) {
        return JCusparse.checkResult(JCusparse.cusparseSbsrsm2_solveNative(handle, dirA, transA, transXY, mb, n, nnzb, alpha, descrA, bsrSortedVal, bsrSortedRowPtr, bsrSortedColInd, blockSize, info, F, ldf, X2, ldx, policy, pBuffer));
    }

    private static native int cusparseSbsrsm2_solveNative(cusparseHandle var0, int var1, int var2, int var3, int var4, int var5, int var6, Pointer var7, cusparseMatDescr var8, Pointer var9, Pointer var10, Pointer var11, int var12, bsrsm2Info var13, Pointer var14, int var15, Pointer var16, int var17, int var18, Pointer var19);

    public static int cusparseDbsrsm2_solve(cusparseHandle handle, int dirA, int transA, int transXY, int mb, int n, int nnzb, Pointer alpha, cusparseMatDescr descrA, Pointer bsrSortedVal, Pointer bsrSortedRowPtr, Pointer bsrSortedColInd, int blockSize, bsrsm2Info info, Pointer F, int ldf, Pointer X2, int ldx, int policy, Pointer pBuffer) {
        return JCusparse.checkResult(JCusparse.cusparseDbsrsm2_solveNative(handle, dirA, transA, transXY, mb, n, nnzb, alpha, descrA, bsrSortedVal, bsrSortedRowPtr, bsrSortedColInd, blockSize, info, F, ldf, X2, ldx, policy, pBuffer));
    }

    private static native int cusparseDbsrsm2_solveNative(cusparseHandle var0, int var1, int var2, int var3, int var4, int var5, int var6, Pointer var7, cusparseMatDescr var8, Pointer var9, Pointer var10, Pointer var11, int var12, bsrsm2Info var13, Pointer var14, int var15, Pointer var16, int var17, int var18, Pointer var19);

    public static int cusparseCbsrsm2_solve(cusparseHandle handle, int dirA, int transA, int transXY, int mb, int n, int nnzb, Pointer alpha, cusparseMatDescr descrA, Pointer bsrSortedVal, Pointer bsrSortedRowPtr, Pointer bsrSortedColInd, int blockSize, bsrsm2Info info, Pointer F, int ldf, Pointer X2, int ldx, int policy, Pointer pBuffer) {
        return JCusparse.checkResult(JCusparse.cusparseCbsrsm2_solveNative(handle, dirA, transA, transXY, mb, n, nnzb, alpha, descrA, bsrSortedVal, bsrSortedRowPtr, bsrSortedColInd, blockSize, info, F, ldf, X2, ldx, policy, pBuffer));
    }

    private static native int cusparseCbsrsm2_solveNative(cusparseHandle var0, int var1, int var2, int var3, int var4, int var5, int var6, Pointer var7, cusparseMatDescr var8, Pointer var9, Pointer var10, Pointer var11, int var12, bsrsm2Info var13, Pointer var14, int var15, Pointer var16, int var17, int var18, Pointer var19);

    public static int cusparseZbsrsm2_solve(cusparseHandle handle, int dirA, int transA, int transXY, int mb, int n, int nnzb, Pointer alpha, cusparseMatDescr descrA, Pointer bsrSortedVal, Pointer bsrSortedRowPtr, Pointer bsrSortedColInd, int blockSize, bsrsm2Info info, Pointer F, int ldf, Pointer X2, int ldx, int policy, Pointer pBuffer) {
        return JCusparse.checkResult(JCusparse.cusparseZbsrsm2_solveNative(handle, dirA, transA, transXY, mb, n, nnzb, alpha, descrA, bsrSortedVal, bsrSortedRowPtr, bsrSortedColInd, blockSize, info, F, ldf, X2, ldx, policy, pBuffer));
    }

    private static native int cusparseZbsrsm2_solveNative(cusparseHandle var0, int var1, int var2, int var3, int var4, int var5, int var6, Pointer var7, cusparseMatDescr var8, Pointer var9, Pointer var10, Pointer var11, int var12, bsrsm2Info var13, Pointer var14, int var15, Pointer var16, int var17, int var18, Pointer var19);

    public static int cusparseCsrilu0Ex(cusparseHandle handle, int trans, int m, cusparseMatDescr descrA, Pointer csrSortedValA_ValM, int csrSortedValA_ValMtype, Pointer csrSortedRowPtrA, Pointer csrSortedColIndA, cusparseSolveAnalysisInfo info, int executiontype) {
        return JCusparse.checkResult(JCusparse.cusparseCsrilu0ExNative(handle, trans, m, descrA, csrSortedValA_ValM, csrSortedValA_ValMtype, csrSortedRowPtrA, csrSortedColIndA, info, executiontype));
    }

    private static native int cusparseCsrilu0ExNative(cusparseHandle var0, int var1, int var2, cusparseMatDescr var3, Pointer var4, int var5, Pointer var6, Pointer var7, cusparseSolveAnalysisInfo var8, int var9);

    public static int cusparseScsrilu0(cusparseHandle handle, int trans, int m, cusparseMatDescr descrA, Pointer csrSortedValA_ValM, Pointer csrSortedRowPtrA, Pointer csrSortedColIndA, cusparseSolveAnalysisInfo info) {
        return JCusparse.checkResult(JCusparse.cusparseScsrilu0Native(handle, trans, m, descrA, csrSortedValA_ValM, csrSortedRowPtrA, csrSortedColIndA, info));
    }

    private static native int cusparseScsrilu0Native(cusparseHandle var0, int var1, int var2, cusparseMatDescr var3, Pointer var4, Pointer var5, Pointer var6, cusparseSolveAnalysisInfo var7);

    public static int cusparseDcsrilu0(cusparseHandle handle, int trans, int m, cusparseMatDescr descrA, Pointer csrSortedValA_ValM, Pointer csrSortedRowPtrA, Pointer csrSortedColIndA, cusparseSolveAnalysisInfo info) {
        return JCusparse.checkResult(JCusparse.cusparseDcsrilu0Native(handle, trans, m, descrA, csrSortedValA_ValM, csrSortedRowPtrA, csrSortedColIndA, info));
    }

    private static native int cusparseDcsrilu0Native(cusparseHandle var0, int var1, int var2, cusparseMatDescr var3, Pointer var4, Pointer var5, Pointer var6, cusparseSolveAnalysisInfo var7);

    public static int cusparseCcsrilu0(cusparseHandle handle, int trans, int m, cusparseMatDescr descrA, Pointer csrSortedValA_ValM, Pointer csrSortedRowPtrA, Pointer csrSortedColIndA, cusparseSolveAnalysisInfo info) {
        return JCusparse.checkResult(JCusparse.cusparseCcsrilu0Native(handle, trans, m, descrA, csrSortedValA_ValM, csrSortedRowPtrA, csrSortedColIndA, info));
    }

    private static native int cusparseCcsrilu0Native(cusparseHandle var0, int var1, int var2, cusparseMatDescr var3, Pointer var4, Pointer var5, Pointer var6, cusparseSolveAnalysisInfo var7);

    public static int cusparseZcsrilu0(cusparseHandle handle, int trans, int m, cusparseMatDescr descrA, Pointer csrSortedValA_ValM, Pointer csrSortedRowPtrA, Pointer csrSortedColIndA, cusparseSolveAnalysisInfo info) {
        return JCusparse.checkResult(JCusparse.cusparseZcsrilu0Native(handle, trans, m, descrA, csrSortedValA_ValM, csrSortedRowPtrA, csrSortedColIndA, info));
    }

    private static native int cusparseZcsrilu0Native(cusparseHandle var0, int var1, int var2, cusparseMatDescr var3, Pointer var4, Pointer var5, Pointer var6, cusparseSolveAnalysisInfo var7);

    public static int cusparseScsrilu02_numericBoost(cusparseHandle handle, csrilu02Info info, int enable_boost, Pointer tol, Pointer boost_val) {
        return JCusparse.checkResult(JCusparse.cusparseScsrilu02_numericBoostNative(handle, info, enable_boost, tol, boost_val));
    }

    private static native int cusparseScsrilu02_numericBoostNative(cusparseHandle var0, csrilu02Info var1, int var2, Pointer var3, Pointer var4);

    public static int cusparseDcsrilu02_numericBoost(cusparseHandle handle, csrilu02Info info, int enable_boost, Pointer tol, Pointer boost_val) {
        return JCusparse.checkResult(JCusparse.cusparseDcsrilu02_numericBoostNative(handle, info, enable_boost, tol, boost_val));
    }

    private static native int cusparseDcsrilu02_numericBoostNative(cusparseHandle var0, csrilu02Info var1, int var2, Pointer var3, Pointer var4);

    public static int cusparseCcsrilu02_numericBoost(cusparseHandle handle, csrilu02Info info, int enable_boost, Pointer tol, Pointer boost_val) {
        return JCusparse.checkResult(JCusparse.cusparseCcsrilu02_numericBoostNative(handle, info, enable_boost, tol, boost_val));
    }

    private static native int cusparseCcsrilu02_numericBoostNative(cusparseHandle var0, csrilu02Info var1, int var2, Pointer var3, Pointer var4);

    public static int cusparseZcsrilu02_numericBoost(cusparseHandle handle, csrilu02Info info, int enable_boost, Pointer tol, Pointer boost_val) {
        return JCusparse.checkResult(JCusparse.cusparseZcsrilu02_numericBoostNative(handle, info, enable_boost, tol, boost_val));
    }

    private static native int cusparseZcsrilu02_numericBoostNative(cusparseHandle var0, csrilu02Info var1, int var2, Pointer var3, Pointer var4);

    public static int cusparseXcsrilu02_zeroPivot(cusparseHandle handle, csrilu02Info info, Pointer position) {
        return JCusparse.checkResult(JCusparse.cusparseXcsrilu02_zeroPivotNative(handle, info, position));
    }

    private static native int cusparseXcsrilu02_zeroPivotNative(cusparseHandle var0, csrilu02Info var1, Pointer var2);

    public static int cusparseScsrilu02_bufferSize(cusparseHandle handle, int m, int nnz, cusparseMatDescr descrA, Pointer csrSortedValA, Pointer csrSortedRowPtrA, Pointer csrSortedColIndA, csrilu02Info info, int[] pBufferSizeInBytes) {
        return JCusparse.checkResult(JCusparse.cusparseScsrilu02_bufferSizeNative(handle, m, nnz, descrA, csrSortedValA, csrSortedRowPtrA, csrSortedColIndA, info, pBufferSizeInBytes));
    }

    private static native int cusparseScsrilu02_bufferSizeNative(cusparseHandle var0, int var1, int var2, cusparseMatDescr var3, Pointer var4, Pointer var5, Pointer var6, csrilu02Info var7, int[] var8);

    public static int cusparseDcsrilu02_bufferSize(cusparseHandle handle, int m, int nnz, cusparseMatDescr descrA, Pointer csrSortedValA, Pointer csrSortedRowPtrA, Pointer csrSortedColIndA, csrilu02Info info, int[] pBufferSizeInBytes) {
        return JCusparse.checkResult(JCusparse.cusparseDcsrilu02_bufferSizeNative(handle, m, nnz, descrA, csrSortedValA, csrSortedRowPtrA, csrSortedColIndA, info, pBufferSizeInBytes));
    }

    private static native int cusparseDcsrilu02_bufferSizeNative(cusparseHandle var0, int var1, int var2, cusparseMatDescr var3, Pointer var4, Pointer var5, Pointer var6, csrilu02Info var7, int[] var8);

    public static int cusparseCcsrilu02_bufferSize(cusparseHandle handle, int m, int nnz, cusparseMatDescr descrA, Pointer csrSortedValA, Pointer csrSortedRowPtrA, Pointer csrSortedColIndA, csrilu02Info info, int[] pBufferSizeInBytes) {
        return JCusparse.checkResult(JCusparse.cusparseCcsrilu02_bufferSizeNative(handle, m, nnz, descrA, csrSortedValA, csrSortedRowPtrA, csrSortedColIndA, info, pBufferSizeInBytes));
    }

    private static native int cusparseCcsrilu02_bufferSizeNative(cusparseHandle var0, int var1, int var2, cusparseMatDescr var3, Pointer var4, Pointer var5, Pointer var6, csrilu02Info var7, int[] var8);

    public static int cusparseZcsrilu02_bufferSize(cusparseHandle handle, int m, int nnz, cusparseMatDescr descrA, Pointer csrSortedValA, Pointer csrSortedRowPtrA, Pointer csrSortedColIndA, csrilu02Info info, int[] pBufferSizeInBytes) {
        return JCusparse.checkResult(JCusparse.cusparseZcsrilu02_bufferSizeNative(handle, m, nnz, descrA, csrSortedValA, csrSortedRowPtrA, csrSortedColIndA, info, pBufferSizeInBytes));
    }

    private static native int cusparseZcsrilu02_bufferSizeNative(cusparseHandle var0, int var1, int var2, cusparseMatDescr var3, Pointer var4, Pointer var5, Pointer var6, csrilu02Info var7, int[] var8);

    public static int cusparseScsrilu02_bufferSizeExt(cusparseHandle handle, int m, int nnz, cusparseMatDescr descrA, Pointer csrSortedVal, Pointer csrSortedRowPtr, Pointer csrSortedColInd, csrilu02Info info, int[] pBufferSize) {
        return JCusparse.checkResult(JCusparse.cusparseScsrilu02_bufferSizeExtNative(handle, m, nnz, descrA, csrSortedVal, csrSortedRowPtr, csrSortedColInd, info, pBufferSize));
    }

    private static native int cusparseScsrilu02_bufferSizeExtNative(cusparseHandle var0, int var1, int var2, cusparseMatDescr var3, Pointer var4, Pointer var5, Pointer var6, csrilu02Info var7, int[] var8);

    public static int cusparseDcsrilu02_bufferSizeExt(cusparseHandle handle, int m, int nnz, cusparseMatDescr descrA, Pointer csrSortedVal, Pointer csrSortedRowPtr, Pointer csrSortedColInd, csrilu02Info info, int[] pBufferSize) {
        return JCusparse.checkResult(JCusparse.cusparseDcsrilu02_bufferSizeExtNative(handle, m, nnz, descrA, csrSortedVal, csrSortedRowPtr, csrSortedColInd, info, pBufferSize));
    }

    private static native int cusparseDcsrilu02_bufferSizeExtNative(cusparseHandle var0, int var1, int var2, cusparseMatDescr var3, Pointer var4, Pointer var5, Pointer var6, csrilu02Info var7, int[] var8);

    public static int cusparseCcsrilu02_bufferSizeExt(cusparseHandle handle, int m, int nnz, cusparseMatDescr descrA, Pointer csrSortedVal, Pointer csrSortedRowPtr, Pointer csrSortedColInd, csrilu02Info info, int[] pBufferSize) {
        return JCusparse.checkResult(JCusparse.cusparseCcsrilu02_bufferSizeExtNative(handle, m, nnz, descrA, csrSortedVal, csrSortedRowPtr, csrSortedColInd, info, pBufferSize));
    }

    private static native int cusparseCcsrilu02_bufferSizeExtNative(cusparseHandle var0, int var1, int var2, cusparseMatDescr var3, Pointer var4, Pointer var5, Pointer var6, csrilu02Info var7, int[] var8);

    public static int cusparseZcsrilu02_bufferSizeExt(cusparseHandle handle, int m, int nnz, cusparseMatDescr descrA, Pointer csrSortedVal, Pointer csrSortedRowPtr, Pointer csrSortedColInd, csrilu02Info info, int[] pBufferSize) {
        return JCusparse.checkResult(JCusparse.cusparseZcsrilu02_bufferSizeExtNative(handle, m, nnz, descrA, csrSortedVal, csrSortedRowPtr, csrSortedColInd, info, pBufferSize));
    }

    private static native int cusparseZcsrilu02_bufferSizeExtNative(cusparseHandle var0, int var1, int var2, cusparseMatDescr var3, Pointer var4, Pointer var5, Pointer var6, csrilu02Info var7, int[] var8);

    public static int cusparseScsrilu02_analysis(cusparseHandle handle, int m, int nnz, cusparseMatDescr descrA, Pointer csrSortedValA, Pointer csrSortedRowPtrA, Pointer csrSortedColIndA, csrilu02Info info, int policy, Pointer pBuffer) {
        return JCusparse.checkResult(JCusparse.cusparseScsrilu02_analysisNative(handle, m, nnz, descrA, csrSortedValA, csrSortedRowPtrA, csrSortedColIndA, info, policy, pBuffer));
    }

    private static native int cusparseScsrilu02_analysisNative(cusparseHandle var0, int var1, int var2, cusparseMatDescr var3, Pointer var4, Pointer var5, Pointer var6, csrilu02Info var7, int var8, Pointer var9);

    public static int cusparseDcsrilu02_analysis(cusparseHandle handle, int m, int nnz, cusparseMatDescr descrA, Pointer csrSortedValA, Pointer csrSortedRowPtrA, Pointer csrSortedColIndA, csrilu02Info info, int policy, Pointer pBuffer) {
        return JCusparse.checkResult(JCusparse.cusparseDcsrilu02_analysisNative(handle, m, nnz, descrA, csrSortedValA, csrSortedRowPtrA, csrSortedColIndA, info, policy, pBuffer));
    }

    private static native int cusparseDcsrilu02_analysisNative(cusparseHandle var0, int var1, int var2, cusparseMatDescr var3, Pointer var4, Pointer var5, Pointer var6, csrilu02Info var7, int var8, Pointer var9);

    public static int cusparseCcsrilu02_analysis(cusparseHandle handle, int m, int nnz, cusparseMatDescr descrA, Pointer csrSortedValA, Pointer csrSortedRowPtrA, Pointer csrSortedColIndA, csrilu02Info info, int policy, Pointer pBuffer) {
        return JCusparse.checkResult(JCusparse.cusparseCcsrilu02_analysisNative(handle, m, nnz, descrA, csrSortedValA, csrSortedRowPtrA, csrSortedColIndA, info, policy, pBuffer));
    }

    private static native int cusparseCcsrilu02_analysisNative(cusparseHandle var0, int var1, int var2, cusparseMatDescr var3, Pointer var4, Pointer var5, Pointer var6, csrilu02Info var7, int var8, Pointer var9);

    public static int cusparseZcsrilu02_analysis(cusparseHandle handle, int m, int nnz, cusparseMatDescr descrA, Pointer csrSortedValA, Pointer csrSortedRowPtrA, Pointer csrSortedColIndA, csrilu02Info info, int policy, Pointer pBuffer) {
        return JCusparse.checkResult(JCusparse.cusparseZcsrilu02_analysisNative(handle, m, nnz, descrA, csrSortedValA, csrSortedRowPtrA, csrSortedColIndA, info, policy, pBuffer));
    }

    private static native int cusparseZcsrilu02_analysisNative(cusparseHandle var0, int var1, int var2, cusparseMatDescr var3, Pointer var4, Pointer var5, Pointer var6, csrilu02Info var7, int var8, Pointer var9);

    public static int cusparseScsrilu02(cusparseHandle handle, int m, int nnz, cusparseMatDescr descrA, Pointer csrSortedValA_valM, Pointer csrSortedRowPtrA, Pointer csrSortedColIndA, csrilu02Info info, int policy, Pointer pBuffer) {
        return JCusparse.checkResult(JCusparse.cusparseScsrilu02Native(handle, m, nnz, descrA, csrSortedValA_valM, csrSortedRowPtrA, csrSortedColIndA, info, policy, pBuffer));
    }

    private static native int cusparseScsrilu02Native(cusparseHandle var0, int var1, int var2, cusparseMatDescr var3, Pointer var4, Pointer var5, Pointer var6, csrilu02Info var7, int var8, Pointer var9);

    public static int cusparseDcsrilu02(cusparseHandle handle, int m, int nnz, cusparseMatDescr descrA, Pointer csrSortedValA_valM, Pointer csrSortedRowPtrA, Pointer csrSortedColIndA, csrilu02Info info, int policy, Pointer pBuffer) {
        return JCusparse.checkResult(JCusparse.cusparseDcsrilu02Native(handle, m, nnz, descrA, csrSortedValA_valM, csrSortedRowPtrA, csrSortedColIndA, info, policy, pBuffer));
    }

    private static native int cusparseDcsrilu02Native(cusparseHandle var0, int var1, int var2, cusparseMatDescr var3, Pointer var4, Pointer var5, Pointer var6, csrilu02Info var7, int var8, Pointer var9);

    public static int cusparseCcsrilu02(cusparseHandle handle, int m, int nnz, cusparseMatDescr descrA, Pointer csrSortedValA_valM, Pointer csrSortedRowPtrA, Pointer csrSortedColIndA, csrilu02Info info, int policy, Pointer pBuffer) {
        return JCusparse.checkResult(JCusparse.cusparseCcsrilu02Native(handle, m, nnz, descrA, csrSortedValA_valM, csrSortedRowPtrA, csrSortedColIndA, info, policy, pBuffer));
    }

    private static native int cusparseCcsrilu02Native(cusparseHandle var0, int var1, int var2, cusparseMatDescr var3, Pointer var4, Pointer var5, Pointer var6, csrilu02Info var7, int var8, Pointer var9);

    public static int cusparseZcsrilu02(cusparseHandle handle, int m, int nnz, cusparseMatDescr descrA, Pointer csrSortedValA_valM, Pointer csrSortedRowPtrA, Pointer csrSortedColIndA, csrilu02Info info, int policy, Pointer pBuffer) {
        return JCusparse.checkResult(JCusparse.cusparseZcsrilu02Native(handle, m, nnz, descrA, csrSortedValA_valM, csrSortedRowPtrA, csrSortedColIndA, info, policy, pBuffer));
    }

    private static native int cusparseZcsrilu02Native(cusparseHandle var0, int var1, int var2, cusparseMatDescr var3, Pointer var4, Pointer var5, Pointer var6, csrilu02Info var7, int var8, Pointer var9);

    public static int cusparseSbsrilu02_numericBoost(cusparseHandle handle, bsrilu02Info info, int enable_boost, Pointer tol, Pointer boost_val) {
        return JCusparse.checkResult(JCusparse.cusparseSbsrilu02_numericBoostNative(handle, info, enable_boost, tol, boost_val));
    }

    private static native int cusparseSbsrilu02_numericBoostNative(cusparseHandle var0, bsrilu02Info var1, int var2, Pointer var3, Pointer var4);

    public static int cusparseDbsrilu02_numericBoost(cusparseHandle handle, bsrilu02Info info, int enable_boost, Pointer tol, Pointer boost_val) {
        return JCusparse.checkResult(JCusparse.cusparseDbsrilu02_numericBoostNative(handle, info, enable_boost, tol, boost_val));
    }

    private static native int cusparseDbsrilu02_numericBoostNative(cusparseHandle var0, bsrilu02Info var1, int var2, Pointer var3, Pointer var4);

    public static int cusparseCbsrilu02_numericBoost(cusparseHandle handle, bsrilu02Info info, int enable_boost, Pointer tol, Pointer boost_val) {
        return JCusparse.checkResult(JCusparse.cusparseCbsrilu02_numericBoostNative(handle, info, enable_boost, tol, boost_val));
    }

    private static native int cusparseCbsrilu02_numericBoostNative(cusparseHandle var0, bsrilu02Info var1, int var2, Pointer var3, Pointer var4);

    public static int cusparseZbsrilu02_numericBoost(cusparseHandle handle, bsrilu02Info info, int enable_boost, Pointer tol, Pointer boost_val) {
        return JCusparse.checkResult(JCusparse.cusparseZbsrilu02_numericBoostNative(handle, info, enable_boost, tol, boost_val));
    }

    private static native int cusparseZbsrilu02_numericBoostNative(cusparseHandle var0, bsrilu02Info var1, int var2, Pointer var3, Pointer var4);

    public static int cusparseXbsrilu02_zeroPivot(cusparseHandle handle, bsrilu02Info info, Pointer position) {
        return JCusparse.checkResult(JCusparse.cusparseXbsrilu02_zeroPivotNative(handle, info, position));
    }

    private static native int cusparseXbsrilu02_zeroPivotNative(cusparseHandle var0, bsrilu02Info var1, Pointer var2);

    public static int cusparseSbsrilu02_bufferSize(cusparseHandle handle, int dirA, int mb, int nnzb, cusparseMatDescr descrA, Pointer bsrSortedVal, Pointer bsrSortedRowPtr, Pointer bsrSortedColInd, int blockDim, bsrilu02Info info, int[] pBufferSizeInBytes) {
        return JCusparse.checkResult(JCusparse.cusparseSbsrilu02_bufferSizeNative(handle, dirA, mb, nnzb, descrA, bsrSortedVal, bsrSortedRowPtr, bsrSortedColInd, blockDim, info, pBufferSizeInBytes));
    }

    private static native int cusparseSbsrilu02_bufferSizeNative(cusparseHandle var0, int var1, int var2, int var3, cusparseMatDescr var4, Pointer var5, Pointer var6, Pointer var7, int var8, bsrilu02Info var9, int[] var10);

    public static int cusparseDbsrilu02_bufferSize(cusparseHandle handle, int dirA, int mb, int nnzb, cusparseMatDescr descrA, Pointer bsrSortedVal, Pointer bsrSortedRowPtr, Pointer bsrSortedColInd, int blockDim, bsrilu02Info info, int[] pBufferSizeInBytes) {
        return JCusparse.checkResult(JCusparse.cusparseDbsrilu02_bufferSizeNative(handle, dirA, mb, nnzb, descrA, bsrSortedVal, bsrSortedRowPtr, bsrSortedColInd, blockDim, info, pBufferSizeInBytes));
    }

    private static native int cusparseDbsrilu02_bufferSizeNative(cusparseHandle var0, int var1, int var2, int var3, cusparseMatDescr var4, Pointer var5, Pointer var6, Pointer var7, int var8, bsrilu02Info var9, int[] var10);

    public static int cusparseCbsrilu02_bufferSize(cusparseHandle handle, int dirA, int mb, int nnzb, cusparseMatDescr descrA, Pointer bsrSortedVal, Pointer bsrSortedRowPtr, Pointer bsrSortedColInd, int blockDim, bsrilu02Info info, int[] pBufferSizeInBytes) {
        return JCusparse.checkResult(JCusparse.cusparseCbsrilu02_bufferSizeNative(handle, dirA, mb, nnzb, descrA, bsrSortedVal, bsrSortedRowPtr, bsrSortedColInd, blockDim, info, pBufferSizeInBytes));
    }

    private static native int cusparseCbsrilu02_bufferSizeNative(cusparseHandle var0, int var1, int var2, int var3, cusparseMatDescr var4, Pointer var5, Pointer var6, Pointer var7, int var8, bsrilu02Info var9, int[] var10);

    public static int cusparseZbsrilu02_bufferSize(cusparseHandle handle, int dirA, int mb, int nnzb, cusparseMatDescr descrA, Pointer bsrSortedVal, Pointer bsrSortedRowPtr, Pointer bsrSortedColInd, int blockDim, bsrilu02Info info, int[] pBufferSizeInBytes) {
        return JCusparse.checkResult(JCusparse.cusparseZbsrilu02_bufferSizeNative(handle, dirA, mb, nnzb, descrA, bsrSortedVal, bsrSortedRowPtr, bsrSortedColInd, blockDim, info, pBufferSizeInBytes));
    }

    private static native int cusparseZbsrilu02_bufferSizeNative(cusparseHandle var0, int var1, int var2, int var3, cusparseMatDescr var4, Pointer var5, Pointer var6, Pointer var7, int var8, bsrilu02Info var9, int[] var10);

    public static int cusparseSbsrilu02_bufferSizeExt(cusparseHandle handle, int dirA, int mb, int nnzb, cusparseMatDescr descrA, Pointer bsrSortedVal, Pointer bsrSortedRowPtr, Pointer bsrSortedColInd, int blockSize, bsrilu02Info info, int[] pBufferSize) {
        return JCusparse.checkResult(JCusparse.cusparseSbsrilu02_bufferSizeExtNative(handle, dirA, mb, nnzb, descrA, bsrSortedVal, bsrSortedRowPtr, bsrSortedColInd, blockSize, info, pBufferSize));
    }

    private static native int cusparseSbsrilu02_bufferSizeExtNative(cusparseHandle var0, int var1, int var2, int var3, cusparseMatDescr var4, Pointer var5, Pointer var6, Pointer var7, int var8, bsrilu02Info var9, int[] var10);

    public static int cusparseDbsrilu02_bufferSizeExt(cusparseHandle handle, int dirA, int mb, int nnzb, cusparseMatDescr descrA, Pointer bsrSortedVal, Pointer bsrSortedRowPtr, Pointer bsrSortedColInd, int blockSize, bsrilu02Info info, int[] pBufferSize) {
        return JCusparse.checkResult(JCusparse.cusparseDbsrilu02_bufferSizeExtNative(handle, dirA, mb, nnzb, descrA, bsrSortedVal, bsrSortedRowPtr, bsrSortedColInd, blockSize, info, pBufferSize));
    }

    private static native int cusparseDbsrilu02_bufferSizeExtNative(cusparseHandle var0, int var1, int var2, int var3, cusparseMatDescr var4, Pointer var5, Pointer var6, Pointer var7, int var8, bsrilu02Info var9, int[] var10);

    public static int cusparseCbsrilu02_bufferSizeExt(cusparseHandle handle, int dirA, int mb, int nnzb, cusparseMatDescr descrA, Pointer bsrSortedVal, Pointer bsrSortedRowPtr, Pointer bsrSortedColInd, int blockSize, bsrilu02Info info, int[] pBufferSize) {
        return JCusparse.checkResult(JCusparse.cusparseCbsrilu02_bufferSizeExtNative(handle, dirA, mb, nnzb, descrA, bsrSortedVal, bsrSortedRowPtr, bsrSortedColInd, blockSize, info, pBufferSize));
    }

    private static native int cusparseCbsrilu02_bufferSizeExtNative(cusparseHandle var0, int var1, int var2, int var3, cusparseMatDescr var4, Pointer var5, Pointer var6, Pointer var7, int var8, bsrilu02Info var9, int[] var10);

    public static int cusparseZbsrilu02_bufferSizeExt(cusparseHandle handle, int dirA, int mb, int nnzb, cusparseMatDescr descrA, Pointer bsrSortedVal, Pointer bsrSortedRowPtr, Pointer bsrSortedColInd, int blockSize, bsrilu02Info info, int[] pBufferSize) {
        return JCusparse.checkResult(JCusparse.cusparseZbsrilu02_bufferSizeExtNative(handle, dirA, mb, nnzb, descrA, bsrSortedVal, bsrSortedRowPtr, bsrSortedColInd, blockSize, info, pBufferSize));
    }

    private static native int cusparseZbsrilu02_bufferSizeExtNative(cusparseHandle var0, int var1, int var2, int var3, cusparseMatDescr var4, Pointer var5, Pointer var6, Pointer var7, int var8, bsrilu02Info var9, int[] var10);

    public static int cusparseSbsrilu02_analysis(cusparseHandle handle, int dirA, int mb, int nnzb, cusparseMatDescr descrA, Pointer bsrSortedVal, Pointer bsrSortedRowPtr, Pointer bsrSortedColInd, int blockDim, bsrilu02Info info, int policy, Pointer pBuffer) {
        return JCusparse.checkResult(JCusparse.cusparseSbsrilu02_analysisNative(handle, dirA, mb, nnzb, descrA, bsrSortedVal, bsrSortedRowPtr, bsrSortedColInd, blockDim, info, policy, pBuffer));
    }

    private static native int cusparseSbsrilu02_analysisNative(cusparseHandle var0, int var1, int var2, int var3, cusparseMatDescr var4, Pointer var5, Pointer var6, Pointer var7, int var8, bsrilu02Info var9, int var10, Pointer var11);

    public static int cusparseDbsrilu02_analysis(cusparseHandle handle, int dirA, int mb, int nnzb, cusparseMatDescr descrA, Pointer bsrSortedVal, Pointer bsrSortedRowPtr, Pointer bsrSortedColInd, int blockDim, bsrilu02Info info, int policy, Pointer pBuffer) {
        return JCusparse.checkResult(JCusparse.cusparseDbsrilu02_analysisNative(handle, dirA, mb, nnzb, descrA, bsrSortedVal, bsrSortedRowPtr, bsrSortedColInd, blockDim, info, policy, pBuffer));
    }

    private static native int cusparseDbsrilu02_analysisNative(cusparseHandle var0, int var1, int var2, int var3, cusparseMatDescr var4, Pointer var5, Pointer var6, Pointer var7, int var8, bsrilu02Info var9, int var10, Pointer var11);

    public static int cusparseCbsrilu02_analysis(cusparseHandle handle, int dirA, int mb, int nnzb, cusparseMatDescr descrA, Pointer bsrSortedVal, Pointer bsrSortedRowPtr, Pointer bsrSortedColInd, int blockDim, bsrilu02Info info, int policy, Pointer pBuffer) {
        return JCusparse.checkResult(JCusparse.cusparseCbsrilu02_analysisNative(handle, dirA, mb, nnzb, descrA, bsrSortedVal, bsrSortedRowPtr, bsrSortedColInd, blockDim, info, policy, pBuffer));
    }

    private static native int cusparseCbsrilu02_analysisNative(cusparseHandle var0, int var1, int var2, int var3, cusparseMatDescr var4, Pointer var5, Pointer var6, Pointer var7, int var8, bsrilu02Info var9, int var10, Pointer var11);

    public static int cusparseZbsrilu02_analysis(cusparseHandle handle, int dirA, int mb, int nnzb, cusparseMatDescr descrA, Pointer bsrSortedVal, Pointer bsrSortedRowPtr, Pointer bsrSortedColInd, int blockDim, bsrilu02Info info, int policy, Pointer pBuffer) {
        return JCusparse.checkResult(JCusparse.cusparseZbsrilu02_analysisNative(handle, dirA, mb, nnzb, descrA, bsrSortedVal, bsrSortedRowPtr, bsrSortedColInd, blockDim, info, policy, pBuffer));
    }

    private static native int cusparseZbsrilu02_analysisNative(cusparseHandle var0, int var1, int var2, int var3, cusparseMatDescr var4, Pointer var5, Pointer var6, Pointer var7, int var8, bsrilu02Info var9, int var10, Pointer var11);

    public static int cusparseSbsrilu02(cusparseHandle handle, int dirA, int mb, int nnzb, cusparseMatDescr descra, Pointer bsrSortedVal, Pointer bsrSortedRowPtr, Pointer bsrSortedColInd, int blockDim, bsrilu02Info info, int policy, Pointer pBuffer) {
        return JCusparse.checkResult(JCusparse.cusparseSbsrilu02Native(handle, dirA, mb, nnzb, descra, bsrSortedVal, bsrSortedRowPtr, bsrSortedColInd, blockDim, info, policy, pBuffer));
    }

    private static native int cusparseSbsrilu02Native(cusparseHandle var0, int var1, int var2, int var3, cusparseMatDescr var4, Pointer var5, Pointer var6, Pointer var7, int var8, bsrilu02Info var9, int var10, Pointer var11);

    public static int cusparseDbsrilu02(cusparseHandle handle, int dirA, int mb, int nnzb, cusparseMatDescr descra, Pointer bsrSortedVal, Pointer bsrSortedRowPtr, Pointer bsrSortedColInd, int blockDim, bsrilu02Info info, int policy, Pointer pBuffer) {
        return JCusparse.checkResult(JCusparse.cusparseDbsrilu02Native(handle, dirA, mb, nnzb, descra, bsrSortedVal, bsrSortedRowPtr, bsrSortedColInd, blockDim, info, policy, pBuffer));
    }

    private static native int cusparseDbsrilu02Native(cusparseHandle var0, int var1, int var2, int var3, cusparseMatDescr var4, Pointer var5, Pointer var6, Pointer var7, int var8, bsrilu02Info var9, int var10, Pointer var11);

    public static int cusparseCbsrilu02(cusparseHandle handle, int dirA, int mb, int nnzb, cusparseMatDescr descra, Pointer bsrSortedVal, Pointer bsrSortedRowPtr, Pointer bsrSortedColInd, int blockDim, bsrilu02Info info, int policy, Pointer pBuffer) {
        return JCusparse.checkResult(JCusparse.cusparseCbsrilu02Native(handle, dirA, mb, nnzb, descra, bsrSortedVal, bsrSortedRowPtr, bsrSortedColInd, blockDim, info, policy, pBuffer));
    }

    private static native int cusparseCbsrilu02Native(cusparseHandle var0, int var1, int var2, int var3, cusparseMatDescr var4, Pointer var5, Pointer var6, Pointer var7, int var8, bsrilu02Info var9, int var10, Pointer var11);

    public static int cusparseZbsrilu02(cusparseHandle handle, int dirA, int mb, int nnzb, cusparseMatDescr descra, Pointer bsrSortedVal, Pointer bsrSortedRowPtr, Pointer bsrSortedColInd, int blockDim, bsrilu02Info info, int policy, Pointer pBuffer) {
        return JCusparse.checkResult(JCusparse.cusparseZbsrilu02Native(handle, dirA, mb, nnzb, descra, bsrSortedVal, bsrSortedRowPtr, bsrSortedColInd, blockDim, info, policy, pBuffer));
    }

    private static native int cusparseZbsrilu02Native(cusparseHandle var0, int var1, int var2, int var3, cusparseMatDescr var4, Pointer var5, Pointer var6, Pointer var7, int var8, bsrilu02Info var9, int var10, Pointer var11);

    public static int cusparseScsric0(cusparseHandle handle, int trans, int m, cusparseMatDescr descrA, Pointer csrSortedValA_ValM, Pointer csrSortedRowPtrA, Pointer csrSortedColIndA, cusparseSolveAnalysisInfo info) {
        return JCusparse.checkResult(JCusparse.cusparseScsric0Native(handle, trans, m, descrA, csrSortedValA_ValM, csrSortedRowPtrA, csrSortedColIndA, info));
    }

    private static native int cusparseScsric0Native(cusparseHandle var0, int var1, int var2, cusparseMatDescr var3, Pointer var4, Pointer var5, Pointer var6, cusparseSolveAnalysisInfo var7);

    public static int cusparseDcsric0(cusparseHandle handle, int trans, int m, cusparseMatDescr descrA, Pointer csrSortedValA_ValM, Pointer csrSortedRowPtrA, Pointer csrSortedColIndA, cusparseSolveAnalysisInfo info) {
        return JCusparse.checkResult(JCusparse.cusparseDcsric0Native(handle, trans, m, descrA, csrSortedValA_ValM, csrSortedRowPtrA, csrSortedColIndA, info));
    }

    private static native int cusparseDcsric0Native(cusparseHandle var0, int var1, int var2, cusparseMatDescr var3, Pointer var4, Pointer var5, Pointer var6, cusparseSolveAnalysisInfo var7);

    public static int cusparseCcsric0(cusparseHandle handle, int trans, int m, cusparseMatDescr descrA, Pointer csrSortedValA_ValM, Pointer csrSortedRowPtrA, Pointer csrSortedColIndA, cusparseSolveAnalysisInfo info) {
        return JCusparse.checkResult(JCusparse.cusparseCcsric0Native(handle, trans, m, descrA, csrSortedValA_ValM, csrSortedRowPtrA, csrSortedColIndA, info));
    }

    private static native int cusparseCcsric0Native(cusparseHandle var0, int var1, int var2, cusparseMatDescr var3, Pointer var4, Pointer var5, Pointer var6, cusparseSolveAnalysisInfo var7);

    public static int cusparseZcsric0(cusparseHandle handle, int trans, int m, cusparseMatDescr descrA, Pointer csrSortedValA_ValM, Pointer csrSortedRowPtrA, Pointer csrSortedColIndA, cusparseSolveAnalysisInfo info) {
        return JCusparse.checkResult(JCusparse.cusparseZcsric0Native(handle, trans, m, descrA, csrSortedValA_ValM, csrSortedRowPtrA, csrSortedColIndA, info));
    }

    private static native int cusparseZcsric0Native(cusparseHandle var0, int var1, int var2, cusparseMatDescr var3, Pointer var4, Pointer var5, Pointer var6, cusparseSolveAnalysisInfo var7);

    public static int cusparseXcsric02_zeroPivot(cusparseHandle handle, csric02Info info, Pointer position) {
        return JCusparse.checkResult(JCusparse.cusparseXcsric02_zeroPivotNative(handle, info, position));
    }

    private static native int cusparseXcsric02_zeroPivotNative(cusparseHandle var0, csric02Info var1, Pointer var2);

    public static int cusparseScsric02_bufferSize(cusparseHandle handle, int m, int nnz, cusparseMatDescr descrA, Pointer csrSortedValA, Pointer csrSortedRowPtrA, Pointer csrSortedColIndA, csric02Info info, int[] pBufferSizeInBytes) {
        return JCusparse.checkResult(JCusparse.cusparseScsric02_bufferSizeNative(handle, m, nnz, descrA, csrSortedValA, csrSortedRowPtrA, csrSortedColIndA, info, pBufferSizeInBytes));
    }

    private static native int cusparseScsric02_bufferSizeNative(cusparseHandle var0, int var1, int var2, cusparseMatDescr var3, Pointer var4, Pointer var5, Pointer var6, csric02Info var7, int[] var8);

    public static int cusparseDcsric02_bufferSize(cusparseHandle handle, int m, int nnz, cusparseMatDescr descrA, Pointer csrSortedValA, Pointer csrSortedRowPtrA, Pointer csrSortedColIndA, csric02Info info, int[] pBufferSizeInBytes) {
        return JCusparse.checkResult(JCusparse.cusparseDcsric02_bufferSizeNative(handle, m, nnz, descrA, csrSortedValA, csrSortedRowPtrA, csrSortedColIndA, info, pBufferSizeInBytes));
    }

    private static native int cusparseDcsric02_bufferSizeNative(cusparseHandle var0, int var1, int var2, cusparseMatDescr var3, Pointer var4, Pointer var5, Pointer var6, csric02Info var7, int[] var8);

    public static int cusparseCcsric02_bufferSize(cusparseHandle handle, int m, int nnz, cusparseMatDescr descrA, Pointer csrSortedValA, Pointer csrSortedRowPtrA, Pointer csrSortedColIndA, csric02Info info, int[] pBufferSizeInBytes) {
        return JCusparse.checkResult(JCusparse.cusparseCcsric02_bufferSizeNative(handle, m, nnz, descrA, csrSortedValA, csrSortedRowPtrA, csrSortedColIndA, info, pBufferSizeInBytes));
    }

    private static native int cusparseCcsric02_bufferSizeNative(cusparseHandle var0, int var1, int var2, cusparseMatDescr var3, Pointer var4, Pointer var5, Pointer var6, csric02Info var7, int[] var8);

    public static int cusparseZcsric02_bufferSize(cusparseHandle handle, int m, int nnz, cusparseMatDescr descrA, Pointer csrSortedValA, Pointer csrSortedRowPtrA, Pointer csrSortedColIndA, csric02Info info, int[] pBufferSizeInBytes) {
        return JCusparse.checkResult(JCusparse.cusparseZcsric02_bufferSizeNative(handle, m, nnz, descrA, csrSortedValA, csrSortedRowPtrA, csrSortedColIndA, info, pBufferSizeInBytes));
    }

    private static native int cusparseZcsric02_bufferSizeNative(cusparseHandle var0, int var1, int var2, cusparseMatDescr var3, Pointer var4, Pointer var5, Pointer var6, csric02Info var7, int[] var8);

    public static int cusparseScsric02_bufferSizeExt(cusparseHandle handle, int m, int nnz, cusparseMatDescr descrA, Pointer csrSortedVal, Pointer csrSortedRowPtr, Pointer csrSortedColInd, csric02Info info, int[] pBufferSize) {
        return JCusparse.checkResult(JCusparse.cusparseScsric02_bufferSizeExtNative(handle, m, nnz, descrA, csrSortedVal, csrSortedRowPtr, csrSortedColInd, info, pBufferSize));
    }

    private static native int cusparseScsric02_bufferSizeExtNative(cusparseHandle var0, int var1, int var2, cusparseMatDescr var3, Pointer var4, Pointer var5, Pointer var6, csric02Info var7, int[] var8);

    public static int cusparseDcsric02_bufferSizeExt(cusparseHandle handle, int m, int nnz, cusparseMatDescr descrA, Pointer csrSortedVal, Pointer csrSortedRowPtr, Pointer csrSortedColInd, csric02Info info, int[] pBufferSize) {
        return JCusparse.checkResult(JCusparse.cusparseDcsric02_bufferSizeExtNative(handle, m, nnz, descrA, csrSortedVal, csrSortedRowPtr, csrSortedColInd, info, pBufferSize));
    }

    private static native int cusparseDcsric02_bufferSizeExtNative(cusparseHandle var0, int var1, int var2, cusparseMatDescr var3, Pointer var4, Pointer var5, Pointer var6, csric02Info var7, int[] var8);

    public static int cusparseCcsric02_bufferSizeExt(cusparseHandle handle, int m, int nnz, cusparseMatDescr descrA, Pointer csrSortedVal, Pointer csrSortedRowPtr, Pointer csrSortedColInd, csric02Info info, int[] pBufferSize) {
        return JCusparse.checkResult(JCusparse.cusparseCcsric02_bufferSizeExtNative(handle, m, nnz, descrA, csrSortedVal, csrSortedRowPtr, csrSortedColInd, info, pBufferSize));
    }

    private static native int cusparseCcsric02_bufferSizeExtNative(cusparseHandle var0, int var1, int var2, cusparseMatDescr var3, Pointer var4, Pointer var5, Pointer var6, csric02Info var7, int[] var8);

    public static int cusparseZcsric02_bufferSizeExt(cusparseHandle handle, int m, int nnz, cusparseMatDescr descrA, Pointer csrSortedVal, Pointer csrSortedRowPtr, Pointer csrSortedColInd, csric02Info info, int[] pBufferSize) {
        return JCusparse.checkResult(JCusparse.cusparseZcsric02_bufferSizeExtNative(handle, m, nnz, descrA, csrSortedVal, csrSortedRowPtr, csrSortedColInd, info, pBufferSize));
    }

    private static native int cusparseZcsric02_bufferSizeExtNative(cusparseHandle var0, int var1, int var2, cusparseMatDescr var3, Pointer var4, Pointer var5, Pointer var6, csric02Info var7, int[] var8);

    public static int cusparseScsric02_analysis(cusparseHandle handle, int m, int nnz, cusparseMatDescr descrA, Pointer csrSortedValA, Pointer csrSortedRowPtrA, Pointer csrSortedColIndA, csric02Info info, int policy, Pointer pBuffer) {
        return JCusparse.checkResult(JCusparse.cusparseScsric02_analysisNative(handle, m, nnz, descrA, csrSortedValA, csrSortedRowPtrA, csrSortedColIndA, info, policy, pBuffer));
    }

    private static native int cusparseScsric02_analysisNative(cusparseHandle var0, int var1, int var2, cusparseMatDescr var3, Pointer var4, Pointer var5, Pointer var6, csric02Info var7, int var8, Pointer var9);

    public static int cusparseDcsric02_analysis(cusparseHandle handle, int m, int nnz, cusparseMatDescr descrA, Pointer csrSortedValA, Pointer csrSortedRowPtrA, Pointer csrSortedColIndA, csric02Info info, int policy, Pointer pBuffer) {
        return JCusparse.checkResult(JCusparse.cusparseDcsric02_analysisNative(handle, m, nnz, descrA, csrSortedValA, csrSortedRowPtrA, csrSortedColIndA, info, policy, pBuffer));
    }

    private static native int cusparseDcsric02_analysisNative(cusparseHandle var0, int var1, int var2, cusparseMatDescr var3, Pointer var4, Pointer var5, Pointer var6, csric02Info var7, int var8, Pointer var9);

    public static int cusparseCcsric02_analysis(cusparseHandle handle, int m, int nnz, cusparseMatDescr descrA, Pointer csrSortedValA, Pointer csrSortedRowPtrA, Pointer csrSortedColIndA, csric02Info info, int policy, Pointer pBuffer) {
        return JCusparse.checkResult(JCusparse.cusparseCcsric02_analysisNative(handle, m, nnz, descrA, csrSortedValA, csrSortedRowPtrA, csrSortedColIndA, info, policy, pBuffer));
    }

    private static native int cusparseCcsric02_analysisNative(cusparseHandle var0, int var1, int var2, cusparseMatDescr var3, Pointer var4, Pointer var5, Pointer var6, csric02Info var7, int var8, Pointer var9);

    public static int cusparseZcsric02_analysis(cusparseHandle handle, int m, int nnz, cusparseMatDescr descrA, Pointer csrSortedValA, Pointer csrSortedRowPtrA, Pointer csrSortedColIndA, csric02Info info, int policy, Pointer pBuffer) {
        return JCusparse.checkResult(JCusparse.cusparseZcsric02_analysisNative(handle, m, nnz, descrA, csrSortedValA, csrSortedRowPtrA, csrSortedColIndA, info, policy, pBuffer));
    }

    private static native int cusparseZcsric02_analysisNative(cusparseHandle var0, int var1, int var2, cusparseMatDescr var3, Pointer var4, Pointer var5, Pointer var6, csric02Info var7, int var8, Pointer var9);

    public static int cusparseScsric02(cusparseHandle handle, int m, int nnz, cusparseMatDescr descrA, Pointer csrSortedValA_valM, Pointer csrSortedRowPtrA, Pointer csrSortedColIndA, csric02Info info, int policy, Pointer pBuffer) {
        return JCusparse.checkResult(JCusparse.cusparseScsric02Native(handle, m, nnz, descrA, csrSortedValA_valM, csrSortedRowPtrA, csrSortedColIndA, info, policy, pBuffer));
    }

    private static native int cusparseScsric02Native(cusparseHandle var0, int var1, int var2, cusparseMatDescr var3, Pointer var4, Pointer var5, Pointer var6, csric02Info var7, int var8, Pointer var9);

    public static int cusparseDcsric02(cusparseHandle handle, int m, int nnz, cusparseMatDescr descrA, Pointer csrSortedValA_valM, Pointer csrSortedRowPtrA, Pointer csrSortedColIndA, csric02Info info, int policy, Pointer pBuffer) {
        return JCusparse.checkResult(JCusparse.cusparseDcsric02Native(handle, m, nnz, descrA, csrSortedValA_valM, csrSortedRowPtrA, csrSortedColIndA, info, policy, pBuffer));
    }

    private static native int cusparseDcsric02Native(cusparseHandle var0, int var1, int var2, cusparseMatDescr var3, Pointer var4, Pointer var5, Pointer var6, csric02Info var7, int var8, Pointer var9);

    public static int cusparseCcsric02(cusparseHandle handle, int m, int nnz, cusparseMatDescr descrA, Pointer csrSortedValA_valM, Pointer csrSortedRowPtrA, Pointer csrSortedColIndA, csric02Info info, int policy, Pointer pBuffer) {
        return JCusparse.checkResult(JCusparse.cusparseCcsric02Native(handle, m, nnz, descrA, csrSortedValA_valM, csrSortedRowPtrA, csrSortedColIndA, info, policy, pBuffer));
    }

    private static native int cusparseCcsric02Native(cusparseHandle var0, int var1, int var2, cusparseMatDescr var3, Pointer var4, Pointer var5, Pointer var6, csric02Info var7, int var8, Pointer var9);

    public static int cusparseZcsric02(cusparseHandle handle, int m, int nnz, cusparseMatDescr descrA, Pointer csrSortedValA_valM, Pointer csrSortedRowPtrA, Pointer csrSortedColIndA, csric02Info info, int policy, Pointer pBuffer) {
        return JCusparse.checkResult(JCusparse.cusparseZcsric02Native(handle, m, nnz, descrA, csrSortedValA_valM, csrSortedRowPtrA, csrSortedColIndA, info, policy, pBuffer));
    }

    private static native int cusparseZcsric02Native(cusparseHandle var0, int var1, int var2, cusparseMatDescr var3, Pointer var4, Pointer var5, Pointer var6, csric02Info var7, int var8, Pointer var9);

    public static int cusparseXbsric02_zeroPivot(cusparseHandle handle, bsric02Info info, Pointer position) {
        return JCusparse.checkResult(JCusparse.cusparseXbsric02_zeroPivotNative(handle, info, position));
    }

    private static native int cusparseXbsric02_zeroPivotNative(cusparseHandle var0, bsric02Info var1, Pointer var2);

    public static int cusparseSbsric02_bufferSize(cusparseHandle handle, int dirA, int mb, int nnzb, cusparseMatDescr descrA, Pointer bsrSortedVal, Pointer bsrSortedRowPtr, Pointer bsrSortedColInd, int blockDim, bsric02Info info, int[] pBufferSizeInBytes) {
        return JCusparse.checkResult(JCusparse.cusparseSbsric02_bufferSizeNative(handle, dirA, mb, nnzb, descrA, bsrSortedVal, bsrSortedRowPtr, bsrSortedColInd, blockDim, info, pBufferSizeInBytes));
    }

    private static native int cusparseSbsric02_bufferSizeNative(cusparseHandle var0, int var1, int var2, int var3, cusparseMatDescr var4, Pointer var5, Pointer var6, Pointer var7, int var8, bsric02Info var9, int[] var10);

    public static int cusparseDbsric02_bufferSize(cusparseHandle handle, int dirA, int mb, int nnzb, cusparseMatDescr descrA, Pointer bsrSortedVal, Pointer bsrSortedRowPtr, Pointer bsrSortedColInd, int blockDim, bsric02Info info, int[] pBufferSizeInBytes) {
        return JCusparse.checkResult(JCusparse.cusparseDbsric02_bufferSizeNative(handle, dirA, mb, nnzb, descrA, bsrSortedVal, bsrSortedRowPtr, bsrSortedColInd, blockDim, info, pBufferSizeInBytes));
    }

    private static native int cusparseDbsric02_bufferSizeNative(cusparseHandle var0, int var1, int var2, int var3, cusparseMatDescr var4, Pointer var5, Pointer var6, Pointer var7, int var8, bsric02Info var9, int[] var10);

    public static int cusparseCbsric02_bufferSize(cusparseHandle handle, int dirA, int mb, int nnzb, cusparseMatDescr descrA, Pointer bsrSortedVal, Pointer bsrSortedRowPtr, Pointer bsrSortedColInd, int blockDim, bsric02Info info, int[] pBufferSizeInBytes) {
        return JCusparse.checkResult(JCusparse.cusparseCbsric02_bufferSizeNative(handle, dirA, mb, nnzb, descrA, bsrSortedVal, bsrSortedRowPtr, bsrSortedColInd, blockDim, info, pBufferSizeInBytes));
    }

    private static native int cusparseCbsric02_bufferSizeNative(cusparseHandle var0, int var1, int var2, int var3, cusparseMatDescr var4, Pointer var5, Pointer var6, Pointer var7, int var8, bsric02Info var9, int[] var10);

    public static int cusparseZbsric02_bufferSize(cusparseHandle handle, int dirA, int mb, int nnzb, cusparseMatDescr descrA, Pointer bsrSortedVal, Pointer bsrSortedRowPtr, Pointer bsrSortedColInd, int blockDim, bsric02Info info, int[] pBufferSizeInBytes) {
        return JCusparse.checkResult(JCusparse.cusparseZbsric02_bufferSizeNative(handle, dirA, mb, nnzb, descrA, bsrSortedVal, bsrSortedRowPtr, bsrSortedColInd, blockDim, info, pBufferSizeInBytes));
    }

    private static native int cusparseZbsric02_bufferSizeNative(cusparseHandle var0, int var1, int var2, int var3, cusparseMatDescr var4, Pointer var5, Pointer var6, Pointer var7, int var8, bsric02Info var9, int[] var10);

    public static int cusparseSbsric02_bufferSizeExt(cusparseHandle handle, int dirA, int mb, int nnzb, cusparseMatDescr descrA, Pointer bsrSortedVal, Pointer bsrSortedRowPtr, Pointer bsrSortedColInd, int blockSize, bsric02Info info, int[] pBufferSize) {
        return JCusparse.checkResult(JCusparse.cusparseSbsric02_bufferSizeExtNative(handle, dirA, mb, nnzb, descrA, bsrSortedVal, bsrSortedRowPtr, bsrSortedColInd, blockSize, info, pBufferSize));
    }

    private static native int cusparseSbsric02_bufferSizeExtNative(cusparseHandle var0, int var1, int var2, int var3, cusparseMatDescr var4, Pointer var5, Pointer var6, Pointer var7, int var8, bsric02Info var9, int[] var10);

    public static int cusparseDbsric02_bufferSizeExt(cusparseHandle handle, int dirA, int mb, int nnzb, cusparseMatDescr descrA, Pointer bsrSortedVal, Pointer bsrSortedRowPtr, Pointer bsrSortedColInd, int blockSize, bsric02Info info, int[] pBufferSize) {
        return JCusparse.checkResult(JCusparse.cusparseDbsric02_bufferSizeExtNative(handle, dirA, mb, nnzb, descrA, bsrSortedVal, bsrSortedRowPtr, bsrSortedColInd, blockSize, info, pBufferSize));
    }

    private static native int cusparseDbsric02_bufferSizeExtNative(cusparseHandle var0, int var1, int var2, int var3, cusparseMatDescr var4, Pointer var5, Pointer var6, Pointer var7, int var8, bsric02Info var9, int[] var10);

    public static int cusparseCbsric02_bufferSizeExt(cusparseHandle handle, int dirA, int mb, int nnzb, cusparseMatDescr descrA, Pointer bsrSortedVal, Pointer bsrSortedRowPtr, Pointer bsrSortedColInd, int blockSize, bsric02Info info, int[] pBufferSize) {
        return JCusparse.checkResult(JCusparse.cusparseCbsric02_bufferSizeExtNative(handle, dirA, mb, nnzb, descrA, bsrSortedVal, bsrSortedRowPtr, bsrSortedColInd, blockSize, info, pBufferSize));
    }

    private static native int cusparseCbsric02_bufferSizeExtNative(cusparseHandle var0, int var1, int var2, int var3, cusparseMatDescr var4, Pointer var5, Pointer var6, Pointer var7, int var8, bsric02Info var9, int[] var10);

    public static int cusparseZbsric02_bufferSizeExt(cusparseHandle handle, int dirA, int mb, int nnzb, cusparseMatDescr descrA, Pointer bsrSortedVal, Pointer bsrSortedRowPtr, Pointer bsrSortedColInd, int blockSize, bsric02Info info, int[] pBufferSize) {
        return JCusparse.checkResult(JCusparse.cusparseZbsric02_bufferSizeExtNative(handle, dirA, mb, nnzb, descrA, bsrSortedVal, bsrSortedRowPtr, bsrSortedColInd, blockSize, info, pBufferSize));
    }

    private static native int cusparseZbsric02_bufferSizeExtNative(cusparseHandle var0, int var1, int var2, int var3, cusparseMatDescr var4, Pointer var5, Pointer var6, Pointer var7, int var8, bsric02Info var9, int[] var10);

    public static int cusparseSbsric02_analysis(cusparseHandle handle, int dirA, int mb, int nnzb, cusparseMatDescr descrA, Pointer bsrSortedVal, Pointer bsrSortedRowPtr, Pointer bsrSortedColInd, int blockDim, bsric02Info info, int policy, Pointer pInputBuffer) {
        return JCusparse.checkResult(JCusparse.cusparseSbsric02_analysisNative(handle, dirA, mb, nnzb, descrA, bsrSortedVal, bsrSortedRowPtr, bsrSortedColInd, blockDim, info, policy, pInputBuffer));
    }

    private static native int cusparseSbsric02_analysisNative(cusparseHandle var0, int var1, int var2, int var3, cusparseMatDescr var4, Pointer var5, Pointer var6, Pointer var7, int var8, bsric02Info var9, int var10, Pointer var11);

    public static int cusparseDbsric02_analysis(cusparseHandle handle, int dirA, int mb, int nnzb, cusparseMatDescr descrA, Pointer bsrSortedVal, Pointer bsrSortedRowPtr, Pointer bsrSortedColInd, int blockDim, bsric02Info info, int policy, Pointer pInputBuffer) {
        return JCusparse.checkResult(JCusparse.cusparseDbsric02_analysisNative(handle, dirA, mb, nnzb, descrA, bsrSortedVal, bsrSortedRowPtr, bsrSortedColInd, blockDim, info, policy, pInputBuffer));
    }

    private static native int cusparseDbsric02_analysisNative(cusparseHandle var0, int var1, int var2, int var3, cusparseMatDescr var4, Pointer var5, Pointer var6, Pointer var7, int var8, bsric02Info var9, int var10, Pointer var11);

    public static int cusparseCbsric02_analysis(cusparseHandle handle, int dirA, int mb, int nnzb, cusparseMatDescr descrA, Pointer bsrSortedVal, Pointer bsrSortedRowPtr, Pointer bsrSortedColInd, int blockDim, bsric02Info info, int policy, Pointer pInputBuffer) {
        return JCusparse.checkResult(JCusparse.cusparseCbsric02_analysisNative(handle, dirA, mb, nnzb, descrA, bsrSortedVal, bsrSortedRowPtr, bsrSortedColInd, blockDim, info, policy, pInputBuffer));
    }

    private static native int cusparseCbsric02_analysisNative(cusparseHandle var0, int var1, int var2, int var3, cusparseMatDescr var4, Pointer var5, Pointer var6, Pointer var7, int var8, bsric02Info var9, int var10, Pointer var11);

    public static int cusparseZbsric02_analysis(cusparseHandle handle, int dirA, int mb, int nnzb, cusparseMatDescr descrA, Pointer bsrSortedVal, Pointer bsrSortedRowPtr, Pointer bsrSortedColInd, int blockDim, bsric02Info info, int policy, Pointer pInputBuffer) {
        return JCusparse.checkResult(JCusparse.cusparseZbsric02_analysisNative(handle, dirA, mb, nnzb, descrA, bsrSortedVal, bsrSortedRowPtr, bsrSortedColInd, blockDim, info, policy, pInputBuffer));
    }

    private static native int cusparseZbsric02_analysisNative(cusparseHandle var0, int var1, int var2, int var3, cusparseMatDescr var4, Pointer var5, Pointer var6, Pointer var7, int var8, bsric02Info var9, int var10, Pointer var11);

    public static int cusparseSbsric02(cusparseHandle handle, int dirA, int mb, int nnzb, cusparseMatDescr descrA, Pointer bsrSortedVal, Pointer bsrSortedRowPtr, Pointer bsrSortedColInd, int blockDim, bsric02Info info, int policy, Pointer pBuffer) {
        return JCusparse.checkResult(JCusparse.cusparseSbsric02Native(handle, dirA, mb, nnzb, descrA, bsrSortedVal, bsrSortedRowPtr, bsrSortedColInd, blockDim, info, policy, pBuffer));
    }

    private static native int cusparseSbsric02Native(cusparseHandle var0, int var1, int var2, int var3, cusparseMatDescr var4, Pointer var5, Pointer var6, Pointer var7, int var8, bsric02Info var9, int var10, Pointer var11);

    public static int cusparseDbsric02(cusparseHandle handle, int dirA, int mb, int nnzb, cusparseMatDescr descrA, Pointer bsrSortedVal, Pointer bsrSortedRowPtr, Pointer bsrSortedColInd, int blockDim, bsric02Info info, int policy, Pointer pBuffer) {
        return JCusparse.checkResult(JCusparse.cusparseDbsric02Native(handle, dirA, mb, nnzb, descrA, bsrSortedVal, bsrSortedRowPtr, bsrSortedColInd, blockDim, info, policy, pBuffer));
    }

    private static native int cusparseDbsric02Native(cusparseHandle var0, int var1, int var2, int var3, cusparseMatDescr var4, Pointer var5, Pointer var6, Pointer var7, int var8, bsric02Info var9, int var10, Pointer var11);

    public static int cusparseCbsric02(cusparseHandle handle, int dirA, int mb, int nnzb, cusparseMatDescr descrA, Pointer bsrSortedVal, Pointer bsrSortedRowPtr, Pointer bsrSortedColInd, int blockDim, bsric02Info info, int policy, Pointer pBuffer) {
        return JCusparse.checkResult(JCusparse.cusparseCbsric02Native(handle, dirA, mb, nnzb, descrA, bsrSortedVal, bsrSortedRowPtr, bsrSortedColInd, blockDim, info, policy, pBuffer));
    }

    private static native int cusparseCbsric02Native(cusparseHandle var0, int var1, int var2, int var3, cusparseMatDescr var4, Pointer var5, Pointer var6, Pointer var7, int var8, bsric02Info var9, int var10, Pointer var11);

    public static int cusparseZbsric02(cusparseHandle handle, int dirA, int mb, int nnzb, cusparseMatDescr descrA, Pointer bsrSortedVal, Pointer bsrSortedRowPtr, Pointer bsrSortedColInd, int blockDim, bsric02Info info, int policy, Pointer pBuffer) {
        return JCusparse.checkResult(JCusparse.cusparseZbsric02Native(handle, dirA, mb, nnzb, descrA, bsrSortedVal, bsrSortedRowPtr, bsrSortedColInd, blockDim, info, policy, pBuffer));
    }

    private static native int cusparseZbsric02Native(cusparseHandle var0, int var1, int var2, int var3, cusparseMatDescr var4, Pointer var5, Pointer var6, Pointer var7, int var8, bsric02Info var9, int var10, Pointer var11);

    public static int cusparseSgtsv(cusparseHandle handle, int m, int n, Pointer dl, Pointer d, Pointer du, Pointer B, int ldb) {
        return JCusparse.checkResult(JCusparse.cusparseSgtsvNative(handle, m, n, dl, d, du, B, ldb));
    }

    private static native int cusparseSgtsvNative(cusparseHandle var0, int var1, int var2, Pointer var3, Pointer var4, Pointer var5, Pointer var6, int var7);

    public static int cusparseDgtsv(cusparseHandle handle, int m, int n, Pointer dl, Pointer d, Pointer du, Pointer B, int ldb) {
        return JCusparse.checkResult(JCusparse.cusparseDgtsvNative(handle, m, n, dl, d, du, B, ldb));
    }

    private static native int cusparseDgtsvNative(cusparseHandle var0, int var1, int var2, Pointer var3, Pointer var4, Pointer var5, Pointer var6, int var7);

    public static int cusparseCgtsv(cusparseHandle handle, int m, int n, Pointer dl, Pointer d, Pointer du, Pointer B, int ldb) {
        return JCusparse.checkResult(JCusparse.cusparseCgtsvNative(handle, m, n, dl, d, du, B, ldb));
    }

    private static native int cusparseCgtsvNative(cusparseHandle var0, int var1, int var2, Pointer var3, Pointer var4, Pointer var5, Pointer var6, int var7);

    public static int cusparseZgtsv(cusparseHandle handle, int m, int n, Pointer dl, Pointer d, Pointer du, Pointer B, int ldb) {
        return JCusparse.checkResult(JCusparse.cusparseZgtsvNative(handle, m, n, dl, d, du, B, ldb));
    }

    private static native int cusparseZgtsvNative(cusparseHandle var0, int var1, int var2, Pointer var3, Pointer var4, Pointer var5, Pointer var6, int var7);

    public static int cusparseSgtsv_nopivot(cusparseHandle handle, int m, int n, Pointer dl, Pointer d, Pointer du, Pointer B, int ldb) {
        return JCusparse.checkResult(JCusparse.cusparseSgtsv_nopivotNative(handle, m, n, dl, d, du, B, ldb));
    }

    private static native int cusparseSgtsv_nopivotNative(cusparseHandle var0, int var1, int var2, Pointer var3, Pointer var4, Pointer var5, Pointer var6, int var7);

    public static int cusparseDgtsv_nopivot(cusparseHandle handle, int m, int n, Pointer dl, Pointer d, Pointer du, Pointer B, int ldb) {
        return JCusparse.checkResult(JCusparse.cusparseDgtsv_nopivotNative(handle, m, n, dl, d, du, B, ldb));
    }

    private static native int cusparseDgtsv_nopivotNative(cusparseHandle var0, int var1, int var2, Pointer var3, Pointer var4, Pointer var5, Pointer var6, int var7);

    public static int cusparseCgtsv_nopivot(cusparseHandle handle, int m, int n, Pointer dl, Pointer d, Pointer du, Pointer B, int ldb) {
        return JCusparse.checkResult(JCusparse.cusparseCgtsv_nopivotNative(handle, m, n, dl, d, du, B, ldb));
    }

    private static native int cusparseCgtsv_nopivotNative(cusparseHandle var0, int var1, int var2, Pointer var3, Pointer var4, Pointer var5, Pointer var6, int var7);

    public static int cusparseZgtsv_nopivot(cusparseHandle handle, int m, int n, Pointer dl, Pointer d, Pointer du, Pointer B, int ldb) {
        return JCusparse.checkResult(JCusparse.cusparseZgtsv_nopivotNative(handle, m, n, dl, d, du, B, ldb));
    }

    private static native int cusparseZgtsv_nopivotNative(cusparseHandle var0, int var1, int var2, Pointer var3, Pointer var4, Pointer var5, Pointer var6, int var7);

    public static int cusparseSgtsvStridedBatch(cusparseHandle handle, int m, Pointer dl, Pointer d, Pointer du, Pointer x, int batchCount, int batchStride) {
        return JCusparse.checkResult(JCusparse.cusparseSgtsvStridedBatchNative(handle, m, dl, d, du, x, batchCount, batchStride));
    }

    private static native int cusparseSgtsvStridedBatchNative(cusparseHandle var0, int var1, Pointer var2, Pointer var3, Pointer var4, Pointer var5, int var6, int var7);

    public static int cusparseDgtsvStridedBatch(cusparseHandle handle, int m, Pointer dl, Pointer d, Pointer du, Pointer x, int batchCount, int batchStride) {
        return JCusparse.checkResult(JCusparse.cusparseDgtsvStridedBatchNative(handle, m, dl, d, du, x, batchCount, batchStride));
    }

    private static native int cusparseDgtsvStridedBatchNative(cusparseHandle var0, int var1, Pointer var2, Pointer var3, Pointer var4, Pointer var5, int var6, int var7);

    public static int cusparseCgtsvStridedBatch(cusparseHandle handle, int m, Pointer dl, Pointer d, Pointer du, Pointer x, int batchCount, int batchStride) {
        return JCusparse.checkResult(JCusparse.cusparseCgtsvStridedBatchNative(handle, m, dl, d, du, x, batchCount, batchStride));
    }

    private static native int cusparseCgtsvStridedBatchNative(cusparseHandle var0, int var1, Pointer var2, Pointer var3, Pointer var4, Pointer var5, int var6, int var7);

    public static int cusparseZgtsvStridedBatch(cusparseHandle handle, int m, Pointer dl, Pointer d, Pointer du, Pointer x, int batchCount, int batchStride) {
        return JCusparse.checkResult(JCusparse.cusparseZgtsvStridedBatchNative(handle, m, dl, d, du, x, batchCount, batchStride));
    }

    private static native int cusparseZgtsvStridedBatchNative(cusparseHandle var0, int var1, Pointer var2, Pointer var3, Pointer var4, Pointer var5, int var6, int var7);

    public static int cusparseXcsrgemmNnz(cusparseHandle handle, int transA, int transB, int m, int n, int k, cusparseMatDescr descrA, int nnzA, Pointer csrSortedRowPtrA, Pointer csrSortedColIndA, cusparseMatDescr descrB, int nnzB, Pointer csrSortedRowPtrB, Pointer csrSortedColIndB, cusparseMatDescr descrC, Pointer csrSortedRowPtrC, Pointer nnzTotalDevHostPtr) {
        return JCusparse.checkResult(JCusparse.cusparseXcsrgemmNnzNative(handle, transA, transB, m, n, k, descrA, nnzA, csrSortedRowPtrA, csrSortedColIndA, descrB, nnzB, csrSortedRowPtrB, csrSortedColIndB, descrC, csrSortedRowPtrC, nnzTotalDevHostPtr));
    }

    private static native int cusparseXcsrgemmNnzNative(cusparseHandle var0, int var1, int var2, int var3, int var4, int var5, cusparseMatDescr var6, int var7, Pointer var8, Pointer var9, cusparseMatDescr var10, int var11, Pointer var12, Pointer var13, cusparseMatDescr var14, Pointer var15, Pointer var16);

    public static int cusparseScsrgemm(cusparseHandle handle, int transA, int transB, int m, int n, int k, cusparseMatDescr descrA, int nnzA, Pointer csrSortedValA, Pointer csrSortedRowPtrA, Pointer csrSortedColIndA, cusparseMatDescr descrB, int nnzB, Pointer csrSortedValB, Pointer csrSortedRowPtrB, Pointer csrSortedColIndB, cusparseMatDescr descrC, Pointer csrSortedValC, Pointer csrSortedRowPtrC, Pointer csrSortedColIndC) {
        return JCusparse.checkResult(JCusparse.cusparseScsrgemmNative(handle, transA, transB, m, n, k, descrA, nnzA, csrSortedValA, csrSortedRowPtrA, csrSortedColIndA, descrB, nnzB, csrSortedValB, csrSortedRowPtrB, csrSortedColIndB, descrC, csrSortedValC, csrSortedRowPtrC, csrSortedColIndC));
    }

    private static native int cusparseScsrgemmNative(cusparseHandle var0, int var1, int var2, int var3, int var4, int var5, cusparseMatDescr var6, int var7, Pointer var8, Pointer var9, Pointer var10, cusparseMatDescr var11, int var12, Pointer var13, Pointer var14, Pointer var15, cusparseMatDescr var16, Pointer var17, Pointer var18, Pointer var19);

    public static int cusparseDcsrgemm(cusparseHandle handle, int transA, int transB, int m, int n, int k, cusparseMatDescr descrA, int nnzA, Pointer csrSortedValA, Pointer csrSortedRowPtrA, Pointer csrSortedColIndA, cusparseMatDescr descrB, int nnzB, Pointer csrSortedValB, Pointer csrSortedRowPtrB, Pointer csrSortedColIndB, cusparseMatDescr descrC, Pointer csrSortedValC, Pointer csrSortedRowPtrC, Pointer csrSortedColIndC) {
        return JCusparse.checkResult(JCusparse.cusparseDcsrgemmNative(handle, transA, transB, m, n, k, descrA, nnzA, csrSortedValA, csrSortedRowPtrA, csrSortedColIndA, descrB, nnzB, csrSortedValB, csrSortedRowPtrB, csrSortedColIndB, descrC, csrSortedValC, csrSortedRowPtrC, csrSortedColIndC));
    }

    private static native int cusparseDcsrgemmNative(cusparseHandle var0, int var1, int var2, int var3, int var4, int var5, cusparseMatDescr var6, int var7, Pointer var8, Pointer var9, Pointer var10, cusparseMatDescr var11, int var12, Pointer var13, Pointer var14, Pointer var15, cusparseMatDescr var16, Pointer var17, Pointer var18, Pointer var19);

    public static int cusparseCcsrgemm(cusparseHandle handle, int transA, int transB, int m, int n, int k, cusparseMatDescr descrA, int nnzA, Pointer csrSortedValA, Pointer csrSortedRowPtrA, Pointer csrSortedColIndA, cusparseMatDescr descrB, int nnzB, Pointer csrSortedValB, Pointer csrSortedRowPtrB, Pointer csrSortedColIndB, cusparseMatDescr descrC, Pointer csrSortedValC, Pointer csrSortedRowPtrC, Pointer csrSortedColIndC) {
        return JCusparse.checkResult(JCusparse.cusparseCcsrgemmNative(handle, transA, transB, m, n, k, descrA, nnzA, csrSortedValA, csrSortedRowPtrA, csrSortedColIndA, descrB, nnzB, csrSortedValB, csrSortedRowPtrB, csrSortedColIndB, descrC, csrSortedValC, csrSortedRowPtrC, csrSortedColIndC));
    }

    private static native int cusparseCcsrgemmNative(cusparseHandle var0, int var1, int var2, int var3, int var4, int var5, cusparseMatDescr var6, int var7, Pointer var8, Pointer var9, Pointer var10, cusparseMatDescr var11, int var12, Pointer var13, Pointer var14, Pointer var15, cusparseMatDescr var16, Pointer var17, Pointer var18, Pointer var19);

    public static int cusparseZcsrgemm(cusparseHandle handle, int transA, int transB, int m, int n, int k, cusparseMatDescr descrA, int nnzA, Pointer csrSortedValA, Pointer csrSortedRowPtrA, Pointer csrSortedColIndA, cusparseMatDescr descrB, int nnzB, Pointer csrSortedValB, Pointer csrSortedRowPtrB, Pointer csrSortedColIndB, cusparseMatDescr descrC, Pointer csrSortedValC, Pointer csrSortedRowPtrC, Pointer csrSortedColIndC) {
        return JCusparse.checkResult(JCusparse.cusparseZcsrgemmNative(handle, transA, transB, m, n, k, descrA, nnzA, csrSortedValA, csrSortedRowPtrA, csrSortedColIndA, descrB, nnzB, csrSortedValB, csrSortedRowPtrB, csrSortedColIndB, descrC, csrSortedValC, csrSortedRowPtrC, csrSortedColIndC));
    }

    private static native int cusparseZcsrgemmNative(cusparseHandle var0, int var1, int var2, int var3, int var4, int var5, cusparseMatDescr var6, int var7, Pointer var8, Pointer var9, Pointer var10, cusparseMatDescr var11, int var12, Pointer var13, Pointer var14, Pointer var15, cusparseMatDescr var16, Pointer var17, Pointer var18, Pointer var19);

    public static int cusparseCreateCsrgemm2Info(csrgemm2Info info) {
        return JCusparse.checkResult(JCusparse.cusparseCreateCsrgemm2InfoNative(info));
    }

    private static native int cusparseCreateCsrgemm2InfoNative(csrgemm2Info var0);

    public static int cusparseDestroyCsrgemm2Info(csrgemm2Info info) {
        return JCusparse.checkResult(JCusparse.cusparseDestroyCsrgemm2InfoNative(info));
    }

    private static native int cusparseDestroyCsrgemm2InfoNative(csrgemm2Info var0);

    public static int cusparseScsrgemm2_bufferSizeExt(cusparseHandle handle, int m, int n, int k, Pointer alpha, cusparseMatDescr descrA, int nnzA, Pointer csrSortedRowPtrA, Pointer csrSortedColIndA, cusparseMatDescr descrB, int nnzB, Pointer csrSortedRowPtrB, Pointer csrSortedColIndB, Pointer beta, cusparseMatDescr descrD, int nnzD, Pointer csrSortedRowPtrD, Pointer csrSortedColIndD, csrgemm2Info info, int[] pBufferSizeInBytes) {
        return JCusparse.checkResult(JCusparse.cusparseScsrgemm2_bufferSizeExtNative(handle, m, n, k, alpha, descrA, nnzA, csrSortedRowPtrA, csrSortedColIndA, descrB, nnzB, csrSortedRowPtrB, csrSortedColIndB, beta, descrD, nnzD, csrSortedRowPtrD, csrSortedColIndD, info, pBufferSizeInBytes));
    }

    private static native int cusparseScsrgemm2_bufferSizeExtNative(cusparseHandle var0, int var1, int var2, int var3, Pointer var4, cusparseMatDescr var5, int var6, Pointer var7, Pointer var8, cusparseMatDescr var9, int var10, Pointer var11, Pointer var12, Pointer var13, cusparseMatDescr var14, int var15, Pointer var16, Pointer var17, csrgemm2Info var18, int[] var19);

    public static int cusparseDcsrgemm2_bufferSizeExt(cusparseHandle handle, int m, int n, int k, Pointer alpha, cusparseMatDescr descrA, int nnzA, Pointer csrSortedRowPtrA, Pointer csrSortedColIndA, cusparseMatDescr descrB, int nnzB, Pointer csrSortedRowPtrB, Pointer csrSortedColIndB, Pointer beta, cusparseMatDescr descrD, int nnzD, Pointer csrSortedRowPtrD, Pointer csrSortedColIndD, csrgemm2Info info, int[] pBufferSizeInBytes) {
        return JCusparse.checkResult(JCusparse.cusparseDcsrgemm2_bufferSizeExtNative(handle, m, n, k, alpha, descrA, nnzA, csrSortedRowPtrA, csrSortedColIndA, descrB, nnzB, csrSortedRowPtrB, csrSortedColIndB, beta, descrD, nnzD, csrSortedRowPtrD, csrSortedColIndD, info, pBufferSizeInBytes));
    }

    private static native int cusparseDcsrgemm2_bufferSizeExtNative(cusparseHandle var0, int var1, int var2, int var3, Pointer var4, cusparseMatDescr var5, int var6, Pointer var7, Pointer var8, cusparseMatDescr var9, int var10, Pointer var11, Pointer var12, Pointer var13, cusparseMatDescr var14, int var15, Pointer var16, Pointer var17, csrgemm2Info var18, int[] var19);

    public static int cusparseCcsrgemm2_bufferSizeExt(cusparseHandle handle, int m, int n, int k, Pointer alpha, cusparseMatDescr descrA, int nnzA, Pointer csrSortedRowPtrA, Pointer csrSortedColIndA, cusparseMatDescr descrB, int nnzB, Pointer csrSortedRowPtrB, Pointer csrSortedColIndB, Pointer beta, cusparseMatDescr descrD, int nnzD, Pointer csrSortedRowPtrD, Pointer csrSortedColIndD, csrgemm2Info info, int[] pBufferSizeInBytes) {
        return JCusparse.checkResult(JCusparse.cusparseCcsrgemm2_bufferSizeExtNative(handle, m, n, k, alpha, descrA, nnzA, csrSortedRowPtrA, csrSortedColIndA, descrB, nnzB, csrSortedRowPtrB, csrSortedColIndB, beta, descrD, nnzD, csrSortedRowPtrD, csrSortedColIndD, info, pBufferSizeInBytes));
    }

    private static native int cusparseCcsrgemm2_bufferSizeExtNative(cusparseHandle var0, int var1, int var2, int var3, Pointer var4, cusparseMatDescr var5, int var6, Pointer var7, Pointer var8, cusparseMatDescr var9, int var10, Pointer var11, Pointer var12, Pointer var13, cusparseMatDescr var14, int var15, Pointer var16, Pointer var17, csrgemm2Info var18, int[] var19);

    public static int cusparseZcsrgemm2_bufferSizeExt(cusparseHandle handle, int m, int n, int k, Pointer alpha, cusparseMatDescr descrA, int nnzA, Pointer csrSortedRowPtrA, Pointer csrSortedColIndA, cusparseMatDescr descrB, int nnzB, Pointer csrSortedRowPtrB, Pointer csrSortedColIndB, Pointer beta, cusparseMatDescr descrD, int nnzD, Pointer csrSortedRowPtrD, Pointer csrSortedColIndD, csrgemm2Info info, int[] pBufferSizeInBytes) {
        return JCusparse.checkResult(JCusparse.cusparseZcsrgemm2_bufferSizeExtNative(handle, m, n, k, alpha, descrA, nnzA, csrSortedRowPtrA, csrSortedColIndA, descrB, nnzB, csrSortedRowPtrB, csrSortedColIndB, beta, descrD, nnzD, csrSortedRowPtrD, csrSortedColIndD, info, pBufferSizeInBytes));
    }

    private static native int cusparseZcsrgemm2_bufferSizeExtNative(cusparseHandle var0, int var1, int var2, int var3, Pointer var4, cusparseMatDescr var5, int var6, Pointer var7, Pointer var8, cusparseMatDescr var9, int var10, Pointer var11, Pointer var12, Pointer var13, cusparseMatDescr var14, int var15, Pointer var16, Pointer var17, csrgemm2Info var18, int[] var19);

    public static int cusparseXcsrgemm2Nnz(cusparseHandle handle, int m, int n, int k, cusparseMatDescr descrA, int nnzA, Pointer csrSortedRowPtrA, Pointer csrSortedColIndA, cusparseMatDescr descrB, int nnzB, Pointer csrSortedRowPtrB, Pointer csrSortedColIndB, cusparseMatDescr descrD, int nnzD, Pointer csrSortedRowPtrD, Pointer csrSortedColIndD, cusparseMatDescr descrC, Pointer csrSortedRowPtrC, Pointer nnzTotalDevHostPtr, csrgemm2Info info, Pointer pBuffer) {
        return JCusparse.checkResult(JCusparse.cusparseXcsrgemm2NnzNative(handle, m, n, k, descrA, nnzA, csrSortedRowPtrA, csrSortedColIndA, descrB, nnzB, csrSortedRowPtrB, csrSortedColIndB, descrD, nnzD, csrSortedRowPtrD, csrSortedColIndD, descrC, csrSortedRowPtrC, nnzTotalDevHostPtr, info, pBuffer));
    }

    private static native int cusparseXcsrgemm2NnzNative(cusparseHandle var0, int var1, int var2, int var3, cusparseMatDescr var4, int var5, Pointer var6, Pointer var7, cusparseMatDescr var8, int var9, Pointer var10, Pointer var11, cusparseMatDescr var12, int var13, Pointer var14, Pointer var15, cusparseMatDescr var16, Pointer var17, Pointer var18, csrgemm2Info var19, Pointer var20);

    public static int cusparseScsrgemm2(cusparseHandle handle, int m, int n, int k, Pointer alpha, cusparseMatDescr descrA, int nnzA, Pointer csrSortedValA, Pointer csrSortedRowPtrA, Pointer csrSortedColIndA, cusparseMatDescr descrB, int nnzB, Pointer csrSortedValB, Pointer csrSortedRowPtrB, Pointer csrSortedColIndB, Pointer beta, cusparseMatDescr descrD, int nnzD, Pointer csrSortedValD, Pointer csrSortedRowPtrD, Pointer csrSortedColIndD, cusparseMatDescr descrC, Pointer csrSortedValC, Pointer csrSortedRowPtrC, Pointer csrSortedColIndC, csrgemm2Info info, Pointer pBuffer) {
        return JCusparse.checkResult(JCusparse.cusparseScsrgemm2Native(handle, m, n, k, alpha, descrA, nnzA, csrSortedValA, csrSortedRowPtrA, csrSortedColIndA, descrB, nnzB, csrSortedValB, csrSortedRowPtrB, csrSortedColIndB, beta, descrD, nnzD, csrSortedValD, csrSortedRowPtrD, csrSortedColIndD, descrC, csrSortedValC, csrSortedRowPtrC, csrSortedColIndC, info, pBuffer));
    }

    private static native int cusparseScsrgemm2Native(cusparseHandle var0, int var1, int var2, int var3, Pointer var4, cusparseMatDescr var5, int var6, Pointer var7, Pointer var8, Pointer var9, cusparseMatDescr var10, int var11, Pointer var12, Pointer var13, Pointer var14, Pointer var15, cusparseMatDescr var16, int var17, Pointer var18, Pointer var19, Pointer var20, cusparseMatDescr var21, Pointer var22, Pointer var23, Pointer var24, csrgemm2Info var25, Pointer var26);

    public static int cusparseDcsrgemm2(cusparseHandle handle, int m, int n, int k, Pointer alpha, cusparseMatDescr descrA, int nnzA, Pointer csrSortedValA, Pointer csrSortedRowPtrA, Pointer csrSortedColIndA, cusparseMatDescr descrB, int nnzB, Pointer csrSortedValB, Pointer csrSortedRowPtrB, Pointer csrSortedColIndB, Pointer beta, cusparseMatDescr descrD, int nnzD, Pointer csrSortedValD, Pointer csrSortedRowPtrD, Pointer csrSortedColIndD, cusparseMatDescr descrC, Pointer csrSortedValC, Pointer csrSortedRowPtrC, Pointer csrSortedColIndC, csrgemm2Info info, Pointer pBuffer) {
        return JCusparse.checkResult(JCusparse.cusparseDcsrgemm2Native(handle, m, n, k, alpha, descrA, nnzA, csrSortedValA, csrSortedRowPtrA, csrSortedColIndA, descrB, nnzB, csrSortedValB, csrSortedRowPtrB, csrSortedColIndB, beta, descrD, nnzD, csrSortedValD, csrSortedRowPtrD, csrSortedColIndD, descrC, csrSortedValC, csrSortedRowPtrC, csrSortedColIndC, info, pBuffer));
    }

    private static native int cusparseDcsrgemm2Native(cusparseHandle var0, int var1, int var2, int var3, Pointer var4, cusparseMatDescr var5, int var6, Pointer var7, Pointer var8, Pointer var9, cusparseMatDescr var10, int var11, Pointer var12, Pointer var13, Pointer var14, Pointer var15, cusparseMatDescr var16, int var17, Pointer var18, Pointer var19, Pointer var20, cusparseMatDescr var21, Pointer var22, Pointer var23, Pointer var24, csrgemm2Info var25, Pointer var26);

    public static int cusparseCcsrgemm2(cusparseHandle handle, int m, int n, int k, Pointer alpha, cusparseMatDescr descrA, int nnzA, Pointer csrSortedValA, Pointer csrSortedRowPtrA, Pointer csrSortedColIndA, cusparseMatDescr descrB, int nnzB, Pointer csrSortedValB, Pointer csrSortedRowPtrB, Pointer csrSortedColIndB, Pointer beta, cusparseMatDescr descrD, int nnzD, Pointer csrSortedValD, Pointer csrSortedRowPtrD, Pointer csrSortedColIndD, cusparseMatDescr descrC, Pointer csrSortedValC, Pointer csrSortedRowPtrC, Pointer csrSortedColIndC, csrgemm2Info info, Pointer pBuffer) {
        return JCusparse.checkResult(JCusparse.cusparseCcsrgemm2Native(handle, m, n, k, alpha, descrA, nnzA, csrSortedValA, csrSortedRowPtrA, csrSortedColIndA, descrB, nnzB, csrSortedValB, csrSortedRowPtrB, csrSortedColIndB, beta, descrD, nnzD, csrSortedValD, csrSortedRowPtrD, csrSortedColIndD, descrC, csrSortedValC, csrSortedRowPtrC, csrSortedColIndC, info, pBuffer));
    }

    private static native int cusparseCcsrgemm2Native(cusparseHandle var0, int var1, int var2, int var3, Pointer var4, cusparseMatDescr var5, int var6, Pointer var7, Pointer var8, Pointer var9, cusparseMatDescr var10, int var11, Pointer var12, Pointer var13, Pointer var14, Pointer var15, cusparseMatDescr var16, int var17, Pointer var18, Pointer var19, Pointer var20, cusparseMatDescr var21, Pointer var22, Pointer var23, Pointer var24, csrgemm2Info var25, Pointer var26);

    public static int cusparseZcsrgemm2(cusparseHandle handle, int m, int n, int k, Pointer alpha, cusparseMatDescr descrA, int nnzA, Pointer csrSortedValA, Pointer csrSortedRowPtrA, Pointer csrSortedColIndA, cusparseMatDescr descrB, int nnzB, Pointer csrSortedValB, Pointer csrSortedRowPtrB, Pointer csrSortedColIndB, Pointer beta, cusparseMatDescr descrD, int nnzD, Pointer csrSortedValD, Pointer csrSortedRowPtrD, Pointer csrSortedColIndD, cusparseMatDescr descrC, Pointer csrSortedValC, Pointer csrSortedRowPtrC, Pointer csrSortedColIndC, csrgemm2Info info, Pointer pBuffer) {
        return JCusparse.checkResult(JCusparse.cusparseZcsrgemm2Native(handle, m, n, k, alpha, descrA, nnzA, csrSortedValA, csrSortedRowPtrA, csrSortedColIndA, descrB, nnzB, csrSortedValB, csrSortedRowPtrB, csrSortedColIndB, beta, descrD, nnzD, csrSortedValD, csrSortedRowPtrD, csrSortedColIndD, descrC, csrSortedValC, csrSortedRowPtrC, csrSortedColIndC, info, pBuffer));
    }

    private static native int cusparseZcsrgemm2Native(cusparseHandle var0, int var1, int var2, int var3, Pointer var4, cusparseMatDescr var5, int var6, Pointer var7, Pointer var8, Pointer var9, cusparseMatDescr var10, int var11, Pointer var12, Pointer var13, Pointer var14, Pointer var15, cusparseMatDescr var16, int var17, Pointer var18, Pointer var19, Pointer var20, cusparseMatDescr var21, Pointer var22, Pointer var23, Pointer var24, csrgemm2Info var25, Pointer var26);

    public static int cusparseXcsrgeamNnz(cusparseHandle handle, int m, int n, cusparseMatDescr descrA, int nnzA, Pointer csrSortedRowPtrA, Pointer csrSortedColIndA, cusparseMatDescr descrB, int nnzB, Pointer csrSortedRowPtrB, Pointer csrSortedColIndB, cusparseMatDescr descrC, Pointer csrSortedRowPtrC, Pointer nnzTotalDevHostPtr) {
        return JCusparse.checkResult(JCusparse.cusparseXcsrgeamNnzNative(handle, m, n, descrA, nnzA, csrSortedRowPtrA, csrSortedColIndA, descrB, nnzB, csrSortedRowPtrB, csrSortedColIndB, descrC, csrSortedRowPtrC, nnzTotalDevHostPtr));
    }

    private static native int cusparseXcsrgeamNnzNative(cusparseHandle var0, int var1, int var2, cusparseMatDescr var3, int var4, Pointer var5, Pointer var6, cusparseMatDescr var7, int var8, Pointer var9, Pointer var10, cusparseMatDescr var11, Pointer var12, Pointer var13);

    public static int cusparseScsrgeam(cusparseHandle handle, int m, int n, Pointer alpha, cusparseMatDescr descrA, int nnzA, Pointer csrSortedValA, Pointer csrSortedRowPtrA, Pointer csrSortedColIndA, Pointer beta, cusparseMatDescr descrB, int nnzB, Pointer csrSortedValB, Pointer csrSortedRowPtrB, Pointer csrSortedColIndB, cusparseMatDescr descrC, Pointer csrSortedValC, Pointer csrSortedRowPtrC, Pointer csrSortedColIndC) {
        return JCusparse.checkResult(JCusparse.cusparseScsrgeamNative(handle, m, n, alpha, descrA, nnzA, csrSortedValA, csrSortedRowPtrA, csrSortedColIndA, beta, descrB, nnzB, csrSortedValB, csrSortedRowPtrB, csrSortedColIndB, descrC, csrSortedValC, csrSortedRowPtrC, csrSortedColIndC));
    }

    private static native int cusparseScsrgeamNative(cusparseHandle var0, int var1, int var2, Pointer var3, cusparseMatDescr var4, int var5, Pointer var6, Pointer var7, Pointer var8, Pointer var9, cusparseMatDescr var10, int var11, Pointer var12, Pointer var13, Pointer var14, cusparseMatDescr var15, Pointer var16, Pointer var17, Pointer var18);

    public static int cusparseDcsrgeam(cusparseHandle handle, int m, int n, Pointer alpha, cusparseMatDescr descrA, int nnzA, Pointer csrSortedValA, Pointer csrSortedRowPtrA, Pointer csrSortedColIndA, Pointer beta, cusparseMatDescr descrB, int nnzB, Pointer csrSortedValB, Pointer csrSortedRowPtrB, Pointer csrSortedColIndB, cusparseMatDescr descrC, Pointer csrSortedValC, Pointer csrSortedRowPtrC, Pointer csrSortedColIndC) {
        return JCusparse.checkResult(JCusparse.cusparseDcsrgeamNative(handle, m, n, alpha, descrA, nnzA, csrSortedValA, csrSortedRowPtrA, csrSortedColIndA, beta, descrB, nnzB, csrSortedValB, csrSortedRowPtrB, csrSortedColIndB, descrC, csrSortedValC, csrSortedRowPtrC, csrSortedColIndC));
    }

    private static native int cusparseDcsrgeamNative(cusparseHandle var0, int var1, int var2, Pointer var3, cusparseMatDescr var4, int var5, Pointer var6, Pointer var7, Pointer var8, Pointer var9, cusparseMatDescr var10, int var11, Pointer var12, Pointer var13, Pointer var14, cusparseMatDescr var15, Pointer var16, Pointer var17, Pointer var18);

    public static int cusparseCcsrgeam(cusparseHandle handle, int m, int n, Pointer alpha, cusparseMatDescr descrA, int nnzA, Pointer csrSortedValA, Pointer csrSortedRowPtrA, Pointer csrSortedColIndA, Pointer beta, cusparseMatDescr descrB, int nnzB, Pointer csrSortedValB, Pointer csrSortedRowPtrB, Pointer csrSortedColIndB, cusparseMatDescr descrC, Pointer csrSortedValC, Pointer csrSortedRowPtrC, Pointer csrSortedColIndC) {
        return JCusparse.checkResult(JCusparse.cusparseCcsrgeamNative(handle, m, n, alpha, descrA, nnzA, csrSortedValA, csrSortedRowPtrA, csrSortedColIndA, beta, descrB, nnzB, csrSortedValB, csrSortedRowPtrB, csrSortedColIndB, descrC, csrSortedValC, csrSortedRowPtrC, csrSortedColIndC));
    }

    private static native int cusparseCcsrgeamNative(cusparseHandle var0, int var1, int var2, Pointer var3, cusparseMatDescr var4, int var5, Pointer var6, Pointer var7, Pointer var8, Pointer var9, cusparseMatDescr var10, int var11, Pointer var12, Pointer var13, Pointer var14, cusparseMatDescr var15, Pointer var16, Pointer var17, Pointer var18);

    public static int cusparseZcsrgeam(cusparseHandle handle, int m, int n, Pointer alpha, cusparseMatDescr descrA, int nnzA, Pointer csrSortedValA, Pointer csrSortedRowPtrA, Pointer csrSortedColIndA, Pointer beta, cusparseMatDescr descrB, int nnzB, Pointer csrSortedValB, Pointer csrSortedRowPtrB, Pointer csrSortedColIndB, cusparseMatDescr descrC, Pointer csrSortedValC, Pointer csrSortedRowPtrC, Pointer csrSortedColIndC) {
        return JCusparse.checkResult(JCusparse.cusparseZcsrgeamNative(handle, m, n, alpha, descrA, nnzA, csrSortedValA, csrSortedRowPtrA, csrSortedColIndA, beta, descrB, nnzB, csrSortedValB, csrSortedRowPtrB, csrSortedColIndB, descrC, csrSortedValC, csrSortedRowPtrC, csrSortedColIndC));
    }

    private static native int cusparseZcsrgeamNative(cusparseHandle var0, int var1, int var2, Pointer var3, cusparseMatDescr var4, int var5, Pointer var6, Pointer var7, Pointer var8, Pointer var9, cusparseMatDescr var10, int var11, Pointer var12, Pointer var13, Pointer var14, cusparseMatDescr var15, Pointer var16, Pointer var17, Pointer var18);

    public static int cusparseScsrcolor(cusparseHandle handle, int m, int nnz, cusparseMatDescr descrA, Pointer csrSortedValA, Pointer csrSortedRowPtrA, Pointer csrSortedColIndA, Pointer fractionToColor, Pointer ncolors, Pointer coloring, Pointer reordering, cusparseColorInfo info) {
        return JCusparse.checkResult(JCusparse.cusparseScsrcolorNative(handle, m, nnz, descrA, csrSortedValA, csrSortedRowPtrA, csrSortedColIndA, fractionToColor, ncolors, coloring, reordering, info));
    }

    private static native int cusparseScsrcolorNative(cusparseHandle var0, int var1, int var2, cusparseMatDescr var3, Pointer var4, Pointer var5, Pointer var6, Pointer var7, Pointer var8, Pointer var9, Pointer var10, cusparseColorInfo var11);

    public static int cusparseDcsrcolor(cusparseHandle handle, int m, int nnz, cusparseMatDescr descrA, Pointer csrSortedValA, Pointer csrSortedRowPtrA, Pointer csrSortedColIndA, Pointer fractionToColor, Pointer ncolors, Pointer coloring, Pointer reordering, cusparseColorInfo info) {
        return JCusparse.checkResult(JCusparse.cusparseDcsrcolorNative(handle, m, nnz, descrA, csrSortedValA, csrSortedRowPtrA, csrSortedColIndA, fractionToColor, ncolors, coloring, reordering, info));
    }

    private static native int cusparseDcsrcolorNative(cusparseHandle var0, int var1, int var2, cusparseMatDescr var3, Pointer var4, Pointer var5, Pointer var6, Pointer var7, Pointer var8, Pointer var9, Pointer var10, cusparseColorInfo var11);

    public static int cusparseCcsrcolor(cusparseHandle handle, int m, int nnz, cusparseMatDescr descrA, Pointer csrSortedValA, Pointer csrSortedRowPtrA, Pointer csrSortedColIndA, Pointer fractionToColor, Pointer ncolors, Pointer coloring, Pointer reordering, cusparseColorInfo info) {
        return JCusparse.checkResult(JCusparse.cusparseCcsrcolorNative(handle, m, nnz, descrA, csrSortedValA, csrSortedRowPtrA, csrSortedColIndA, fractionToColor, ncolors, coloring, reordering, info));
    }

    private static native int cusparseCcsrcolorNative(cusparseHandle var0, int var1, int var2, cusparseMatDescr var3, Pointer var4, Pointer var5, Pointer var6, Pointer var7, Pointer var8, Pointer var9, Pointer var10, cusparseColorInfo var11);

    public static int cusparseZcsrcolor(cusparseHandle handle, int m, int nnz, cusparseMatDescr descrA, Pointer csrSortedValA, Pointer csrSortedRowPtrA, Pointer csrSortedColIndA, Pointer fractionToColor, Pointer ncolors, Pointer coloring, Pointer reordering, cusparseColorInfo info) {
        return JCusparse.checkResult(JCusparse.cusparseZcsrcolorNative(handle, m, nnz, descrA, csrSortedValA, csrSortedRowPtrA, csrSortedColIndA, fractionToColor, ncolors, coloring, reordering, info));
    }

    private static native int cusparseZcsrcolorNative(cusparseHandle var0, int var1, int var2, cusparseMatDescr var3, Pointer var4, Pointer var5, Pointer var6, Pointer var7, Pointer var8, Pointer var9, Pointer var10, cusparseColorInfo var11);

    public static int cusparseSnnz(cusparseHandle handle, int dirA, int m, int n, cusparseMatDescr descrA, Pointer A, int lda, Pointer nnzPerRowCol, Pointer nnzTotalDevHostPtr) {
        return JCusparse.checkResult(JCusparse.cusparseSnnzNative(handle, dirA, m, n, descrA, A, lda, nnzPerRowCol, nnzTotalDevHostPtr));
    }

    private static native int cusparseSnnzNative(cusparseHandle var0, int var1, int var2, int var3, cusparseMatDescr var4, Pointer var5, int var6, Pointer var7, Pointer var8);

    public static int cusparseDnnz(cusparseHandle handle, int dirA, int m, int n, cusparseMatDescr descrA, Pointer A, int lda, Pointer nnzPerRowCol, Pointer nnzTotalDevHostPtr) {
        return JCusparse.checkResult(JCusparse.cusparseDnnzNative(handle, dirA, m, n, descrA, A, lda, nnzPerRowCol, nnzTotalDevHostPtr));
    }

    private static native int cusparseDnnzNative(cusparseHandle var0, int var1, int var2, int var3, cusparseMatDescr var4, Pointer var5, int var6, Pointer var7, Pointer var8);

    public static int cusparseCnnz(cusparseHandle handle, int dirA, int m, int n, cusparseMatDescr descrA, Pointer A, int lda, Pointer nnzPerRowCol, Pointer nnzTotalDevHostPtr) {
        return JCusparse.checkResult(JCusparse.cusparseCnnzNative(handle, dirA, m, n, descrA, A, lda, nnzPerRowCol, nnzTotalDevHostPtr));
    }

    private static native int cusparseCnnzNative(cusparseHandle var0, int var1, int var2, int var3, cusparseMatDescr var4, Pointer var5, int var6, Pointer var7, Pointer var8);

    public static int cusparseZnnz(cusparseHandle handle, int dirA, int m, int n, cusparseMatDescr descrA, Pointer A, int lda, Pointer nnzPerRowCol, Pointer nnzTotalDevHostPtr) {
        return JCusparse.checkResult(JCusparse.cusparseZnnzNative(handle, dirA, m, n, descrA, A, lda, nnzPerRowCol, nnzTotalDevHostPtr));
    }

    private static native int cusparseZnnzNative(cusparseHandle var0, int var1, int var2, int var3, cusparseMatDescr var4, Pointer var5, int var6, Pointer var7, Pointer var8);

    public static int cusparseSnnz_compress(cusparseHandle handle, int m, cusparseMatDescr descr, Pointer values, Pointer rowPtr, Pointer nnzPerRow, Pointer nnzTotal, float tol) {
        return JCusparse.checkResult(JCusparse.cusparseSnnz_compressNative(handle, m, descr, values, rowPtr, nnzPerRow, nnzTotal, tol));
    }

    private static native int cusparseSnnz_compressNative(cusparseHandle var0, int var1, cusparseMatDescr var2, Pointer var3, Pointer var4, Pointer var5, Pointer var6, float var7);

    public static int cusparseDnnz_compress(cusparseHandle handle, int m, cusparseMatDescr descr, Pointer values, Pointer rowPtr, Pointer nnzPerRow, Pointer nnzTotal, double tol) {
        return JCusparse.checkResult(JCusparse.cusparseDnnz_compressNative(handle, m, descr, values, rowPtr, nnzPerRow, nnzTotal, tol));
    }

    private static native int cusparseDnnz_compressNative(cusparseHandle var0, int var1, cusparseMatDescr var2, Pointer var3, Pointer var4, Pointer var5, Pointer var6, double var7);

    public static int cusparseCnnz_compress(cusparseHandle handle, int m, cusparseMatDescr descr, Pointer values, Pointer rowPtr, Pointer nnzPerRow, Pointer nnzTotal, cuComplex tol) {
        return JCusparse.checkResult(JCusparse.cusparseCnnz_compressNative(handle, m, descr, values, rowPtr, nnzPerRow, nnzTotal, tol));
    }

    private static native int cusparseCnnz_compressNative(cusparseHandle var0, int var1, cusparseMatDescr var2, Pointer var3, Pointer var4, Pointer var5, Pointer var6, cuComplex var7);

    public static int cusparseZnnz_compress(cusparseHandle handle, int m, cusparseMatDescr descr, Pointer values, Pointer rowPtr, Pointer nnzPerRow, Pointer nnzTotal, cuDoubleComplex tol) {
        return JCusparse.checkResult(JCusparse.cusparseZnnz_compressNative(handle, m, descr, values, rowPtr, nnzPerRow, nnzTotal, tol));
    }

    private static native int cusparseZnnz_compressNative(cusparseHandle var0, int var1, cusparseMatDescr var2, Pointer var3, Pointer var4, Pointer var5, Pointer var6, cuDoubleComplex var7);

    public static int cusparseScsr2csr_compress(cusparseHandle handle, int m, int n, cusparseMatDescr descra, Pointer inVal, Pointer inColInd, Pointer inRowPtr, int inNnz, Pointer nnzPerRow, Pointer outVal, Pointer outColInd, Pointer outRowPtr, float tol) {
        return JCusparse.checkResult(JCusparse.cusparseScsr2csr_compressNative(handle, m, n, descra, inVal, inColInd, inRowPtr, inNnz, nnzPerRow, outVal, outColInd, outRowPtr, tol));
    }

    private static native int cusparseScsr2csr_compressNative(cusparseHandle var0, int var1, int var2, cusparseMatDescr var3, Pointer var4, Pointer var5, Pointer var6, int var7, Pointer var8, Pointer var9, Pointer var10, Pointer var11, float var12);

    public static int cusparseDcsr2csr_compress(cusparseHandle handle, int m, int n, cusparseMatDescr descra, Pointer inVal, Pointer inColInd, Pointer inRowPtr, int inNnz, Pointer nnzPerRow, Pointer outVal, Pointer outColInd, Pointer outRowPtr, double tol) {
        return JCusparse.checkResult(JCusparse.cusparseDcsr2csr_compressNative(handle, m, n, descra, inVal, inColInd, inRowPtr, inNnz, nnzPerRow, outVal, outColInd, outRowPtr, tol));
    }

    private static native int cusparseDcsr2csr_compressNative(cusparseHandle var0, int var1, int var2, cusparseMatDescr var3, Pointer var4, Pointer var5, Pointer var6, int var7, Pointer var8, Pointer var9, Pointer var10, Pointer var11, double var12);

    public static int cusparseCcsr2csr_compress(cusparseHandle handle, int m, int n, cusparseMatDescr descra, Pointer inVal, Pointer inColInd, Pointer inRowPtr, int inNnz, Pointer nnzPerRow, Pointer outVal, Pointer outColInd, Pointer outRowPtr, cuComplex tol) {
        return JCusparse.checkResult(JCusparse.cusparseCcsr2csr_compressNative(handle, m, n, descra, inVal, inColInd, inRowPtr, inNnz, nnzPerRow, outVal, outColInd, outRowPtr, tol));
    }

    private static native int cusparseCcsr2csr_compressNative(cusparseHandle var0, int var1, int var2, cusparseMatDescr var3, Pointer var4, Pointer var5, Pointer var6, int var7, Pointer var8, Pointer var9, Pointer var10, Pointer var11, cuComplex var12);

    public static int cusparseZcsr2csr_compress(cusparseHandle handle, int m, int n, cusparseMatDescr descra, Pointer inVal, Pointer inColInd, Pointer inRowPtr, int inNnz, Pointer nnzPerRow, Pointer outVal, Pointer outColInd, Pointer outRowPtr, cuDoubleComplex tol) {
        return JCusparse.checkResult(JCusparse.cusparseZcsr2csr_compressNative(handle, m, n, descra, inVal, inColInd, inRowPtr, inNnz, nnzPerRow, outVal, outColInd, outRowPtr, tol));
    }

    private static native int cusparseZcsr2csr_compressNative(cusparseHandle var0, int var1, int var2, cusparseMatDescr var3, Pointer var4, Pointer var5, Pointer var6, int var7, Pointer var8, Pointer var9, Pointer var10, Pointer var11, cuDoubleComplex var12);

    public static int cusparseSdense2csr(cusparseHandle handle, int m, int n, cusparseMatDescr descrA, Pointer A, int lda, Pointer nnzPerRow, Pointer csrSortedValA, Pointer csrSortedRowPtrA, Pointer csrSortedColIndA) {
        return JCusparse.checkResult(JCusparse.cusparseSdense2csrNative(handle, m, n, descrA, A, lda, nnzPerRow, csrSortedValA, csrSortedRowPtrA, csrSortedColIndA));
    }

    private static native int cusparseSdense2csrNative(cusparseHandle var0, int var1, int var2, cusparseMatDescr var3, Pointer var4, int var5, Pointer var6, Pointer var7, Pointer var8, Pointer var9);

    public static int cusparseDdense2csr(cusparseHandle handle, int m, int n, cusparseMatDescr descrA, Pointer A, int lda, Pointer nnzPerRow, Pointer csrSortedValA, Pointer csrSortedRowPtrA, Pointer csrSortedColIndA) {
        return JCusparse.checkResult(JCusparse.cusparseDdense2csrNative(handle, m, n, descrA, A, lda, nnzPerRow, csrSortedValA, csrSortedRowPtrA, csrSortedColIndA));
    }

    private static native int cusparseDdense2csrNative(cusparseHandle var0, int var1, int var2, cusparseMatDescr var3, Pointer var4, int var5, Pointer var6, Pointer var7, Pointer var8, Pointer var9);

    public static int cusparseCdense2csr(cusparseHandle handle, int m, int n, cusparseMatDescr descrA, Pointer A, int lda, Pointer nnzPerRow, Pointer csrSortedValA, Pointer csrSortedRowPtrA, Pointer csrSortedColIndA) {
        return JCusparse.checkResult(JCusparse.cusparseCdense2csrNative(handle, m, n, descrA, A, lda, nnzPerRow, csrSortedValA, csrSortedRowPtrA, csrSortedColIndA));
    }

    private static native int cusparseCdense2csrNative(cusparseHandle var0, int var1, int var2, cusparseMatDescr var3, Pointer var4, int var5, Pointer var6, Pointer var7, Pointer var8, Pointer var9);

    public static int cusparseZdense2csr(cusparseHandle handle, int m, int n, cusparseMatDescr descrA, Pointer A, int lda, Pointer nnzPerRow, Pointer csrSortedValA, Pointer csrSortedRowPtrA, Pointer csrSortedColIndA) {
        return JCusparse.checkResult(JCusparse.cusparseZdense2csrNative(handle, m, n, descrA, A, lda, nnzPerRow, csrSortedValA, csrSortedRowPtrA, csrSortedColIndA));
    }

    private static native int cusparseZdense2csrNative(cusparseHandle var0, int var1, int var2, cusparseMatDescr var3, Pointer var4, int var5, Pointer var6, Pointer var7, Pointer var8, Pointer var9);

    public static int cusparseScsr2dense(cusparseHandle handle, int m, int n, cusparseMatDescr descrA, Pointer csrSortedValA, Pointer csrSortedRowPtrA, Pointer csrSortedColIndA, Pointer A, int lda) {
        return JCusparse.checkResult(JCusparse.cusparseScsr2denseNative(handle, m, n, descrA, csrSortedValA, csrSortedRowPtrA, csrSortedColIndA, A, lda));
    }

    private static native int cusparseScsr2denseNative(cusparseHandle var0, int var1, int var2, cusparseMatDescr var3, Pointer var4, Pointer var5, Pointer var6, Pointer var7, int var8);

    public static int cusparseDcsr2dense(cusparseHandle handle, int m, int n, cusparseMatDescr descrA, Pointer csrSortedValA, Pointer csrSortedRowPtrA, Pointer csrSortedColIndA, Pointer A, int lda) {
        return JCusparse.checkResult(JCusparse.cusparseDcsr2denseNative(handle, m, n, descrA, csrSortedValA, csrSortedRowPtrA, csrSortedColIndA, A, lda));
    }

    private static native int cusparseDcsr2denseNative(cusparseHandle var0, int var1, int var2, cusparseMatDescr var3, Pointer var4, Pointer var5, Pointer var6, Pointer var7, int var8);

    public static int cusparseCcsr2dense(cusparseHandle handle, int m, int n, cusparseMatDescr descrA, Pointer csrSortedValA, Pointer csrSortedRowPtrA, Pointer csrSortedColIndA, Pointer A, int lda) {
        return JCusparse.checkResult(JCusparse.cusparseCcsr2denseNative(handle, m, n, descrA, csrSortedValA, csrSortedRowPtrA, csrSortedColIndA, A, lda));
    }

    private static native int cusparseCcsr2denseNative(cusparseHandle var0, int var1, int var2, cusparseMatDescr var3, Pointer var4, Pointer var5, Pointer var6, Pointer var7, int var8);

    public static int cusparseZcsr2dense(cusparseHandle handle, int m, int n, cusparseMatDescr descrA, Pointer csrSortedValA, Pointer csrSortedRowPtrA, Pointer csrSortedColIndA, Pointer A, int lda) {
        return JCusparse.checkResult(JCusparse.cusparseZcsr2denseNative(handle, m, n, descrA, csrSortedValA, csrSortedRowPtrA, csrSortedColIndA, A, lda));
    }

    private static native int cusparseZcsr2denseNative(cusparseHandle var0, int var1, int var2, cusparseMatDescr var3, Pointer var4, Pointer var5, Pointer var6, Pointer var7, int var8);

    public static int cusparseSdense2csc(cusparseHandle handle, int m, int n, cusparseMatDescr descrA, Pointer A, int lda, Pointer nnzPerCol, Pointer cscSortedValA, Pointer cscSortedRowIndA, Pointer cscSortedColPtrA) {
        return JCusparse.checkResult(JCusparse.cusparseSdense2cscNative(handle, m, n, descrA, A, lda, nnzPerCol, cscSortedValA, cscSortedRowIndA, cscSortedColPtrA));
    }

    private static native int cusparseSdense2cscNative(cusparseHandle var0, int var1, int var2, cusparseMatDescr var3, Pointer var4, int var5, Pointer var6, Pointer var7, Pointer var8, Pointer var9);

    public static int cusparseDdense2csc(cusparseHandle handle, int m, int n, cusparseMatDescr descrA, Pointer A, int lda, Pointer nnzPerCol, Pointer cscSortedValA, Pointer cscSortedRowIndA, Pointer cscSortedColPtrA) {
        return JCusparse.checkResult(JCusparse.cusparseDdense2cscNative(handle, m, n, descrA, A, lda, nnzPerCol, cscSortedValA, cscSortedRowIndA, cscSortedColPtrA));
    }

    private static native int cusparseDdense2cscNative(cusparseHandle var0, int var1, int var2, cusparseMatDescr var3, Pointer var4, int var5, Pointer var6, Pointer var7, Pointer var8, Pointer var9);

    public static int cusparseCdense2csc(cusparseHandle handle, int m, int n, cusparseMatDescr descrA, Pointer A, int lda, Pointer nnzPerCol, Pointer cscSortedValA, Pointer cscSortedRowIndA, Pointer cscSortedColPtrA) {
        return JCusparse.checkResult(JCusparse.cusparseCdense2cscNative(handle, m, n, descrA, A, lda, nnzPerCol, cscSortedValA, cscSortedRowIndA, cscSortedColPtrA));
    }

    private static native int cusparseCdense2cscNative(cusparseHandle var0, int var1, int var2, cusparseMatDescr var3, Pointer var4, int var5, Pointer var6, Pointer var7, Pointer var8, Pointer var9);

    public static int cusparseZdense2csc(cusparseHandle handle, int m, int n, cusparseMatDescr descrA, Pointer A, int lda, Pointer nnzPerCol, Pointer cscSortedValA, Pointer cscSortedRowIndA, Pointer cscSortedColPtrA) {
        return JCusparse.checkResult(JCusparse.cusparseZdense2cscNative(handle, m, n, descrA, A, lda, nnzPerCol, cscSortedValA, cscSortedRowIndA, cscSortedColPtrA));
    }

    private static native int cusparseZdense2cscNative(cusparseHandle var0, int var1, int var2, cusparseMatDescr var3, Pointer var4, int var5, Pointer var6, Pointer var7, Pointer var8, Pointer var9);

    public static int cusparseScsc2dense(cusparseHandle handle, int m, int n, cusparseMatDescr descrA, Pointer cscSortedValA, Pointer cscSortedRowIndA, Pointer cscSortedColPtrA, Pointer A, int lda) {
        return JCusparse.checkResult(JCusparse.cusparseScsc2denseNative(handle, m, n, descrA, cscSortedValA, cscSortedRowIndA, cscSortedColPtrA, A, lda));
    }

    private static native int cusparseScsc2denseNative(cusparseHandle var0, int var1, int var2, cusparseMatDescr var3, Pointer var4, Pointer var5, Pointer var6, Pointer var7, int var8);

    public static int cusparseDcsc2dense(cusparseHandle handle, int m, int n, cusparseMatDescr descrA, Pointer cscSortedValA, Pointer cscSortedRowIndA, Pointer cscSortedColPtrA, Pointer A, int lda) {
        return JCusparse.checkResult(JCusparse.cusparseDcsc2denseNative(handle, m, n, descrA, cscSortedValA, cscSortedRowIndA, cscSortedColPtrA, A, lda));
    }

    private static native int cusparseDcsc2denseNative(cusparseHandle var0, int var1, int var2, cusparseMatDescr var3, Pointer var4, Pointer var5, Pointer var6, Pointer var7, int var8);

    public static int cusparseCcsc2dense(cusparseHandle handle, int m, int n, cusparseMatDescr descrA, Pointer cscSortedValA, Pointer cscSortedRowIndA, Pointer cscSortedColPtrA, Pointer A, int lda) {
        return JCusparse.checkResult(JCusparse.cusparseCcsc2denseNative(handle, m, n, descrA, cscSortedValA, cscSortedRowIndA, cscSortedColPtrA, A, lda));
    }

    private static native int cusparseCcsc2denseNative(cusparseHandle var0, int var1, int var2, cusparseMatDescr var3, Pointer var4, Pointer var5, Pointer var6, Pointer var7, int var8);

    public static int cusparseZcsc2dense(cusparseHandle handle, int m, int n, cusparseMatDescr descrA, Pointer cscSortedValA, Pointer cscSortedRowIndA, Pointer cscSortedColPtrA, Pointer A, int lda) {
        return JCusparse.checkResult(JCusparse.cusparseZcsc2denseNative(handle, m, n, descrA, cscSortedValA, cscSortedRowIndA, cscSortedColPtrA, A, lda));
    }

    private static native int cusparseZcsc2denseNative(cusparseHandle var0, int var1, int var2, cusparseMatDescr var3, Pointer var4, Pointer var5, Pointer var6, Pointer var7, int var8);

    public static int cusparseXcoo2csr(cusparseHandle handle, Pointer cooRowInd, int nnz, int m, Pointer csrSortedRowPtr, int idxBase) {
        return JCusparse.checkResult(JCusparse.cusparseXcoo2csrNative(handle, cooRowInd, nnz, m, csrSortedRowPtr, idxBase));
    }

    private static native int cusparseXcoo2csrNative(cusparseHandle var0, Pointer var1, int var2, int var3, Pointer var4, int var5);

    public static int cusparseXcsr2coo(cusparseHandle handle, Pointer csrSortedRowPtr, int nnz, int m, Pointer cooRowInd, int idxBase) {
        return JCusparse.checkResult(JCusparse.cusparseXcsr2cooNative(handle, csrSortedRowPtr, nnz, m, cooRowInd, idxBase));
    }

    private static native int cusparseXcsr2cooNative(cusparseHandle var0, Pointer var1, int var2, int var3, Pointer var4, int var5);

    public static int cusparseCsr2cscEx(cusparseHandle handle, int m, int n, int nnz, Pointer csrSortedVal, int csrSortedValtype, Pointer csrSortedRowPtr, Pointer csrSortedColInd, Pointer cscSortedVal, int cscSortedValtype, Pointer cscSortedRowInd, Pointer cscSortedColPtr, int copyValues, int idxBase, int executiontype) {
        return JCusparse.checkResult(JCusparse.cusparseCsr2cscExNative(handle, m, n, nnz, csrSortedVal, csrSortedValtype, csrSortedRowPtr, csrSortedColInd, cscSortedVal, cscSortedValtype, cscSortedRowInd, cscSortedColPtr, copyValues, idxBase, executiontype));
    }

    private static native int cusparseCsr2cscExNative(cusparseHandle var0, int var1, int var2, int var3, Pointer var4, int var5, Pointer var6, Pointer var7, Pointer var8, int var9, Pointer var10, Pointer var11, int var12, int var13, int var14);

    public static int cusparseScsr2csc(cusparseHandle handle, int m, int n, int nnz, Pointer csrSortedVal, Pointer csrSortedRowPtr, Pointer csrSortedColInd, Pointer cscSortedVal, Pointer cscSortedRowInd, Pointer cscSortedColPtr, int copyValues, int idxBase) {
        return JCusparse.checkResult(JCusparse.cusparseScsr2cscNative(handle, m, n, nnz, csrSortedVal, csrSortedRowPtr, csrSortedColInd, cscSortedVal, cscSortedRowInd, cscSortedColPtr, copyValues, idxBase));
    }

    private static native int cusparseScsr2cscNative(cusparseHandle var0, int var1, int var2, int var3, Pointer var4, Pointer var5, Pointer var6, Pointer var7, Pointer var8, Pointer var9, int var10, int var11);

    public static int cusparseDcsr2csc(cusparseHandle handle, int m, int n, int nnz, Pointer csrSortedVal, Pointer csrSortedRowPtr, Pointer csrSortedColInd, Pointer cscSortedVal, Pointer cscSortedRowInd, Pointer cscSortedColPtr, int copyValues, int idxBase) {
        return JCusparse.checkResult(JCusparse.cusparseDcsr2cscNative(handle, m, n, nnz, csrSortedVal, csrSortedRowPtr, csrSortedColInd, cscSortedVal, cscSortedRowInd, cscSortedColPtr, copyValues, idxBase));
    }

    private static native int cusparseDcsr2cscNative(cusparseHandle var0, int var1, int var2, int var3, Pointer var4, Pointer var5, Pointer var6, Pointer var7, Pointer var8, Pointer var9, int var10, int var11);

    public static int cusparseCcsr2csc(cusparseHandle handle, int m, int n, int nnz, Pointer csrSortedVal, Pointer csrSortedRowPtr, Pointer csrSortedColInd, Pointer cscSortedVal, Pointer cscSortedRowInd, Pointer cscSortedColPtr, int copyValues, int idxBase) {
        return JCusparse.checkResult(JCusparse.cusparseCcsr2cscNative(handle, m, n, nnz, csrSortedVal, csrSortedRowPtr, csrSortedColInd, cscSortedVal, cscSortedRowInd, cscSortedColPtr, copyValues, idxBase));
    }

    private static native int cusparseCcsr2cscNative(cusparseHandle var0, int var1, int var2, int var3, Pointer var4, Pointer var5, Pointer var6, Pointer var7, Pointer var8, Pointer var9, int var10, int var11);

    public static int cusparseZcsr2csc(cusparseHandle handle, int m, int n, int nnz, Pointer csrSortedVal, Pointer csrSortedRowPtr, Pointer csrSortedColInd, Pointer cscSortedVal, Pointer cscSortedRowInd, Pointer cscSortedColPtr, int copyValues, int idxBase) {
        return JCusparse.checkResult(JCusparse.cusparseZcsr2cscNative(handle, m, n, nnz, csrSortedVal, csrSortedRowPtr, csrSortedColInd, cscSortedVal, cscSortedRowInd, cscSortedColPtr, copyValues, idxBase));
    }

    private static native int cusparseZcsr2cscNative(cusparseHandle var0, int var1, int var2, int var3, Pointer var4, Pointer var5, Pointer var6, Pointer var7, Pointer var8, Pointer var9, int var10, int var11);

    public static int cusparseSdense2hyb(cusparseHandle handle, int m, int n, cusparseMatDescr descrA, Pointer A, int lda, Pointer nnzPerRow, cusparseHybMat hybA, int userEllWidth, int partitionType) {
        return JCusparse.checkResult(JCusparse.cusparseSdense2hybNative(handle, m, n, descrA, A, lda, nnzPerRow, hybA, userEllWidth, partitionType));
    }

    private static native int cusparseSdense2hybNative(cusparseHandle var0, int var1, int var2, cusparseMatDescr var3, Pointer var4, int var5, Pointer var6, cusparseHybMat var7, int var8, int var9);

    public static int cusparseDdense2hyb(cusparseHandle handle, int m, int n, cusparseMatDescr descrA, Pointer A, int lda, Pointer nnzPerRow, cusparseHybMat hybA, int userEllWidth, int partitionType) {
        return JCusparse.checkResult(JCusparse.cusparseDdense2hybNative(handle, m, n, descrA, A, lda, nnzPerRow, hybA, userEllWidth, partitionType));
    }

    private static native int cusparseDdense2hybNative(cusparseHandle var0, int var1, int var2, cusparseMatDescr var3, Pointer var4, int var5, Pointer var6, cusparseHybMat var7, int var8, int var9);

    public static int cusparseCdense2hyb(cusparseHandle handle, int m, int n, cusparseMatDescr descrA, Pointer A, int lda, Pointer nnzPerRow, cusparseHybMat hybA, int userEllWidth, int partitionType) {
        return JCusparse.checkResult(JCusparse.cusparseCdense2hybNative(handle, m, n, descrA, A, lda, nnzPerRow, hybA, userEllWidth, partitionType));
    }

    private static native int cusparseCdense2hybNative(cusparseHandle var0, int var1, int var2, cusparseMatDescr var3, Pointer var4, int var5, Pointer var6, cusparseHybMat var7, int var8, int var9);

    public static int cusparseZdense2hyb(cusparseHandle handle, int m, int n, cusparseMatDescr descrA, Pointer A, int lda, Pointer nnzPerRow, cusparseHybMat hybA, int userEllWidth, int partitionType) {
        return JCusparse.checkResult(JCusparse.cusparseZdense2hybNative(handle, m, n, descrA, A, lda, nnzPerRow, hybA, userEllWidth, partitionType));
    }

    private static native int cusparseZdense2hybNative(cusparseHandle var0, int var1, int var2, cusparseMatDescr var3, Pointer var4, int var5, Pointer var6, cusparseHybMat var7, int var8, int var9);

    public static int cusparseShyb2dense(cusparseHandle handle, cusparseMatDescr descrA, cusparseHybMat hybA, Pointer A, int lda) {
        return JCusparse.checkResult(JCusparse.cusparseShyb2denseNative(handle, descrA, hybA, A, lda));
    }

    private static native int cusparseShyb2denseNative(cusparseHandle var0, cusparseMatDescr var1, cusparseHybMat var2, Pointer var3, int var4);

    public static int cusparseDhyb2dense(cusparseHandle handle, cusparseMatDescr descrA, cusparseHybMat hybA, Pointer A, int lda) {
        return JCusparse.checkResult(JCusparse.cusparseDhyb2denseNative(handle, descrA, hybA, A, lda));
    }

    private static native int cusparseDhyb2denseNative(cusparseHandle var0, cusparseMatDescr var1, cusparseHybMat var2, Pointer var3, int var4);

    public static int cusparseChyb2dense(cusparseHandle handle, cusparseMatDescr descrA, cusparseHybMat hybA, Pointer A, int lda) {
        return JCusparse.checkResult(JCusparse.cusparseChyb2denseNative(handle, descrA, hybA, A, lda));
    }

    private static native int cusparseChyb2denseNative(cusparseHandle var0, cusparseMatDescr var1, cusparseHybMat var2, Pointer var3, int var4);

    public static int cusparseZhyb2dense(cusparseHandle handle, cusparseMatDescr descrA, cusparseHybMat hybA, Pointer A, int lda) {
        return JCusparse.checkResult(JCusparse.cusparseZhyb2denseNative(handle, descrA, hybA, A, lda));
    }

    private static native int cusparseZhyb2denseNative(cusparseHandle var0, cusparseMatDescr var1, cusparseHybMat var2, Pointer var3, int var4);

    public static int cusparseScsr2hyb(cusparseHandle handle, int m, int n, cusparseMatDescr descrA, Pointer csrSortedValA, Pointer csrSortedRowPtrA, Pointer csrSortedColIndA, cusparseHybMat hybA, int userEllWidth, int partitionType) {
        return JCusparse.checkResult(JCusparse.cusparseScsr2hybNative(handle, m, n, descrA, csrSortedValA, csrSortedRowPtrA, csrSortedColIndA, hybA, userEllWidth, partitionType));
    }

    private static native int cusparseScsr2hybNative(cusparseHandle var0, int var1, int var2, cusparseMatDescr var3, Pointer var4, Pointer var5, Pointer var6, cusparseHybMat var7, int var8, int var9);

    public static int cusparseDcsr2hyb(cusparseHandle handle, int m, int n, cusparseMatDescr descrA, Pointer csrSortedValA, Pointer csrSortedRowPtrA, Pointer csrSortedColIndA, cusparseHybMat hybA, int userEllWidth, int partitionType) {
        return JCusparse.checkResult(JCusparse.cusparseDcsr2hybNative(handle, m, n, descrA, csrSortedValA, csrSortedRowPtrA, csrSortedColIndA, hybA, userEllWidth, partitionType));
    }

    private static native int cusparseDcsr2hybNative(cusparseHandle var0, int var1, int var2, cusparseMatDescr var3, Pointer var4, Pointer var5, Pointer var6, cusparseHybMat var7, int var8, int var9);

    public static int cusparseCcsr2hyb(cusparseHandle handle, int m, int n, cusparseMatDescr descrA, Pointer csrSortedValA, Pointer csrSortedRowPtrA, Pointer csrSortedColIndA, cusparseHybMat hybA, int userEllWidth, int partitionType) {
        return JCusparse.checkResult(JCusparse.cusparseCcsr2hybNative(handle, m, n, descrA, csrSortedValA, csrSortedRowPtrA, csrSortedColIndA, hybA, userEllWidth, partitionType));
    }

    private static native int cusparseCcsr2hybNative(cusparseHandle var0, int var1, int var2, cusparseMatDescr var3, Pointer var4, Pointer var5, Pointer var6, cusparseHybMat var7, int var8, int var9);

    public static int cusparseZcsr2hyb(cusparseHandle handle, int m, int n, cusparseMatDescr descrA, Pointer csrSortedValA, Pointer csrSortedRowPtrA, Pointer csrSortedColIndA, cusparseHybMat hybA, int userEllWidth, int partitionType) {
        return JCusparse.checkResult(JCusparse.cusparseZcsr2hybNative(handle, m, n, descrA, csrSortedValA, csrSortedRowPtrA, csrSortedColIndA, hybA, userEllWidth, partitionType));
    }

    private static native int cusparseZcsr2hybNative(cusparseHandle var0, int var1, int var2, cusparseMatDescr var3, Pointer var4, Pointer var5, Pointer var6, cusparseHybMat var7, int var8, int var9);

    public static int cusparseShyb2csr(cusparseHandle handle, cusparseMatDescr descrA, cusparseHybMat hybA, Pointer csrSortedValA, Pointer csrSortedRowPtrA, Pointer csrSortedColIndA) {
        return JCusparse.checkResult(JCusparse.cusparseShyb2csrNative(handle, descrA, hybA, csrSortedValA, csrSortedRowPtrA, csrSortedColIndA));
    }

    private static native int cusparseShyb2csrNative(cusparseHandle var0, cusparseMatDescr var1, cusparseHybMat var2, Pointer var3, Pointer var4, Pointer var5);

    public static int cusparseDhyb2csr(cusparseHandle handle, cusparseMatDescr descrA, cusparseHybMat hybA, Pointer csrSortedValA, Pointer csrSortedRowPtrA, Pointer csrSortedColIndA) {
        return JCusparse.checkResult(JCusparse.cusparseDhyb2csrNative(handle, descrA, hybA, csrSortedValA, csrSortedRowPtrA, csrSortedColIndA));
    }

    private static native int cusparseDhyb2csrNative(cusparseHandle var0, cusparseMatDescr var1, cusparseHybMat var2, Pointer var3, Pointer var4, Pointer var5);

    public static int cusparseChyb2csr(cusparseHandle handle, cusparseMatDescr descrA, cusparseHybMat hybA, Pointer csrSortedValA, Pointer csrSortedRowPtrA, Pointer csrSortedColIndA) {
        return JCusparse.checkResult(JCusparse.cusparseChyb2csrNative(handle, descrA, hybA, csrSortedValA, csrSortedRowPtrA, csrSortedColIndA));
    }

    private static native int cusparseChyb2csrNative(cusparseHandle var0, cusparseMatDescr var1, cusparseHybMat var2, Pointer var3, Pointer var4, Pointer var5);

    public static int cusparseZhyb2csr(cusparseHandle handle, cusparseMatDescr descrA, cusparseHybMat hybA, Pointer csrSortedValA, Pointer csrSortedRowPtrA, Pointer csrSortedColIndA) {
        return JCusparse.checkResult(JCusparse.cusparseZhyb2csrNative(handle, descrA, hybA, csrSortedValA, csrSortedRowPtrA, csrSortedColIndA));
    }

    private static native int cusparseZhyb2csrNative(cusparseHandle var0, cusparseMatDescr var1, cusparseHybMat var2, Pointer var3, Pointer var4, Pointer var5);

    public static int cusparseScsc2hyb(cusparseHandle handle, int m, int n, cusparseMatDescr descrA, Pointer cscSortedValA, Pointer cscSortedRowIndA, Pointer cscSortedColPtrA, cusparseHybMat hybA, int userEllWidth, int partitionType) {
        return JCusparse.checkResult(JCusparse.cusparseScsc2hybNative(handle, m, n, descrA, cscSortedValA, cscSortedRowIndA, cscSortedColPtrA, hybA, userEllWidth, partitionType));
    }

    private static native int cusparseScsc2hybNative(cusparseHandle var0, int var1, int var2, cusparseMatDescr var3, Pointer var4, Pointer var5, Pointer var6, cusparseHybMat var7, int var8, int var9);

    public static int cusparseDcsc2hyb(cusparseHandle handle, int m, int n, cusparseMatDescr descrA, Pointer cscSortedValA, Pointer cscSortedRowIndA, Pointer cscSortedColPtrA, cusparseHybMat hybA, int userEllWidth, int partitionType) {
        return JCusparse.checkResult(JCusparse.cusparseDcsc2hybNative(handle, m, n, descrA, cscSortedValA, cscSortedRowIndA, cscSortedColPtrA, hybA, userEllWidth, partitionType));
    }

    private static native int cusparseDcsc2hybNative(cusparseHandle var0, int var1, int var2, cusparseMatDescr var3, Pointer var4, Pointer var5, Pointer var6, cusparseHybMat var7, int var8, int var9);

    public static int cusparseCcsc2hyb(cusparseHandle handle, int m, int n, cusparseMatDescr descrA, Pointer cscSortedValA, Pointer cscSortedRowIndA, Pointer cscSortedColPtrA, cusparseHybMat hybA, int userEllWidth, int partitionType) {
        return JCusparse.checkResult(JCusparse.cusparseCcsc2hybNative(handle, m, n, descrA, cscSortedValA, cscSortedRowIndA, cscSortedColPtrA, hybA, userEllWidth, partitionType));
    }

    private static native int cusparseCcsc2hybNative(cusparseHandle var0, int var1, int var2, cusparseMatDescr var3, Pointer var4, Pointer var5, Pointer var6, cusparseHybMat var7, int var8, int var9);

    public static int cusparseZcsc2hyb(cusparseHandle handle, int m, int n, cusparseMatDescr descrA, Pointer cscSortedValA, Pointer cscSortedRowIndA, Pointer cscSortedColPtrA, cusparseHybMat hybA, int userEllWidth, int partitionType) {
        return JCusparse.checkResult(JCusparse.cusparseZcsc2hybNative(handle, m, n, descrA, cscSortedValA, cscSortedRowIndA, cscSortedColPtrA, hybA, userEllWidth, partitionType));
    }

    private static native int cusparseZcsc2hybNative(cusparseHandle var0, int var1, int var2, cusparseMatDescr var3, Pointer var4, Pointer var5, Pointer var6, cusparseHybMat var7, int var8, int var9);

    public static int cusparseShyb2csc(cusparseHandle handle, cusparseMatDescr descrA, cusparseHybMat hybA, Pointer cscSortedVal, Pointer cscSortedRowInd, Pointer cscSortedColPtr) {
        return JCusparse.checkResult(JCusparse.cusparseShyb2cscNative(handle, descrA, hybA, cscSortedVal, cscSortedRowInd, cscSortedColPtr));
    }

    private static native int cusparseShyb2cscNative(cusparseHandle var0, cusparseMatDescr var1, cusparseHybMat var2, Pointer var3, Pointer var4, Pointer var5);

    public static int cusparseDhyb2csc(cusparseHandle handle, cusparseMatDescr descrA, cusparseHybMat hybA, Pointer cscSortedVal, Pointer cscSortedRowInd, Pointer cscSortedColPtr) {
        return JCusparse.checkResult(JCusparse.cusparseDhyb2cscNative(handle, descrA, hybA, cscSortedVal, cscSortedRowInd, cscSortedColPtr));
    }

    private static native int cusparseDhyb2cscNative(cusparseHandle var0, cusparseMatDescr var1, cusparseHybMat var2, Pointer var3, Pointer var4, Pointer var5);

    public static int cusparseChyb2csc(cusparseHandle handle, cusparseMatDescr descrA, cusparseHybMat hybA, Pointer cscSortedVal, Pointer cscSortedRowInd, Pointer cscSortedColPtr) {
        return JCusparse.checkResult(JCusparse.cusparseChyb2cscNative(handle, descrA, hybA, cscSortedVal, cscSortedRowInd, cscSortedColPtr));
    }

    private static native int cusparseChyb2cscNative(cusparseHandle var0, cusparseMatDescr var1, cusparseHybMat var2, Pointer var3, Pointer var4, Pointer var5);

    public static int cusparseZhyb2csc(cusparseHandle handle, cusparseMatDescr descrA, cusparseHybMat hybA, Pointer cscSortedVal, Pointer cscSortedRowInd, Pointer cscSortedColPtr) {
        return JCusparse.checkResult(JCusparse.cusparseZhyb2cscNative(handle, descrA, hybA, cscSortedVal, cscSortedRowInd, cscSortedColPtr));
    }

    private static native int cusparseZhyb2cscNative(cusparseHandle var0, cusparseMatDescr var1, cusparseHybMat var2, Pointer var3, Pointer var4, Pointer var5);

    public static int cusparseXcsr2bsrNnz(cusparseHandle handle, int dirA, int m, int n, cusparseMatDescr descrA, Pointer csrSortedRowPtrA, Pointer csrSortedColIndA, int blockDim, cusparseMatDescr descrC, Pointer bsrSortedRowPtrC, Pointer nnzTotalDevHostPtr) {
        return JCusparse.checkResult(JCusparse.cusparseXcsr2bsrNnzNative(handle, dirA, m, n, descrA, csrSortedRowPtrA, csrSortedColIndA, blockDim, descrC, bsrSortedRowPtrC, nnzTotalDevHostPtr));
    }

    private static native int cusparseXcsr2bsrNnzNative(cusparseHandle var0, int var1, int var2, int var3, cusparseMatDescr var4, Pointer var5, Pointer var6, int var7, cusparseMatDescr var8, Pointer var9, Pointer var10);

    public static int cusparseScsr2bsr(cusparseHandle handle, int dirA, int m, int n, cusparseMatDescr descrA, Pointer csrSortedValA, Pointer csrSortedRowPtrA, Pointer csrSortedColIndA, int blockDim, cusparseMatDescr descrC, Pointer bsrSortedValC, Pointer bsrSortedRowPtrC, Pointer bsrSortedColIndC) {
        return JCusparse.checkResult(JCusparse.cusparseScsr2bsrNative(handle, dirA, m, n, descrA, csrSortedValA, csrSortedRowPtrA, csrSortedColIndA, blockDim, descrC, bsrSortedValC, bsrSortedRowPtrC, bsrSortedColIndC));
    }

    private static native int cusparseScsr2bsrNative(cusparseHandle var0, int var1, int var2, int var3, cusparseMatDescr var4, Pointer var5, Pointer var6, Pointer var7, int var8, cusparseMatDescr var9, Pointer var10, Pointer var11, Pointer var12);

    public static int cusparseDcsr2bsr(cusparseHandle handle, int dirA, int m, int n, cusparseMatDescr descrA, Pointer csrSortedValA, Pointer csrSortedRowPtrA, Pointer csrSortedColIndA, int blockDim, cusparseMatDescr descrC, Pointer bsrSortedValC, Pointer bsrSortedRowPtrC, Pointer bsrSortedColIndC) {
        return JCusparse.checkResult(JCusparse.cusparseDcsr2bsrNative(handle, dirA, m, n, descrA, csrSortedValA, csrSortedRowPtrA, csrSortedColIndA, blockDim, descrC, bsrSortedValC, bsrSortedRowPtrC, bsrSortedColIndC));
    }

    private static native int cusparseDcsr2bsrNative(cusparseHandle var0, int var1, int var2, int var3, cusparseMatDescr var4, Pointer var5, Pointer var6, Pointer var7, int var8, cusparseMatDescr var9, Pointer var10, Pointer var11, Pointer var12);

    public static int cusparseCcsr2bsr(cusparseHandle handle, int dirA, int m, int n, cusparseMatDescr descrA, Pointer csrSortedValA, Pointer csrSortedRowPtrA, Pointer csrSortedColIndA, int blockDim, cusparseMatDescr descrC, Pointer bsrSortedValC, Pointer bsrSortedRowPtrC, Pointer bsrSortedColIndC) {
        return JCusparse.checkResult(JCusparse.cusparseCcsr2bsrNative(handle, dirA, m, n, descrA, csrSortedValA, csrSortedRowPtrA, csrSortedColIndA, blockDim, descrC, bsrSortedValC, bsrSortedRowPtrC, bsrSortedColIndC));
    }

    private static native int cusparseCcsr2bsrNative(cusparseHandle var0, int var1, int var2, int var3, cusparseMatDescr var4, Pointer var5, Pointer var6, Pointer var7, int var8, cusparseMatDescr var9, Pointer var10, Pointer var11, Pointer var12);

    public static int cusparseZcsr2bsr(cusparseHandle handle, int dirA, int m, int n, cusparseMatDescr descrA, Pointer csrSortedValA, Pointer csrSortedRowPtrA, Pointer csrSortedColIndA, int blockDim, cusparseMatDescr descrC, Pointer bsrSortedValC, Pointer bsrSortedRowPtrC, Pointer bsrSortedColIndC) {
        return JCusparse.checkResult(JCusparse.cusparseZcsr2bsrNative(handle, dirA, m, n, descrA, csrSortedValA, csrSortedRowPtrA, csrSortedColIndA, blockDim, descrC, bsrSortedValC, bsrSortedRowPtrC, bsrSortedColIndC));
    }

    private static native int cusparseZcsr2bsrNative(cusparseHandle var0, int var1, int var2, int var3, cusparseMatDescr var4, Pointer var5, Pointer var6, Pointer var7, int var8, cusparseMatDescr var9, Pointer var10, Pointer var11, Pointer var12);

    public static int cusparseSbsr2csr(cusparseHandle handle, int dirA, int mb, int nb, cusparseMatDescr descrA, Pointer bsrSortedValA, Pointer bsrSortedRowPtrA, Pointer bsrSortedColIndA, int blockDim, cusparseMatDescr descrC, Pointer csrSortedValC, Pointer csrSortedRowPtrC, Pointer csrSortedColIndC) {
        return JCusparse.checkResult(JCusparse.cusparseSbsr2csrNative(handle, dirA, mb, nb, descrA, bsrSortedValA, bsrSortedRowPtrA, bsrSortedColIndA, blockDim, descrC, csrSortedValC, csrSortedRowPtrC, csrSortedColIndC));
    }

    private static native int cusparseSbsr2csrNative(cusparseHandle var0, int var1, int var2, int var3, cusparseMatDescr var4, Pointer var5, Pointer var6, Pointer var7, int var8, cusparseMatDescr var9, Pointer var10, Pointer var11, Pointer var12);

    public static int cusparseDbsr2csr(cusparseHandle handle, int dirA, int mb, int nb, cusparseMatDescr descrA, Pointer bsrSortedValA, Pointer bsrSortedRowPtrA, Pointer bsrSortedColIndA, int blockDim, cusparseMatDescr descrC, Pointer csrSortedValC, Pointer csrSortedRowPtrC, Pointer csrSortedColIndC) {
        return JCusparse.checkResult(JCusparse.cusparseDbsr2csrNative(handle, dirA, mb, nb, descrA, bsrSortedValA, bsrSortedRowPtrA, bsrSortedColIndA, blockDim, descrC, csrSortedValC, csrSortedRowPtrC, csrSortedColIndC));
    }

    private static native int cusparseDbsr2csrNative(cusparseHandle var0, int var1, int var2, int var3, cusparseMatDescr var4, Pointer var5, Pointer var6, Pointer var7, int var8, cusparseMatDescr var9, Pointer var10, Pointer var11, Pointer var12);

    public static int cusparseCbsr2csr(cusparseHandle handle, int dirA, int mb, int nb, cusparseMatDescr descrA, Pointer bsrSortedValA, Pointer bsrSortedRowPtrA, Pointer bsrSortedColIndA, int blockDim, cusparseMatDescr descrC, Pointer csrSortedValC, Pointer csrSortedRowPtrC, Pointer csrSortedColIndC) {
        return JCusparse.checkResult(JCusparse.cusparseCbsr2csrNative(handle, dirA, mb, nb, descrA, bsrSortedValA, bsrSortedRowPtrA, bsrSortedColIndA, blockDim, descrC, csrSortedValC, csrSortedRowPtrC, csrSortedColIndC));
    }

    private static native int cusparseCbsr2csrNative(cusparseHandle var0, int var1, int var2, int var3, cusparseMatDescr var4, Pointer var5, Pointer var6, Pointer var7, int var8, cusparseMatDescr var9, Pointer var10, Pointer var11, Pointer var12);

    public static int cusparseZbsr2csr(cusparseHandle handle, int dirA, int mb, int nb, cusparseMatDescr descrA, Pointer bsrSortedValA, Pointer bsrSortedRowPtrA, Pointer bsrSortedColIndA, int blockDim, cusparseMatDescr descrC, Pointer csrSortedValC, Pointer csrSortedRowPtrC, Pointer csrSortedColIndC) {
        return JCusparse.checkResult(JCusparse.cusparseZbsr2csrNative(handle, dirA, mb, nb, descrA, bsrSortedValA, bsrSortedRowPtrA, bsrSortedColIndA, blockDim, descrC, csrSortedValC, csrSortedRowPtrC, csrSortedColIndC));
    }

    private static native int cusparseZbsr2csrNative(cusparseHandle var0, int var1, int var2, int var3, cusparseMatDescr var4, Pointer var5, Pointer var6, Pointer var7, int var8, cusparseMatDescr var9, Pointer var10, Pointer var11, Pointer var12);

    public static int cusparseSgebsr2gebsc_bufferSize(cusparseHandle handle, int mb, int nb, int nnzb, Pointer bsrSortedVal, Pointer bsrSortedRowPtr, Pointer bsrSortedColInd, int rowBlockDim, int colBlockDim, int[] pBufferSizeInBytes) {
        return JCusparse.checkResult(JCusparse.cusparseSgebsr2gebsc_bufferSizeNative(handle, mb, nb, nnzb, bsrSortedVal, bsrSortedRowPtr, bsrSortedColInd, rowBlockDim, colBlockDim, pBufferSizeInBytes));
    }

    private static native int cusparseSgebsr2gebsc_bufferSizeNative(cusparseHandle var0, int var1, int var2, int var3, Pointer var4, Pointer var5, Pointer var6, int var7, int var8, int[] var9);

    public static int cusparseDgebsr2gebsc_bufferSize(cusparseHandle handle, int mb, int nb, int nnzb, Pointer bsrSortedVal, Pointer bsrSortedRowPtr, Pointer bsrSortedColInd, int rowBlockDim, int colBlockDim, int[] pBufferSizeInBytes) {
        return JCusparse.checkResult(JCusparse.cusparseDgebsr2gebsc_bufferSizeNative(handle, mb, nb, nnzb, bsrSortedVal, bsrSortedRowPtr, bsrSortedColInd, rowBlockDim, colBlockDim, pBufferSizeInBytes));
    }

    private static native int cusparseDgebsr2gebsc_bufferSizeNative(cusparseHandle var0, int var1, int var2, int var3, Pointer var4, Pointer var5, Pointer var6, int var7, int var8, int[] var9);

    public static int cusparseCgebsr2gebsc_bufferSize(cusparseHandle handle, int mb, int nb, int nnzb, Pointer bsrSortedVal, Pointer bsrSortedRowPtr, Pointer bsrSortedColInd, int rowBlockDim, int colBlockDim, int[] pBufferSizeInBytes) {
        return JCusparse.checkResult(JCusparse.cusparseCgebsr2gebsc_bufferSizeNative(handle, mb, nb, nnzb, bsrSortedVal, bsrSortedRowPtr, bsrSortedColInd, rowBlockDim, colBlockDim, pBufferSizeInBytes));
    }

    private static native int cusparseCgebsr2gebsc_bufferSizeNative(cusparseHandle var0, int var1, int var2, int var3, Pointer var4, Pointer var5, Pointer var6, int var7, int var8, int[] var9);

    public static int cusparseZgebsr2gebsc_bufferSize(cusparseHandle handle, int mb, int nb, int nnzb, Pointer bsrSortedVal, Pointer bsrSortedRowPtr, Pointer bsrSortedColInd, int rowBlockDim, int colBlockDim, int[] pBufferSizeInBytes) {
        return JCusparse.checkResult(JCusparse.cusparseZgebsr2gebsc_bufferSizeNative(handle, mb, nb, nnzb, bsrSortedVal, bsrSortedRowPtr, bsrSortedColInd, rowBlockDim, colBlockDim, pBufferSizeInBytes));
    }

    private static native int cusparseZgebsr2gebsc_bufferSizeNative(cusparseHandle var0, int var1, int var2, int var3, Pointer var4, Pointer var5, Pointer var6, int var7, int var8, int[] var9);

    public static int cusparseSgebsr2gebsc_bufferSizeExt(cusparseHandle handle, int mb, int nb, int nnzb, Pointer bsrSortedVal, Pointer bsrSortedRowPtr, Pointer bsrSortedColInd, int rowBlockDim, int colBlockDim, int[] pBufferSize) {
        return JCusparse.checkResult(JCusparse.cusparseSgebsr2gebsc_bufferSizeExtNative(handle, mb, nb, nnzb, bsrSortedVal, bsrSortedRowPtr, bsrSortedColInd, rowBlockDim, colBlockDim, pBufferSize));
    }

    private static native int cusparseSgebsr2gebsc_bufferSizeExtNative(cusparseHandle var0, int var1, int var2, int var3, Pointer var4, Pointer var5, Pointer var6, int var7, int var8, int[] var9);

    public static int cusparseDgebsr2gebsc_bufferSizeExt(cusparseHandle handle, int mb, int nb, int nnzb, Pointer bsrSortedVal, Pointer bsrSortedRowPtr, Pointer bsrSortedColInd, int rowBlockDim, int colBlockDim, int[] pBufferSize) {
        return JCusparse.checkResult(JCusparse.cusparseDgebsr2gebsc_bufferSizeExtNative(handle, mb, nb, nnzb, bsrSortedVal, bsrSortedRowPtr, bsrSortedColInd, rowBlockDim, colBlockDim, pBufferSize));
    }

    private static native int cusparseDgebsr2gebsc_bufferSizeExtNative(cusparseHandle var0, int var1, int var2, int var3, Pointer var4, Pointer var5, Pointer var6, int var7, int var8, int[] var9);

    public static int cusparseCgebsr2gebsc_bufferSizeExt(cusparseHandle handle, int mb, int nb, int nnzb, Pointer bsrSortedVal, Pointer bsrSortedRowPtr, Pointer bsrSortedColInd, int rowBlockDim, int colBlockDim, int[] pBufferSize) {
        return JCusparse.checkResult(JCusparse.cusparseCgebsr2gebsc_bufferSizeExtNative(handle, mb, nb, nnzb, bsrSortedVal, bsrSortedRowPtr, bsrSortedColInd, rowBlockDim, colBlockDim, pBufferSize));
    }

    private static native int cusparseCgebsr2gebsc_bufferSizeExtNative(cusparseHandle var0, int var1, int var2, int var3, Pointer var4, Pointer var5, Pointer var6, int var7, int var8, int[] var9);

    public static int cusparseZgebsr2gebsc_bufferSizeExt(cusparseHandle handle, int mb, int nb, int nnzb, Pointer bsrSortedVal, Pointer bsrSortedRowPtr, Pointer bsrSortedColInd, int rowBlockDim, int colBlockDim, int[] pBufferSize) {
        return JCusparse.checkResult(JCusparse.cusparseZgebsr2gebsc_bufferSizeExtNative(handle, mb, nb, nnzb, bsrSortedVal, bsrSortedRowPtr, bsrSortedColInd, rowBlockDim, colBlockDim, pBufferSize));
    }

    private static native int cusparseZgebsr2gebsc_bufferSizeExtNative(cusparseHandle var0, int var1, int var2, int var3, Pointer var4, Pointer var5, Pointer var6, int var7, int var8, int[] var9);

    public static int cusparseSgebsr2gebsc(cusparseHandle handle, int mb, int nb, int nnzb, Pointer bsrSortedVal, Pointer bsrSortedRowPtr, Pointer bsrSortedColInd, int rowBlockDim, int colBlockDim, Pointer bscVal, Pointer bscRowInd, Pointer bscColPtr, int copyValues, int baseIdx, Pointer pBuffer) {
        return JCusparse.checkResult(JCusparse.cusparseSgebsr2gebscNative(handle, mb, nb, nnzb, bsrSortedVal, bsrSortedRowPtr, bsrSortedColInd, rowBlockDim, colBlockDim, bscVal, bscRowInd, bscColPtr, copyValues, baseIdx, pBuffer));
    }

    private static native int cusparseSgebsr2gebscNative(cusparseHandle var0, int var1, int var2, int var3, Pointer var4, Pointer var5, Pointer var6, int var7, int var8, Pointer var9, Pointer var10, Pointer var11, int var12, int var13, Pointer var14);

    public static int cusparseDgebsr2gebsc(cusparseHandle handle, int mb, int nb, int nnzb, Pointer bsrSortedVal, Pointer bsrSortedRowPtr, Pointer bsrSortedColInd, int rowBlockDim, int colBlockDim, Pointer bscVal, Pointer bscRowInd, Pointer bscColPtr, int copyValues, int baseIdx, Pointer pBuffer) {
        return JCusparse.checkResult(JCusparse.cusparseDgebsr2gebscNative(handle, mb, nb, nnzb, bsrSortedVal, bsrSortedRowPtr, bsrSortedColInd, rowBlockDim, colBlockDim, bscVal, bscRowInd, bscColPtr, copyValues, baseIdx, pBuffer));
    }

    private static native int cusparseDgebsr2gebscNative(cusparseHandle var0, int var1, int var2, int var3, Pointer var4, Pointer var5, Pointer var6, int var7, int var8, Pointer var9, Pointer var10, Pointer var11, int var12, int var13, Pointer var14);

    public static int cusparseCgebsr2gebsc(cusparseHandle handle, int mb, int nb, int nnzb, Pointer bsrSortedVal, Pointer bsrSortedRowPtr, Pointer bsrSortedColInd, int rowBlockDim, int colBlockDim, Pointer bscVal, Pointer bscRowInd, Pointer bscColPtr, int copyValues, int baseIdx, Pointer pBuffer) {
        return JCusparse.checkResult(JCusparse.cusparseCgebsr2gebscNative(handle, mb, nb, nnzb, bsrSortedVal, bsrSortedRowPtr, bsrSortedColInd, rowBlockDim, colBlockDim, bscVal, bscRowInd, bscColPtr, copyValues, baseIdx, pBuffer));
    }

    private static native int cusparseCgebsr2gebscNative(cusparseHandle var0, int var1, int var2, int var3, Pointer var4, Pointer var5, Pointer var6, int var7, int var8, Pointer var9, Pointer var10, Pointer var11, int var12, int var13, Pointer var14);

    public static int cusparseZgebsr2gebsc(cusparseHandle handle, int mb, int nb, int nnzb, Pointer bsrSortedVal, Pointer bsrSortedRowPtr, Pointer bsrSortedColInd, int rowBlockDim, int colBlockDim, Pointer bscVal, Pointer bscRowInd, Pointer bscColPtr, int copyValues, int baseIdx, Pointer pBuffer) {
        return JCusparse.checkResult(JCusparse.cusparseZgebsr2gebscNative(handle, mb, nb, nnzb, bsrSortedVal, bsrSortedRowPtr, bsrSortedColInd, rowBlockDim, colBlockDim, bscVal, bscRowInd, bscColPtr, copyValues, baseIdx, pBuffer));
    }

    private static native int cusparseZgebsr2gebscNative(cusparseHandle var0, int var1, int var2, int var3, Pointer var4, Pointer var5, Pointer var6, int var7, int var8, Pointer var9, Pointer var10, Pointer var11, int var12, int var13, Pointer var14);

    public static int cusparseXgebsr2csr(cusparseHandle handle, int dirA, int mb, int nb, cusparseMatDescr descrA, Pointer bsrSortedRowPtrA, Pointer bsrSortedColIndA, int rowBlockDim, int colBlockDim, cusparseMatDescr descrC, Pointer csrSortedRowPtrC, Pointer csrSortedColIndC) {
        return JCusparse.checkResult(JCusparse.cusparseXgebsr2csrNative(handle, dirA, mb, nb, descrA, bsrSortedRowPtrA, bsrSortedColIndA, rowBlockDim, colBlockDim, descrC, csrSortedRowPtrC, csrSortedColIndC));
    }

    private static native int cusparseXgebsr2csrNative(cusparseHandle var0, int var1, int var2, int var3, cusparseMatDescr var4, Pointer var5, Pointer var6, int var7, int var8, cusparseMatDescr var9, Pointer var10, Pointer var11);

    public static int cusparseSgebsr2csr(cusparseHandle handle, int dirA, int mb, int nb, cusparseMatDescr descrA, Pointer bsrSortedValA, Pointer bsrSortedRowPtrA, Pointer bsrSortedColIndA, int rowBlockDim, int colBlockDim, cusparseMatDescr descrC, Pointer csrSortedValC, Pointer csrSortedRowPtrC, Pointer csrSortedColIndC) {
        return JCusparse.checkResult(JCusparse.cusparseSgebsr2csrNative(handle, dirA, mb, nb, descrA, bsrSortedValA, bsrSortedRowPtrA, bsrSortedColIndA, rowBlockDim, colBlockDim, descrC, csrSortedValC, csrSortedRowPtrC, csrSortedColIndC));
    }

    private static native int cusparseSgebsr2csrNative(cusparseHandle var0, int var1, int var2, int var3, cusparseMatDescr var4, Pointer var5, Pointer var6, Pointer var7, int var8, int var9, cusparseMatDescr var10, Pointer var11, Pointer var12, Pointer var13);

    public static int cusparseDgebsr2csr(cusparseHandle handle, int dirA, int mb, int nb, cusparseMatDescr descrA, Pointer bsrSortedValA, Pointer bsrSortedRowPtrA, Pointer bsrSortedColIndA, int rowBlockDim, int colBlockDim, cusparseMatDescr descrC, Pointer csrSortedValC, Pointer csrSortedRowPtrC, Pointer csrSortedColIndC) {
        return JCusparse.checkResult(JCusparse.cusparseDgebsr2csrNative(handle, dirA, mb, nb, descrA, bsrSortedValA, bsrSortedRowPtrA, bsrSortedColIndA, rowBlockDim, colBlockDim, descrC, csrSortedValC, csrSortedRowPtrC, csrSortedColIndC));
    }

    private static native int cusparseDgebsr2csrNative(cusparseHandle var0, int var1, int var2, int var3, cusparseMatDescr var4, Pointer var5, Pointer var6, Pointer var7, int var8, int var9, cusparseMatDescr var10, Pointer var11, Pointer var12, Pointer var13);

    public static int cusparseCgebsr2csr(cusparseHandle handle, int dirA, int mb, int nb, cusparseMatDescr descrA, Pointer bsrSortedValA, Pointer bsrSortedRowPtrA, Pointer bsrSortedColIndA, int rowBlockDim, int colBlockDim, cusparseMatDescr descrC, Pointer csrSortedValC, Pointer csrSortedRowPtrC, Pointer csrSortedColIndC) {
        return JCusparse.checkResult(JCusparse.cusparseCgebsr2csrNative(handle, dirA, mb, nb, descrA, bsrSortedValA, bsrSortedRowPtrA, bsrSortedColIndA, rowBlockDim, colBlockDim, descrC, csrSortedValC, csrSortedRowPtrC, csrSortedColIndC));
    }

    private static native int cusparseCgebsr2csrNative(cusparseHandle var0, int var1, int var2, int var3, cusparseMatDescr var4, Pointer var5, Pointer var6, Pointer var7, int var8, int var9, cusparseMatDescr var10, Pointer var11, Pointer var12, Pointer var13);

    public static int cusparseZgebsr2csr(cusparseHandle handle, int dirA, int mb, int nb, cusparseMatDescr descrA, Pointer bsrSortedValA, Pointer bsrSortedRowPtrA, Pointer bsrSortedColIndA, int rowBlockDim, int colBlockDim, cusparseMatDescr descrC, Pointer csrSortedValC, Pointer csrSortedRowPtrC, Pointer csrSortedColIndC) {
        return JCusparse.checkResult(JCusparse.cusparseZgebsr2csrNative(handle, dirA, mb, nb, descrA, bsrSortedValA, bsrSortedRowPtrA, bsrSortedColIndA, rowBlockDim, colBlockDim, descrC, csrSortedValC, csrSortedRowPtrC, csrSortedColIndC));
    }

    private static native int cusparseZgebsr2csrNative(cusparseHandle var0, int var1, int var2, int var3, cusparseMatDescr var4, Pointer var5, Pointer var6, Pointer var7, int var8, int var9, cusparseMatDescr var10, Pointer var11, Pointer var12, Pointer var13);

    public static int cusparseScsr2gebsr_bufferSize(cusparseHandle handle, int dirA, int m, int n, cusparseMatDescr descrA, Pointer csrSortedValA, Pointer csrSortedRowPtrA, Pointer csrSortedColIndA, int rowBlockDim, int colBlockDim, int[] pBufferSizeInBytes) {
        return JCusparse.checkResult(JCusparse.cusparseScsr2gebsr_bufferSizeNative(handle, dirA, m, n, descrA, csrSortedValA, csrSortedRowPtrA, csrSortedColIndA, rowBlockDim, colBlockDim, pBufferSizeInBytes));
    }

    private static native int cusparseScsr2gebsr_bufferSizeNative(cusparseHandle var0, int var1, int var2, int var3, cusparseMatDescr var4, Pointer var5, Pointer var6, Pointer var7, int var8, int var9, int[] var10);

    public static int cusparseDcsr2gebsr_bufferSize(cusparseHandle handle, int dirA, int m, int n, cusparseMatDescr descrA, Pointer csrSortedValA, Pointer csrSortedRowPtrA, Pointer csrSortedColIndA, int rowBlockDim, int colBlockDim, int[] pBufferSizeInBytes) {
        return JCusparse.checkResult(JCusparse.cusparseDcsr2gebsr_bufferSizeNative(handle, dirA, m, n, descrA, csrSortedValA, csrSortedRowPtrA, csrSortedColIndA, rowBlockDim, colBlockDim, pBufferSizeInBytes));
    }

    private static native int cusparseDcsr2gebsr_bufferSizeNative(cusparseHandle var0, int var1, int var2, int var3, cusparseMatDescr var4, Pointer var5, Pointer var6, Pointer var7, int var8, int var9, int[] var10);

    public static int cusparseCcsr2gebsr_bufferSize(cusparseHandle handle, int dirA, int m, int n, cusparseMatDescr descrA, Pointer csrSortedValA, Pointer csrSortedRowPtrA, Pointer csrSortedColIndA, int rowBlockDim, int colBlockDim, int[] pBufferSizeInBytes) {
        return JCusparse.checkResult(JCusparse.cusparseCcsr2gebsr_bufferSizeNative(handle, dirA, m, n, descrA, csrSortedValA, csrSortedRowPtrA, csrSortedColIndA, rowBlockDim, colBlockDim, pBufferSizeInBytes));
    }

    private static native int cusparseCcsr2gebsr_bufferSizeNative(cusparseHandle var0, int var1, int var2, int var3, cusparseMatDescr var4, Pointer var5, Pointer var6, Pointer var7, int var8, int var9, int[] var10);

    public static int cusparseZcsr2gebsr_bufferSize(cusparseHandle handle, int dirA, int m, int n, cusparseMatDescr descrA, Pointer csrSortedValA, Pointer csrSortedRowPtrA, Pointer csrSortedColIndA, int rowBlockDim, int colBlockDim, int[] pBufferSizeInBytes) {
        return JCusparse.checkResult(JCusparse.cusparseZcsr2gebsr_bufferSizeNative(handle, dirA, m, n, descrA, csrSortedValA, csrSortedRowPtrA, csrSortedColIndA, rowBlockDim, colBlockDim, pBufferSizeInBytes));
    }

    private static native int cusparseZcsr2gebsr_bufferSizeNative(cusparseHandle var0, int var1, int var2, int var3, cusparseMatDescr var4, Pointer var5, Pointer var6, Pointer var7, int var8, int var9, int[] var10);

    public static int cusparseScsr2gebsr_bufferSizeExt(cusparseHandle handle, int dirA, int m, int n, cusparseMatDescr descrA, Pointer csrSortedValA, Pointer csrSortedRowPtrA, Pointer csrSortedColIndA, int rowBlockDim, int colBlockDim, int[] pBufferSize) {
        return JCusparse.checkResult(JCusparse.cusparseScsr2gebsr_bufferSizeExtNative(handle, dirA, m, n, descrA, csrSortedValA, csrSortedRowPtrA, csrSortedColIndA, rowBlockDim, colBlockDim, pBufferSize));
    }

    private static native int cusparseScsr2gebsr_bufferSizeExtNative(cusparseHandle var0, int var1, int var2, int var3, cusparseMatDescr var4, Pointer var5, Pointer var6, Pointer var7, int var8, int var9, int[] var10);

    public static int cusparseDcsr2gebsr_bufferSizeExt(cusparseHandle handle, int dirA, int m, int n, cusparseMatDescr descrA, Pointer csrSortedValA, Pointer csrSortedRowPtrA, Pointer csrSortedColIndA, int rowBlockDim, int colBlockDim, int[] pBufferSize) {
        return JCusparse.checkResult(JCusparse.cusparseDcsr2gebsr_bufferSizeExtNative(handle, dirA, m, n, descrA, csrSortedValA, csrSortedRowPtrA, csrSortedColIndA, rowBlockDim, colBlockDim, pBufferSize));
    }

    private static native int cusparseDcsr2gebsr_bufferSizeExtNative(cusparseHandle var0, int var1, int var2, int var3, cusparseMatDescr var4, Pointer var5, Pointer var6, Pointer var7, int var8, int var9, int[] var10);

    public static int cusparseCcsr2gebsr_bufferSizeExt(cusparseHandle handle, int dirA, int m, int n, cusparseMatDescr descrA, Pointer csrSortedValA, Pointer csrSortedRowPtrA, Pointer csrSortedColIndA, int rowBlockDim, int colBlockDim, int[] pBufferSize) {
        return JCusparse.checkResult(JCusparse.cusparseCcsr2gebsr_bufferSizeExtNative(handle, dirA, m, n, descrA, csrSortedValA, csrSortedRowPtrA, csrSortedColIndA, rowBlockDim, colBlockDim, pBufferSize));
    }

    private static native int cusparseCcsr2gebsr_bufferSizeExtNative(cusparseHandle var0, int var1, int var2, int var3, cusparseMatDescr var4, Pointer var5, Pointer var6, Pointer var7, int var8, int var9, int[] var10);

    public static int cusparseZcsr2gebsr_bufferSizeExt(cusparseHandle handle, int dirA, int m, int n, cusparseMatDescr descrA, Pointer csrSortedValA, Pointer csrSortedRowPtrA, Pointer csrSortedColIndA, int rowBlockDim, int colBlockDim, int[] pBufferSize) {
        return JCusparse.checkResult(JCusparse.cusparseZcsr2gebsr_bufferSizeExtNative(handle, dirA, m, n, descrA, csrSortedValA, csrSortedRowPtrA, csrSortedColIndA, rowBlockDim, colBlockDim, pBufferSize));
    }

    private static native int cusparseZcsr2gebsr_bufferSizeExtNative(cusparseHandle var0, int var1, int var2, int var3, cusparseMatDescr var4, Pointer var5, Pointer var6, Pointer var7, int var8, int var9, int[] var10);

    public static int cusparseXcsr2gebsrNnz(cusparseHandle handle, int dirA, int m, int n, cusparseMatDescr descrA, Pointer csrSortedRowPtrA, Pointer csrSortedColIndA, cusparseMatDescr descrC, Pointer bsrSortedRowPtrC, int rowBlockDim, int colBlockDim, Pointer nnzTotalDevHostPtr, Pointer pBuffer) {
        return JCusparse.checkResult(JCusparse.cusparseXcsr2gebsrNnzNative(handle, dirA, m, n, descrA, csrSortedRowPtrA, csrSortedColIndA, descrC, bsrSortedRowPtrC, rowBlockDim, colBlockDim, nnzTotalDevHostPtr, pBuffer));
    }

    private static native int cusparseXcsr2gebsrNnzNative(cusparseHandle var0, int var1, int var2, int var3, cusparseMatDescr var4, Pointer var5, Pointer var6, cusparseMatDescr var7, Pointer var8, int var9, int var10, Pointer var11, Pointer var12);

    public static int cusparseScsr2gebsr(cusparseHandle handle, int dirA, int m, int n, cusparseMatDescr descrA, Pointer csrSortedValA, Pointer csrSortedRowPtrA, Pointer csrSortedColIndA, cusparseMatDescr descrC, Pointer bsrSortedValC, Pointer bsrSortedRowPtrC, Pointer bsrSortedColIndC, int rowBlockDim, int colBlockDim, Pointer pBuffer) {
        return JCusparse.checkResult(JCusparse.cusparseScsr2gebsrNative(handle, dirA, m, n, descrA, csrSortedValA, csrSortedRowPtrA, csrSortedColIndA, descrC, bsrSortedValC, bsrSortedRowPtrC, bsrSortedColIndC, rowBlockDim, colBlockDim, pBuffer));
    }

    private static native int cusparseScsr2gebsrNative(cusparseHandle var0, int var1, int var2, int var3, cusparseMatDescr var4, Pointer var5, Pointer var6, Pointer var7, cusparseMatDescr var8, Pointer var9, Pointer var10, Pointer var11, int var12, int var13, Pointer var14);

    public static int cusparseDcsr2gebsr(cusparseHandle handle, int dirA, int m, int n, cusparseMatDescr descrA, Pointer csrSortedValA, Pointer csrSortedRowPtrA, Pointer csrSortedColIndA, cusparseMatDescr descrC, Pointer bsrSortedValC, Pointer bsrSortedRowPtrC, Pointer bsrSortedColIndC, int rowBlockDim, int colBlockDim, Pointer pBuffer) {
        return JCusparse.checkResult(JCusparse.cusparseDcsr2gebsrNative(handle, dirA, m, n, descrA, csrSortedValA, csrSortedRowPtrA, csrSortedColIndA, descrC, bsrSortedValC, bsrSortedRowPtrC, bsrSortedColIndC, rowBlockDim, colBlockDim, pBuffer));
    }

    private static native int cusparseDcsr2gebsrNative(cusparseHandle var0, int var1, int var2, int var3, cusparseMatDescr var4, Pointer var5, Pointer var6, Pointer var7, cusparseMatDescr var8, Pointer var9, Pointer var10, Pointer var11, int var12, int var13, Pointer var14);

    public static int cusparseCcsr2gebsr(cusparseHandle handle, int dirA, int m, int n, cusparseMatDescr descrA, Pointer csrSortedValA, Pointer csrSortedRowPtrA, Pointer csrSortedColIndA, cusparseMatDescr descrC, Pointer bsrSortedValC, Pointer bsrSortedRowPtrC, Pointer bsrSortedColIndC, int rowBlockDim, int colBlockDim, Pointer pBuffer) {
        return JCusparse.checkResult(JCusparse.cusparseCcsr2gebsrNative(handle, dirA, m, n, descrA, csrSortedValA, csrSortedRowPtrA, csrSortedColIndA, descrC, bsrSortedValC, bsrSortedRowPtrC, bsrSortedColIndC, rowBlockDim, colBlockDim, pBuffer));
    }

    private static native int cusparseCcsr2gebsrNative(cusparseHandle var0, int var1, int var2, int var3, cusparseMatDescr var4, Pointer var5, Pointer var6, Pointer var7, cusparseMatDescr var8, Pointer var9, Pointer var10, Pointer var11, int var12, int var13, Pointer var14);

    public static int cusparseZcsr2gebsr(cusparseHandle handle, int dirA, int m, int n, cusparseMatDescr descrA, Pointer csrSortedValA, Pointer csrSortedRowPtrA, Pointer csrSortedColIndA, cusparseMatDescr descrC, Pointer bsrSortedValC, Pointer bsrSortedRowPtrC, Pointer bsrSortedColIndC, int rowBlockDim, int colBlockDim, Pointer pBuffer) {
        return JCusparse.checkResult(JCusparse.cusparseZcsr2gebsrNative(handle, dirA, m, n, descrA, csrSortedValA, csrSortedRowPtrA, csrSortedColIndA, descrC, bsrSortedValC, bsrSortedRowPtrC, bsrSortedColIndC, rowBlockDim, colBlockDim, pBuffer));
    }

    private static native int cusparseZcsr2gebsrNative(cusparseHandle var0, int var1, int var2, int var3, cusparseMatDescr var4, Pointer var5, Pointer var6, Pointer var7, cusparseMatDescr var8, Pointer var9, Pointer var10, Pointer var11, int var12, int var13, Pointer var14);

    public static int cusparseSgebsr2gebsr_bufferSize(cusparseHandle handle, int dirA, int mb, int nb, int nnzb, cusparseMatDescr descrA, Pointer bsrSortedValA, Pointer bsrSortedRowPtrA, Pointer bsrSortedColIndA, int rowBlockDimA, int colBlockDimA, int rowBlockDimC, int colBlockDimC, int[] pBufferSizeInBytes) {
        return JCusparse.checkResult(JCusparse.cusparseSgebsr2gebsr_bufferSizeNative(handle, dirA, mb, nb, nnzb, descrA, bsrSortedValA, bsrSortedRowPtrA, bsrSortedColIndA, rowBlockDimA, colBlockDimA, rowBlockDimC, colBlockDimC, pBufferSizeInBytes));
    }

    private static native int cusparseSgebsr2gebsr_bufferSizeNative(cusparseHandle var0, int var1, int var2, int var3, int var4, cusparseMatDescr var5, Pointer var6, Pointer var7, Pointer var8, int var9, int var10, int var11, int var12, int[] var13);

    public static int cusparseDgebsr2gebsr_bufferSize(cusparseHandle handle, int dirA, int mb, int nb, int nnzb, cusparseMatDescr descrA, Pointer bsrSortedValA, Pointer bsrSortedRowPtrA, Pointer bsrSortedColIndA, int rowBlockDimA, int colBlockDimA, int rowBlockDimC, int colBlockDimC, int[] pBufferSizeInBytes) {
        return JCusparse.checkResult(JCusparse.cusparseDgebsr2gebsr_bufferSizeNative(handle, dirA, mb, nb, nnzb, descrA, bsrSortedValA, bsrSortedRowPtrA, bsrSortedColIndA, rowBlockDimA, colBlockDimA, rowBlockDimC, colBlockDimC, pBufferSizeInBytes));
    }

    private static native int cusparseDgebsr2gebsr_bufferSizeNative(cusparseHandle var0, int var1, int var2, int var3, int var4, cusparseMatDescr var5, Pointer var6, Pointer var7, Pointer var8, int var9, int var10, int var11, int var12, int[] var13);

    public static int cusparseCgebsr2gebsr_bufferSize(cusparseHandle handle, int dirA, int mb, int nb, int nnzb, cusparseMatDescr descrA, Pointer bsrSortedValA, Pointer bsrSortedRowPtrA, Pointer bsrSortedColIndA, int rowBlockDimA, int colBlockDimA, int rowBlockDimC, int colBlockDimC, int[] pBufferSizeInBytes) {
        return JCusparse.checkResult(JCusparse.cusparseCgebsr2gebsr_bufferSizeNative(handle, dirA, mb, nb, nnzb, descrA, bsrSortedValA, bsrSortedRowPtrA, bsrSortedColIndA, rowBlockDimA, colBlockDimA, rowBlockDimC, colBlockDimC, pBufferSizeInBytes));
    }

    private static native int cusparseCgebsr2gebsr_bufferSizeNative(cusparseHandle var0, int var1, int var2, int var3, int var4, cusparseMatDescr var5, Pointer var6, Pointer var7, Pointer var8, int var9, int var10, int var11, int var12, int[] var13);

    public static int cusparseZgebsr2gebsr_bufferSize(cusparseHandle handle, int dirA, int mb, int nb, int nnzb, cusparseMatDescr descrA, Pointer bsrSortedValA, Pointer bsrSortedRowPtrA, Pointer bsrSortedColIndA, int rowBlockDimA, int colBlockDimA, int rowBlockDimC, int colBlockDimC, int[] pBufferSizeInBytes) {
        return JCusparse.checkResult(JCusparse.cusparseZgebsr2gebsr_bufferSizeNative(handle, dirA, mb, nb, nnzb, descrA, bsrSortedValA, bsrSortedRowPtrA, bsrSortedColIndA, rowBlockDimA, colBlockDimA, rowBlockDimC, colBlockDimC, pBufferSizeInBytes));
    }

    private static native int cusparseZgebsr2gebsr_bufferSizeNative(cusparseHandle var0, int var1, int var2, int var3, int var4, cusparseMatDescr var5, Pointer var6, Pointer var7, Pointer var8, int var9, int var10, int var11, int var12, int[] var13);

    public static int cusparseSgebsr2gebsr_bufferSizeExt(cusparseHandle handle, int dirA, int mb, int nb, int nnzb, cusparseMatDescr descrA, Pointer bsrSortedValA, Pointer bsrSortedRowPtrA, Pointer bsrSortedColIndA, int rowBlockDimA, int colBlockDimA, int rowBlockDimC, int colBlockDimC, int[] pBufferSize) {
        return JCusparse.checkResult(JCusparse.cusparseSgebsr2gebsr_bufferSizeExtNative(handle, dirA, mb, nb, nnzb, descrA, bsrSortedValA, bsrSortedRowPtrA, bsrSortedColIndA, rowBlockDimA, colBlockDimA, rowBlockDimC, colBlockDimC, pBufferSize));
    }

    private static native int cusparseSgebsr2gebsr_bufferSizeExtNative(cusparseHandle var0, int var1, int var2, int var3, int var4, cusparseMatDescr var5, Pointer var6, Pointer var7, Pointer var8, int var9, int var10, int var11, int var12, int[] var13);

    public static int cusparseDgebsr2gebsr_bufferSizeExt(cusparseHandle handle, int dirA, int mb, int nb, int nnzb, cusparseMatDescr descrA, Pointer bsrSortedValA, Pointer bsrSortedRowPtrA, Pointer bsrSortedColIndA, int rowBlockDimA, int colBlockDimA, int rowBlockDimC, int colBlockDimC, int[] pBufferSize) {
        return JCusparse.checkResult(JCusparse.cusparseDgebsr2gebsr_bufferSizeExtNative(handle, dirA, mb, nb, nnzb, descrA, bsrSortedValA, bsrSortedRowPtrA, bsrSortedColIndA, rowBlockDimA, colBlockDimA, rowBlockDimC, colBlockDimC, pBufferSize));
    }

    private static native int cusparseDgebsr2gebsr_bufferSizeExtNative(cusparseHandle var0, int var1, int var2, int var3, int var4, cusparseMatDescr var5, Pointer var6, Pointer var7, Pointer var8, int var9, int var10, int var11, int var12, int[] var13);

    public static int cusparseCgebsr2gebsr_bufferSizeExt(cusparseHandle handle, int dirA, int mb, int nb, int nnzb, cusparseMatDescr descrA, Pointer bsrSortedValA, Pointer bsrSortedRowPtrA, Pointer bsrSortedColIndA, int rowBlockDimA, int colBlockDimA, int rowBlockDimC, int colBlockDimC, int[] pBufferSize) {
        return JCusparse.checkResult(JCusparse.cusparseCgebsr2gebsr_bufferSizeExtNative(handle, dirA, mb, nb, nnzb, descrA, bsrSortedValA, bsrSortedRowPtrA, bsrSortedColIndA, rowBlockDimA, colBlockDimA, rowBlockDimC, colBlockDimC, pBufferSize));
    }

    private static native int cusparseCgebsr2gebsr_bufferSizeExtNative(cusparseHandle var0, int var1, int var2, int var3, int var4, cusparseMatDescr var5, Pointer var6, Pointer var7, Pointer var8, int var9, int var10, int var11, int var12, int[] var13);

    public static int cusparseZgebsr2gebsr_bufferSizeExt(cusparseHandle handle, int dirA, int mb, int nb, int nnzb, cusparseMatDescr descrA, Pointer bsrSortedValA, Pointer bsrSortedRowPtrA, Pointer bsrSortedColIndA, int rowBlockDimA, int colBlockDimA, int rowBlockDimC, int colBlockDimC, int[] pBufferSize) {
        return JCusparse.checkResult(JCusparse.cusparseZgebsr2gebsr_bufferSizeExtNative(handle, dirA, mb, nb, nnzb, descrA, bsrSortedValA, bsrSortedRowPtrA, bsrSortedColIndA, rowBlockDimA, colBlockDimA, rowBlockDimC, colBlockDimC, pBufferSize));
    }

    private static native int cusparseZgebsr2gebsr_bufferSizeExtNative(cusparseHandle var0, int var1, int var2, int var3, int var4, cusparseMatDescr var5, Pointer var6, Pointer var7, Pointer var8, int var9, int var10, int var11, int var12, int[] var13);

    public static int cusparseXgebsr2gebsrNnz(cusparseHandle handle, int dirA, int mb, int nb, int nnzb, cusparseMatDescr descrA, Pointer bsrSortedRowPtrA, Pointer bsrSortedColIndA, int rowBlockDimA, int colBlockDimA, cusparseMatDescr descrC, Pointer bsrSortedRowPtrC, int rowBlockDimC, int colBlockDimC, Pointer nnzTotalDevHostPtr, Pointer pBuffer) {
        return JCusparse.checkResult(JCusparse.cusparseXgebsr2gebsrNnzNative(handle, dirA, mb, nb, nnzb, descrA, bsrSortedRowPtrA, bsrSortedColIndA, rowBlockDimA, colBlockDimA, descrC, bsrSortedRowPtrC, rowBlockDimC, colBlockDimC, nnzTotalDevHostPtr, pBuffer));
    }

    private static native int cusparseXgebsr2gebsrNnzNative(cusparseHandle var0, int var1, int var2, int var3, int var4, cusparseMatDescr var5, Pointer var6, Pointer var7, int var8, int var9, cusparseMatDescr var10, Pointer var11, int var12, int var13, Pointer var14, Pointer var15);

    public static int cusparseSgebsr2gebsr(cusparseHandle handle, int dirA, int mb, int nb, int nnzb, cusparseMatDescr descrA, Pointer bsrSortedValA, Pointer bsrSortedRowPtrA, Pointer bsrSortedColIndA, int rowBlockDimA, int colBlockDimA, cusparseMatDescr descrC, Pointer bsrSortedValC, Pointer bsrSortedRowPtrC, Pointer bsrSortedColIndC, int rowBlockDimC, int colBlockDimC, Pointer pBuffer) {
        return JCusparse.checkResult(JCusparse.cusparseSgebsr2gebsrNative(handle, dirA, mb, nb, nnzb, descrA, bsrSortedValA, bsrSortedRowPtrA, bsrSortedColIndA, rowBlockDimA, colBlockDimA, descrC, bsrSortedValC, bsrSortedRowPtrC, bsrSortedColIndC, rowBlockDimC, colBlockDimC, pBuffer));
    }

    private static native int cusparseSgebsr2gebsrNative(cusparseHandle var0, int var1, int var2, int var3, int var4, cusparseMatDescr var5, Pointer var6, Pointer var7, Pointer var8, int var9, int var10, cusparseMatDescr var11, Pointer var12, Pointer var13, Pointer var14, int var15, int var16, Pointer var17);

    public static int cusparseDgebsr2gebsr(cusparseHandle handle, int dirA, int mb, int nb, int nnzb, cusparseMatDescr descrA, Pointer bsrSortedValA, Pointer bsrSortedRowPtrA, Pointer bsrSortedColIndA, int rowBlockDimA, int colBlockDimA, cusparseMatDescr descrC, Pointer bsrSortedValC, Pointer bsrSortedRowPtrC, Pointer bsrSortedColIndC, int rowBlockDimC, int colBlockDimC, Pointer pBuffer) {
        return JCusparse.checkResult(JCusparse.cusparseDgebsr2gebsrNative(handle, dirA, mb, nb, nnzb, descrA, bsrSortedValA, bsrSortedRowPtrA, bsrSortedColIndA, rowBlockDimA, colBlockDimA, descrC, bsrSortedValC, bsrSortedRowPtrC, bsrSortedColIndC, rowBlockDimC, colBlockDimC, pBuffer));
    }

    private static native int cusparseDgebsr2gebsrNative(cusparseHandle var0, int var1, int var2, int var3, int var4, cusparseMatDescr var5, Pointer var6, Pointer var7, Pointer var8, int var9, int var10, cusparseMatDescr var11, Pointer var12, Pointer var13, Pointer var14, int var15, int var16, Pointer var17);

    public static int cusparseCgebsr2gebsr(cusparseHandle handle, int dirA, int mb, int nb, int nnzb, cusparseMatDescr descrA, Pointer bsrSortedValA, Pointer bsrSortedRowPtrA, Pointer bsrSortedColIndA, int rowBlockDimA, int colBlockDimA, cusparseMatDescr descrC, Pointer bsrSortedValC, Pointer bsrSortedRowPtrC, Pointer bsrSortedColIndC, int rowBlockDimC, int colBlockDimC, Pointer pBuffer) {
        return JCusparse.checkResult(JCusparse.cusparseCgebsr2gebsrNative(handle, dirA, mb, nb, nnzb, descrA, bsrSortedValA, bsrSortedRowPtrA, bsrSortedColIndA, rowBlockDimA, colBlockDimA, descrC, bsrSortedValC, bsrSortedRowPtrC, bsrSortedColIndC, rowBlockDimC, colBlockDimC, pBuffer));
    }

    private static native int cusparseCgebsr2gebsrNative(cusparseHandle var0, int var1, int var2, int var3, int var4, cusparseMatDescr var5, Pointer var6, Pointer var7, Pointer var8, int var9, int var10, cusparseMatDescr var11, Pointer var12, Pointer var13, Pointer var14, int var15, int var16, Pointer var17);

    public static int cusparseZgebsr2gebsr(cusparseHandle handle, int dirA, int mb, int nb, int nnzb, cusparseMatDescr descrA, Pointer bsrSortedValA, Pointer bsrSortedRowPtrA, Pointer bsrSortedColIndA, int rowBlockDimA, int colBlockDimA, cusparseMatDescr descrC, Pointer bsrSortedValC, Pointer bsrSortedRowPtrC, Pointer bsrSortedColIndC, int rowBlockDimC, int colBlockDimC, Pointer pBuffer) {
        return JCusparse.checkResult(JCusparse.cusparseZgebsr2gebsrNative(handle, dirA, mb, nb, nnzb, descrA, bsrSortedValA, bsrSortedRowPtrA, bsrSortedColIndA, rowBlockDimA, colBlockDimA, descrC, bsrSortedValC, bsrSortedRowPtrC, bsrSortedColIndC, rowBlockDimC, colBlockDimC, pBuffer));
    }

    private static native int cusparseZgebsr2gebsrNative(cusparseHandle var0, int var1, int var2, int var3, int var4, cusparseMatDescr var5, Pointer var6, Pointer var7, Pointer var8, int var9, int var10, cusparseMatDescr var11, Pointer var12, Pointer var13, Pointer var14, int var15, int var16, Pointer var17);

    public static int cusparseCreateIdentityPermutation(cusparseHandle handle, int n, Pointer p) {
        return JCusparse.checkResult(JCusparse.cusparseCreateIdentityPermutationNative(handle, n, p));
    }

    private static native int cusparseCreateIdentityPermutationNative(cusparseHandle var0, int var1, Pointer var2);

    public static int cusparseXcoosort_bufferSizeExt(cusparseHandle handle, int m, int n, int nnz, Pointer cooRowsA, Pointer cooColsA, int[] pBufferSizeInBytes) {
        return JCusparse.checkResult(JCusparse.cusparseXcoosort_bufferSizeExtNative(handle, m, n, nnz, cooRowsA, cooColsA, pBufferSizeInBytes));
    }

    private static native int cusparseXcoosort_bufferSizeExtNative(cusparseHandle var0, int var1, int var2, int var3, Pointer var4, Pointer var5, int[] var6);

    public static int cusparseXcoosortByRow(cusparseHandle handle, int m, int n, int nnz, Pointer cooRowsA, Pointer cooColsA, Pointer P, Pointer pBuffer) {
        return JCusparse.checkResult(JCusparse.cusparseXcoosortByRowNative(handle, m, n, nnz, cooRowsA, cooColsA, P, pBuffer));
    }

    private static native int cusparseXcoosortByRowNative(cusparseHandle var0, int var1, int var2, int var3, Pointer var4, Pointer var5, Pointer var6, Pointer var7);

    public static int cusparseXcoosortByColumn(cusparseHandle handle, int m, int n, int nnz, Pointer cooRowsA, Pointer cooColsA, Pointer P, Pointer pBuffer) {
        return JCusparse.checkResult(JCusparse.cusparseXcoosortByColumnNative(handle, m, n, nnz, cooRowsA, cooColsA, P, pBuffer));
    }

    private static native int cusparseXcoosortByColumnNative(cusparseHandle var0, int var1, int var2, int var3, Pointer var4, Pointer var5, Pointer var6, Pointer var7);

    public static int cusparseXcsrsort_bufferSizeExt(cusparseHandle handle, int m, int n, int nnz, Pointer csrRowPtrA, Pointer csrColIndA, int[] pBufferSizeInBytes) {
        return JCusparse.checkResult(JCusparse.cusparseXcsrsort_bufferSizeExtNative(handle, m, n, nnz, csrRowPtrA, csrColIndA, pBufferSizeInBytes));
    }

    private static native int cusparseXcsrsort_bufferSizeExtNative(cusparseHandle var0, int var1, int var2, int var3, Pointer var4, Pointer var5, int[] var6);

    public static int cusparseXcsrsort(cusparseHandle handle, int m, int n, int nnz, cusparseMatDescr descrA, Pointer csrRowPtrA, Pointer csrColIndA, Pointer P, Pointer pBuffer) {
        return JCusparse.checkResult(JCusparse.cusparseXcsrsortNative(handle, m, n, nnz, descrA, csrRowPtrA, csrColIndA, P, pBuffer));
    }

    private static native int cusparseXcsrsortNative(cusparseHandle var0, int var1, int var2, int var3, cusparseMatDescr var4, Pointer var5, Pointer var6, Pointer var7, Pointer var8);

    public static int cusparseXcscsort_bufferSizeExt(cusparseHandle handle, int m, int n, int nnz, Pointer cscColPtrA, Pointer cscRowIndA, int[] pBufferSizeInBytes) {
        return JCusparse.checkResult(JCusparse.cusparseXcscsort_bufferSizeExtNative(handle, m, n, nnz, cscColPtrA, cscRowIndA, pBufferSizeInBytes));
    }

    private static native int cusparseXcscsort_bufferSizeExtNative(cusparseHandle var0, int var1, int var2, int var3, Pointer var4, Pointer var5, int[] var6);

    public static int cusparseXcscsort(cusparseHandle handle, int m, int n, int nnz, cusparseMatDescr descrA, Pointer cscColPtrA, Pointer cscRowIndA, Pointer P, Pointer pBuffer) {
        return JCusparse.checkResult(JCusparse.cusparseXcscsortNative(handle, m, n, nnz, descrA, cscColPtrA, cscRowIndA, P, pBuffer));
    }

    private static native int cusparseXcscsortNative(cusparseHandle var0, int var1, int var2, int var3, cusparseMatDescr var4, Pointer var5, Pointer var6, Pointer var7, Pointer var8);

    public static int cusparseScsru2csr_bufferSizeExt(cusparseHandle handle, int m, int n, int nnz, Pointer csrVal, Pointer csrRowPtr, Pointer csrColInd, csru2csrInfo info, int[] pBufferSizeInBytes) {
        return JCusparse.checkResult(JCusparse.cusparseScsru2csr_bufferSizeExtNative(handle, m, n, nnz, csrVal, csrRowPtr, csrColInd, info, pBufferSizeInBytes));
    }

    private static native int cusparseScsru2csr_bufferSizeExtNative(cusparseHandle var0, int var1, int var2, int var3, Pointer var4, Pointer var5, Pointer var6, csru2csrInfo var7, int[] var8);

    public static int cusparseDcsru2csr_bufferSizeExt(cusparseHandle handle, int m, int n, int nnz, Pointer csrVal, Pointer csrRowPtr, Pointer csrColInd, csru2csrInfo info, int[] pBufferSizeInBytes) {
        return JCusparse.checkResult(JCusparse.cusparseDcsru2csr_bufferSizeExtNative(handle, m, n, nnz, csrVal, csrRowPtr, csrColInd, info, pBufferSizeInBytes));
    }

    private static native int cusparseDcsru2csr_bufferSizeExtNative(cusparseHandle var0, int var1, int var2, int var3, Pointer var4, Pointer var5, Pointer var6, csru2csrInfo var7, int[] var8);

    public static int cusparseCcsru2csr_bufferSizeExt(cusparseHandle handle, int m, int n, int nnz, Pointer csrVal, Pointer csrRowPtr, Pointer csrColInd, csru2csrInfo info, int[] pBufferSizeInBytes) {
        return JCusparse.checkResult(JCusparse.cusparseCcsru2csr_bufferSizeExtNative(handle, m, n, nnz, csrVal, csrRowPtr, csrColInd, info, pBufferSizeInBytes));
    }

    private static native int cusparseCcsru2csr_bufferSizeExtNative(cusparseHandle var0, int var1, int var2, int var3, Pointer var4, Pointer var5, Pointer var6, csru2csrInfo var7, int[] var8);

    public static int cusparseZcsru2csr_bufferSizeExt(cusparseHandle handle, int m, int n, int nnz, Pointer csrVal, Pointer csrRowPtr, Pointer csrColInd, csru2csrInfo info, int[] pBufferSizeInBytes) {
        return JCusparse.checkResult(JCusparse.cusparseZcsru2csr_bufferSizeExtNative(handle, m, n, nnz, csrVal, csrRowPtr, csrColInd, info, pBufferSizeInBytes));
    }

    private static native int cusparseZcsru2csr_bufferSizeExtNative(cusparseHandle var0, int var1, int var2, int var3, Pointer var4, Pointer var5, Pointer var6, csru2csrInfo var7, int[] var8);

    public static int cusparseScsru2csr(cusparseHandle handle, int m, int n, int nnz, cusparseMatDescr descrA, Pointer csrVal, Pointer csrRowPtr, Pointer csrColInd, csru2csrInfo info, Pointer pBuffer) {
        return JCusparse.checkResult(JCusparse.cusparseScsru2csrNative(handle, m, n, nnz, descrA, csrVal, csrRowPtr, csrColInd, info, pBuffer));
    }

    private static native int cusparseScsru2csrNative(cusparseHandle var0, int var1, int var2, int var3, cusparseMatDescr var4, Pointer var5, Pointer var6, Pointer var7, csru2csrInfo var8, Pointer var9);

    public static int cusparseDcsru2csr(cusparseHandle handle, int m, int n, int nnz, cusparseMatDescr descrA, Pointer csrVal, Pointer csrRowPtr, Pointer csrColInd, csru2csrInfo info, Pointer pBuffer) {
        return JCusparse.checkResult(JCusparse.cusparseDcsru2csrNative(handle, m, n, nnz, descrA, csrVal, csrRowPtr, csrColInd, info, pBuffer));
    }

    private static native int cusparseDcsru2csrNative(cusparseHandle var0, int var1, int var2, int var3, cusparseMatDescr var4, Pointer var5, Pointer var6, Pointer var7, csru2csrInfo var8, Pointer var9);

    public static int cusparseCcsru2csr(cusparseHandle handle, int m, int n, int nnz, cusparseMatDescr descrA, Pointer csrVal, Pointer csrRowPtr, Pointer csrColInd, csru2csrInfo info, Pointer pBuffer) {
        return JCusparse.checkResult(JCusparse.cusparseCcsru2csrNative(handle, m, n, nnz, descrA, csrVal, csrRowPtr, csrColInd, info, pBuffer));
    }

    private static native int cusparseCcsru2csrNative(cusparseHandle var0, int var1, int var2, int var3, cusparseMatDescr var4, Pointer var5, Pointer var6, Pointer var7, csru2csrInfo var8, Pointer var9);

    public static int cusparseZcsru2csr(cusparseHandle handle, int m, int n, int nnz, cusparseMatDescr descrA, Pointer csrVal, Pointer csrRowPtr, Pointer csrColInd, csru2csrInfo info, Pointer pBuffer) {
        return JCusparse.checkResult(JCusparse.cusparseZcsru2csrNative(handle, m, n, nnz, descrA, csrVal, csrRowPtr, csrColInd, info, pBuffer));
    }

    private static native int cusparseZcsru2csrNative(cusparseHandle var0, int var1, int var2, int var3, cusparseMatDescr var4, Pointer var5, Pointer var6, Pointer var7, csru2csrInfo var8, Pointer var9);

    public static int cusparseScsr2csru(cusparseHandle handle, int m, int n, int nnz, cusparseMatDescr descrA, Pointer csrVal, Pointer csrRowPtr, Pointer csrColInd, csru2csrInfo info, Pointer pBuffer) {
        return JCusparse.checkResult(JCusparse.cusparseScsr2csruNative(handle, m, n, nnz, descrA, csrVal, csrRowPtr, csrColInd, info, pBuffer));
    }

    private static native int cusparseScsr2csruNative(cusparseHandle var0, int var1, int var2, int var3, cusparseMatDescr var4, Pointer var5, Pointer var6, Pointer var7, csru2csrInfo var8, Pointer var9);

    public static int cusparseDcsr2csru(cusparseHandle handle, int m, int n, int nnz, cusparseMatDescr descrA, Pointer csrVal, Pointer csrRowPtr, Pointer csrColInd, csru2csrInfo info, Pointer pBuffer) {
        return JCusparse.checkResult(JCusparse.cusparseDcsr2csruNative(handle, m, n, nnz, descrA, csrVal, csrRowPtr, csrColInd, info, pBuffer));
    }

    private static native int cusparseDcsr2csruNative(cusparseHandle var0, int var1, int var2, int var3, cusparseMatDescr var4, Pointer var5, Pointer var6, Pointer var7, csru2csrInfo var8, Pointer var9);

    public static int cusparseCcsr2csru(cusparseHandle handle, int m, int n, int nnz, cusparseMatDescr descrA, Pointer csrVal, Pointer csrRowPtr, Pointer csrColInd, csru2csrInfo info, Pointer pBuffer) {
        return JCusparse.checkResult(JCusparse.cusparseCcsr2csruNative(handle, m, n, nnz, descrA, csrVal, csrRowPtr, csrColInd, info, pBuffer));
    }

    private static native int cusparseCcsr2csruNative(cusparseHandle var0, int var1, int var2, int var3, cusparseMatDescr var4, Pointer var5, Pointer var6, Pointer var7, csru2csrInfo var8, Pointer var9);

    public static int cusparseZcsr2csru(cusparseHandle handle, int m, int n, int nnz, cusparseMatDescr descrA, Pointer csrVal, Pointer csrRowPtr, Pointer csrColInd, csru2csrInfo info, Pointer pBuffer) {
        return JCusparse.checkResult(JCusparse.cusparseZcsr2csruNative(handle, m, n, nnz, descrA, csrVal, csrRowPtr, csrColInd, info, pBuffer));
    }

    private static native int cusparseZcsr2csruNative(cusparseHandle var0, int var1, int var2, int var3, cusparseMatDescr var4, Pointer var5, Pointer var6, Pointer var7, csru2csrInfo var8, Pointer var9);

    static {
        JCusparse.initialize();
    }
}

