/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.utils;

import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.sysml.runtime.DMLRuntimeException;

public class LRUCacheMap<K, V>
extends LinkedHashMap<K, V> {
    private static final long serialVersionUID = 7078404374799241418L;
    private boolean evictLRU = false;
    private Map.Entry<K, V> lastEvictedEntry = null;

    public LRUCacheMap() {
        super(16, 0.75f, true);
    }

    public Map.Entry<K, V> removeAndGetLRUEntry() throws DMLRuntimeException {
        this.lastEvictedEntry = null;
        if (this.size() <= 0) {
            return null;
        }
        this.evictLRU = true;
        Object previous = super.put(null, null);
        this.remove(null);
        if (previous != null) {
            throw new DMLRuntimeException("ERROR : Internal state of LRUCacheMap invalid - a value for the key 'null' is already present");
        }
        this.evictLRU = false;
        Map.Entry<K, V> toRet = this.lastEvictedEntry;
        return toRet;
    }

    @Override
    protected boolean removeEldestEntry(Map.Entry<K, V> eldest) {
        if (this.evictLRU) {
            this.lastEvictedEntry = eldest;
            return true;
        }
        return false;
    }

    @Override
    public V put(K k, V v) {
        if (k == null) {
            throw new IllegalArgumentException("ERROR: an entry with a null key was tried to be inserted in to the LRUCacheMap");
        }
        return super.put(k, v);
    }
}

