/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.scripts.algorithms;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.apache.sysml.api.mlcontext.MLResults;
import org.apache.sysml.api.mlcontext.Matrix;
import org.apache.sysml.api.mlcontext.Script;
import org.apache.sysml.scripts.algorithms.steplinearregds.Linear_regression_output;

public class StepLinearRegDS
extends Script {
    public StepLinearRegDS() {
        String string = "scripts/algorithms/StepLinearRegDS.dml";
        InputStream inputStream = Script.class.getResourceAsStream(new StringBuffer().append("/").append(string).toString());
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
        char[] cArray = new char[1024];
        StringBuilder stringBuilder = new StringBuilder();
        try {
            int n;
            while ((n = inputStreamReader.read(cArray)) > 0) {
                stringBuilder.append(cArray, 0, n);
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        this.setScriptString(stringBuilder.toString());
    }

    public Matrix reorder_matrix(Object object, Object object2, Object object3) {
        String string = "source('scripts/algorithms/StepLinearRegDS.dml') as mlcontextns;Y = mlcontextns::reorder_matrix(ncolX, B, S);";
        Script script = new Script(string);
        script.in("ncolX", object).in("B", object2).in("S", object3).out("Y");
        MLResults mLResults = script.execute();
        Matrix matrix = mLResults.getMatrix("Y");
        return matrix;
    }

    public String reorder_matrix__docs() {
        String string = "reorder_matrix = function(\n  double ncolX, # number of column in X, inlcuding the intercept column\n  matrix[double] B, # beta\n  matrix[double] S  # Selected\n) return (matrix[double] Y) {\n  # This function assumes that B and S have same number of elements.\n  # if the intercept is included in the model, all inputs should be adjusted\n  # appropriately before calling this function.\n\n  S = t(S);\n  num_empty_B = ncolX - nrow(B);\n  if (num_empty_B < 0) {\n    stop(\"Error: unable to re-order the matrix. Reason: B more than matrix X\");\n  }\n\n  if (num_empty_B > 0) {\n    pad_zeros = matrix(0, rows = num_empty_B, cols=1);\n    B = rbind(B, pad_zeros);\n    S = rbind(S, pad_zeros);\n  }\n\n  # since the table won't accept zeros as index we hack it.\n  S0 = replace(target = S, pattern = 0, replacement = ncolX+1);\n  seqS = seq(1, nrow(S0));\n  P = table(seqS, S0, ncolX, ncolX);\n\n  Y = t(P) %*% B;\n}\n";
        return string;
    }

    public String reorder_matrix__source() {
        String string = "reorder_matrix = function(\n  double ncolX, # number of column in X, inlcuding the intercept column\n  matrix[double] B, # beta\n  matrix[double] S  # Selected\n) return (matrix[double] Y) {\n  # This function assumes that B and S have same number of elements.\n  # if the intercept is included in the model, all inputs should be adjusted\n  # appropriately before calling this function.\n\n  S = t(S);\n  num_empty_B = ncolX - nrow(B);\n  if (num_empty_B < 0) {\n    stop(\"Error: unable to re-order the matrix. Reason: B more than matrix X\");\n  }\n\n  if (num_empty_B > 0) {\n    pad_zeros = matrix(0, rows = num_empty_B, cols=1);\n    B = rbind(B, pad_zeros);\n    S = rbind(S, pad_zeros);\n  }\n\n  # since the table won't accept zeros as index we hack it.\n  S0 = replace(target = S, pattern = 0, replacement = ncolX+1);\n  seqS = seq(1, nrow(S0));\n  P = table(seqS, S0, ncolX, ncolX);\n\n  Y = t(P) %*% B;\n}\n";
        return string;
    }

    public Linear_regression_output linear_regression(Object object, Object object2, Object object3, Object object4, Object object5, Object object6) {
        String string = "source('scripts/algorithms/StepLinearRegDS.dml') as mlcontextns;[AIC, beta] = mlcontextns::linear_regression(X, y, m_orig, Selected, write_beta, writeStats);";
        Script script = new Script(string);
        script.in("X", object).in("y", object2).in("m_orig", object3).in("Selected", object4).in("write_beta", object5).in("writeStats", object6).out("AIC").out("beta");
        MLResults mLResults = script.execute();
        double d = mLResults.getDouble("AIC");
        Matrix matrix = mLResults.getMatrix("beta");
        Linear_regression_output linear_regression_output = new Linear_regression_output(d, matrix);
        return linear_regression_output;
    }

    public String linear_regression__docs() {
        String string = "linear_regression = function (Matrix[Double] X, Matrix[Double] y, Double m_orig,\n  Matrix[Double] Selected, Boolean write_beta, Boolean writeStats)\n  return (Double AIC, Matrix[Double] beta) {\n\n    intercept_status = ifdef ($icpt, 0);\n    fmt = ifdef ($fmt, \"text\");\n    n = nrow (X);\n    m = ncol (X);\n\n    # Introduce the intercept, shift and rescale the columns of X if needed\n    if (intercept_status == 1 | intercept_status == 2) { # add the intercept column\n      ones_n = matrix (1, rows = n, cols = 1);\n      X = cbind (X, ones_n);\n      m = m - 1;\n    }\n\n    m_ext = ncol(X);\n\n    if (intercept_status == 2) { # scale-&-shift X columns to mean 0, variance 1\n      # Important assumption: X [, m_ext] = ones_n\n      avg_X_cols = t(colSums(X)) / n;\n      var_X_cols = (t(colSums (X ^ 2)) - n * (avg_X_cols ^ 2)) / (n - 1);\n      is_unsafe = (var_X_cols <= 0);\n      scale_X = 1.0 / sqrt (var_X_cols * (1 - is_unsafe) + is_unsafe);\n      scale_X [m_ext, 1] = 1;\n      shift_X = - avg_X_cols * scale_X;\n      shift_X [m_ext, 1] = 0;\n    } else {\n      scale_X = matrix (1, rows = m_ext, cols = 1);\n      shift_X = matrix (0, rows = m_ext, cols = 1);\n    }\n\n    # BEGIN THE DIRECT SOLVE ALGORITHM (EXTERNAL CALL)\n\n    A = t(X) %*% X;\n    b = t(X) %*% y;\n    if (intercept_status == 2) {\n      A = t(diag (scale_X) %*% A + shift_X %*% A [m_ext, ]);\n      A =   diag (scale_X) %*% A + shift_X %*% A [m_ext, ];\n      b =   diag (scale_X) %*% b + shift_X %*% b [m_ext, ];\n    }\n\n    beta_unscaled = solve (A, b);\n\n    # END THE DIRECT SOLVE ALGORITHM\n\n    if (intercept_status == 2) {\n      beta = scale_X * beta_unscaled;\n      beta [m_ext, ] = beta [m_ext, ] + t(shift_X) %*% beta_unscaled;\n    } else {\n      beta = beta_unscaled;\n    }\n\n    # COMPUTE AIC\n    y_residual = y - X %*% beta;\n    ss_res = sum (y_residual ^ 2);\n    eq_deg_of_freedom = m_ext;\n    AIC = (2 * eq_deg_of_freedom) + n * log (ss_res / n);\n\n    if(write_beta == 1) {\n      fileO = ifdef ($O, \" \");\n      fileS = $S;\n\n      print (\"Computing the statistics...\");\n      avg_tot = sum (y) / n;\n      ss_tot = sum (y ^ 2);\n      ss_avg_tot = ss_tot - n * avg_tot ^ 2;\n      var_tot = ss_avg_tot / (n - 1);\n      # y_residual = y - X %*% beta;\n      avg_res = sum (y_residual) / n;\n      # ss_res = sum (y_residual ^ 2);\n      ss_avg_res = ss_res - n * avg_res ^ 2;\n\n      R2 = 1 - ss_res / ss_avg_tot;\n      if (n > m_ext) {\n        dispersion  = ss_res / (n - m_ext);\n        adjusted_R2 = 1 - dispersion / (ss_avg_tot / (n - 1));\n      } else {\n        dispersion  = 0.0 / 0.0;\n        adjusted_R2 = 0.0 / 0.0;\n      }\n\n      R2_nobias = 1 - ss_avg_res / ss_avg_tot;\n      deg_freedom = n - m - 1;\n      if (deg_freedom > 0) {\n        var_res = ss_avg_res / deg_freedom;\n        adjusted_R2_nobias = 1 - var_res / (ss_avg_tot / (n - 1));\n      } else {\n        var_res = 0.0 / 0.0;\n        adjusted_R2_nobias = 0.0 / 0.0;\n        print (\"Warning: zero or negative number of degrees of freedom.\");\n      }\n\n      R2_vs_0 = 1 - ss_res / ss_tot;\n      if (n > m) {\n        adjusted_R2_vs_0 = 1 - (ss_res / (n - m)) / (ss_tot / n);\n      } else {\n        adjusted_R2_vs_0 = 0.0 / 0.0;\n      }\n\n      str = \"AVG_TOT_Y,\" + avg_tot;                                    #  Average of the response value Y\n      str = append (str, \"STDEV_TOT_Y,\" + sqrt (var_tot));             #  Standard Deviation of the response value Y\n      str = append (str, \"AVG_RES_Y,\" + avg_res);                      #  Average of the residual Y - pred(Y|X), i.e. residual bias\n      str = append (str, \"STDEV_RES_Y,\" + sqrt (var_res));             #  Standard Deviation of the residual Y - pred(Y|X)\n      str = append (str, \"DISPERSION,\" + dispersion);                  #  GLM-style dispersion, i.e. residual sum of squares / # d.f.\n      str = append (str, \"R2,\" + R2);                                  #  R^2 of residual with bias included vs. total average\n      str = append (str, \"ADJUSTED_R2,\" + adjusted_R2);                #  Adjusted R^2 of residual with bias included vs. total average\n      str = append (str, \"R2_NOBIAS,\" + R2_nobias);                    #  R^2 of residual with bias subtracted vs. total average\n      str = append (str, \"ADJUSTED_R2_NOBIAS,\" + adjusted_R2_nobias);  #  Adjusted R^2 of residual with bias subtracted vs. total average\n      if (intercept_status == 0) {\n        str = append (str, \"R2_VS_0,\" + R2_vs_0);                      #  R^2 of residual with bias included vs. zero constant\n        str = append (str, \"ADJUSTED_R2_VS_0,\" + adjusted_R2_vs_0);    #  Adjusted R^2 of residual with bias included vs. zero constant\n      }\n\n      if (fileO != \" \" & writeStats != 0) {\n        write(str, fileO);\n      } else {\n        print (str);\n        print (\"\");\n      }\n\n      # TODO IMP NOTE: with the fix in PR-22, we have not accounted for \n      # intercept=2 and # the code before # was not matching so we have removed it\n      # for now. Pl see the git revision history and diff to see the changes.\n      # in future we will have this feature. For now it is disabled\n    }\n  }\n";
        return string;
    }

    public String linear_regression__source() {
        String string = "linear_regression = function (Matrix[Double] X, Matrix[Double] y, Double m_orig,\n  Matrix[Double] Selected, Boolean write_beta, Boolean writeStats)\n  return (Double AIC, Matrix[Double] beta) {\n\n    intercept_status = ifdef ($icpt, 0);\n    fmt = ifdef ($fmt, \"text\");\n    n = nrow (X);\n    m = ncol (X);\n\n    # Introduce the intercept, shift and rescale the columns of X if needed\n    if (intercept_status == 1 | intercept_status == 2) { # add the intercept column\n      ones_n = matrix (1, rows = n, cols = 1);\n      X = cbind (X, ones_n);\n      m = m - 1;\n    }\n\n    m_ext = ncol(X);\n\n    if (intercept_status == 2) { # scale-&-shift X columns to mean 0, variance 1\n      # Important assumption: X [, m_ext] = ones_n\n      avg_X_cols = t(colSums(X)) / n;\n      var_X_cols = (t(colSums (X ^ 2)) - n * (avg_X_cols ^ 2)) / (n - 1);\n      is_unsafe = (var_X_cols <= 0);\n      scale_X = 1.0 / sqrt (var_X_cols * (1 - is_unsafe) + is_unsafe);\n      scale_X [m_ext, 1] = 1;\n      shift_X = - avg_X_cols * scale_X;\n      shift_X [m_ext, 1] = 0;\n    } else {\n      scale_X = matrix (1, rows = m_ext, cols = 1);\n      shift_X = matrix (0, rows = m_ext, cols = 1);\n    }\n\n    # BEGIN THE DIRECT SOLVE ALGORITHM (EXTERNAL CALL)\n\n    A = t(X) %*% X;\n    b = t(X) %*% y;\n    if (intercept_status == 2) {\n      A = t(diag (scale_X) %*% A + shift_X %*% A [m_ext, ]);\n      A =   diag (scale_X) %*% A + shift_X %*% A [m_ext, ];\n      b =   diag (scale_X) %*% b + shift_X %*% b [m_ext, ];\n    }\n\n    beta_unscaled = solve (A, b);\n\n    # END THE DIRECT SOLVE ALGORITHM\n\n    if (intercept_status == 2) {\n      beta = scale_X * beta_unscaled;\n      beta [m_ext, ] = beta [m_ext, ] + t(shift_X) %*% beta_unscaled;\n    } else {\n      beta = beta_unscaled;\n    }\n\n    # COMPUTE AIC\n    y_residual = y - X %*% beta;\n    ss_res = sum (y_residual ^ 2);\n    eq_deg_of_freedom = m_ext;\n    AIC = (2 * eq_deg_of_freedom) + n * log (ss_res / n);\n\n    if(write_beta == 1) {\n      fileO = ifdef ($O, \" \");\n      fileS = $S;\n\n      print (\"Computing the statistics...\");\n      avg_tot = sum (y) / n;\n      ss_tot = sum (y ^ 2);\n      ss_avg_tot = ss_tot - n * avg_tot ^ 2;\n      var_tot = ss_avg_tot / (n - 1);\n      # y_residual = y - X %*% beta;\n      avg_res = sum (y_residual) / n;\n      # ss_res = sum (y_residual ^ 2);\n      ss_avg_res = ss_res - n * avg_res ^ 2;\n\n      R2 = 1 - ss_res / ss_avg_tot;\n      if (n > m_ext) {\n        dispersion  = ss_res / (n - m_ext);\n        adjusted_R2 = 1 - dispersion / (ss_avg_tot / (n - 1));\n      } else {\n        dispersion  = 0.0 / 0.0;\n        adjusted_R2 = 0.0 / 0.0;\n      }\n\n      R2_nobias = 1 - ss_avg_res / ss_avg_tot;\n      deg_freedom = n - m - 1;\n      if (deg_freedom > 0) {\n        var_res = ss_avg_res / deg_freedom;\n        adjusted_R2_nobias = 1 - var_res / (ss_avg_tot / (n - 1));\n      } else {\n        var_res = 0.0 / 0.0;\n        adjusted_R2_nobias = 0.0 / 0.0;\n        print (\"Warning: zero or negative number of degrees of freedom.\");\n      }\n\n      R2_vs_0 = 1 - ss_res / ss_tot;\n      if (n > m) {\n        adjusted_R2_vs_0 = 1 - (ss_res / (n - m)) / (ss_tot / n);\n      } else {\n        adjusted_R2_vs_0 = 0.0 / 0.0;\n      }\n\n      str = \"AVG_TOT_Y,\" + avg_tot;                                    #  Average of the response value Y\n      str = append (str, \"STDEV_TOT_Y,\" + sqrt (var_tot));             #  Standard Deviation of the response value Y\n      str = append (str, \"AVG_RES_Y,\" + avg_res);                      #  Average of the residual Y - pred(Y|X), i.e. residual bias\n      str = append (str, \"STDEV_RES_Y,\" + sqrt (var_res));             #  Standard Deviation of the residual Y - pred(Y|X)\n      str = append (str, \"DISPERSION,\" + dispersion);                  #  GLM-style dispersion, i.e. residual sum of squares / # d.f.\n      str = append (str, \"R2,\" + R2);                                  #  R^2 of residual with bias included vs. total average\n      str = append (str, \"ADJUSTED_R2,\" + adjusted_R2);                #  Adjusted R^2 of residual with bias included vs. total average\n      str = append (str, \"R2_NOBIAS,\" + R2_nobias);                    #  R^2 of residual with bias subtracted vs. total average\n      str = append (str, \"ADJUSTED_R2_NOBIAS,\" + adjusted_R2_nobias);  #  Adjusted R^2 of residual with bias subtracted vs. total average\n      if (intercept_status == 0) {\n        str = append (str, \"R2_VS_0,\" + R2_vs_0);                      #  R^2 of residual with bias included vs. zero constant\n        str = append (str, \"ADJUSTED_R2_VS_0,\" + adjusted_R2_vs_0);    #  Adjusted R^2 of residual with bias included vs. zero constant\n      }\n\n      if (fileO != \" \" & writeStats != 0) {\n        write(str, fileO);\n      } else {\n        print (str);\n        print (\"\");\n      }\n\n      # TODO IMP NOTE: with the fix in PR-22, we have not accounted for \n      # intercept=2 and # the code before # was not matching so we have removed it\n      # for now. Pl see the git revision history and diff to see the changes.\n      # in future we will have this feature. For now it is disabled\n    }\n  }\n";
        return string;
    }
}

