/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.matrix.data;

import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.sysml.runtime.matrix.data.Converter;
import org.apache.sysml.runtime.matrix.data.MatrixCell;
import org.apache.sysml.runtime.matrix.data.MatrixIndexes;
import org.apache.sysml.runtime.matrix.data.Pair;
import org.apache.sysml.runtime.util.FastStringTokenizer;

public class TextToBinaryCellConverter
implements Converter<LongWritable, Text, MatrixIndexes, MatrixCell> {
    private MatrixIndexes indexes = new MatrixIndexes();
    private MatrixCell value = new MatrixCell();
    private Pair<MatrixIndexes, MatrixCell> pair = new Pair<MatrixIndexes, MatrixCell>(this.indexes, this.value);
    private FastStringTokenizer st = new FastStringTokenizer(' ');
    private boolean hasValue = false;
    private boolean toIgnore = false;

    @Override
    public void convert(LongWritable k1, Text v1) {
        String str = v1.toString();
        if (str.startsWith("%")) {
            if (str.startsWith("%%")) {
                this.toIgnore = true;
            }
            this.hasValue = false;
            return;
        }
        if (this.toIgnore) {
            this.toIgnore = false;
            this.hasValue = false;
            return;
        }
        this.st.reset(str);
        this.indexes.setIndexes(this.st.nextLong(), this.st.nextLong());
        this.value.setValue(this.st.nextDouble());
        this.hasValue = true;
    }

    @Override
    public boolean hasNext() {
        return this.hasValue;
    }

    @Override
    public Pair<MatrixIndexes, MatrixCell> next() {
        if (!this.hasValue) {
            return null;
        }
        this.hasValue = false;
        return this.pair;
    }

    @Override
    public void setBlockSize(int rl, int cl) {
    }
}

