/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.matrix.data;

import java.io.Serializable;
import org.apache.hadoop.io.DoubleWritable;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapred.OutputFormat;
import org.apache.hadoop.mapred.SequenceFileOutputFormat;
import org.apache.hadoop.mapred.TextOutputFormat;
import org.apache.sysml.runtime.DMLRuntimeException;
import org.apache.sysml.runtime.matrix.data.FrameBlock;
import org.apache.sysml.runtime.matrix.data.InputInfo;
import org.apache.sysml.runtime.matrix.data.MatrixBlock;
import org.apache.sysml.runtime.matrix.data.MatrixCell;
import org.apache.sysml.runtime.matrix.data.MatrixIndexes;
import org.apache.sysml.runtime.matrix.data.UnPaddedOutputFormat;
import org.apache.sysml.runtime.matrix.data.WeightedPair;
import org.apache.sysml.runtime.matrix.mapred.CSVWriteReducer;
import org.apache.sysml.runtime.matrix.sort.CompactOutputFormat;

public class OutputInfo
implements Serializable {
    private static final long serialVersionUID = -3115943514779675817L;
    public Class<? extends OutputFormat> outputFormatClass;
    public Class<? extends Writable> outputKeyClass;
    public Class<? extends Writable> outputValueClass;
    public static final OutputInfo TextCellOutputInfo = new OutputInfo(TextOutputFormat.class, NullWritable.class, Text.class);
    public static final OutputInfo MatrixMarketOutputInfo = new OutputInfo(TextOutputFormat.class, NullWritable.class, Text.class);
    public static final OutputInfo BinaryCellOutputInfo = new OutputInfo(SequenceFileOutputFormat.class, MatrixIndexes.class, MatrixCell.class);
    public static final OutputInfo BinaryBlockOutputInfo = new OutputInfo(SequenceFileOutputFormat.class, MatrixIndexes.class, MatrixBlock.class);
    public static final OutputInfo BinaryBlockFrameOutputInfo = new OutputInfo(SequenceFileOutputFormat.class, LongWritable.class, FrameBlock.class);
    public static final OutputInfo OutputInfoForSortInput = new OutputInfo(SequenceFileOutputFormat.class, DoubleWritable.class, IntWritable.class);
    public static final OutputInfo OutputInfoForSortOutput = new OutputInfo(CompactOutputFormat.class, DoubleWritable.class, IntWritable.class);
    public static final OutputInfo WeightedPairOutputInfo = new OutputInfo(SequenceFileOutputFormat.class, MatrixIndexes.class, WeightedPair.class);
    public static final OutputInfo CSVOutputInfo = new OutputInfo(UnPaddedOutputFormat.class, NullWritable.class, CSVWriteReducer.RowBlockForTextOutput.class);

    public OutputInfo(Class<? extends OutputFormat> formatCls, Class<? extends Writable> keyCls, Class<? extends Writable> valueCls) {
        this.outputFormatClass = formatCls;
        this.outputKeyClass = keyCls;
        this.outputValueClass = valueCls;
    }

    public static InputInfo getMatchingInputInfo(OutputInfo oi) throws DMLRuntimeException {
        if (oi == BinaryBlockOutputInfo) {
            return InputInfo.BinaryBlockInputInfo;
        }
        if (oi == MatrixMarketOutputInfo) {
            return InputInfo.MatrixMarketInputInfo;
        }
        if (oi == BinaryCellOutputInfo) {
            return InputInfo.BinaryCellInputInfo;
        }
        if (oi == TextCellOutputInfo) {
            return InputInfo.TextCellInputInfo;
        }
        if (oi == OutputInfoForSortInput) {
            return InputInfo.InputInfoForSort;
        }
        if (oi == OutputInfoForSortOutput) {
            return InputInfo.InputInfoForSortOutput;
        }
        if (oi == WeightedPairOutputInfo) {
            return InputInfo.WeightedPairInputInfo;
        }
        if (oi == CSVOutputInfo) {
            return InputInfo.CSVInputInfo;
        }
        throw new DMLRuntimeException("Unrecognized output info: " + oi);
    }

    public static OutputInfo stringToOutputInfo(String str) {
        if (str.equalsIgnoreCase("textcell")) {
            return TextCellOutputInfo;
        }
        if (str.equalsIgnoreCase("matrixmarket")) {
            return MatrixMarketOutputInfo;
        }
        if (str.equalsIgnoreCase("binarycell")) {
            return BinaryCellOutputInfo;
        }
        if (str.equalsIgnoreCase("binaryblock")) {
            return BinaryBlockOutputInfo;
        }
        if (str.equalsIgnoreCase("sort_input")) {
            return OutputInfoForSortInput;
        }
        if (str.equalsIgnoreCase("sort_output")) {
            return OutputInfoForSortOutput;
        }
        if (str.equalsIgnoreCase("weightedpair")) {
            return WeightedPairOutputInfo;
        }
        if (str.equalsIgnoreCase("csv")) {
            return CSVOutputInfo;
        }
        return null;
    }

    public static String outputInfoToString(OutputInfo oi) throws DMLRuntimeException {
        if (oi == TextCellOutputInfo) {
            return "textcell";
        }
        if (oi == MatrixMarketOutputInfo) {
            return "matrixmarket";
        }
        if (oi == BinaryCellOutputInfo) {
            return "binarycell";
        }
        if (oi == BinaryBlockOutputInfo) {
            return "binaryblock";
        }
        if (oi == OutputInfoForSortInput) {
            return "sort_input";
        }
        if (oi == OutputInfoForSortOutput) {
            return "sort_output";
        }
        if (oi == WeightedPairOutputInfo) {
            return "weightedpair";
        }
        if (oi == CSVOutputInfo) {
            return "csv";
        }
        throw new DMLRuntimeException("Unrecognized outputInfo: " + oi);
    }

    public static String outputInfoToStringExternal(OutputInfo oinfo) {
        if (oinfo == TextCellOutputInfo) {
            return "text";
        }
        if (oinfo == MatrixMarketOutputInfo) {
            return "mm";
        }
        if (oinfo == CSVOutputInfo) {
            return "csv";
        }
        if (oinfo == BinaryBlockOutputInfo || oinfo == BinaryCellOutputInfo) {
            return "binary";
        }
        return "specialized";
    }

    public boolean equals(Object o) {
        if (!(o instanceof OutputInfo)) {
            return false;
        }
        OutputInfo that = (OutputInfo)o;
        return this.outputFormatClass == that.outputFormatClass && this.outputKeyClass == that.outputKeyClass && this.outputValueClass == that.outputValueClass;
    }
}

