/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.matrix.data;

import java.util.Arrays;
import java.util.concurrent.Callable;
import org.apache.sysml.runtime.matrix.data.ConvolutionParameters;

public class LibMatrixDNNPoolingHelper {

    public static class SparseMaxPooling
    implements Callable<Long> {
        public int _rl;
        public int _ru;
        private final ConvolutionParameters _params;
        int HW;
        double[] outputArray;
        int C;
        int P;
        int Q;
        int W;
        boolean isNthRowEmpty = false;
        int apos;
        int alen;
        int[] aix;
        double[] avals;
        int fromIndex = -1;
        int toIndex = -1;

        public SparseMaxPooling(int rl, int ru, ConvolutionParameters params) {
            this._rl = rl;
            this._ru = ru;
            this._params = params;
            this.outputArray = params.output.getDenseBlock();
            this.C = params.C;
            this.P = params.P;
            this.Q = params.Q;
            this.W = params.W;
            this.HW = this._params.H * this._params.W;
        }

        private void getNthSparseRow(int n) {
            if (!this._params.input1.sparseBlock.isEmpty(n)) {
                this.apos = this._params.input1.sparseBlock.pos(n);
                this.alen = this._params.input1.sparseBlock.size(n);
                this.aix = this._params.input1.sparseBlock.indexes(n);
                this.avals = this._params.input1.sparseBlock.values(n);
                this.isNthRowEmpty = false;
            } else {
                this.isNthRowEmpty = true;
            }
        }

        private int setSearchIndex(int from, int searchVal) {
            for (int j = from; j < this.apos + this.alen; ++j) {
                if (this.aix[j] <= searchVal) continue;
                return Math.max(from, j - 1);
            }
            return this.apos + this.alen;
        }

        private double getValue(int col) {
            if (!this.isNthRowEmpty) {
                int index = Arrays.binarySearch(this.aix, this.fromIndex, this.toIndex, col);
                return index > 0 ? this.avals[index] : 0.0;
            }
            return 0.0;
        }

        @Override
        public Long call() throws Exception {
            int CPQ = this.C * this.P * this.Q;
            for (int n = this._rl; n < this._ru; ++n) {
                this.getNthSparseRow(n);
                int out_index = n * CPQ;
                for (int c = 0; c < this.C; ++c) {
                    this.fromIndex = this.setSearchIndex(this.apos, c * this.HW);
                    this.toIndex = Math.min(this.apos + this.alen, this.setSearchIndex(this.fromIndex, (c + 1) * this.HW));
                    for (int p = 0; p < this.P; ++p) {
                        int q = 0;
                        while (q < this.Q) {
                            for (int h = this._params.start_indexes_h[p]; h < this._params.end_indexes_h[p]; ++h) {
                                for (int w = this._params.start_indexes_w[q]; w < this._params.end_indexes_w[q]; ++w) {
                                    this.outputArray[out_index] = Math.max(this.outputArray[out_index], this.getValue(c * this.HW + h * this.W + w));
                                }
                            }
                            ++q;
                            ++out_index;
                        }
                    }
                }
            }
            return 0L;
        }
    }

    public static class DenseMaxPooling
    implements Callable<Long> {
        public int _rl;
        public int _ru;
        private final ConvolutionParameters _params;
        double[] inputArray;
        double[] outputArray;
        int C;
        int P;
        int Q;
        int W;

        public DenseMaxPooling(int rl, int ru, ConvolutionParameters params) {
            this._rl = rl;
            this._ru = ru;
            this._params = params;
            this.inputArray = params.input1.getDenseBlock();
            this.outputArray = params.output.getDenseBlock();
            this.C = params.C;
            this.P = params.P;
            this.Q = params.Q;
            this.W = params.W;
        }

        @Override
        public Long call() throws Exception {
            int HW = this._params.H * this._params.W;
            int CHW = this._params.C * this._params.H * this._params.W;
            int CPQ = this.C * this.P * this.Q;
            for (int n = this._rl; n < this._ru; ++n) {
                int inOffset = n * CHW;
                int out_index = n * CPQ;
                for (int c = 0; c < this.C; ++c) {
                    int inOffset1 = inOffset + c * HW;
                    for (int p = 0; p < this.P; ++p) {
                        int q = 0;
                        while (q < this.Q) {
                            for (int h = this._params.start_indexes_h[p]; h < this._params.end_indexes_h[p]; ++h) {
                                for (int w = this._params.start_indexes_w[q]; w < this._params.end_indexes_w[q]; ++w) {
                                    this.outputArray[out_index] = Math.max(this.outputArray[out_index], this.inputArray[inOffset1 + h * this.W + w]);
                                }
                            }
                            ++q;
                            ++out_index;
                        }
                    }
                }
            }
            return 0L;
        }
    }
}

