/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.matrix;

import java.io.Serializable;
import java.util.HashMap;
import org.apache.sysml.lops.MMTSJ;
import org.apache.sysml.runtime.DMLRuntimeException;
import org.apache.sysml.runtime.instructions.mr.AggregateBinaryInstruction;
import org.apache.sysml.runtime.instructions.mr.AggregateInstruction;
import org.apache.sysml.runtime.instructions.mr.AggregateUnaryInstruction;
import org.apache.sysml.runtime.instructions.mr.AppendInstruction;
import org.apache.sysml.runtime.instructions.mr.BinaryInstruction;
import org.apache.sysml.runtime.instructions.mr.BinaryMInstruction;
import org.apache.sysml.runtime.instructions.mr.BinaryMRInstructionBase;
import org.apache.sysml.runtime.instructions.mr.CM_N_COVInstruction;
import org.apache.sysml.runtime.instructions.mr.CombineBinaryInstruction;
import org.apache.sysml.runtime.instructions.mr.CombineTernaryInstruction;
import org.apache.sysml.runtime.instructions.mr.CombineUnaryInstruction;
import org.apache.sysml.runtime.instructions.mr.CumulativeAggregateInstruction;
import org.apache.sysml.runtime.instructions.mr.DataGenMRInstruction;
import org.apache.sysml.runtime.instructions.mr.GroupedAggregateInstruction;
import org.apache.sysml.runtime.instructions.mr.GroupedAggregateMInstruction;
import org.apache.sysml.runtime.instructions.mr.MMTSJMRInstruction;
import org.apache.sysml.runtime.instructions.mr.MRInstruction;
import org.apache.sysml.runtime.instructions.mr.MapMultChainInstruction;
import org.apache.sysml.runtime.instructions.mr.MatrixReshapeMRInstruction;
import org.apache.sysml.runtime.instructions.mr.PMMJMRInstruction;
import org.apache.sysml.runtime.instructions.mr.ParameterizedBuiltinMRInstruction;
import org.apache.sysml.runtime.instructions.mr.QuaternaryInstruction;
import org.apache.sysml.runtime.instructions.mr.RandInstruction;
import org.apache.sysml.runtime.instructions.mr.RangeBasedReIndexInstruction;
import org.apache.sysml.runtime.instructions.mr.ReblockInstruction;
import org.apache.sysml.runtime.instructions.mr.RemoveEmptyMRInstruction;
import org.apache.sysml.runtime.instructions.mr.ReorgInstruction;
import org.apache.sysml.runtime.instructions.mr.ReplicateInstruction;
import org.apache.sysml.runtime.instructions.mr.ScalarInstruction;
import org.apache.sysml.runtime.instructions.mr.SeqInstruction;
import org.apache.sysml.runtime.instructions.mr.TernaryInstruction;
import org.apache.sysml.runtime.instructions.mr.UaggOuterChainInstruction;
import org.apache.sysml.runtime.instructions.mr.UnaryInstruction;
import org.apache.sysml.runtime.instructions.mr.UnaryMRInstructionBase;
import org.apache.sysml.runtime.instructions.mr.ZeroOutInstruction;
import org.apache.sysml.runtime.matrix.operators.AggregateBinaryOperator;
import org.apache.sysml.runtime.matrix.operators.AggregateUnaryOperator;
import org.apache.sysml.runtime.matrix.operators.ReorgOperator;

public class MatrixCharacteristics
implements Serializable {
    private static final long serialVersionUID = 8300479822915546000L;
    private long numRows = -1L;
    private long numColumns = -1L;
    private int numRowsPerBlock = 1;
    private int numColumnsPerBlock = 1;
    private long nonZero = -1L;

    public MatrixCharacteristics() {
    }

    public MatrixCharacteristics(long nr, long nc, int bnr, int bnc) {
        this.set(nr, nc, bnr, bnc);
    }

    public MatrixCharacteristics(long nr, long nc, int bnr, int bnc, long nnz) {
        this.set(nr, nc, bnr, bnc, nnz);
    }

    public MatrixCharacteristics(MatrixCharacteristics that) {
        this.set(that.numRows, that.numColumns, that.numRowsPerBlock, that.numColumnsPerBlock, that.nonZero);
    }

    public void set(long nr, long nc, int bnr, int bnc) {
        this.numRows = nr;
        this.numColumns = nc;
        this.numRowsPerBlock = bnr;
        this.numColumnsPerBlock = bnc;
    }

    public void set(long nr, long nc, int bnr, int bnc, long nnz) {
        this.numRows = nr;
        this.numColumns = nc;
        this.numRowsPerBlock = bnr;
        this.numColumnsPerBlock = bnc;
        this.nonZero = nnz;
    }

    public void set(MatrixCharacteristics that) {
        this.numRows = that.numRows;
        this.numColumns = that.numColumns;
        this.numRowsPerBlock = that.numRowsPerBlock;
        this.numColumnsPerBlock = that.numColumnsPerBlock;
        this.nonZero = that.nonZero;
    }

    public long getRows() {
        return this.numRows;
    }

    public long getCols() {
        return this.numColumns;
    }

    public int getRowsPerBlock() {
        return this.numRowsPerBlock;
    }

    public void setRowsPerBlock(int brlen) {
        this.numRowsPerBlock = brlen;
    }

    public int getColsPerBlock() {
        return this.numColumnsPerBlock;
    }

    public void setColsPerBlock(int bclen) {
        this.numColumnsPerBlock = bclen;
    }

    public long getNumBlocks() {
        return this.getNumRowBlocks() * this.getNumColBlocks();
    }

    public long getNumRowBlocks() {
        return (long)Math.ceil((double)this.getRows() / (double)this.getRowsPerBlock());
    }

    public long getNumColBlocks() {
        return (long)Math.ceil((double)this.getCols() / (double)this.getColsPerBlock());
    }

    public String toString() {
        return "[" + this.numRows + " x " + this.numColumns + ", nnz=" + this.nonZero + ", blocks (" + this.numRowsPerBlock + " x " + this.numColumnsPerBlock + ")]";
    }

    public void setDimension(long nr, long nc) {
        this.numRows = nr;
        this.numColumns = nc;
    }

    public void setBlockSize(int blen) {
        this.setBlockSize(blen, blen);
    }

    public void setBlockSize(int bnr, int bnc) {
        this.numRowsPerBlock = bnr;
        this.numColumnsPerBlock = bnc;
    }

    public void setNonZeros(long nnz) {
        this.nonZero = nnz;
    }

    public long getNonZeros() {
        return this.nonZero;
    }

    public boolean dimsKnown() {
        return this.numRows > 0L && this.numColumns > 0L;
    }

    public boolean dimsKnown(boolean includeNnz) {
        return this.numRows > 0L && this.numColumns > 0L && (!includeNnz || this.nonZero >= 0L);
    }

    public boolean rowsKnown() {
        return this.numRows > 0L;
    }

    public boolean colsKnown() {
        return this.numColumns > 0L;
    }

    public boolean nnzKnown() {
        return this.nonZero >= 0L;
    }

    public boolean mightHaveEmptyBlocks() {
        long singleBlk = Math.min(this.numRows, (long)this.numRowsPerBlock) * Math.min(this.numColumns, (long)this.numColumnsPerBlock);
        return !this.nnzKnown() || this.nonZero < this.numRows * this.numColumns - singleBlk;
    }

    public static void reorg(MatrixCharacteristics dim, ReorgOperator op, MatrixCharacteristics dimOut) throws DMLRuntimeException {
        op.fn.computeDimension(dim, dimOut);
    }

    public static void aggregateUnary(MatrixCharacteristics dim, AggregateUnaryOperator op, MatrixCharacteristics dimOut) throws DMLRuntimeException {
        op.indexFn.computeDimension(dim, dimOut);
    }

    public static void aggregateBinary(MatrixCharacteristics dim1, MatrixCharacteristics dim2, AggregateBinaryOperator op, MatrixCharacteristics dimOut) {
        dimOut.set(dim1.numRows, dim2.numColumns, dim1.numRowsPerBlock, dim2.numColumnsPerBlock);
    }

    public static void computeDimension(HashMap<Byte, MatrixCharacteristics> dims, MRInstruction ins) throws DMLRuntimeException {
        MatrixCharacteristics dimOut = dims.get(ins.output);
        if (dimOut == null) {
            dimOut = new MatrixCharacteristics();
            dims.put(ins.output, dimOut);
        }
        if (ins instanceof ReorgInstruction) {
            ReorgInstruction realIns = (ReorgInstruction)ins;
            MatrixCharacteristics.reorg(dims.get(realIns.input), (ReorgOperator)realIns.getOperator(), dimOut);
        } else if (ins instanceof AppendInstruction) {
            AppendInstruction realIns = (AppendInstruction)ins;
            MatrixCharacteristics in_dim1 = dims.get(realIns.input1);
            MatrixCharacteristics in_dim2 = dims.get(realIns.input2);
            if (realIns.isCBind()) {
                dimOut.set(in_dim1.numRows, in_dim1.numColumns + in_dim2.numColumns, in_dim1.numRowsPerBlock, in_dim2.numColumnsPerBlock);
            } else {
                dimOut.set(in_dim1.numRows + in_dim2.numRows, in_dim1.numColumns, in_dim1.numRowsPerBlock, in_dim2.numColumnsPerBlock);
            }
        } else if (ins instanceof CumulativeAggregateInstruction) {
            AggregateUnaryInstruction realIns = (AggregateUnaryInstruction)ins;
            MatrixCharacteristics in = dims.get(realIns.input);
            dimOut.set((long)Math.ceil((double)in.getRows() / (double)in.getRowsPerBlock()), in.getCols(), in.getRowsPerBlock(), in.getColsPerBlock());
        } else if (ins instanceof AggregateUnaryInstruction) {
            AggregateUnaryInstruction realIns = (AggregateUnaryInstruction)ins;
            MatrixCharacteristics.aggregateUnary(dims.get(realIns.input), (AggregateUnaryOperator)realIns.getOperator(), dimOut);
        } else if (ins instanceof AggregateBinaryInstruction) {
            AggregateBinaryInstruction realIns = (AggregateBinaryInstruction)ins;
            MatrixCharacteristics.aggregateBinary(dims.get(realIns.input1), dims.get(realIns.input2), (AggregateBinaryOperator)realIns.getOperator(), dimOut);
        } else if (ins instanceof MapMultChainInstruction) {
            MapMultChainInstruction realIns = (MapMultChainInstruction)ins;
            MatrixCharacteristics mc1 = dims.get(realIns.getInput1());
            MatrixCharacteristics mc2 = dims.get(realIns.getInput2());
            dimOut.set(mc1.numColumns, mc2.numColumns, mc1.numRowsPerBlock, mc1.numColumnsPerBlock);
        } else if (ins instanceof QuaternaryInstruction) {
            QuaternaryInstruction realIns = (QuaternaryInstruction)ins;
            MatrixCharacteristics mc1 = dims.get(realIns.getInput1());
            MatrixCharacteristics mc2 = dims.get(realIns.getInput2());
            MatrixCharacteristics mc3 = dims.get(realIns.getInput3());
            realIns.computeMatrixCharacteristics(mc1, mc2, mc3, dimOut);
        } else if (ins instanceof ReblockInstruction) {
            ReblockInstruction realIns = (ReblockInstruction)ins;
            MatrixCharacteristics in_dim = dims.get(realIns.input);
            dimOut.set(in_dim.numRows, in_dim.numColumns, realIns.brlen, realIns.bclen, in_dim.nonZero);
        } else if (ins instanceof MatrixReshapeMRInstruction) {
            MatrixReshapeMRInstruction mrinst = (MatrixReshapeMRInstruction)ins;
            MatrixCharacteristics in_dim = dims.get(mrinst.input);
            dimOut.set(mrinst.getNumRows(), mrinst.getNumColunms(), in_dim.getRowsPerBlock(), in_dim.getColsPerBlock(), in_dim.getNonZeros());
        } else if (ins instanceof RandInstruction || ins instanceof SeqInstruction) {
            DataGenMRInstruction dataIns = (DataGenMRInstruction)ins;
            dimOut.set(dims.get(dataIns.getInput()));
        } else if (ins instanceof ReplicateInstruction) {
            ReplicateInstruction realIns = (ReplicateInstruction)ins;
            realIns.computeOutputDimension(dims.get(realIns.input), dimOut);
        } else if (ins instanceof ParameterizedBuiltinMRInstruction) {
            ParameterizedBuiltinMRInstruction realIns = (ParameterizedBuiltinMRInstruction)ins;
            realIns.computeOutputCharacteristics(dims.get(realIns.input), dimOut);
        } else if (ins instanceof ScalarInstruction || ins instanceof AggregateInstruction || ins instanceof UnaryInstruction && !(ins instanceof MMTSJMRInstruction) || ins instanceof ZeroOutInstruction) {
            UnaryMRInstructionBase realIns = (UnaryMRInstructionBase)ins;
            dimOut.set(dims.get(realIns.input));
        } else if (ins instanceof MMTSJMRInstruction) {
            MMTSJMRInstruction mmtsj = (MMTSJMRInstruction)ins;
            MMTSJ.MMTSJType tstype = mmtsj.getMMTSJType();
            MatrixCharacteristics mc = dims.get(mmtsj.input);
            dimOut.set(tstype.isLeft() ? mc.numColumns : mc.numRows, tstype.isLeft() ? mc.numColumns : mc.numRows, mc.numRowsPerBlock, mc.numColumnsPerBlock);
        } else if (ins instanceof PMMJMRInstruction) {
            PMMJMRInstruction pmmins = (PMMJMRInstruction)ins;
            MatrixCharacteristics mc = dims.get(pmmins.input2);
            dimOut.set(pmmins.getNumRows(), mc.numColumns, mc.numRowsPerBlock, mc.numColumnsPerBlock);
        } else if (ins instanceof RemoveEmptyMRInstruction) {
            RemoveEmptyMRInstruction realIns = (RemoveEmptyMRInstruction)ins;
            MatrixCharacteristics mc = dims.get(realIns.input1);
            if (realIns.isRemoveRows()) {
                dimOut.set(realIns.getOutputLen(), mc.getCols(), mc.numRowsPerBlock, mc.numColumnsPerBlock);
            } else {
                dimOut.set(mc.getRows(), realIns.getOutputLen(), mc.numRowsPerBlock, mc.numColumnsPerBlock);
            }
        } else if (ins instanceof UaggOuterChainInstruction) {
            UaggOuterChainInstruction realIns = (UaggOuterChainInstruction)ins;
            MatrixCharacteristics mc1 = dims.get(realIns.input1);
            MatrixCharacteristics mc2 = dims.get(realIns.input2);
            realIns.computeOutputCharacteristics(mc1, mc2, dimOut);
        } else if (ins instanceof GroupedAggregateMInstruction) {
            GroupedAggregateMInstruction realIns = (GroupedAggregateMInstruction)ins;
            MatrixCharacteristics mc1 = dims.get(realIns.input1);
            realIns.computeOutputCharacteristics(mc1, dimOut);
        } else if (ins instanceof BinaryInstruction || ins instanceof BinaryMInstruction || ins instanceof CombineBinaryInstruction) {
            BinaryMRInstructionBase realIns = (BinaryMRInstructionBase)ins;
            MatrixCharacteristics mc1 = dims.get(realIns.input1);
            MatrixCharacteristics mc2 = dims.get(realIns.input2);
            if (mc1.getRows() > 1L && mc1.getCols() == 1L && mc2.getRows() == 1L && mc2.getCols() > 1L) {
                dimOut.set(mc1.getRows(), mc2.getCols(), mc1.getRowsPerBlock(), mc2.getColsPerBlock());
            } else {
                dimOut.set(mc1);
            }
        } else if (ins instanceof CombineTernaryInstruction) {
            TernaryInstruction realIns = (TernaryInstruction)ins;
            dimOut.set(dims.get(realIns.input1));
        } else if (ins instanceof CombineUnaryInstruction) {
            dimOut.set(dims.get(((CombineUnaryInstruction)ins).input));
        } else if (ins instanceof CM_N_COVInstruction || ins instanceof GroupedAggregateInstruction) {
            dimOut.set(1L, 1L, 1, 1);
        } else if (ins instanceof RangeBasedReIndexInstruction) {
            RangeBasedReIndexInstruction realIns = (RangeBasedReIndexInstruction)ins;
            MatrixCharacteristics dimIn = dims.get(realIns.input);
            realIns.computeOutputCharacteristics(dimIn, dimOut);
        } else if (ins instanceof TernaryInstruction) {
            TernaryInstruction realIns = (TernaryInstruction)ins;
            MatrixCharacteristics in_dim = dims.get(realIns.input1);
            dimOut.set(realIns.getOutputDim1(), realIns.getOutputDim2(), in_dim.numRowsPerBlock, in_dim.numColumnsPerBlock);
        } else {
            dimOut.numRows = -1L;
            dimOut.numColumns = -1L;
            dimOut.numRowsPerBlock = 1;
            dimOut.numColumnsPerBlock = 1;
        }
    }

    public boolean equals(Object anObject) {
        if (anObject instanceof MatrixCharacteristics) {
            MatrixCharacteristics mc = (MatrixCharacteristics)anObject;
            return this.numRows == mc.numRows && this.numColumns == mc.numColumns && this.numRowsPerBlock == mc.numRowsPerBlock && this.numColumnsPerBlock == mc.numColumnsPerBlock && this.nonZero == mc.nonZero;
        }
        return false;
    }

    public int hashCode() {
        return super.hashCode();
    }
}

