/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.instructions.spark;

import org.apache.spark.api.java.JavaPairRDD;
import org.apache.spark.api.java.function.Function;
import org.apache.sysml.runtime.DMLRuntimeException;
import org.apache.sysml.runtime.controlprogram.context.ExecutionContext;
import org.apache.sysml.runtime.controlprogram.context.SparkExecutionContext;
import org.apache.sysml.runtime.instructions.cp.CPOperand;
import org.apache.sysml.runtime.instructions.spark.BuiltinUnarySPInstruction;
import org.apache.sysml.runtime.matrix.data.MatrixBlock;
import org.apache.sysml.runtime.matrix.data.MatrixIndexes;
import org.apache.sysml.runtime.matrix.operators.Operator;
import org.apache.sysml.runtime.matrix.operators.UnaryOperator;

public class MatrixBuiltinSPInstruction
extends BuiltinUnarySPInstruction {
    protected MatrixBuiltinSPInstruction(Operator op, CPOperand in, CPOperand out, String opcode, String instr) {
        super(op, in, out, opcode, instr);
    }

    @Override
    public void processInstruction(ExecutionContext ec) throws DMLRuntimeException {
        SparkExecutionContext sec = (SparkExecutionContext)ec;
        JavaPairRDD<MatrixIndexes, MatrixBlock> in = sec.getBinaryBlockRDDHandleForVariable(this.input1.getName());
        UnaryOperator uop = (UnaryOperator)this._optr;
        JavaPairRDD out = in.mapValues((Function)new RDDMatrixBuiltinUnaryOp(uop));
        this.updateUnaryOutputMatrixCharacteristics(sec);
        sec.setRDDHandleForVariable(this.output.getName(), out);
        sec.addLineageRDD(this.output.getName(), this.input1.getName());
    }

    private static class RDDMatrixBuiltinUnaryOp
    implements Function<MatrixBlock, MatrixBlock> {
        private static final long serialVersionUID = -3128192099832877491L;
        private UnaryOperator _op = null;

        public RDDMatrixBuiltinUnaryOp(UnaryOperator u_op) {
            this._op = u_op;
        }

        public MatrixBlock call(MatrixBlock arg0) throws Exception {
            return (MatrixBlock)arg0.unaryOperations(this._op, new MatrixBlock());
        }
    }
}

