/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.instructions.cp;

import org.apache.sysml.runtime.DMLRuntimeException;
import org.apache.sysml.runtime.controlprogram.caching.MatrixObject;
import org.apache.sysml.runtime.controlprogram.context.ExecutionContext;
import org.apache.sysml.runtime.instructions.cp.BuiltinBinaryCPInstruction;
import org.apache.sysml.runtime.instructions.cp.CPOperand;
import org.apache.sysml.runtime.matrix.data.LibCommonsMath;
import org.apache.sysml.runtime.matrix.data.MatrixBlock;
import org.apache.sysml.runtime.matrix.operators.BinaryOperator;
import org.apache.sysml.runtime.matrix.operators.Operator;

public class MatrixMatrixBuiltinCPInstruction
extends BuiltinBinaryCPInstruction {
    protected MatrixMatrixBuiltinCPInstruction(Operator op, CPOperand in1, CPOperand in2, CPOperand out, String opcode, String istr) {
        super(op, in1, in2, out, 2, opcode, istr);
    }

    @Override
    public void processInstruction(ExecutionContext ec) throws DMLRuntimeException {
        String opcode = this.getOpcode();
        if (LibCommonsMath.isSupportedMatrixMatrixOperation(opcode)) {
            MatrixBlock solution = LibCommonsMath.matrixMatrixOperations(ec.getMatrixObject(this.input1.getName()), (MatrixObject)ec.getVariable(this.input2.getName()), opcode);
            ec.setMatrixOutput(this.output.getName(), solution, this.getExtendedOpcode());
            return;
        }
        String output_name = this.output.getName();
        BinaryOperator bop = (BinaryOperator)this._optr;
        MatrixBlock inBlock1 = ec.getMatrixInput(this.input1.getName(), this.getExtendedOpcode());
        MatrixBlock inBlock2 = ec.getMatrixInput(this.input2.getName(), this.getExtendedOpcode());
        MatrixBlock retBlock = (MatrixBlock)inBlock1.binaryOperations(bop, inBlock2, new MatrixBlock());
        ec.releaseMatrixInput(this.input1.getName(), this.getExtendedOpcode());
        ec.releaseMatrixInput(this.input2.getName(), this.getExtendedOpcode());
        if (this.checkGuardedRepresentationChange(inBlock1, inBlock2, retBlock)) {
            retBlock.examSparsity();
        }
        ec.setMatrixOutput(output_name, retBlock, this.getExtendedOpcode());
    }
}

