/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.instructions.cp;

import org.apache.sysml.lops.runtime.RunMRJobs;
import org.apache.sysml.runtime.DMLRuntimeException;
import org.apache.sysml.runtime.controlprogram.context.ExecutionContext;
import org.apache.sysml.runtime.instructions.CPInstructionParser;
import org.apache.sysml.runtime.instructions.Instruction;
import org.apache.sysml.runtime.matrix.operators.Operator;

public abstract class CPInstruction
extends Instruction {
    protected CPINSTRUCTION_TYPE _cptype;
    protected Operator _optr;
    protected boolean _requiresLabelUpdate = false;
    public static final String MISC_TIMER_GET_SPARSE_MB = "aqrs";
    public static final String MISC_TIMER_GET_DENSE_MB = "aqrd";
    public static final String MISC_TIMER_ACQ_MODIFY_SPARSE_MB = "aqms";
    public static final String MISC_TIMER_ACQ_MODIFY_DENSE_MB = "aqmd";
    public static final String MISC_TIMER_RELEASE_INPUT_MB = "rlsi";
    public static final String MISC_TIMER_RELEASE_EVICTION = "rlsev";
    public static final String MISC_TIMER_RELEASE_BUFF_WRITE = "rlswr";
    public static final String MISC_TIMER_SPARSE_TO_DENSE = "s2d";
    public static final String MISC_TIMER_DENSE_TO_SPARSE = "d2s";
    public static final String MISC_TIMER_CSR_LIX_COPY = "csrlix";
    public static final String MISC_TIMER_LIX_COPY = "lixcp";

    protected CPInstruction(String opcode, String istr) {
        this.type = Instruction.INSTRUCTION_TYPE.CONTROL_PROGRAM;
        this.instString = istr;
        this.instOpcode = opcode;
        this._requiresLabelUpdate = super.requiresLabelUpdate();
    }

    protected CPInstruction(Operator op, String opcode, String istr) {
        this(opcode, istr);
        this._optr = op;
    }

    public CPINSTRUCTION_TYPE getCPInstructionType() {
        return this._cptype;
    }

    @Override
    public boolean requiresLabelUpdate() {
        return this._requiresLabelUpdate;
    }

    @Override
    public String getGraphString() {
        return this.getOpcode();
    }

    @Override
    public Instruction preprocessInstruction(ExecutionContext ec) throws DMLRuntimeException {
        Instruction tmp = super.preprocessInstruction(ec);
        if (tmp.requiresLabelUpdate()) {
            String updInst = RunMRJobs.updateLabels(tmp.toString(), ec.getVariables());
            tmp = CPInstructionParser.parseSingleInstruction(updInst);
        }
        return tmp;
    }

    @Override
    public abstract void processInstruction(ExecutionContext var1) throws DMLRuntimeException;

    public static enum CPINSTRUCTION_TYPE {
        INVALID,
        AggregateUnary,
        AggregateBinary,
        AggregateTernary,
        ArithmeticBinary,
        Ternary,
        Quaternary,
        BooleanBinary,
        BooleanUnary,
        BuiltinBinary,
        BuiltinUnary,
        BuiltinMultiple,
        MultiReturnParameterizedBuiltin,
        ParameterizedBuiltin,
        MultiReturnBuiltin,
        Builtin,
        Reorg,
        RelationalBinary,
        Variable,
        External,
        Append,
        Rand,
        QSort,
        QPick,
        MatrixIndexing,
        MMTSJ,
        PMMJ,
        MMChain,
        MatrixReshape,
        Partition,
        Compression,
        SpoofFused,
        StringInit,
        CentralMoment,
        Covariance,
        UaggOuterChain,
        Convolution;

    }
}

