/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.instructions.cp;

import org.apache.sysml.parser.Expression;
import org.apache.sysml.runtime.DMLRuntimeException;
import org.apache.sysml.runtime.controlprogram.context.ExecutionContext;
import org.apache.sysml.runtime.instructions.cp.BooleanObject;
import org.apache.sysml.runtime.instructions.cp.CPInstruction;
import org.apache.sysml.runtime.instructions.cp.CPOperand;
import org.apache.sysml.runtime.instructions.cp.ScalarObject;
import org.apache.sysml.runtime.instructions.cp.UnaryCPInstruction;
import org.apache.sysml.runtime.matrix.operators.Operator;
import org.apache.sysml.runtime.matrix.operators.SimpleOperator;

public class BooleanUnaryCPInstruction
extends UnaryCPInstruction {
    private BooleanUnaryCPInstruction(Operator op, CPOperand in, CPOperand out, String opcode, String instr) {
        super(op, in, out, opcode, instr);
        this._cptype = CPInstruction.CPINSTRUCTION_TYPE.BooleanUnary;
    }

    public static BooleanUnaryCPInstruction parseInstruction(String str) throws DMLRuntimeException {
        CPOperand in = new CPOperand("", Expression.ValueType.UNKNOWN, Expression.DataType.UNKNOWN);
        CPOperand out = new CPOperand("", Expression.ValueType.UNKNOWN, Expression.DataType.UNKNOWN);
        String opcode = BooleanUnaryCPInstruction.parseUnaryInstruction(str, in, out);
        Expression.ValueType vt1 = in.getValueType();
        Expression.ValueType vt2 = out.getValueType();
        if (vt1 != Expression.ValueType.BOOLEAN || vt2 != Expression.ValueType.BOOLEAN) {
            throw new DMLRuntimeException("Unexpected ValueType in ArithmeticInstruction.");
        }
        return new BooleanUnaryCPInstruction(BooleanUnaryCPInstruction.getSimpleUnaryOperator(opcode), in, out, opcode, str);
    }

    @Override
    public void processInstruction(ExecutionContext ec) throws DMLRuntimeException {
        ScalarObject so = ec.getScalarInput(this.input1.getName(), this.input1.getValueType(), this.input1.isLiteral());
        SimpleOperator dop = (SimpleOperator)this._optr;
        boolean rval = dop.fn.execute(so.getBooleanValue());
        BooleanObject sores = new BooleanObject(rval);
        ec.setScalarOutput(this.output.getName(), sores);
    }
}

