/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.controlprogram.parfor.stat;

import java.io.IOException;
import java.util.StringTokenizer;
import org.apache.hadoop.mapred.ClusterStatus;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobConf;
import org.apache.sysml.conf.ConfigurationManager;
import org.apache.sysml.hops.OptimizerUtils;
import org.apache.sysml.runtime.controlprogram.context.SparkExecutionContext;
import org.apache.sysml.runtime.matrix.mapred.MRConfigurationNames;
import org.apache.sysml.runtime.util.UtilFunctions;

public class InfrastructureAnalyzer {
    public static final long DEFAULT_JVM_SIZE = 0x20000000L;
    private static int _localPar = -1;
    private static long _localJVMMaxMem = -1L;
    private static boolean _isLtJDK8 = false;
    private static int _remotePar = -1;
    private static int _remoteParMap = -1;
    private static int _remoteParReduce = -1;
    private static long _remoteJVMMaxMemMap = -1L;
    private static long _remoteJVMMaxMemReduce = -1L;
    private static long _remoteMRSortMem = -1L;
    private static boolean _localJT = false;
    private static long _blocksize = -1L;
    private static boolean _yarnEnabled = false;

    public static boolean isJavaVersionLessThanJDK8() {
        return _isLtJDK8;
    }

    public static int getLocalParallelism() {
        return _localPar;
    }

    public static int getRemoteParallelNodes() {
        if (_remotePar == -1) {
            InfrastructureAnalyzer.analyzeHadoopCluster();
        }
        return _remotePar;
    }

    public static int getRemoteParallelMapTasks() {
        if (_remoteParMap == -1) {
            InfrastructureAnalyzer.analyzeHadoopCluster();
        }
        return _remoteParMap;
    }

    public static void setRemoteParallelMapTasks(int pmap) {
        _remoteParMap = pmap;
    }

    public static int getRemoteParallelReduceTasks() {
        if (_remoteParReduce == -1) {
            InfrastructureAnalyzer.analyzeHadoopCluster();
        }
        return _remoteParReduce;
    }

    public static void setRemoteParallelReduceTasks(int preduce) {
        _remoteParReduce = preduce;
    }

    public static long getLocalMaxMemory() {
        return _localJVMMaxMem;
    }

    public static void setLocalMaxMemory(long localMem) {
        _localJVMMaxMem = localMem;
    }

    public static long getRemoteMaxMemoryMap() {
        if (_remoteJVMMaxMemMap == -1L) {
            InfrastructureAnalyzer.analyzeHadoopConfiguration();
        }
        return _remoteJVMMaxMemMap;
    }

    public static void setRemoteMaxMemoryMap(long remoteMem) {
        _remoteJVMMaxMemMap = remoteMem;
    }

    public static long getRemoteMaxMemoryReduce() {
        if (_remoteJVMMaxMemReduce == -1L) {
            InfrastructureAnalyzer.analyzeHadoopConfiguration();
        }
        return _remoteJVMMaxMemReduce;
    }

    public static void setRemoteMaxMemoryReduce(long remoteMem) {
        _remoteJVMMaxMemReduce = remoteMem;
    }

    public static long getRemoteMaxMemorySortBuffer() {
        if (_remoteMRSortMem == -1L) {
            InfrastructureAnalyzer.analyzeHadoopConfiguration();
        }
        return _remoteMRSortMem;
    }

    public static boolean isLocalMode() {
        if (_remoteJVMMaxMemMap == -1L) {
            InfrastructureAnalyzer.analyzeHadoopConfiguration();
        }
        return _localJT;
    }

    public static boolean isLocalMode(JobConf job) {
        String jobTracker = job.get(MRConfigurationNames.MR_JOBTRACKER_ADDRESS, "local");
        String framework = job.get("mapreduce.framework.name", "local");
        boolean isYarnEnabled = framework != null && framework.equals("yarn");
        return "local".equals(jobTracker) & !isYarnEnabled;
    }

    public static int getCkMaxCP() {
        return InfrastructureAnalyzer.getLocalParallelism();
    }

    public static int getCkMaxMR() {
        if (OptimizerUtils.isSparkExecutionMode()) {
            return SparkExecutionContext.getDefaultParallelism(true);
        }
        return InfrastructureAnalyzer.getRemoteParallelMapTasks();
    }

    public static long getCmMax() {
        return Math.min(InfrastructureAnalyzer.getLocalMaxMemory(), InfrastructureAnalyzer.getRemoteMaxMemoryMap());
    }

    public static long getHDFSBlockSize() {
        if (_blocksize == -1L) {
            InfrastructureAnalyzer.analyzeHadoopConfiguration();
        }
        return _blocksize;
    }

    public static boolean isYarnEnabled() {
        if (_remoteJVMMaxMemMap == -1L) {
            InfrastructureAnalyzer.analyzeHadoopConfiguration();
        }
        return _yarnEnabled;
    }

    public static long extractMaxMemoryOpt(String javaOpts) {
        long ret = -1L;
        try {
            StringTokenizer st = new StringTokenizer(javaOpts, " ");
            while (st.hasMoreTokens()) {
                String arg = st.nextToken();
                if (!arg.startsWith("-Xmx")) continue;
                arg = arg.substring(4);
                ret = UtilFunctions.parseMemorySize(arg);
            }
            if (ret < 0L) {
                ret = 0x20000000L;
            }
        }
        catch (Exception ex) {
            ret = 0x20000000L;
        }
        return ret;
    }

    public static void setMaxMemoryOpt(JobConf job, String key, long bytes) {
        String javaOptsOld = job.get(key);
        String javaOptsNew = null;
        String[] tokens = javaOptsOld.split(" ");
        StringBuilder sb = new StringBuilder();
        for (String arg : tokens) {
            if (arg.startsWith("-Xmx")) {
                sb.append("-Xmx");
                sb.append(bytes / 0x100000L);
                sb.append("M");
            } else {
                sb.append(arg);
            }
            sb.append(" ");
        }
        javaOptsNew = sb.toString().trim();
        job.set(key, javaOptsNew);
    }

    public static double getClusterUtilization(boolean mapOnly) throws IOException {
        JobConf job = ConfigurationManager.getCachedJobConf();
        JobClient client = new JobClient(job);
        ClusterStatus stat = client.getClusterStatus();
        double ret = 0.0;
        if (stat != null) {
            if (mapOnly) {
                int capacity = stat.getMaxMapTasks();
                int current = stat.getMapTasks();
                ret = (double)current / (double)capacity;
            } else {
                int capacity = stat.getMaxMapTasks() + stat.getMaxReduceTasks();
                int current = stat.getMapTasks() + stat.getReduceTasks();
                ret = (double)current / (double)capacity;
            }
        }
        return ret;
    }

    private static void analyzeLocalMachine() {
        _localPar = Runtime.getRuntime().availableProcessors();
        _localJVMMaxMem = Runtime.getRuntime().maxMemory();
        String version = System.getProperty("java.version");
        _isLtJDK8 = UtilFunctions.compareVersion(version, "1.8") < 0;
    }

    private static void analyzeHadoopCluster() {
        try {
            JobConf job = ConfigurationManager.getCachedJobConf();
            JobClient client = new JobClient(job);
            ClusterStatus stat = client.getClusterStatus();
            if (stat != null) {
                _remotePar = stat.getTaskTrackers();
                _remoteParMap = stat.getMaxMapTasks();
                _remoteParReduce = stat.getMaxReduceTasks();
                InfrastructureAnalyzer.analyzeHadoopConfiguration();
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to analyze infrastructure.", e);
        }
    }

    private static void analyzeHadoopConfiguration() {
        JobConf job = ConfigurationManager.getCachedJobConf();
        _remoteMRSortMem = 0x100000L * job.getLong(MRConfigurationNames.MR_TASK_IO_SORT_MB, 100L);
        String javaOpts1 = job.get("mapred.child.java.opts");
        String javaOpts2 = job.get(MRConfigurationNames.MR_MAP_JAVA_OPTS, null);
        String javaOpts3 = job.get(MRConfigurationNames.MR_REDUCE_JAVA_OPTS, null);
        _remoteJVMMaxMemMap = javaOpts2 != null ? InfrastructureAnalyzer.extractMaxMemoryOpt(javaOpts2) : InfrastructureAnalyzer.extractMaxMemoryOpt(javaOpts1);
        _remoteJVMMaxMemReduce = javaOpts3 != null ? InfrastructureAnalyzer.extractMaxMemoryOpt(javaOpts3) : InfrastructureAnalyzer.extractMaxMemoryOpt(javaOpts1);
        String blocksize = job.get(MRConfigurationNames.DFS_BLOCKSIZE, "134217728");
        _blocksize = Long.parseLong(blocksize);
        String framework = job.get("mapreduce.framework.name");
        _yarnEnabled = framework != null && framework.equals("yarn");
        _localJT = InfrastructureAnalyzer.analyzeLocalMode(job);
    }

    private static boolean analyzeLocalMode(JobConf job) {
        String jobTracker = job.get(MRConfigurationNames.MR_JOBTRACKER_ADDRESS, "local");
        return "local".equals(jobTracker) & !InfrastructureAnalyzer.isYarnEnabled();
    }

    static {
        InfrastructureAnalyzer.analyzeLocalMachine();
    }
}

