/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.controlprogram.parfor;

import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.sysml.runtime.DMLRuntimeException;
import org.apache.sysml.runtime.controlprogram.caching.MatrixObject;
import org.apache.sysml.runtime.matrix.MatrixCharacteristics;
import org.apache.sysml.runtime.matrix.data.MatrixBlock;

public abstract class ResultMerge {
    protected static final Log LOG = LogFactory.getLog((String)ResultMerge.class.getName());
    protected static final String NAME_SUFFIX = "_rm";
    protected MatrixObject _output = null;
    protected MatrixObject[] _inputs = null;
    protected String _outputFName = null;

    protected ResultMerge() {
    }

    public ResultMerge(MatrixObject out, MatrixObject[] in, String outputFilename) {
        this._output = out;
        this._inputs = in;
        this._outputFName = outputFilename;
    }

    public abstract MatrixObject executeSerialMerge() throws DMLRuntimeException;

    public abstract MatrixObject executeParallelMerge(int var1) throws DMLRuntimeException;

    protected void mergeWithoutComp(MatrixBlock out, MatrixBlock in, boolean appendOnly) throws DMLRuntimeException {
        out.merge(in, appendOnly);
    }

    protected void mergeWithComp(MatrixBlock out, MatrixBlock in, double[][] compare) throws DMLRuntimeException {
        if (in.isInSparseFormat()) {
            int rows = in.getNumRows();
            int cols = in.getNumColumns();
            for (int i = 0; i < rows; ++i) {
                for (int j = 0; j < cols; ++j) {
                    double value = in.getValueSparseUnsafe(i, j);
                    if ((value == compare[i][j] || Double.isNaN(value)) && Double.isNaN(value) == Double.isNaN(compare[i][j])) continue;
                    out.quickSetValue(i, j, value);
                }
            }
        } else {
            int rows = in.getNumRows();
            int cols = in.getNumColumns();
            for (int i = 0; i < rows; ++i) {
                for (int j = 0; j < cols; ++j) {
                    double value = in.getValueDenseUnsafe(i, j);
                    if ((value == compare[i][j] || Double.isNaN(value)) && Double.isNaN(value) == Double.isNaN(compare[i][j])) continue;
                    out.quickSetValue(i, j, value);
                }
            }
        }
    }

    protected long computeNonZeros(MatrixObject out, ArrayList<MatrixObject> in) {
        long outNNZ;
        MatrixCharacteristics mc = out.getMatrixCharacteristics();
        long ret = outNNZ = mc.getNonZeros();
        for (MatrixObject tmp : in) {
            MatrixCharacteristics tmpmc = tmp.getMatrixCharacteristics();
            long inNNZ = tmpmc.getNonZeros();
            ret += inNNZ - outNNZ;
        }
        return ret;
    }

    protected ArrayList<MatrixObject> convertToList(MatrixObject[] in) {
        ArrayList<MatrixObject> ret = new ArrayList<MatrixObject>();
        for (MatrixObject mo : in) {
            ret.add(mo);
        }
        return ret;
    }
}

