/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.api.mlcontext;

import java.io.File;
import java.io.FileNotFoundException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Scanner;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.text.WordUtils;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.api.java.JavaPairRDD;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.ml.linalg.VectorUDT;
import org.apache.spark.mllib.util.MLUtils;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.sysml.api.mlcontext.Frame;
import org.apache.sysml.api.mlcontext.FrameFormat;
import org.apache.sysml.api.mlcontext.FrameMetadata;
import org.apache.sysml.api.mlcontext.MLContext;
import org.apache.sysml.api.mlcontext.MLContextConversionUtil;
import org.apache.sysml.api.mlcontext.MLContextException;
import org.apache.sysml.api.mlcontext.Matrix;
import org.apache.sysml.api.mlcontext.MatrixFormat;
import org.apache.sysml.api.mlcontext.MatrixMetadata;
import org.apache.sysml.api.mlcontext.Metadata;
import org.apache.sysml.api.mlcontext.ProjectInfo;
import org.apache.sysml.api.mlcontext.Script;
import org.apache.sysml.api.mlcontext.ScriptExecutor;
import org.apache.sysml.api.mlcontext.ScriptType;
import org.apache.sysml.conf.CompilerConfig;
import org.apache.sysml.conf.ConfigurationManager;
import org.apache.sysml.conf.DMLConfig;
import org.apache.sysml.hops.HopsException;
import org.apache.sysml.parser.LanguageException;
import org.apache.sysml.parser.ParseException;
import org.apache.sysml.runtime.DMLRuntimeException;
import org.apache.sysml.runtime.controlprogram.ForProgramBlock;
import org.apache.sysml.runtime.controlprogram.FunctionProgramBlock;
import org.apache.sysml.runtime.controlprogram.IfProgramBlock;
import org.apache.sysml.runtime.controlprogram.LocalVariableMap;
import org.apache.sysml.runtime.controlprogram.Program;
import org.apache.sysml.runtime.controlprogram.ProgramBlock;
import org.apache.sysml.runtime.controlprogram.WhileProgramBlock;
import org.apache.sysml.runtime.controlprogram.caching.FrameObject;
import org.apache.sysml.runtime.controlprogram.caching.MatrixObject;
import org.apache.sysml.runtime.controlprogram.context.SparkExecutionContext;
import org.apache.sysml.runtime.controlprogram.parfor.stat.InfrastructureAnalyzer;
import org.apache.sysml.runtime.instructions.Instruction;
import org.apache.sysml.runtime.instructions.cp.BooleanObject;
import org.apache.sysml.runtime.instructions.cp.Data;
import org.apache.sysml.runtime.instructions.cp.DoubleObject;
import org.apache.sysml.runtime.instructions.cp.IntObject;
import org.apache.sysml.runtime.instructions.cp.StringObject;
import org.apache.sysml.runtime.instructions.cp.VariableCPInstruction;
import org.apache.sysml.runtime.matrix.data.FrameBlock;
import org.apache.sysml.runtime.matrix.data.MatrixBlock;
import org.apache.sysml.runtime.matrix.data.MatrixIndexes;
import org.apache.sysml.utils.Explain;
import org.apache.sysml.utils.MLContextProxy;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class MLContextUtil {
    public static final String VERSION_NOT_AVAILABLE = "Version not available";
    public static final String BUILD_TIME_NOT_AVAILABLE = "Build time not available";
    public static final Class[] BASIC_DATA_TYPES = new Class[]{Integer.class, Boolean.class, Double.class, String.class};
    public static final Class[] COMPLEX_DATA_TYPES = new Class[]{JavaRDD.class, RDD.class, Dataset.class, Matrix.class, Frame.class, new double[0][].getClass(), MatrixBlock.class, URL.class};
    public static final Class[] ALL_SUPPORTED_DATA_TYPES = (Class[])ArrayUtils.addAll((Object[])BASIC_DATA_TYPES, (Object[])COMPLEX_DATA_TYPES);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int compareVersion(String versionStr1, String versionStr2) {
        if (versionStr1 == null) {
            throw new MLContextException("First version argument to compareVersion() is null");
        }
        if (versionStr2 == null) {
            throw new MLContextException("Second version argument to compareVersion() is null");
        }
        Scanner scanner1 = null;
        Scanner scanner2 = null;
        try {
            scanner1 = new Scanner(versionStr1);
            scanner2 = new Scanner(versionStr2);
            scanner1.useDelimiter("\\.");
            scanner2.useDelimiter("\\.");
            while (scanner1.hasNextInt() && scanner2.hasNextInt()) {
                int version2;
                int version1 = scanner1.nextInt();
                if (version1 < (version2 = scanner2.nextInt())) {
                    int n = -1;
                    return n;
                }
                if (version1 <= version2) continue;
                int n = 1;
                return n;
            }
            int n = scanner1.hasNextInt() ? 1 : 0;
            return n;
        }
        finally {
            scanner1.close();
            scanner2.close();
        }
    }

    public static boolean isSparkVersionSupported(String sparkVersion, String minimumRecommendedSparkVersion) {
        return MLContextUtil.compareVersion(sparkVersion, minimumRecommendedSparkVersion) >= 0;
    }

    public static void verifySparkVersionSupported(SparkSession spark) {
        String minimumRecommendedSparkVersion = null;
        try {
            ProjectInfo projectInfo = ProjectInfo.getProjectInfo();
            minimumRecommendedSparkVersion = projectInfo.minimumRecommendedSparkVersion();
        }
        catch (MLContextException e) {
            try {
                minimumRecommendedSparkVersion = MLContextUtil.getMinimumRecommendedSparkVersionFromPom();
            }
            catch (MLContextException e1) {
                throw new MLContextException("Minimum recommended Spark version could not be determined from SystemML jar file manifest or pom.xml");
            }
        }
        String sparkVersion = spark.version();
        if (!MLContextUtil.isSparkVersionSupported(sparkVersion, minimumRecommendedSparkVersion)) {
            throw new MLContextException("Spark " + sparkVersion + " or greater is recommended for this version of SystemML.");
        }
    }

    static String getMinimumRecommendedSparkVersionFromPom() {
        return MLContextUtil.getUniquePomProperty("spark.version");
    }

    static String getUniquePomProperty(String property) {
        File f = new File("pom.xml");
        if (!f.exists()) {
            throw new MLContextException("pom.xml not found");
        }
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = dbf.newDocumentBuilder();
            Document document = builder.parse(f);
            NodeList nodes = document.getElementsByTagName(property);
            int length = nodes.getLength();
            if (length == 0) {
                throw new MLContextException("Property not found in pom.xml");
            }
            Node node = nodes.item(0);
            String value = node.getTextContent();
            return value;
        }
        catch (Exception e) {
            throw new MLContextException("MLContextException when reading property '" + property + "' from pom.xml", e);
        }
    }

    public static void setDefaultConfig() {
        ConfigurationManager.setGlobalConfig(new DMLConfig());
    }

    public static void setConfig(String configFilePath) {
        try {
            DMLConfig config = new DMLConfig(configFilePath);
            ConfigurationManager.setGlobalConfig(config);
        }
        catch (ParseException e) {
            throw new MLContextException("Parse Exception when setting config", e);
        }
        catch (FileNotFoundException e) {
            throw new MLContextException("File not found (" + configFilePath + ") when setting config", e);
        }
    }

    public static void setCompilerConfig() {
        CompilerConfig compilerConfig = new CompilerConfig();
        compilerConfig.set(CompilerConfig.ConfigType.IGNORE_UNSPECIFIED_ARGS, true);
        compilerConfig.set(CompilerConfig.ConfigType.REJECT_READ_WRITE_UNKNOWNS, false);
        compilerConfig.set(CompilerConfig.ConfigType.ALLOW_CSE_PERSISTENT_READS, false);
        compilerConfig.set(CompilerConfig.ConfigType.MLCONTEXT, true);
        ConfigurationManager.setGlobalConfig(compilerConfig);
    }

    public static void checkInputValueTypes(Map<String, Object> inputs) {
        for (Map.Entry<String, Object> entry : inputs.entrySet()) {
            MLContextUtil.checkInputValueType(entry.getKey(), entry.getValue());
        }
    }

    public static void checkInputValueType(String name, Object value) {
        if (name == null) {
            throw new MLContextException("No input name supplied");
        }
        if (value == null) {
            throw new MLContextException("No input value supplied");
        }
        Object o = value;
        boolean supported = false;
        for (Class clazz : ALL_SUPPORTED_DATA_TYPES) {
            if (o.getClass().equals(clazz)) {
                supported = true;
                break;
            }
            if (!clazz.isAssignableFrom(o.getClass())) continue;
            supported = true;
            break;
        }
        if (!supported) {
            throw new MLContextException("Input name (\"" + name + "\") value type not supported: " + o.getClass());
        }
    }

    public static void checkInputParameterType(String parameterName, Object parameterValue) {
        if (parameterName == null) {
            throw new MLContextException("No parameter name supplied");
        }
        if (parameterValue == null) {
            throw new MLContextException("No parameter value supplied");
        }
        if (!parameterName.startsWith("$")) {
            throw new MLContextException("Input parameter name must start with a $");
        }
        Object o = parameterValue;
        boolean supported = false;
        for (Class clazz : BASIC_DATA_TYPES) {
            if (o.getClass().equals(clazz)) {
                supported = true;
                break;
            }
            if (!clazz.isAssignableFrom(o.getClass())) continue;
            supported = true;
            break;
        }
        if (!supported) {
            throw new MLContextException("Input parameter (\"" + parameterName + "\") value type not supported: " + o.getClass());
        }
    }

    public static boolean isBasicType(Object object) {
        for (Class clazz : BASIC_DATA_TYPES) {
            if (object.getClass().equals(clazz)) {
                return true;
            }
            if (!clazz.isAssignableFrom(object.getClass())) continue;
            return true;
        }
        return false;
    }

    public static String getBasicTypeString(Object object) {
        if (!MLContextUtil.isBasicType(object)) {
            throw new MLContextException("Type (" + object.getClass() + ") not a recognized basic type");
        }
        Class<?> clazz = object.getClass();
        if (clazz.equals(Integer.class)) {
            return "int";
        }
        if (clazz.equals(Boolean.class)) {
            return "boolean";
        }
        if (clazz.equals(Double.class)) {
            return "double";
        }
        if (clazz.equals(String.class)) {
            return "string";
        }
        return null;
    }

    public static boolean isComplexType(Object object) {
        for (Class clazz : COMPLEX_DATA_TYPES) {
            if (object.getClass().equals(clazz)) {
                return true;
            }
            if (!clazz.isAssignableFrom(object.getClass())) continue;
            return true;
        }
        return false;
    }

    public static Map<String, String> convertInputParametersForParser(Map<String, Object> basicInputParameterMap, ScriptType scriptType) {
        if (basicInputParameterMap == null) {
            return null;
        }
        if (scriptType == null) {
            throw new MLContextException("ScriptType needs to be specified");
        }
        HashMap<String, String> convertedMap = new HashMap<String, String>();
        for (Map.Entry<String, Object> entry : basicInputParameterMap.entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            if (value == null) {
                throw new MLContextException("Input parameter value is null for: " + entry.getKey());
            }
            if (value instanceof Integer) {
                convertedMap.put(key, Integer.toString((Integer)value));
                continue;
            }
            if (value instanceof Boolean) {
                if (scriptType == ScriptType.DML) {
                    convertedMap.put(key, String.valueOf((Boolean)value).toUpperCase());
                    continue;
                }
                convertedMap.put(key, WordUtils.capitalize((String)String.valueOf((Boolean)value)));
                continue;
            }
            if (value instanceof Double) {
                convertedMap.put(key, Double.toString((Double)value));
                continue;
            }
            if (value instanceof String) {
                convertedMap.put(key, (String)value);
                continue;
            }
            throw new MLContextException("Incorrect type for input parameters");
        }
        return convertedMap;
    }

    public static Data convertInputType(String parameterName, Object parameterValue) {
        return MLContextUtil.convertInputType(parameterName, parameterValue, null);
    }

    public static Data convertInputType(String parameterName, Object parameterValue, Metadata metadata) {
        boolean hasFrameMetadata;
        String name = parameterName;
        Object value = parameterValue;
        boolean hasMetadata = metadata != null;
        boolean hasMatrixMetadata = hasMetadata && metadata instanceof MatrixMetadata;
        boolean bl = hasFrameMetadata = hasMetadata && metadata instanceof FrameMetadata;
        if (name == null) {
            throw new MLContextException("Input parameter name is null");
        }
        if (value == null) {
            throw new MLContextException("Input parameter value is null for: " + parameterName);
        }
        if (value instanceof JavaRDD) {
            JavaRDD javaRDD = (JavaRDD)value;
            if (hasMatrixMetadata) {
                MatrixMetadata matrixMetadata = (MatrixMetadata)metadata;
                if (matrixMetadata.getMatrixFormat() == MatrixFormat.IJV) {
                    return MLContextConversionUtil.javaRDDStringIJVToMatrixObject(name, (JavaRDD<String>)javaRDD, matrixMetadata);
                }
                return MLContextConversionUtil.javaRDDStringCSVToMatrixObject(name, (JavaRDD<String>)javaRDD, matrixMetadata);
            }
            if (hasFrameMetadata) {
                FrameMetadata frameMetadata = (FrameMetadata)metadata;
                if (frameMetadata.getFrameFormat() == FrameFormat.IJV) {
                    return MLContextConversionUtil.javaRDDStringIJVToFrameObject(name, (JavaRDD<String>)javaRDD, frameMetadata);
                }
                return MLContextConversionUtil.javaRDDStringCSVToFrameObject(name, (JavaRDD<String>)javaRDD, frameMetadata);
            }
            if (!hasMetadata) {
                String firstLine = (String)javaRDD.first();
                boolean isAllNumbers = MLContextUtil.isCSVLineAllNumbers(firstLine);
                if (isAllNumbers) {
                    return MLContextConversionUtil.javaRDDStringCSVToMatrixObject(name, (JavaRDD<String>)javaRDD);
                }
                return MLContextConversionUtil.javaRDDStringCSVToFrameObject(name, (JavaRDD<String>)javaRDD);
            }
        } else if (value instanceof RDD) {
            RDD rdd = (RDD)value;
            if (hasMatrixMetadata) {
                MatrixMetadata matrixMetadata = (MatrixMetadata)metadata;
                if (matrixMetadata.getMatrixFormat() == MatrixFormat.IJV) {
                    return MLContextConversionUtil.rddStringIJVToMatrixObject(name, (RDD<String>)rdd, matrixMetadata);
                }
                return MLContextConversionUtil.rddStringCSVToMatrixObject(name, (RDD<String>)rdd, matrixMetadata);
            }
            if (hasFrameMetadata) {
                FrameMetadata frameMetadata = (FrameMetadata)metadata;
                if (frameMetadata.getFrameFormat() == FrameFormat.IJV) {
                    return MLContextConversionUtil.rddStringIJVToFrameObject(name, (RDD<String>)rdd, frameMetadata);
                }
                return MLContextConversionUtil.rddStringCSVToFrameObject(name, (RDD<String>)rdd, frameMetadata);
            }
            if (!hasMetadata) {
                String firstLine = (String)rdd.first();
                boolean isAllNumbers = MLContextUtil.isCSVLineAllNumbers(firstLine);
                if (isAllNumbers) {
                    return MLContextConversionUtil.rddStringCSVToMatrixObject(name, (RDD<String>)rdd);
                }
                return MLContextConversionUtil.rddStringCSVToFrameObject(name, (RDD<String>)rdd);
            }
        } else {
            if (value instanceof MatrixBlock) {
                MatrixBlock matrixBlock = (MatrixBlock)value;
                return MLContextConversionUtil.matrixBlockToMatrixObject(name, matrixBlock, (MatrixMetadata)metadata);
            }
            if (value instanceof FrameBlock) {
                FrameBlock frameBlock = (FrameBlock)value;
                return MLContextConversionUtil.frameBlockToFrameObject(name, frameBlock, (FrameMetadata)metadata);
            }
            if (value instanceof Dataset) {
                Dataset dataFrame = (Dataset)value;
                dataFrame = MLUtils.convertVectorColumnsToML((Dataset)dataFrame, (String[])new String[0]);
                if (hasMatrixMetadata) {
                    return MLContextConversionUtil.dataFrameToMatrixObject(name, (Dataset<Row>)dataFrame, (MatrixMetadata)metadata);
                }
                if (hasFrameMetadata) {
                    return MLContextConversionUtil.dataFrameToFrameObject(name, (Dataset<Row>)dataFrame, (FrameMetadata)metadata);
                }
                if (!hasMetadata) {
                    boolean looksLikeMatrix = MLContextUtil.doesDataFrameLookLikeMatrix((Dataset<Row>)dataFrame);
                    if (looksLikeMatrix) {
                        return MLContextConversionUtil.dataFrameToMatrixObject(name, (Dataset<Row>)dataFrame);
                    }
                    return MLContextConversionUtil.dataFrameToFrameObject(name, (Dataset<Row>)dataFrame);
                }
            } else {
                if (value instanceof Matrix) {
                    Matrix matrix = (Matrix)value;
                    if (matrix.hasBinaryBlocks() && !matrix.hasMatrixObject()) {
                        if (metadata == null) {
                            metadata = matrix.getMatrixMetadata();
                        }
                        JavaPairRDD<MatrixIndexes, MatrixBlock> binaryBlocks = matrix.toBinaryBlocks();
                        return MLContextConversionUtil.binaryBlocksToMatrixObject(name, binaryBlocks, (MatrixMetadata)metadata);
                    }
                    return matrix.toMatrixObject();
                }
                if (value instanceof Frame) {
                    Frame frame = (Frame)value;
                    if (frame.hasBinaryBlocks() && !frame.hasFrameObject()) {
                        if (metadata == null) {
                            metadata = frame.getFrameMetadata();
                        }
                        JavaPairRDD<Long, FrameBlock> binaryBlocks = frame.toBinaryBlocks();
                        return MLContextConversionUtil.binaryBlocksToFrameObject(name, binaryBlocks, (FrameMetadata)metadata);
                    }
                    return frame.toFrameObject();
                }
                if (value instanceof double[][]) {
                    double[][] doubleMatrix = (double[][])value;
                    return MLContextConversionUtil.doubleMatrixToMatrixObject(name, doubleMatrix, (MatrixMetadata)metadata);
                }
                if (value instanceof URL) {
                    URL url = (URL)value;
                    return MLContextConversionUtil.urlToMatrixObject(name, url, (MatrixMetadata)metadata);
                }
                if (value instanceof Integer) {
                    return new IntObject(((Integer)value).intValue());
                }
                if (value instanceof Double) {
                    return new DoubleObject((Double)value);
                }
                if (value instanceof String) {
                    return new StringObject((String)value);
                }
                if (value instanceof Boolean) {
                    return new BooleanObject((Boolean)value);
                }
            }
        }
        return null;
    }

    public static boolean isCSVLineAllNumbers(String line) {
        if (StringUtils.isBlank((CharSequence)line)) {
            return false;
        }
        String[] parts = line.split(",");
        for (int i = 0; i < parts.length; ++i) {
            String part = parts[i].trim();
            try {
                Double.parseDouble(part);
                continue;
            }
            catch (NumberFormatException e) {
                return false;
            }
        }
        return true;
    }

    public static boolean doesDataFrameLookLikeMatrix(Dataset<Row> df) {
        StructType schema = df.schema();
        StructField[] fields = schema.fields();
        if (fields == null) {
            return true;
        }
        for (StructField field : fields) {
            DataType dataType = field.dataType();
            if (dataType == DataTypes.DoubleType || dataType == DataTypes.IntegerType || dataType == DataTypes.LongType || dataType instanceof VectorUDT || dataType instanceof org.apache.spark.mllib.linalg.VectorUDT) continue;
            return false;
        }
        return true;
    }

    public static String quotedString(String str) {
        if (str == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("\"");
        for (int i = 0; i < str.length(); ++i) {
            char ch = str.charAt(i);
            if (ch == '\'' || ch == '\"') {
                if (i > 0 && str.charAt(i - 1) != '\\') {
                    sb.append('\\');
                } else if (i == 0) {
                    sb.append('\\');
                }
            }
            sb.append(ch);
        }
        sb.append("\"");
        return sb.toString();
    }

    public static String displayMap(String mapName, Map<String, Object> map) {
        StringBuilder sb = new StringBuilder();
        sb.append(mapName);
        sb.append(":\n");
        Set<String> keys = map.keySet();
        if (keys.isEmpty()) {
            sb.append("None\n");
        } else {
            int count = 0;
            for (String key : keys) {
                sb.append("  [");
                sb.append(++count);
                sb.append("] ");
                sb.append(key);
                sb.append(": ");
                sb.append(map.get(key));
                sb.append("\n");
            }
        }
        return sb.toString();
    }

    public static String displaySet(String setName, Set<String> set) {
        StringBuilder sb = new StringBuilder();
        sb.append(setName);
        sb.append(":\n");
        if (set.isEmpty()) {
            sb.append("None\n");
        } else {
            int count = 0;
            for (String value : set) {
                sb.append("  [");
                sb.append(++count);
                sb.append("] ");
                sb.append(value);
                sb.append("\n");
            }
        }
        return sb.toString();
    }

    public static String displaySymbolTable(String name, LocalVariableMap symbolTable) {
        StringBuilder sb = new StringBuilder();
        sb.append(name);
        sb.append(":\n");
        sb.append(MLContextUtil.displaySymbolTable(symbolTable));
        return sb.toString();
    }

    public static String displaySymbolTable(LocalVariableMap symbolTable) {
        StringBuilder sb = new StringBuilder();
        Set<String> keys = symbolTable.keySet();
        if (keys.isEmpty()) {
            sb.append("None\n");
        } else {
            int count = 0;
            for (String key : keys) {
                sb.append("  [");
                sb.append(++count);
                sb.append("]");
                sb.append(" (");
                sb.append(MLContextUtil.determineOutputTypeAsString(symbolTable, key));
                sb.append(") ");
                sb.append(key);
                sb.append(": ");
                sb.append(symbolTable.get(key));
                sb.append("\n");
            }
        }
        return sb.toString();
    }

    public static String determineOutputTypeAsString(LocalVariableMap symbolTable, String outputName) {
        Data data = symbolTable.get(outputName);
        if (data instanceof BooleanObject) {
            return "Boolean";
        }
        if (data instanceof DoubleObject) {
            return "Double";
        }
        if (data instanceof IntObject) {
            return "Long";
        }
        if (data instanceof StringObject) {
            return "String";
        }
        if (data instanceof MatrixObject) {
            return "Matrix";
        }
        if (data instanceof FrameObject) {
            return "Frame";
        }
        return "Unknown";
    }

    public static String displayInputs(String name, Map<String, Object> map, LocalVariableMap symbolTable) {
        StringBuilder sb = new StringBuilder();
        sb.append(name);
        sb.append(":\n");
        Set<String> keys = map.keySet();
        if (keys.isEmpty()) {
            sb.append("None\n");
        } else {
            int count = 0;
            for (String key : keys) {
                Object object = map.get(key);
                Class<?> clazz = object.getClass();
                String type = clazz.getSimpleName();
                if (object instanceof JavaRDD) {
                    type = "JavaRDD";
                } else if (object instanceof RDD) {
                    type = "RDD";
                }
                sb.append("  [");
                sb.append(++count);
                sb.append("]");
                sb.append(" (");
                sb.append(type);
                if (MLContextUtil.doesSymbolTableContainMatrixObject(symbolTable, key)) {
                    sb.append(" as Matrix");
                } else if (MLContextUtil.doesSymbolTableContainFrameObject(symbolTable, key)) {
                    sb.append(" as Frame");
                }
                sb.append(") ");
                sb.append(key);
                sb.append(": ");
                String str = null;
                if (object instanceof MatrixBlock) {
                    MatrixBlock mb = (MatrixBlock)object;
                    str = "MatrixBlock [sparse? = " + mb.isInSparseFormat() + ", nonzeros = " + mb.getNonZeros() + ", size: " + mb.getNumRows() + " X " + mb.getNumColumns() + "]";
                } else {
                    str = object.toString();
                }
                str = StringUtils.abbreviate((String)str, (int)100);
                sb.append(str);
                sb.append("\n");
            }
        }
        return sb.toString();
    }

    public static String displayOutputs(String name, Set<String> outputNames, LocalVariableMap symbolTable) {
        StringBuilder sb = new StringBuilder();
        sb.append(name);
        sb.append(":\n");
        sb.append(MLContextUtil.displayOutputs(outputNames, symbolTable));
        return sb.toString();
    }

    public static String displayOutputs(Set<String> outputNames, LocalVariableMap symbolTable) {
        StringBuilder sb = new StringBuilder();
        if (outputNames.isEmpty()) {
            sb.append("None\n");
        } else {
            int count = 0;
            for (String outputName : outputNames) {
                sb.append("  [");
                sb.append(++count);
                sb.append("] ");
                if (symbolTable.get(outputName) != null) {
                    sb.append("(");
                    sb.append(MLContextUtil.determineOutputTypeAsString(symbolTable, outputName));
                    sb.append(") ");
                }
                sb.append(outputName);
                if (symbolTable.get(outputName) != null) {
                    sb.append(": ");
                    sb.append(symbolTable.get(outputName));
                }
                sb.append("\n");
            }
        }
        return sb.toString();
    }

    public static String welcomeMessage() {
        StringBuilder sb = new StringBuilder();
        sb.append("\nWelcome to Apache SystemML!\n");
        try {
            ProjectInfo info = ProjectInfo.getProjectInfo();
            if (info.version() != null) {
                sb.append("Version ");
                sb.append(info.version());
            }
        }
        catch (MLContextException mLContextException) {
            // empty catch block
        }
        return sb.toString();
    }

    public static SparkContext getSparkContext(MLContext mlContext) {
        return mlContext.getSparkSession().sparkContext();
    }

    public static JavaSparkContext getJavaSparkContext(MLContext mlContext) {
        return new JavaSparkContext(mlContext.getSparkSession().sparkContext());
    }

    public static SparkContext getSparkContextFromProxy() {
        MLContext activeMLContext = MLContextProxy.getActiveMLContextForAPI();
        SparkContext sc = MLContextUtil.getSparkContext(activeMLContext);
        return sc;
    }

    public static JavaSparkContext getJavaSparkContextFromProxy() {
        MLContext activeMLContext = MLContextProxy.getActiveMLContextForAPI();
        JavaSparkContext jsc = MLContextUtil.getJavaSparkContext(activeMLContext);
        return jsc;
    }

    public static SparkSession getSparkSessionFromProxy() {
        return MLContextProxy.getActiveMLContextForAPI().getSparkSession();
    }

    public static boolean doesSymbolTableContainFrameObject(LocalVariableMap symbolTable, String variableName) {
        return symbolTable != null && symbolTable.keySet().contains(variableName) && symbolTable.get(variableName) instanceof FrameObject;
    }

    public static boolean doesSymbolTableContainMatrixObject(LocalVariableMap symbolTable, String variableName) {
        return symbolTable != null && symbolTable.keySet().contains(variableName) && symbolTable.get(variableName) instanceof MatrixObject;
    }

    public static void deleteRemoveVariableInstructions(Program progam) {
        HashMap<String, FunctionProgramBlock> fpbs = progam.getFunctionProgramBlocks();
        if (fpbs != null && !fpbs.isEmpty()) {
            for (Map.Entry entry : fpbs.entrySet()) {
                FunctionProgramBlock fpb = (FunctionProgramBlock)entry.getValue();
                for (ProgramBlock pb : fpb.getChildBlocks()) {
                    MLContextUtil.deleteRemoveVariableInstructions(pb);
                }
            }
        }
        for (ProgramBlock programBlock : progam.getProgramBlocks()) {
            MLContextUtil.deleteRemoveVariableInstructions(programBlock);
        }
    }

    private static void deleteRemoveVariableInstructions(ProgramBlock pb) {
        if (pb instanceof WhileProgramBlock) {
            WhileProgramBlock wpb = (WhileProgramBlock)pb;
            for (ProgramBlock pbc : wpb.getChildBlocks()) {
                MLContextUtil.deleteRemoveVariableInstructions(pbc);
            }
        } else if (pb instanceof IfProgramBlock) {
            IfProgramBlock ipb = (IfProgramBlock)pb;
            for (ProgramBlock pbc : ipb.getChildBlocksIfBody()) {
                MLContextUtil.deleteRemoveVariableInstructions(pbc);
            }
            for (ProgramBlock pbc : ipb.getChildBlocksElseBody()) {
                MLContextUtil.deleteRemoveVariableInstructions(pbc);
            }
        } else if (pb instanceof ForProgramBlock) {
            ForProgramBlock fpb = (ForProgramBlock)pb;
            for (ProgramBlock pbc : fpb.getChildBlocks()) {
                MLContextUtil.deleteRemoveVariableInstructions(pbc);
            }
        } else {
            ArrayList<Instruction> instructions = pb.getInstructions();
            MLContextUtil.deleteRemoveVariableInstructions(instructions);
        }
    }

    private static void deleteRemoveVariableInstructions(ArrayList<Instruction> instructions) {
        for (int i = 0; i < instructions.size(); ++i) {
            Instruction linst = instructions.get(i);
            if (!(linst instanceof VariableCPInstruction) || !((VariableCPInstruction)linst).isRemoveVariable()) continue;
            VariableCPInstruction varinst = (VariableCPInstruction)linst;
            instructions.remove(varinst);
            --i;
        }
    }

    public static String getHopDAG(MLContext mlCtx, Script script, ArrayList<Integer> lines, boolean performHOPRewrites, boolean withSubgraph) throws HopsException, DMLRuntimeException, LanguageException {
        return MLContextUtil.getHopDAG(mlCtx, script, lines, null, performHOPRewrites, withSubgraph);
    }

    public static String getHopDAG(MLContext mlCtx, Script script, ArrayList<Integer> lines, SparkConf newConf, boolean performHOPRewrites, boolean withSubgraph) throws HopsException, DMLRuntimeException, LanguageException {
        SparkConf oldConf = mlCtx.getSparkSession().sparkContext().getConf();
        SparkExecutionContext.SparkClusterConfig systemmlConf = SparkExecutionContext.getSparkClusterConfig();
        long oldMaxMemory = InfrastructureAnalyzer.getLocalMaxMemory();
        try {
            if (newConf != null) {
                systemmlConf.analyzeSparkConfiguation(newConf);
                InfrastructureAnalyzer.setLocalMaxMemory(newConf.getSizeAsBytes("spark.driver.memory"));
            }
            ScriptExecutor scriptExecutor = new ScriptExecutor();
            scriptExecutor.setExecutionType(mlCtx.getExecutionType());
            scriptExecutor.setGPU(mlCtx.isGPU());
            scriptExecutor.setForceGPU(mlCtx.isForceGPU());
            scriptExecutor.setInit(mlCtx.isInitBeforeExecution());
            if (mlCtx.isInitBeforeExecution()) {
                mlCtx.setInitBeforeExecution(false);
            }
            scriptExecutor.setMaintainSymbolTable(mlCtx.isMaintainSymbolTable());
            Long time = new Long(new Date().getTime());
            if (script.getName() == null || script.getName().equals("")) {
                script.setName(time.toString());
            }
            mlCtx.setExecutionScript(script);
            scriptExecutor.compile(script, performHOPRewrites);
            Explain.reset();
            lines = lines.size() == 1 && lines.get(0) == -1 ? new ArrayList() : lines;
            String string = Explain.getHopDAG(scriptExecutor.dmlProgram, lines, withSubgraph);
            return string;
        }
        catch (RuntimeException e) {
            throw new MLContextException("Exception when compiling script", e);
        }
        finally {
            if (newConf != null) {
                systemmlConf.analyzeSparkConfiguation(oldConf);
                InfrastructureAnalyzer.setLocalMaxMemory(oldMaxMemory);
            }
        }
    }
}

