/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.util;

import java.util.Iterator;
import org.apache.sysml.runtime.util.UtilFunctions;

public class LongLongDoubleHashMap {
    private static final int INIT_CAPACITY = 8;
    private static final int RESIZE_FACTOR = 2;
    private static final float LOAD_FACTOR = 0.75f;
    private LLDoubleEntry[] data = new LLDoubleEntry[8];
    private int size = 0;

    public int size() {
        return this.size;
    }

    public void addValue(long key1, long key2, double value) {
        int hash = LongLongDoubleHashMap.hash(key1, key2);
        int ix = LongLongDoubleHashMap.indexFor(hash, this.data.length);
        LLDoubleEntry e = this.data[ix];
        while (e != null) {
            if (e.key1 == key1 && e.key2 == key2) {
                e.value += value;
                return;
            }
            e = e.next;
        }
        LLDoubleEntry enew = new LLDoubleEntry(key1, key2, value);
        enew.next = this.data[ix];
        this.data[ix] = enew;
        ++this.size;
        if ((float)this.size >= 0.75f * (float)this.data.length) {
            this.resize();
        }
    }

    public Iterator<LLDoubleEntry> getIterator() {
        return new LLDoubleEntryIterator();
    }

    private void resize() {
        if (this.data.length > 0x3FFFFFFF) {
            return;
        }
        LLDoubleEntry[] olddata = this.data;
        this.data = new LLDoubleEntry[this.data.length * 2];
        this.size = 0;
        for (LLDoubleEntry e : olddata) {
            if (e == null) continue;
            while (e.next != null) {
                this.addValue(e.key1, e.key2, e.value);
                e = e.next;
            }
            this.addValue(e.key1, e.key2, e.value);
        }
    }

    private static int hash(long key1, long key2) {
        int h = UtilFunctions.longHashCode(key1, key2);
        h ^= h >>> 20 ^ h >>> 12;
        return h ^ h >>> 7 ^ h >>> 4;
    }

    private static int indexFor(int h, int length) {
        return h & length - 1;
    }

    private class LLDoubleEntryIterator
    implements Iterator<LLDoubleEntry> {
        private LLDoubleEntry _curr = null;
        private int _currPos = -1;

        public LLDoubleEntryIterator() {
            this.findNext();
        }

        @Override
        public boolean hasNext() {
            return this._curr != null;
        }

        @Override
        public LLDoubleEntry next() {
            LLDoubleEntry ret = this._curr;
            this.findNext();
            return ret;
        }

        private void findNext() {
            if (this._curr != null && this._curr.next != null) {
                this._curr = this._curr.next;
                return;
            }
            ++this._currPos;
            while (this._currPos < LongLongDoubleHashMap.this.data.length) {
                this._curr = LongLongDoubleHashMap.this.data[this._currPos];
                if (this._curr != null) {
                    return;
                }
                ++this._currPos;
            }
            this._curr = null;
        }
    }

    public class LLDoubleEntry {
        public long key1 = Long.MAX_VALUE;
        public long key2 = Long.MAX_VALUE;
        public double value = Double.MAX_VALUE;
        public LLDoubleEntry next = null;

        public LLDoubleEntry(long k1, long k2, double val) {
            this.key1 = k1;
            this.key2 = k2;
            this.value = val;
            this.next = null;
        }
    }
}

