/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.transform.encode;

import org.apache.sysml.runtime.matrix.data.FrameBlock;
import org.apache.sysml.runtime.matrix.data.MatrixBlock;
import org.apache.sysml.runtime.transform.encode.Encoder;
import org.apache.sysml.runtime.transform.meta.TfMetaUtils;
import org.apache.sysml.runtime.util.UtilFunctions;
import org.apache.wink.json4j.JSONException;
import org.apache.wink.json4j.JSONObject;

public class EncoderDummycode
extends Encoder {
    private static final long serialVersionUID = 5832130477659116489L;
    private int[] _domainSizes = null;
    private long _dummycodedLength = 0L;

    public EncoderDummycode(JSONObject parsedSpec, String[] colnames, int clen) throws JSONException {
        super(null, clen);
        if (parsedSpec.containsKey("dummycode")) {
            int[] collist = TfMetaUtils.parseJsonIDList(parsedSpec, colnames, "dummycode");
            this.initColList(collist);
        }
    }

    @Override
    public int getNumCols() {
        return (int)this._dummycodedLength;
    }

    @Override
    public MatrixBlock encode(FrameBlock in, MatrixBlock out) {
        return this.apply(in, out);
    }

    @Override
    public void build(FrameBlock in) {
    }

    @Override
    public MatrixBlock apply(FrameBlock in, MatrixBlock out) {
        MatrixBlock ret = new MatrixBlock(out.getNumRows(), (int)this._dummycodedLength, false);
        for (int i = 0; i < out.getNumRows(); ++i) {
            int idx = 0;
            int ncolID = 1;
            for (int colID = 1; colID <= out.getNumColumns(); ++colID) {
                double val = out.quickGetValue(i, colID - 1);
                if (idx < this._colList.length && colID == this._colList[idx]) {
                    ret.quickSetValue(i, ncolID - 1 + (int)val - 1, 1.0);
                    ncolID += this._domainSizes[idx];
                    ++idx;
                    continue;
                }
                double ptval = UtilFunctions.objectToDouble(in.getSchema()[colID - 1], in.get(i, colID - 1));
                ret.quickSetValue(i, ncolID - 1, ptval);
                ++ncolID;
            }
        }
        return ret;
    }

    @Override
    public FrameBlock getMetaData(FrameBlock out) {
        return out;
    }

    @Override
    public void initMetaData(FrameBlock meta) {
        this._domainSizes = new int[this._colList.length];
        this._dummycodedLength = this._clen;
        for (int j = 0; j < this._colList.length; ++j) {
            int colID = this._colList[j];
            this._domainSizes[j] = (int)meta.getColumnMetadata()[colID - 1].getNumDistinct();
            this._dummycodedLength += (long)(this._domainSizes[j] - 1);
        }
    }
}

