/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.matrix.mapred;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapred.Reporter;
import org.apache.sysml.runtime.DMLRuntimeException;
import org.apache.sysml.runtime.io.MatrixWriter;
import org.apache.sysml.runtime.matrix.data.CTableMap;
import org.apache.sysml.runtime.matrix.data.MatrixBlock;
import org.apache.sysml.runtime.matrix.data.MatrixCell;
import org.apache.sysml.runtime.matrix.data.MatrixIndexes;
import org.apache.sysml.runtime.matrix.mapred.CollectMultipleConvertedOutputs;
import org.apache.sysml.runtime.matrix.mapred.ReduceBase;
import org.apache.sysml.runtime.util.LongLongDoubleHashMap;

public class GMRCtableBuffer {
    public static final int MAX_BUFFER_SIZE = 4096;
    private HashMap<Byte, CTableMap> _mapBuffer = null;
    private HashMap<Byte, MatrixBlock> _blockBuffer = null;
    private CollectMultipleConvertedOutputs _collector = null;
    private byte[] _resultIndexes = null;
    private long[] _resultNonZeros = null;
    private byte[] _resultDimsUnknown = null;
    private long[] _resultMaxRowDims = null;
    private long[] _resultMaxColDims = null;

    public GMRCtableBuffer(CollectMultipleConvertedOutputs collector, boolean outputDimsKnown) {
        if (outputDimsKnown) {
            this._blockBuffer = new HashMap();
        } else {
            this._mapBuffer = new HashMap();
        }
        this._collector = collector;
    }

    public void setMetadataReferences(byte[] resultIndexes, long[] resultsNonZeros, byte[] resultDimsUnknown, long[] resultsMaxRowDims, long[] resultsMaxColDims) {
        this._resultIndexes = resultIndexes;
        this._resultNonZeros = resultsNonZeros;
        this._resultDimsUnknown = resultDimsUnknown;
        this._resultMaxRowDims = resultsMaxRowDims;
        this._resultMaxColDims = resultsMaxColDims;
    }

    public int getBufferSize() {
        if (this._mapBuffer != null) {
            int ret = 0;
            for (Map.Entry<Byte, CTableMap> ctable : this._mapBuffer.entrySet()) {
                ret += ctable.getValue().size();
            }
            return ret;
        }
        if (this._blockBuffer != null) {
            int ret = 0;
            for (Map.Entry<Byte, MatrixBlock> ctable : this._blockBuffer.entrySet()) {
                ctable.getValue().recomputeNonZeros();
                ret = (int)((long)ret + MatrixBlock.estimateSizeInMemory(ctable.getValue().getNumRows(), ctable.getValue().getNumColumns(), (double)ctable.getValue().getNonZeros() / (double)ctable.getValue().getNumRows() * (double)ctable.getValue().getNumColumns()));
            }
            return ret;
        }
        return 0;
    }

    public HashMap<Byte, CTableMap> getMapBuffer() {
        return this._mapBuffer;
    }

    public HashMap<Byte, MatrixBlock> getBlockBuffer() {
        return this._blockBuffer;
    }

    public void flushBuffer(Reporter reporter) throws RuntimeException {
        block16: {
            try {
                if (this._mapBuffer != null) {
                    MatrixIndexes key = null;
                    MatrixCell value = new MatrixCell();
                    for (Map.Entry<Byte, CTableMap> ctable : this._mapBuffer.entrySet()) {
                        ArrayList<Integer> resultIDs = ReduceBase.getOutputIndexes(ctable.getKey(), this._resultIndexes);
                        CTableMap resultMap = ctable.getValue();
                        for (Integer i : resultIDs) {
                            int n = i;
                            this._resultNonZeros[n] = this._resultNonZeros[n] + (long)resultMap.size();
                            if (this._resultDimsUnknown[i] != 1) continue;
                            this._resultMaxRowDims[i.intValue()] = Math.max(resultMap.getMaxRow(), this._resultMaxRowDims[i]);
                            this._resultMaxColDims[i.intValue()] = Math.max(resultMap.getMaxColumn(), this._resultMaxColDims[i]);
                        }
                        Iterator<LongLongDoubleHashMap.LLDoubleEntry> iter = resultMap.getIterator();
                        while (iter.hasNext()) {
                            LongLongDoubleHashMap.LLDoubleEntry e = iter.next();
                            key = new MatrixIndexes(e.key1, e.key2);
                            value.setValue(e.value);
                            for (Integer i : resultIDs) {
                                this._collector.collectOutput((Writable)key, (Writable)value, i, reporter);
                            }
                        }
                    }
                    break block16;
                }
                if (this._blockBuffer != null) {
                    MatrixIndexes key = new MatrixIndexes(1L, 1L);
                    for (Map.Entry<Byte, MatrixBlock> ctable : this._blockBuffer.entrySet()) {
                        ArrayList<Integer> resultIDs = ReduceBase.getOutputIndexes(ctable.getKey(), this._resultIndexes);
                        MatrixBlock outBlock = ctable.getValue();
                        outBlock.recomputeNonZeros();
                        int brlen = 1000;
                        int bclen = 1000;
                        int rlen = outBlock.getNumRows();
                        int clen = outBlock.getNumColumns();
                        if (rlen <= brlen && clen <= brlen) {
                            key = new MatrixIndexes(1L, 1L);
                            for (Integer i : resultIDs) {
                                this._collector.collectOutput((Writable)key, outBlock, i, reporter);
                                int n = i;
                                this._resultNonZeros[n] = this._resultNonZeros[n] + outBlock.getNonZeros();
                            }
                            continue;
                        }
                        MatrixBlock[] blocks = MatrixWriter.createMatrixBlocksForReuse(rlen, clen, brlen, bclen, true, outBlock.getNonZeros());
                        for (int blockRow = 0; blockRow < (int)Math.ceil((double)rlen / (double)brlen); ++blockRow) {
                            for (int blockCol = 0; blockCol < (int)Math.ceil((double)clen / (double)bclen); ++blockCol) {
                                int maxRow = blockRow * brlen + brlen < rlen ? brlen : rlen - blockRow * brlen;
                                int maxCol = blockCol * bclen + bclen < clen ? bclen : clen - blockCol * bclen;
                                int row_offset = blockRow * brlen;
                                int col_offset = blockCol * bclen;
                                MatrixBlock block = MatrixWriter.getMatrixBlockForReuse(blocks, maxRow, maxCol, brlen, bclen);
                                outBlock.sliceOperations(row_offset, row_offset + maxRow - 1, col_offset, col_offset + maxCol - 1, block);
                                key.setIndexes(blockRow + 1, blockCol + 1);
                                for (Integer i : resultIDs) {
                                    this._collector.collectOutput((Writable)key, block, i, reporter);
                                    int n = i;
                                    this._resultNonZeros[n] = this._resultNonZeros[n] + block.getNonZeros();
                                }
                                block.reset();
                            }
                        }
                    }
                    break block16;
                }
                throw new DMLRuntimeException("Unexpected.. both ctable buffers are empty.");
            }
            catch (Exception ex) {
                throw new RuntimeException("Failed to flush ctable buffer.", ex);
            }
        }
        if (this._mapBuffer != null) {
            this._mapBuffer.clear();
        } else {
            this._blockBuffer.clear();
        }
    }
}

