/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.instructions.gpu;

import org.apache.sysml.lops.MMTSJ;
import org.apache.sysml.runtime.DMLRuntimeException;
import org.apache.sysml.runtime.controlprogram.caching.MatrixObject;
import org.apache.sysml.runtime.controlprogram.context.ExecutionContext;
import org.apache.sysml.runtime.instructions.InstructionUtils;
import org.apache.sysml.runtime.instructions.cp.CPOperand;
import org.apache.sysml.runtime.instructions.gpu.GPUInstruction;
import org.apache.sysml.runtime.matrix.data.LibMatrixCUDA;
import org.apache.sysml.runtime.matrix.operators.Operator;
import org.apache.sysml.utils.GPUStatistics;

public class MMTSJGPUInstruction
extends GPUInstruction {
    private MMTSJ.MMTSJType _type = null;
    CPOperand _input;
    CPOperand _output;

    private MMTSJGPUInstruction(Operator op, CPOperand in1, MMTSJ.MMTSJType type, CPOperand out, String opcode, String istr) {
        super(op, opcode, istr);
        this._gputype = GPUInstruction.GPUINSTRUCTION_TYPE.MMTSJ;
        this._type = type;
        this._input = in1;
        this._output = out;
    }

    public static MMTSJGPUInstruction parseInstruction(String str) throws DMLRuntimeException {
        String[] parts = InstructionUtils.getInstructionPartsWithValueType(str);
        InstructionUtils.checkNumFields(parts, 3);
        String opcode = parts[0];
        CPOperand in1 = new CPOperand(parts[1]);
        CPOperand out = new CPOperand(parts[2]);
        MMTSJ.MMTSJType titype = MMTSJ.MMTSJType.valueOf(parts[3]);
        if (!opcode.equalsIgnoreCase("tsmm")) {
            throw new DMLRuntimeException("Unknown opcode while parsing an MMTSJGPUInstruction: " + str);
        }
        return new MMTSJGPUInstruction(new Operator(true), in1, titype, out, opcode, str);
    }

    @Override
    public void processInstruction(ExecutionContext ec) throws DMLRuntimeException {
        int rlen;
        GPUStatistics.incrementNoOfExecutedGPUInst();
        MatrixObject mat = this.getMatrixInputForGPUInstruction(ec, this._input.getName());
        boolean isLeftTransposed = this._type == MMTSJ.MMTSJType.LEFT;
        int clen = rlen = (int)(isLeftTransposed ? mat.getNumColumns() : mat.getNumRows());
        ec.setMetaData(this._output.getName(), rlen, clen);
        LibMatrixCUDA.matmultTSMM(ec, ec.getGPUContext(0), this.getExtendedOpcode(), mat, this._output.getName(), isLeftTransposed);
        ec.releaseMatrixInputForGPUInstruction(this._input.getName());
        ec.releaseMatrixOutputForGPUInstruction(this._output.getName());
    }

    public MMTSJ.MMTSJType getMMTSJType() {
        return this._type;
    }
}

