/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.controlprogram.parfor;

import java.io.IOException;
import java.util.HashMap;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.Mapper;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.hadoop.mapred.Reporter;
import org.apache.sysml.api.DMLScript;
import org.apache.sysml.conf.ConfigurationManager;
import org.apache.sysml.runtime.controlprogram.LocalVariableMap;
import org.apache.sysml.runtime.controlprogram.ParForProgramBlock;
import org.apache.sysml.runtime.controlprogram.caching.CacheStatistics;
import org.apache.sysml.runtime.controlprogram.caching.CacheableData;
import org.apache.sysml.runtime.controlprogram.caching.MatrixObject;
import org.apache.sysml.runtime.controlprogram.parfor.ParForBody;
import org.apache.sysml.runtime.controlprogram.parfor.ParWorker;
import org.apache.sysml.runtime.controlprogram.parfor.ProgramConverter;
import org.apache.sysml.runtime.controlprogram.parfor.RemoteParForUtils;
import org.apache.sysml.runtime.controlprogram.parfor.Task;
import org.apache.sysml.runtime.controlprogram.parfor.stat.InfrastructureAnalyzer;
import org.apache.sysml.runtime.controlprogram.parfor.stat.StatisticMonitor;
import org.apache.sysml.runtime.controlprogram.parfor.util.IDHandler;
import org.apache.sysml.runtime.instructions.cp.Data;
import org.apache.sysml.runtime.matrix.mapred.MRConfigurationNames;
import org.apache.sysml.runtime.matrix.mapred.MRJobConfiguration;
import org.apache.sysml.runtime.util.LocalFileUtils;
import org.apache.sysml.utils.Statistics;

public class RemoteParWorkerMapper
extends ParWorker
implements Mapper<LongWritable, Text, Writable, Writable> {
    private static HashMap<String, RemoteParWorkerMapper> _sCache = null;
    protected String _stringID = null;
    protected HashMap<String, String> _rvarFnames = new HashMap();

    public void map(LongWritable key, Text value, OutputCollector<Writable, Writable> out, Reporter reporter) throws IOException {
        LOG.trace((Object)("execute RemoteParWorkerMapper " + this._stringID + " (" + this._workerID + ")"));
        long numIters = this.getExecutedIterations();
        try {
            Task lTask = Task.parseCompactString(value.toString());
            this.executeTask(lTask);
            RemoteParForUtils.exportResultVariables(this._workerID, this._ec.getVariables(), this._resultVars, this._rvarFnames, out);
        }
        catch (Exception ex) {
            throw new IOException("ParFOR: Failed to execute task.", ex);
        }
        RemoteParForUtils.incrementParForMRCounters(reporter, 1L, this.getExecutedIterations() - numIters);
        JobConf job = ConfigurationManager.getCachedJobConf();
        if (DMLScript.STATISTICS && !InfrastructureAnalyzer.isLocalMode(job)) {
            LOG.info((Object)("\nSystemML Statistics:\nHeavy hitter instructions (name, time, count):\n" + Statistics.getHeavyHitters(DMLScript.STATISTICS_COUNT)));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void configure(JobConf job) {
        HashMap<String, RemoteParWorkerMapper> hashMap;
        boolean requiresConfigure = true;
        String jobID = job.get(MRConfigurationNames.MR_JOB_ID);
        if (ParForProgramBlock.ALLOW_REUSE_MR_PAR_WORKER) {
            hashMap = _sCache;
            synchronized (hashMap) {
                if (_sCache.containsKey(jobID)) {
                    RemoteParWorkerMapper tmp = _sCache.get(jobID);
                    this._stringID = tmp._stringID;
                    this._workerID = tmp._workerID;
                    this._childBlocks = tmp._childBlocks;
                    this._resultVars = tmp._resultVars;
                    this._ec = tmp._ec;
                    this._numIters = tmp._numIters;
                    this._numTasks = tmp._numTasks;
                    this._rvarFnames = tmp._rvarFnames;
                    requiresConfigure = false;
                }
            }
        }
        if (requiresConfigure) {
            LOG.trace((Object)("configure RemoteParWorkerMapper " + job.get(MRConfigurationNames.MR_TASK_ID)));
            try {
                this._stringID = job.get(MRConfigurationNames.MR_TASK_ID);
                this._workerID = IDHandler.extractIntID(this._stringID);
                if (!InfrastructureAnalyzer.isLocalMode(job)) {
                    ConfigurationManager.setCachedJobConf(job);
                }
                String in = MRJobConfiguration.getProgramBlocks(job);
                ParForBody body = ProgramConverter.parseParForBody(in, (int)this._workerID);
                this._childBlocks = body.getChildBlocks();
                this._ec = body.getEc();
                this._resultVars = body.getResultVarNames();
                if (!CacheableData.isCachingActive()) {
                    String uuid = IDHandler.createDistributedUniqueID();
                    LocalFileUtils.createWorkingDirectoryWithUUID(uuid);
                    CacheableData.initCaching(uuid);
                }
                if (!CacheableData.cacheEvictionLocalFilePrefix.contains("_")) {
                    CacheableData.cacheEvictionLocalFilePrefix = CacheableData.cacheEvictionLocalFilePrefix + "_" + this._workerID;
                }
                super.pinResultVariables();
                boolean cpCaching = MRJobConfiguration.getParforCachingConfig(job);
                if (!cpCaching) {
                    CacheableData.disableCaching();
                }
                this._numTasks = 0L;
                this._numIters = 0L;
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
            StatisticMonitor.disableStatMonitoring();
            if (ParForProgramBlock.ALLOW_REUSE_MR_PAR_WORKER) {
                hashMap = _sCache;
                synchronized (hashMap) {
                    _sCache.put(jobID, this);
                }
            }
        } else {
            LOG.trace((Object)("reuse configured RemoteParWorkerMapper " + this._stringID));
        }
        if (DMLScript.STATISTICS && !InfrastructureAnalyzer.isLocalMode(job)) {
            CacheStatistics.reset();
            Statistics.reset();
        }
    }

    public void close() throws IOException {
        RemoteParForUtils.cleanupWorkingDirectories();
        if (ParForProgramBlock.ALLOW_REUSE_MR_PAR_WORKER) {
            for (RemoteParWorkerMapper pw : _sCache.values()) {
                LocalVariableMap vars = pw._ec.getVariables();
                for (String varName : vars.keySet()) {
                    Data dat = vars.get(varName);
                    if (!(dat instanceof MatrixObject)) continue;
                    ((MatrixObject)dat).setEmptyStatus();
                }
            }
        }
        CacheableData.enableCaching();
    }

    static {
        _sCache = new HashMap();
    }
}

