/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.parser;

import org.apache.sysml.parser.DataIdentifier;
import org.apache.sysml.parser.LanguageException;
import org.apache.sysml.parser.VariableSet;

public abstract class LiveVariableAnalysis {
    VariableSet _read;
    VariableSet _updated;
    VariableSet _gen;
    VariableSet _kill;
    VariableSet _liveIn;
    VariableSet _liveOut;
    boolean _initialized = false;
    VariableSet _warnSet;

    public VariableSet variablesRead() {
        return this._read;
    }

    public VariableSet variablesUpdated() {
        return this._updated;
    }

    public VariableSet getWarn() {
        return this._warnSet;
    }

    public VariableSet liveIn() {
        return this._liveIn;
    }

    public VariableSet liveOut() {
        return this._liveOut;
    }

    public VariableSet getKill() {
        return this._kill;
    }

    public VariableSet getGen() {
        return this._gen;
    }

    public void setLiveOut(VariableSet lo) {
        this._liveOut = lo;
    }

    public void setLiveIn(VariableSet li) {
        this._liveIn = li;
    }

    public void setKill(VariableSet ki) {
        this._kill = ki;
    }

    public void setGen(VariableSet ge) {
        this._gen = ge;
    }

    public void setUpdatedVariables(VariableSet vars) {
        this._updated = vars;
    }

    public void setReadVariables(VariableSet vars) {
        this._read = vars;
    }

    public abstract VariableSet initializeforwardLV(VariableSet var1) throws LanguageException;

    public abstract VariableSet initializebackwardLV(VariableSet var1) throws LanguageException;

    public abstract VariableSet analyze(VariableSet var1) throws LanguageException;

    public void updateLiveVariablesOut(VariableSet liveOut) {
        this.updateLiveVariables(this._liveOut, liveOut);
    }

    private void updateLiveVariables(VariableSet origVars, VariableSet newVars) {
        for (String var : newVars.getVariables().keySet()) {
            DataIdentifier varId;
            if (!origVars.containsVariable(var) || (varId = newVars.getVariable(var)) == null) continue;
            origVars.addVariable(var, varId);
        }
    }
}

