/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.lops;

import org.apache.sysml.lops.Lop;
import org.apache.sysml.lops.LopProperties;
import org.apache.sysml.lops.LopsException;
import org.apache.sysml.lops.compile.JobType;
import org.apache.sysml.parser.Expression;

public class ZeroOut
extends Lop {
    private void init(Lop inputMatrix, Lop rowL, Lop rowU, Lop colL, Lop colU, long rowDim, long colDim, Expression.DataType dt, Expression.ValueType vt, LopProperties.ExecType et) {
        this.addInput(inputMatrix);
        this.addInput(rowL);
        this.addInput(rowU);
        this.addInput(colL);
        this.addInput(colU);
        inputMatrix.addOutput(this);
        rowL.addOutput(this);
        rowU.addOutput(this);
        colL.addOutput(this);
        colU.addOutput(this);
        boolean breaksAlignment = true;
        boolean aligner = false;
        boolean definesMRJob = false;
        if (et == LopProperties.ExecType.MR) {
            this.lps.addCompatibility(JobType.GMR);
            this.lps.addCompatibility(JobType.DATAGEN);
            this.lps.addCompatibility(JobType.MMCJ);
            this.lps.addCompatibility(JobType.MMRJ);
            this.lps.setProperties(this.inputs, et, LopProperties.ExecLocation.Map, breaksAlignment, aligner, definesMRJob);
        } else {
            this.lps.addCompatibility(JobType.INVALID);
            this.lps.setProperties(this.inputs, et, LopProperties.ExecLocation.ControlProgram, breaksAlignment, aligner, definesMRJob);
        }
    }

    public ZeroOut(Lop input, Lop rowL, Lop rowU, Lop colL, Lop colU, long rowDim, long colDim, Expression.DataType dt, Expression.ValueType vt, LopProperties.ExecType et) throws LopsException {
        super(Lop.Type.ZeroOut, dt, vt);
        this.init(input, rowL, rowU, colL, colU, rowDim, colDim, dt, vt, et);
    }

    private String getOpcode() {
        return "zeroOut";
    }

    @Override
    public String getInstructions(String input, String rowl, String rowu, String coll, String colu, String output) throws LopsException {
        StringBuilder sb = new StringBuilder();
        sb.append((Object)this.getExecType());
        sb.append("\u00b0");
        sb.append(this.getOpcode());
        sb.append("\u00b0");
        sb.append(this.getInputs().get(0).prepInputOperand(input));
        sb.append("\u00b0");
        sb.append(this.getInputs().get(1).prepScalarInputOperand(this.getExecType()));
        sb.append("\u00b0");
        sb.append(this.getInputs().get(2).prepScalarInputOperand(this.getExecType()));
        sb.append("\u00b0");
        sb.append(this.getInputs().get(3).prepScalarInputOperand(this.getExecType()));
        sb.append("\u00b0");
        sb.append(this.getInputs().get(4).prepScalarInputOperand(this.getExecType()));
        sb.append("\u00b0");
        sb.append(this.prepOutputOperand(output));
        return sb.toString();
    }

    @Override
    public String getInstructions(int input_index1, int input_index2, int input_index3, int input_index4, int input_index5, int output_index) throws LopsException {
        return this.getInstructions(String.valueOf(input_index1), String.valueOf(input_index2), String.valueOf(input_index3), String.valueOf(input_index4), String.valueOf(input_index5), String.valueOf(output_index));
    }

    @Override
    public String toString() {
        return "ZeroOut";
    }
}

