/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.lops;

import org.apache.sysml.lops.Lop;
import org.apache.sysml.lops.LopProperties;
import org.apache.sysml.lops.LopsException;
import org.apache.sysml.lops.compile.JobType;
import org.apache.sysml.parser.Expression;

public class MapMultChain
extends Lop {
    public static final String OPCODE = "mapmmchain";
    public static final String OPCODE_CP = "mmchain";
    private ChainType _chainType = null;
    private int _numThreads = 1;

    public MapMultChain(Lop input1, Lop input2, Expression.DataType dt, Expression.ValueType vt, LopProperties.ExecType et) throws LopsException {
        super(Lop.Type.MapMultChain, dt, vt);
        this.addInput(input1);
        this.addInput(input2);
        input1.addOutput(this);
        input2.addOutput(this);
        this._chainType = ChainType.XtXv;
        this.setupLopProperties(et);
    }

    public MapMultChain(Lop input1, Lop input2, Lop input3, ChainType chain, Expression.DataType dt, Expression.ValueType vt, LopProperties.ExecType et) throws LopsException {
        super(Lop.Type.MapMultChain, dt, vt);
        this.addInput(input1);
        this.addInput(input2);
        this.addInput(input3);
        input1.addOutput(this);
        input2.addOutput(this);
        input3.addOutput(this);
        this._chainType = chain;
        this.setupLopProperties(et);
    }

    private void setupLopProperties(LopProperties.ExecType et) {
        if (et == LopProperties.ExecType.MR) {
            boolean breaksAlignment = true;
            boolean aligner = false;
            boolean definesMRJob = false;
            this.lps.addCompatibility(JobType.GMR);
            this.lps.addCompatibility(JobType.DATAGEN);
            this.lps.setProperties(this.inputs, LopProperties.ExecType.MR, LopProperties.ExecLocation.Map, breaksAlignment, aligner, definesMRJob);
        } else {
            boolean breaksAlignment = false;
            boolean aligner = false;
            boolean definesMRJob = false;
            this.lps.addCompatibility(JobType.INVALID);
            this.lps.setProperties(this.inputs, et, LopProperties.ExecLocation.ControlProgram, breaksAlignment, aligner, definesMRJob);
        }
    }

    public void setNumThreads(int k) {
        this._numThreads = k;
    }

    @Override
    public String toString() {
        return "Operation = MapMMChain";
    }

    @Override
    public String getInstructions(int input_index1, int input_index2, int output_index) {
        return this.getInstructions(String.valueOf(input_index1), String.valueOf(input_index2), null, String.valueOf(output_index));
    }

    @Override
    public String getInstructions(int input_index1, int input_index2, int input_index3, int output_index) {
        return this.getInstructions(String.valueOf(input_index1), String.valueOf(input_index2), String.valueOf(input_index3), String.valueOf(output_index));
    }

    @Override
    public String getInstructions(String input1, String input2, String output) {
        return this.getInstructions(input1, input2, null, output);
    }

    @Override
    public String getInstructions(String input1, String input2, String input3, String output) {
        StringBuilder sb = new StringBuilder();
        sb.append((Object)this.getExecType());
        sb.append("\u00b0");
        if (this.getExecType() == LopProperties.ExecType.CP) {
            sb.append(OPCODE_CP);
        } else {
            sb.append(OPCODE);
        }
        sb.append("\u00b0");
        sb.append(this.getInputs().get(0).prepInputOperand(input1));
        sb.append("\u00b0");
        sb.append(this.getInputs().get(1).prepInputOperand(input2));
        if (input3 != null) {
            sb.append("\u00b0");
            sb.append(this.getInputs().get(2).prepInputOperand(input3));
        }
        sb.append("\u00b0");
        sb.append(this.prepOutputOperand(output));
        sb.append("\u00b0");
        sb.append((Object)this._chainType);
        if (this.getExecType() == LopProperties.ExecType.CP) {
            sb.append("\u00b0");
            sb.append(this._numThreads);
        }
        return sb.toString();
    }

    @Override
    public boolean usesDistributedCache() {
        return true;
    }

    @Override
    public int[] distributedCacheInputIndex() {
        int[] nArray;
        if (this._chainType == ChainType.XtXv) {
            int[] nArray2 = new int[1];
            nArray = nArray2;
            nArray2[0] = 2;
        } else {
            int[] nArray3 = new int[2];
            nArray3[0] = 2;
            nArray = nArray3;
            nArray3[1] = 3;
        }
        return nArray;
    }

    public static enum ChainType {
        XtXv,
        XtwXv,
        XtXvy,
        NONE;

    }
}

