/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.conf;

import org.apache.hadoop.mapred.JobConf;
import org.apache.sysml.conf.CompilerConfig;
import org.apache.sysml.conf.DMLConfig;

public class ConfigurationManager {
    private static JobConf _rJob = null;
    private static DMLConfig _dmlconf = null;
    private static ThreadLocalDMLConfig _ldmlconf = new ThreadLocalDMLConfig();
    private static CompilerConfig _cconf = null;
    private static ThreadLocalCompilerConfig _lcconf = new ThreadLocalCompilerConfig();

    public static JobConf getCachedJobConf() {
        return _rJob;
    }

    public static void setCachedJobConf(JobConf job) {
        _rJob = job;
    }

    public static synchronized void setGlobalConfig(DMLConfig conf) {
        _dmlconf = conf;
        _ldmlconf = new ThreadLocalDMLConfig();
    }

    public static void setLocalConfig(DMLConfig conf) {
        _ldmlconf.set(conf);
    }

    public static DMLConfig getDMLConfig() {
        return (DMLConfig)_ldmlconf.get();
    }

    public static synchronized void setGlobalConfig(CompilerConfig conf) {
        _cconf = conf;
        _lcconf = new ThreadLocalCompilerConfig();
    }

    public static void setLocalConfig(CompilerConfig conf) {
        _lcconf.set(conf);
    }

    public static void clearLocalConfigs() {
        _ldmlconf.remove();
        _lcconf.remove();
    }

    public static CompilerConfig getCompilerConfig() {
        return (CompilerConfig)_lcconf.get();
    }

    public static boolean getCompilerConfigFlag(CompilerConfig.ConfigType key) {
        CompilerConfig cconf = ConfigurationManager.getCompilerConfig();
        return cconf != null ? cconf.getBool(key) : false;
    }

    public static String getScratchSpace() {
        return ConfigurationManager.getDMLConfig().getTextValue("scratch");
    }

    public static int getBlocksize() {
        return ConfigurationManager.getCompilerConfig().getInt(CompilerConfig.ConfigType.BLOCK_SIZE);
    }

    public static int getNumReducers() {
        return ConfigurationManager.getDMLConfig().getIntValue("numreducers");
    }

    public static boolean isDynamicRecompilation() {
        return ConfigurationManager.getCompilerConfigFlag(CompilerConfig.ConfigType.ALLOW_DYN_RECOMPILATION);
    }

    public static boolean isParallelMatrixOperations() {
        return ConfigurationManager.getCompilerConfigFlag(CompilerConfig.ConfigType.PARALLEL_CP_MATRIX_OPERATIONS);
    }

    public static boolean isParallelParFor() {
        return ConfigurationManager.getCompilerConfigFlag(CompilerConfig.ConfigType.PARALLEL_LOCAL_OR_REMOTE_PARFOR);
    }

    public static boolean isCodegenEnabled() {
        return ConfigurationManager.getDMLConfig().getBooleanValue("codegen.enabled") || ConfigurationManager.getCompilerConfigFlag(CompilerConfig.ConfigType.CODEGEN_ENABLED);
    }

    static {
        _rJob = new JobConf();
        _dmlconf = new DMLConfig();
        _cconf = new CompilerConfig();
    }

    private static class ThreadLocalCompilerConfig
    extends ThreadLocal<CompilerConfig> {
        private ThreadLocalCompilerConfig() {
        }

        @Override
        protected CompilerConfig initialValue() {
            if (_cconf != null) {
                return _cconf.clone();
            }
            return null;
        }
    }

    private static class ThreadLocalDMLConfig
    extends ThreadLocal<DMLConfig> {
        private ThreadLocalDMLConfig() {
        }

        @Override
        protected DMLConfig initialValue() {
            if (_dmlconf != null) {
                return _dmlconf;
            }
            return null;
        }
    }
}

