/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.ipc.trace;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.apache.avro.ipc.trace.Span;
import org.apache.avro.ipc.trace.SpanEvent;
import org.apache.avro.ipc.trace.TimestampedEvent;
import org.apache.avro.ipc.trace.Trace;
import org.apache.avro.ipc.trace.TraceCollection;
import org.apache.avro.ipc.trace.Util;

public class SpanAggregator {
    static SpanAggregationResults getFullSpans(List<Span> partials) {
        SpanAggregationResults out = new SpanAggregationResults();
        HashMap<Long, Span> seenSpans = new HashMap<Long, Span>();
        List<SpanEvent> allEvents = Arrays.asList(SpanEvent.values());
        for (Span s : partials) {
            EnumSet<SpanEvent> foundEvents = Util.getAllEvents(s);
            if (foundEvents.containsAll(allEvents)) {
                out.completeSpans.add(s);
                continue;
            }
            if (!seenSpans.containsKey(Util.longValue(s.spanID))) {
                seenSpans.put(Util.longValue(s.spanID), s);
                continue;
            }
            Span other = (Span)((Object)seenSpans.remove(Util.longValue(s.spanID)));
            if (!other.messageName.equals(s.messageName) || !Util.idsEqual(other.parentSpanID, s.parentSpanID)) {
                out.incompleteSpans.add(s);
                out.incompleteSpans.add(other);
                continue;
            }
            foundEvents.addAll(Util.getAllEvents(other));
            if (other.requestorHostname != null) {
                s.requestorHostname = other.requestorHostname;
            }
            if (other.responderHostname != null) {
                s.responderHostname = other.responderHostname;
            }
            if (!foundEvents.containsAll(allEvents)) continue;
            for (TimestampedEvent event : other.events) {
                s.events.add(event);
            }
            s.requestPayloadSize = Math.max(s.requestPayloadSize, other.requestPayloadSize);
            s.responsePayloadSize = Math.max(s.responsePayloadSize, other.responsePayloadSize);
            s.complete = true;
            out.completeSpans.add(s);
        }
        for (Span s : seenSpans.values()) {
            out.incompleteSpans.add(s);
        }
        return out;
    }

    static TraceFormationResults getTraces(List<Span> spans) {
        HashMap traces = new HashMap();
        for (Span s : spans) {
            if (traces.get(Util.longValue(s.traceID)) == null) {
                traces.put(Util.longValue(s.traceID), new ArrayList());
            }
            ((List)traces.get(Util.longValue(s.traceID))).add(s);
        }
        TraceFormationResults out = new TraceFormationResults();
        for (List spanSet : traces.values()) {
            Trace trace = Trace.extractTrace(spanSet);
            if (trace != null) {
                out.traces.add(trace);
                continue;
            }
            out.rejectedSpans.addAll(spanSet);
        }
        return out;
    }

    static List<TraceCollection> getTraceCollections(List<Trace> traces) {
        HashMap<Integer, TraceCollection> collections = new HashMap<Integer, TraceCollection>();
        for (Trace t : traces) {
            if (!collections.containsKey(t.executionPathHash())) {
                TraceCollection collection = new TraceCollection(t);
                collections.put(t.executionPathHash(), collection);
            }
            ((TraceCollection)collections.get(t.executionPathHash())).addTrace(t);
        }
        return new LinkedList<TraceCollection>(collections.values());
    }

    public static class TraceFormationResults {
        public List<Trace> traces = new LinkedList<Trace>();
        public List<Span> rejectedSpans = new LinkedList<Span>();
    }

    public static class SpanAggregationResults {
        public List<Span> completeSpans = new LinkedList<Span>();
        public List<Span> incompleteSpans = new LinkedList<Span>();
    }
}

