/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.yarn.ropt;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.yarn.api.records.NodeReport;
import org.apache.hadoop.yarn.api.records.NodeState;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.client.api.YarnClient;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.sysml.hops.OptimizerUtils;
import org.apache.sysml.runtime.matrix.mapred.MRConfigurationNames;
import org.apache.sysml.yarn.ropt.ResourceOptimizer;
import org.apache.sysml.yarn.ropt.YarnClusterConfig;

public class YarnClusterAnalyzer {
    public static final long DEFAULT_JVM_SIZE = 0x20000000L;
    public static final int CPU_HYPER_FACTOR = 1;
    public static int _localPar = -1;
    public static long _localJVMMaxMem = -1L;
    public static int _remotePar = -1;
    public static long _remoteJVMMaxMemMap = -1L;
    public static long _remoteJVMMaxMemReduce = -1L;
    public static long _remoteMRSortMem = -1L;
    public static long _blocksize = -1L;
    public static HashMap<Long, Long> remoteJVMMaxMemPlan = new HashMap();
    public static HashSet<Long> probedSb = new HashSet();
    public static List<Long> nodesMaxPhySorted = null;
    public static List<Double> nodesMaxBudgetSorted = null;
    public static int minimumMRContainerPhyMB = -1;
    public static long mrAMPhy = -1L;
    public static long clusterTotalMem = -1L;
    public static int clusterTotalNodes = -1;
    public static int clusterTotalCores = -1;
    public static long minimalPhyAllocate = -1L;
    public static long maximumPhyAllocate = -1L;
    private static YarnClient _client = null;

    public static List<Long> getNodesMaxPhySorted() {
        if (nodesMaxPhySorted == null) {
            YarnClusterAnalyzer.analyzeYarnCluster(true);
        }
        return nodesMaxPhySorted;
    }

    public static List<Double> getNodesMaxBudgetSorted() {
        if (nodesMaxBudgetSorted == null) {
            YarnClusterAnalyzer.analyzeYarnCluster(true);
        }
        return nodesMaxBudgetSorted;
    }

    public static long getMRARPhy() {
        if (mrAMPhy == -1L) {
            YarnClusterAnalyzer.analyzeYarnCluster(true);
        }
        return mrAMPhy;
    }

    public static long getClusterTotalMem() {
        if (clusterTotalMem == -1L) {
            YarnClusterAnalyzer.analyzeYarnCluster(true);
        }
        return clusterTotalMem;
    }

    public static long getMaxPhyAllocate() {
        if (maximumPhyAllocate == -1L) {
            YarnClusterAnalyzer.analyzeYarnCluster(true);
        }
        return maximumPhyAllocate;
    }

    public static int getMinMRContarinerPhyMB() {
        if (minimumMRContainerPhyMB == -1) {
            YarnClusterAnalyzer.analyzeYarnCluster(true);
        }
        return minimumMRContainerPhyMB;
    }

    public static int getLocalParallelism() {
        return _localPar;
    }

    public static int getRemoteParallelNodes() {
        if (_remotePar == -1) {
            YarnClusterAnalyzer.analyzeYarnCluster(true);
        }
        return _remotePar;
    }

    public static int getRemoteParallelMapTasks(long jobLookupId) {
        int ret;
        if (clusterTotalCores == -1) {
            YarnClusterAnalyzer.analyzeYarnCluster(true);
        }
        if ((ret = YarnClusterAnalyzer.getRemoteParallelTasksGivenMem(YarnClusterAnalyzer.getRemoteMaxMemoryMap(jobLookupId))) >= clusterTotalCores * 1) {
            ret = clusterTotalCores * 1;
        }
        return ret;
    }

    public static int getRemoteParallelReduceTasks(long jobLookupId) {
        int ret;
        if (clusterTotalCores == -1) {
            YarnClusterAnalyzer.analyzeYarnCluster(true);
        }
        if ((ret = YarnClusterAnalyzer.getRemoteParallelTasksGivenMem(YarnClusterAnalyzer.getRemoteMaxMemoryReduce(jobLookupId))) >= clusterTotalCores * 1) {
            ret = clusterTotalCores * 1;
        }
        return ret;
    }

    public static long getYarnPhyAllocate(long requestPhy) {
        if (minimalPhyAllocate == -1L) {
            YarnClusterAnalyzer.analyzeYarnCluster(true);
        }
        if (requestPhy > maximumPhyAllocate) {
            throw new RuntimeException("Requested " + OptimizerUtils.toMB(requestPhy) + "MB, while the maximum yarn allocate is " + OptimizerUtils.toMB(maximumPhyAllocate) + "MB");
        }
        long ret = (long)Math.ceil((double)requestPhy / (double)minimalPhyAllocate);
        if ((ret *= minimalPhyAllocate) > maximumPhyAllocate) {
            ret = maximumPhyAllocate;
        }
        return ret;
    }

    public static int getRemoteParallelTasksGivenMem(long remoteTaskJvmMemory) {
        long second;
        long taskPhy = YarnClusterAnalyzer.getYarnPhyAllocate(ResourceOptimizer.jvmToPhy(remoteTaskJvmMemory, false));
        long cpPhy = YarnClusterAnalyzer.getYarnPhyAllocate(ResourceOptimizer.jvmToPhy(YarnClusterAnalyzer.getLocalMaxMemory(), false));
        long mrAMPhy = YarnClusterAnalyzer.getYarnPhyAllocate(YarnClusterAnalyzer.getMRARPhy());
        if (nodesMaxPhySorted == null) {
            YarnClusterAnalyzer.analyzeYarnCluster(true);
        }
        if (nodesMaxPhySorted.isEmpty()) {
            return -1;
        }
        if (nodesMaxPhySorted.size() == 1) {
            long tmp = nodesMaxPhySorted.get(0) - cpPhy - mrAMPhy;
            if (tmp < 0L) {
                return -1;
            }
            return (int)(tmp / taskPhy);
        }
        long first = nodesMaxPhySorted.get(0) - cpPhy;
        if (first >= (second = nodesMaxPhySorted.get(1).longValue())) {
            first -= mrAMPhy;
        } else {
            second -= mrAMPhy;
        }
        if (first < 0L || second < 0L) {
            return -1;
        }
        long taskCount = first / taskPhy + second / taskPhy;
        int counter = 0;
        for (Long node : nodesMaxPhySorted) {
            if (counter++ < 2) continue;
            taskCount += node / taskPhy;
        }
        return (int)taskCount;
    }

    public static boolean checkValidMemPlan(boolean hasMRJob) {
        if (nodesMaxPhySorted == null) {
            YarnClusterAnalyzer.analyzeYarnCluster(true);
        }
        if (!hasMRJob) {
            return nodesMaxPhySorted.get(0) >= YarnClusterAnalyzer.getYarnPhyAllocate(ResourceOptimizer.jvmToPhy(YarnClusterAnalyzer.getLocalMaxMemory(), false));
        }
        return YarnClusterAnalyzer.getRemoteParallelTasksGivenMem(YarnClusterAnalyzer.getMaximumRemoteMaxMemory()) > 0;
    }

    public static long getLocalMaxMemory() {
        return _localJVMMaxMem;
    }

    public static void setLocalMaxMemory(long localMem) {
        _localJVMMaxMem = localMem;
    }

    public static long getMaximumRemoteMaxMemory() {
        if (_remoteJVMMaxMemMap == -1L) {
            YarnClusterAnalyzer.analyzeYarnCluster(true);
        }
        long ret = _remoteJVMMaxMemMap > _remoteJVMMaxMemReduce ? _remoteJVMMaxMemMap : _remoteJVMMaxMemReduce;
        for (Map.Entry<Long, Long> entry : remoteJVMMaxMemPlan.entrySet()) {
            if (ret >= entry.getValue()) continue;
            ret = entry.getValue();
        }
        return ret;
    }

    public static long getRemoteMaxMemoryMap(long jobLookupId) {
        long ret;
        if (_remoteJVMMaxMemMap == -1L) {
            YarnClusterAnalyzer.analyzeYarnCluster(true);
        }
        if ((ret = YarnClusterAnalyzer.getSpecifiedRemoteMaxMemory(jobLookupId)) == -1L) {
            ret = _remoteJVMMaxMemMap;
        }
        return ret;
    }

    public static long getRemoteMaxMemoryReduce(long jobLookupId) {
        long ret;
        if (_remoteJVMMaxMemReduce == -1L) {
            YarnClusterAnalyzer.analyzeYarnCluster(true);
        }
        if ((ret = YarnClusterAnalyzer.getSpecifiedRemoteMaxMemory(jobLookupId)) == -1L) {
            ret = _remoteJVMMaxMemReduce;
        }
        return ret;
    }

    public static long getSpecifiedRemoteMaxMemory(long jobLookupId) {
        probedSb.add(jobLookupId);
        Long ret = remoteJVMMaxMemPlan.get(jobLookupId);
        if (ret != null) {
            return ret;
        }
        ret = remoteJVMMaxMemPlan.get(-1L);
        if (ret != null) {
            return ret;
        }
        return -1L;
    }

    public static void setRemoteMaxMemPlan(HashMap<Long, Double> budgetMRPlan) {
        remoteJVMMaxMemPlan.clear();
        for (Map.Entry<Long, Double> entry : budgetMRPlan.entrySet()) {
            long mapJvm = ResourceOptimizer.budgetToJvm(entry.getValue());
            remoteJVMMaxMemPlan.put(entry.getKey(), mapJvm);
        }
    }

    public static void resetSBProbedSet() {
        probedSb.clear();
    }

    public static HashSet<Long> getSBProbedSet() {
        return probedSb;
    }

    public static void printProbedSet(String message) {
        ArrayList<Long> probed = new ArrayList<Long>(probedSb);
        Collections.sort(probed);
        System.out.print(message);
        for (Long id : probed) {
            System.out.print(id + ",");
        }
        System.out.println();
    }

    public static long getRemoteMaxMemorySortBuffer() {
        if (_remoteMRSortMem == -1L) {
            YarnClusterAnalyzer.analyzeYarnCluster(true);
        }
        return _remoteMRSortMem;
    }

    public static int getCkMaxCP() {
        return YarnClusterAnalyzer.getLocalParallelism();
    }

    public static int getCkMaxMR(long jobLookupId) {
        return YarnClusterAnalyzer.getRemoteParallelMapTasks(jobLookupId);
    }

    public static long getCmMax(long jobLookupId) {
        return Math.min(YarnClusterAnalyzer.getLocalMaxMemory(), YarnClusterAnalyzer.getRemoteMaxMemoryMap(jobLookupId));
    }

    public static long getHDFSBlockSize() {
        if (_blocksize == -1L) {
            YarnClusterAnalyzer.analyzeYarnCluster(true);
        }
        return _blocksize;
    }

    public static long extractMaxMemoryOpt(String javaOpts) {
        long ret = -1L;
        try {
            StringTokenizer st = new StringTokenizer(javaOpts, " ");
            while (st.hasMoreTokens()) {
                String arg = st.nextToken();
                if (!arg.startsWith("-Xmx")) continue;
                if ((arg = arg.substring(4)).endsWith("g") || arg.endsWith("G")) {
                    ret = Long.parseLong(arg.substring(0, arg.length() - 1)) * 1024L * 1024L * 1024L;
                    continue;
                }
                if (arg.endsWith("m") || arg.endsWith("M")) {
                    ret = Long.parseLong(arg.substring(0, arg.length() - 1)) * 1024L * 1024L;
                    continue;
                }
                if (arg.endsWith("k") || arg.endsWith("K")) {
                    ret = Long.parseLong(arg.substring(0, arg.length() - 1)) * 1024L;
                    continue;
                }
                ret = Long.parseLong(arg.substring(0, arg.length() - 2));
            }
            if (ret < 0L) {
                ret = 0x20000000L;
            }
        }
        catch (Exception ex) {
            ret = 0x20000000L;
        }
        return ret;
    }

    public static void setMaxMemoryOpt(JobConf job, String key, long bytes) {
        String javaOptsOld = job.get(key);
        String javaOptsNew = null;
        String[] tokens = javaOptsOld.split(" ");
        StringBuilder sb = new StringBuilder();
        for (String arg : tokens) {
            if (arg.startsWith("-Xmx")) {
                sb.append("-Xmx");
                sb.append(bytes / 0x100000L);
                sb.append("M");
            } else {
                sb.append(arg);
            }
            sb.append(" ");
        }
        javaOptsNew = sb.toString().trim();
        job.set(key, javaOptsNew);
    }

    private static void analyzeLocalMachine() {
        _localPar = Runtime.getRuntime().availableProcessors();
        _localJVMMaxMem = Runtime.getRuntime().maxMemory();
    }

    public static void analyzeYarnCluster(boolean verbose) {
        YarnConfiguration conf = new YarnConfiguration();
        YarnClient yarnClient = YarnClient.createYarnClient();
        yarnClient.init((Configuration)conf);
        yarnClient.start();
        YarnClusterAnalyzer.analyzeYarnCluster(yarnClient, conf, verbose);
    }

    public static long getMinAllocationBytes() {
        if (minimalPhyAllocate < 0L) {
            YarnClusterAnalyzer.analyzeYarnCluster(false);
        }
        return minimalPhyAllocate;
    }

    public static long getMaxAllocationBytes() {
        if (maximumPhyAllocate < 0L) {
            YarnClusterAnalyzer.analyzeYarnCluster(false);
        }
        return maximumPhyAllocate;
    }

    public static long getNumCores() {
        if (clusterTotalCores < 0) {
            YarnClusterAnalyzer.analyzeYarnCluster(false);
        }
        return clusterTotalCores;
    }

    public static long getNumNodes() {
        if (clusterTotalNodes < 0) {
            YarnClusterAnalyzer.analyzeYarnCluster(false);
        }
        return clusterTotalNodes;
    }

    public static YarnClusterConfig getClusterConfig() {
        YarnClusterConfig cc = new YarnClusterConfig();
        cc.setMinAllocationMB(YarnClusterAnalyzer.getMinAllocationBytes() / 0x100000L);
        cc.setMaxAllocationMB(YarnClusterAnalyzer.getMaxAllocationBytes() / 0x100000L);
        cc.setNumNodes(YarnClusterAnalyzer.getNumNodes());
        cc.setNumCores(YarnClusterAnalyzer.getNumCores() * 1L);
        return cc;
    }

    public static double getClusterUtilization() throws IOException {
        double util = 0.0;
        try {
            if (_client == null) {
                _client = YarnClusterAnalyzer.createYarnClient();
            }
            List nodesReport = _client.getNodeReports(new NodeState[0]);
            double maxMem = 0.0;
            double currMem = 0.0;
            long maxCores = 0L;
            long currCores = 0L;
            for (NodeReport node : nodesReport) {
                Resource max = node.getCapability();
                Resource used = node.getUsed();
                maxMem += (double)max.getMemory();
                currMem += (double)used.getMemory();
                maxCores += (long)max.getVirtualCores();
                currCores += (long)used.getVirtualCores();
            }
            util = Math.max(Math.min(1.0, currMem / maxMem), Math.min(1.0, (double)currCores / (double)maxCores));
        }
        catch (Exception ex) {
            throw new IOException(ex);
        }
        return util;
    }

    public static void analyzeYarnCluster(YarnClient yarnClient, YarnConfiguration conf, boolean verbose) {
        try {
            List nodesReport = yarnClient.getNodeReports(new NodeState[0]);
            if (verbose) {
                System.out.println("There are " + nodesReport.size() + " nodes in the cluster");
            }
            if (nodesReport.isEmpty()) {
                throw new YarnException("There are zero available nodes in the yarn cluster");
            }
            nodesMaxPhySorted = new ArrayList<Long>(nodesReport.size());
            clusterTotalMem = 0L;
            clusterTotalCores = 0;
            clusterTotalNodes = 0;
            minimumMRContainerPhyMB = -1;
            for (NodeReport node : nodesReport) {
                Resource resource = node.getCapability();
                Resource used = node.getUsed();
                if (used == null) {
                    used = Resource.newInstance((int)0, (int)0);
                }
                int mb = resource.getMemory();
                int cores = resource.getVirtualCores();
                if (mb <= 0) {
                    throw new YarnException("A node has non-positive memory " + mb);
                }
                int myMinMRPhyMB = mb / cores / 1;
                if (minimumMRContainerPhyMB < myMinMRPhyMB) {
                    minimumMRContainerPhyMB = myMinMRPhyMB;
                }
                clusterTotalMem += (long)mb * 1024L * 1024L;
                nodesMaxPhySorted.add((long)mb * 1024L * 1024L);
                clusterTotalCores += cores;
                ++clusterTotalNodes;
                if (!verbose) continue;
                System.out.println("\t" + node.getNodeId() + " has " + mb + " MB (" + used.getMemory() + " MB used) memory and " + resource.getVirtualCores() + " (" + used.getVirtualCores() + " used) cores");
            }
            Collections.sort(nodesMaxPhySorted, Collections.reverseOrder());
            nodesMaxBudgetSorted = new ArrayList<Double>(nodesMaxPhySorted.size());
            for (int i = 0; i < nodesMaxPhySorted.size(); ++i) {
                nodesMaxBudgetSorted.add(ResourceOptimizer.phyToBudget(nodesMaxPhySorted.get(i)));
            }
            _remotePar = nodesReport.size();
            if (_remotePar == 0) {
                throw new YarnException("There are no available nodes in the yarn cluster");
            }
            _remoteMRSortMem = 0x100000L * conf.getLong(MRConfigurationNames.MR_TASK_IO_SORT_MB, 100L);
            String javaOpts1 = conf.get("mapred.child.java.opts");
            String javaOpts2 = conf.get(MRConfigurationNames.MR_MAP_JAVA_OPTS, null);
            String javaOpts3 = conf.get(MRConfigurationNames.MR_REDUCE_JAVA_OPTS, null);
            _remoteJVMMaxMemMap = javaOpts2 != null ? YarnClusterAnalyzer.extractMaxMemoryOpt(javaOpts2) : YarnClusterAnalyzer.extractMaxMemoryOpt(javaOpts1);
            _remoteJVMMaxMemReduce = javaOpts3 != null ? YarnClusterAnalyzer.extractMaxMemoryOpt(javaOpts3) : YarnClusterAnalyzer.extractMaxMemoryOpt(javaOpts1);
            String blocksize = conf.get(MRConfigurationNames.DFS_BLOCKSIZE, "134217728");
            _blocksize = Long.parseLong(blocksize);
            minimalPhyAllocate = 0x100000L * (long)conf.getInt("yarn.scheduler.minimum-allocation-mb", 1024);
            maximumPhyAllocate = 0x100000L * (long)conf.getInt("yarn.scheduler.maximum-allocation-mb", 8192);
            mrAMPhy = (long)conf.getInt("yarn.app.mapreduce.am.resource.mb", 1536) * 1024L * 1024L;
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to analyze yarn cluster ", e);
        }
    }

    private static YarnClient createYarnClient() {
        YarnConfiguration conf = new YarnConfiguration();
        YarnClient yarnClient = YarnClient.createYarnClient();
        yarnClient.init((Configuration)conf);
        yarnClient.start();
        return yarnClient;
    }

    static {
        YarnClusterAnalyzer.analyzeLocalMachine();
    }
}

