/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.matrix.mapred;

import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.TreeMap;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.filecache.DistributedCache;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapred.FileOutputFormat;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.lib.CombineSequenceFileInputFormat;
import org.apache.hadoop.mapred.lib.MultipleOutputs;
import org.apache.hadoop.mapred.lib.NullOutputFormat;
import org.apache.sysml.api.DMLScript;
import org.apache.sysml.conf.ConfigurationManager;
import org.apache.sysml.conf.DMLConfig;
import org.apache.sysml.hops.OptimizerUtils;
import org.apache.sysml.runtime.DMLRuntimeException;
import org.apache.sysml.runtime.controlprogram.ParForProgramBlock;
import org.apache.sysml.runtime.controlprogram.parfor.stat.InfrastructureAnalyzer;
import org.apache.sysml.runtime.controlprogram.parfor.util.IDSequence;
import org.apache.sysml.runtime.instructions.MRInstructionParser;
import org.apache.sysml.runtime.instructions.mr.AggregateBinaryInstruction;
import org.apache.sysml.runtime.instructions.mr.AggregateInstruction;
import org.apache.sysml.runtime.instructions.mr.AppendGInstruction;
import org.apache.sysml.runtime.instructions.mr.AppendMInstruction;
import org.apache.sysml.runtime.instructions.mr.BinaryMInstruction;
import org.apache.sysml.runtime.instructions.mr.CM_N_COVInstruction;
import org.apache.sysml.runtime.instructions.mr.CSVReblockInstruction;
import org.apache.sysml.runtime.instructions.mr.CSVWriteInstruction;
import org.apache.sysml.runtime.instructions.mr.DataGenMRInstruction;
import org.apache.sysml.runtime.instructions.mr.GroupedAggregateInstruction;
import org.apache.sysml.runtime.instructions.mr.MRInstruction;
import org.apache.sysml.runtime.instructions.mr.MapMultChainInstruction;
import org.apache.sysml.runtime.instructions.mr.PMMJMRInstruction;
import org.apache.sysml.runtime.instructions.mr.ReblockInstruction;
import org.apache.sysml.runtime.instructions.mr.RemoveEmptyMRInstruction;
import org.apache.sysml.runtime.instructions.mr.UnaryMRInstructionBase;
import org.apache.sysml.runtime.io.BinaryBlockSerialization;
import org.apache.sysml.runtime.io.IOUtilFunctions;
import org.apache.sysml.runtime.matrix.MatrixCharacteristics;
import org.apache.sysml.runtime.matrix.data.AddDummyWeightConverter;
import org.apache.sysml.runtime.matrix.data.BinaryBlockToBinaryCellConverter;
import org.apache.sysml.runtime.matrix.data.BinaryBlockToRowBlockConverter;
import org.apache.sysml.runtime.matrix.data.BinaryBlockToTextCellConverter;
import org.apache.sysml.runtime.matrix.data.BinaryCellToRowBlockConverter;
import org.apache.sysml.runtime.matrix.data.BinaryCellToTextConverter;
import org.apache.sysml.runtime.matrix.data.Converter;
import org.apache.sysml.runtime.matrix.data.IdenticalConverter;
import org.apache.sysml.runtime.matrix.data.InputInfo;
import org.apache.sysml.runtime.matrix.data.MatrixBlock;
import org.apache.sysml.runtime.matrix.data.MatrixCell;
import org.apache.sysml.runtime.matrix.data.MatrixValue;
import org.apache.sysml.runtime.matrix.data.MultipleOutputCommitter;
import org.apache.sysml.runtime.matrix.data.OutputInfo;
import org.apache.sysml.runtime.matrix.data.TextCellToRowBlockConverter;
import org.apache.sysml.runtime.matrix.data.TextToBinaryCellConverter;
import org.apache.sysml.runtime.matrix.data.WeightedCellToSortInputConverter;
import org.apache.sysml.runtime.matrix.data.WeightedPair;
import org.apache.sysml.runtime.matrix.data.hadoopfix.MultipleInputs;
import org.apache.sysml.runtime.matrix.mapred.CollectMultipleConvertedOutputs;
import org.apache.sysml.runtime.matrix.mapred.MRConfigurationNames;
import org.apache.sysml.runtime.util.MapReduceTool;
import org.apache.sysml.yarn.ropt.YarnClusterAnalyzer;

public class MRJobConfiguration {
    public static final boolean USE_BINARYBLOCK_SERIALIZATION = true;
    public static IDSequence seq = new IDSequence();
    private static final String INPUT_MATRICIES_DIRS_CONFIG = "input.matrices.dirs";
    private static final String MAPFUNC_INPUT_MATRICIES_INDEXES_CONFIG = "mapfuc.input.matrices.indexes";
    private static final String BLOCK_REPRESENTATION_CONFIG = "in.block.representation";
    private static final String WEIGHTEDCELL_REPRESENTATION_CONFIG = "in.weighted.cell.representation";
    private static final String INPUT_CONVERTER_CLASS_PREFIX_CONFIG = "input.converter.class.for.";
    private static final String INPUT_KEY_CLASS_PREFIX_CONFIG = "input.key.class.for.";
    private static final String INPUT_VALUE_CLASS_PREFIX_CONFIG = "input.value.class.for.";
    private static final String INPUT_MATRIX_NUM_ROW_PREFIX_CONFIG = "input.matrix.num.row.";
    private static final String INPUT_MATRIX_NUM_COLUMN_PREFIX_CONFIG = "input.matrix.num.column.";
    private static final String INPUT_BLOCK_NUM_ROW_PREFIX_CONFIG = "input.block.num.row.";
    private static final String INPUT_BLOCK_NUM_COLUMN_PREFIX_CONFIG = "input.block.num.column.";
    private static final String INPUT_MATRIX_NUM_NNZ_PREFIX_CONFIG = "input.matrix.num.nnz.";
    private static final String MAPOUTPUT_MATRIX_NUM_ROW_PREFIX_CONFIG = "map.output.matrix.num.row.";
    private static final String MAPOUTPUT_MATRIX_NUM_COLUMN_PREFIX_CONFIG = "map.output.matrix.num.column.";
    private static final String MAPOUTPUT_BLOCK_NUM_ROW_PREFIX_CONFIG = "map.output.block.num.row.";
    private static final String MAPOUTPUT_BLOCK_NUM_COLUMN_PREFIX_CONFIG = "map.output.block.num.column.";
    private static final String INSTRUCTIONS_IN_MAPPER_CONFIG = "instructions.in.mapper";
    private static final String RAND_INSTRUCTIONS_CONFIG = "rand.instructions";
    private static final String OUTPUT_INDEXES_IN_MAPPER_CONFIG = "output.indexes.in.mapper";
    private static final String PARFOR_PROGRAMBLOCKS_CONFIG = "parfor.programblocks.in.mr";
    private static final String PARFOR_CACHING_CONFIG = "parfor.cp.caching";
    private static final String PARTITIONING_INPUT_MATRIX_NUM_ROW_CONFIG = "partitioning.input.matrix.num.row";
    private static final String PARTITIONING_INPUT_MATRIX_NUM_COLUMN_CONFIG = "partitioning.input.matrix.num.column";
    private static final String PARTITIONING_INPUT_BLOCK_NUM_ROW_CONFIG = "partitioning.input.block.num.row";
    private static final String PARTITIONING_INPUT_BLOCK_NUM_COLUMN_CONFIG = "partitioning.input.block.num.column";
    private static final String PARTITIONING_INPUT_INFO_CONFIG = "partitioning.input.inputinfo";
    private static final String PARTITIONING_OUTPUT_INFO_CONFIG = "partitioning.output.outputinfo";
    private static final String PARTITIONING_OUTPUT_FORMAT_CONFIG = "partitioning.output.format";
    private static final String PARTITIONING_OUTPUT_N_CONFIG = "partitioning.output.n";
    private static final String PARTITIONING_OUTPUT_FILENAME_CONFIG = "partitioning.output.filename";
    private static final String PARTITIONING_ITERVAR_CONFIG = "partitioning.itervar";
    private static final String PARTITIONING_MATRIXVAR_CONFIG = "partitioning.matrixvar";
    private static final String PARTITIONING_TRANSPOSE_COL_CONFIG = "partitioning.transposed.col";
    private static final String PARTITIONING_OUTPUT_KEEP_INDEXES_CONFIG = "partitioning.output.keep.indexes";
    private static final String RESULTMERGE_INPUT_INFO_CONFIG = "resultmerge.input.inputinfo";
    private static final String RESULTMERGE_COMPARE_FILENAME_CONFIG = "resultmerge.compare.filename";
    private static final String RESULTMERGE_STAGING_DIR_CONFIG = "resultmerge.staging.dir";
    private static final String RESULTMERGE_MATRIX_NUM_ROW_CONFIG = "resultmerge.matrix.num.row";
    private static final String RESULTMERGE_MATRIX_NUM_COLUMN_CONFIG = "resultmerge.matrix.num.column";
    private static final String RESULTMERGE_BLOCK_NUM_ROW_CONFIG = "resultmerge.block.num.row";
    private static final String RESULTMERGE_BLOCK_NUM_COLUMN_CONFIG = "resultmerge.block.num.column";
    private static final String SORT_PARTITION_FILENAME = "sort.partition.filename";
    private static final String AGGREGATE_INSTRUCTIONS_CONFIG = "aggregate.instructions.after.groupby.at";
    private static final String INSTRUCTIONS_IN_REDUCER_CONFIG = "instructions.in.reducer";
    private static final String AGGREGATE_BINARY_INSTRUCTIONS_CONFIG = "aggregate.binary.instructions";
    private static final String REBLOCK_INSTRUCTIONS_CONFIG = "reblock.instructions";
    private static final String CSV_REBLOCK_INSTRUCTIONS_CONFIG = "csv.reblock.instructions";
    private static final String CSV_WRITE_INSTRUCTIONS_CONFIG = "csv.write.instructions";
    private static final String COMBINE_INSTRUCTIONS_CONFIG = "combine.instructions";
    private static final String CM_N_COV_INSTRUCTIONS_CONFIG = "cm_n_com.instructions";
    private static final String GROUPEDAGG_INSTRUCTIONS_CONFIG = "groupedagg.instructions";
    private static final String AGGBIN_MATRIX_NUM_ROW_PREFIX_CONFIG = "aggbin.matrix.num.row.";
    private static final String AGGBIN_MATRIX_NUM_COLUMN_PREFIX_CONFIG = "aggbin.matrix.num.column.";
    private static final String AGGBIN_BLOCK_NUM_ROW_PREFIX_CONFIG = "aggbin.block.num.row.";
    private static final String AGGBIN_BLOCK_NUM_COLUMN_PREFIX_CONFIG = "aggbin.block.num.column.";
    private static final String OUTPUT_MATRIX_NUM_ROW_PREFIX_CONFIG = "output.matrix.num.row.";
    private static final String OUTPUT_MATRIX_NUM_COLUMN_PREFIX_CONFIG = "output.matrix.num.column.";
    private static final String OUTPUT_BLOCK_NUM_ROW_PREFIX_CONFIG = "output.block.num.row.";
    private static final String OUTPUT_BLOCK_NUM_COLUMN_PREFIX_CONFIG = "output.block.num.column.";
    private static final String REBLOCK_MATRIX_NUM_ROW_PREFIX_CONFIG = "reblock.matrix.num.row.";
    private static final String REBLOCK_MATRIX_NUM_COLUMN_PREFIX_CONFIG = "reblock.matrix.num.column.";
    private static final String REBLOCK_BLOCK_NUM_ROW_PREFIX_CONFIG = "reblock.block.num.row.";
    private static final String REBLOCK_BLOCK_NUM_COLUMN_PREFIX_CONFIG = "reblock.block.num.column.";
    private static final String REBLOCK_MATRIX_NUM_NNZ_PREFIX_CONFIG = "reblock.matrix.num.nnz.";
    private static final String INTERMEDIATE_MATRIX_NUM_ROW_PREFIX_CONFIG = "rdiag.matrix.num.row.";
    private static final String INTERMEDIATE_MATRIX_NUM_COLUMN_PREFIX_CONFIG = "rdiag.matrix.num.column.";
    private static final String INTERMEDIATE_BLOCK_NUM_ROW_PREFIX_CONFIG = "rdiag.block.num.row.";
    private static final String INTERMEDIATE_BLOCK_NUM_COLUMN_PREFIX_CONFIG = "rdiag.block.num.column.";
    private static final String RESULT_INDEXES_CONFIG = "results.indexes";
    private static final String RESULT_DIMS_UNKNOWN_CONFIG = "results.dims.unknown";
    private static final String INTERMEDIATE_INDEXES_CONFIG = "rdiag.indexes";
    public static final String OUTPUT_MATRICES_DIRS_CONFIG = "output.matrices.dirs";
    private static final String OUTPUT_CONVERTER_CLASS_PREFIX_CONFIG = "output.converter.class.for.";
    private static final String DIMS_UNKNOWN_FILE_PREFIX = "dims.unknown.file.prefix";
    private static final String MMCJ_CACHE_SIZE = "mmcj.cache.size";
    private static final String DISTCACHE_INPUT_INDICES = "distcache.input.indices";
    private static final String DISTCACHE_INPUT_PATHS = "distcache.input.paths";
    private static final String SYSTEMML_LOCAL_TMP_DIR = "systemml.local.tmp.dir";
    public static final String NUM_NONZERO_CELLS = "nonzeros";

    public static final int getMiscMemRequired(JobConf job) {
        return job.getInt("io.file.buffer.size", 4096);
    }

    public static void setMMCJCacheSize(JobConf job, long size) {
        job.setLong(MMCJ_CACHE_SIZE, size);
    }

    public static long getMMCJCacheSize(JobConf job) {
        return job.getLong(MMCJ_CACHE_SIZE, 0L);
    }

    public static void setMatrixValueClass(JobConf job, boolean blockRepresentation) {
        job.setBoolean(BLOCK_REPRESENTATION_CONFIG, blockRepresentation);
    }

    public static void setMatrixValueClassForCM_N_COM(JobConf job, boolean weightedCellRepresentation) {
        job.setBoolean(WEIGHTEDCELL_REPRESENTATION_CONFIG, weightedCellRepresentation);
    }

    public static Class<? extends MatrixValue> getMatrixValueClass(JobConf job) {
        if (job.getBoolean(WEIGHTEDCELL_REPRESENTATION_CONFIG, false)) {
            return WeightedPair.class;
        }
        if (job.getBoolean(BLOCK_REPRESENTATION_CONFIG, true)) {
            return MatrixBlock.class;
        }
        return MatrixCell.class;
    }

    public static Class<? extends Converter> getConverterClass(InputInfo inputinfo, int brlen, int bclen, ConvertTarget target) {
        Class converterClass = IdenticalConverter.class;
        if (inputinfo.inputValueClass.equals(MatrixCell.class)) {
            switch (target) {
                case CELL: {
                    converterClass = IdenticalConverter.class;
                    break;
                }
                case BLOCK: {
                    throw new RuntimeException("cannot convert binary cell to binary block representation implicitly");
                }
                case WEIGHTEDCELL: {
                    converterClass = AddDummyWeightConverter.class;
                    break;
                }
                case CSVWRITE: {
                    converterClass = BinaryCellToRowBlockConverter.class;
                }
            }
        } else if (inputinfo.inputValueClass.equals(MatrixBlock.class)) {
            switch (target) {
                case CELL: {
                    converterClass = BinaryBlockToBinaryCellConverter.class;
                    break;
                }
                case BLOCK: {
                    converterClass = IdenticalConverter.class;
                    break;
                }
                case WEIGHTEDCELL: {
                    converterClass = AddDummyWeightConverter.class;
                    break;
                }
                case CSVWRITE: {
                    converterClass = BinaryBlockToRowBlockConverter.class;
                }
            }
        } else if (inputinfo.inputValueClass.equals(Text.class)) {
            switch (target) {
                case CELL: {
                    converterClass = TextToBinaryCellConverter.class;
                    break;
                }
                case BLOCK: {
                    if (brlen > 1 || bclen > 1) {
                        throw new RuntimeException("cannot convert text cell to binary block representation implicitly");
                    }
                    converterClass = TextToBinaryCellConverter.class;
                    break;
                }
                case WEIGHTEDCELL: {
                    converterClass = AddDummyWeightConverter.class;
                    break;
                }
                case CSVWRITE: {
                    converterClass = TextCellToRowBlockConverter.class;
                }
            }
        }
        return converterClass;
    }

    public static void setUniqueWorkingDir(JobConf job) {
        if (InfrastructureAnalyzer.isLocalMode(job)) {
            StringBuilder tmp = new StringBuilder();
            tmp.append("/");
            tmp.append("_p");
            tmp.append(DMLScript.getUUID());
            tmp.append("/");
            tmp.append(seq.getNextID());
            String uniqueSubdir = tmp.toString();
            String[] dirlist = job.get(MRConfigurationNames.MR_CLUSTER_LOCAL_DIR, "/tmp").split(",");
            StringBuilder sb2 = new StringBuilder();
            for (String dir : dirlist) {
                if (sb2.length() > 0) {
                    sb2.append(",");
                }
                sb2.append(dir);
                sb2.append(uniqueSubdir);
            }
            job.set(MRConfigurationNames.MR_CLUSTER_LOCAL_DIR, sb2.toString());
            job.set(MRConfigurationNames.MR_JOBTRACKER_SYSTEM_DIR, job.get(MRConfigurationNames.MR_JOBTRACKER_SYSTEM_DIR) + uniqueSubdir);
            job.set("mapreduce.jobtracker.staging.root.dir", job.get("mapreduce.jobtracker.staging.root.dir") + uniqueSubdir);
        }
    }

    public static String getLocalWorkingDirPrefix(JobConf job) {
        return job.get(MRConfigurationNames.MR_CLUSTER_LOCAL_DIR);
    }

    public static String getSystemWorkingDirPrefix(JobConf job) {
        return job.get(MRConfigurationNames.MR_JOBTRACKER_SYSTEM_DIR);
    }

    public static String getStagingWorkingDirPrefix(JobConf job) {
        return job.get("mapreduce.jobtracker.staging.root.dir");
    }

    public static void setInputInfo(JobConf job, byte input, InputInfo inputinfo, int brlen, int bclen, ConvertTarget target) {
        Class<? extends Converter> converterClass = MRJobConfiguration.getConverterClass(inputinfo, brlen, bclen, target);
        job.setClass(INPUT_CONVERTER_CLASS_PREFIX_CONFIG + input, converterClass, Converter.class);
        job.setClass(INPUT_KEY_CLASS_PREFIX_CONFIG + input, inputinfo.inputKeyClass, Writable.class);
        job.setClass(INPUT_VALUE_CLASS_PREFIX_CONFIG + input, inputinfo.inputValueClass, Writable.class);
    }

    public static void setOutputInfo(JobConf job, int i, OutputInfo outputinfo, boolean sourceInBlock) throws DMLRuntimeException {
        Class converterClass;
        if (sourceInBlock) {
            converterClass = outputinfo.outputValueClass.equals(MatrixCell.class) ? BinaryBlockToBinaryCellConverter.class : (outputinfo.outputValueClass.equals(Text.class) ? BinaryBlockToTextCellConverter.class : (outputinfo.outputValueClass.equals(MatrixBlock.class) ? IdenticalConverter.class : (outputinfo.outputValueClass.equals(IntWritable.class) ? WeightedCellToSortInputConverter.class : (outputinfo.outputValueClass.equals(WeightedPair.class) ? IdenticalConverter.class : IdenticalConverter.class))));
        } else if (outputinfo.outputValueClass.equals(MatrixCell.class)) {
            converterClass = IdenticalConverter.class;
        } else if (outputinfo.outputValueClass.equals(Text.class)) {
            converterClass = BinaryCellToTextConverter.class;
        } else if (outputinfo.outputValueClass.equals(IntWritable.class)) {
            converterClass = WeightedCellToSortInputConverter.class;
        } else if (outputinfo.outputValueClass.equals(WeightedPair.class)) {
            converterClass = IdenticalConverter.class;
        } else {
            throw new DMLRuntimeException("unsupported conversion: " + outputinfo.outputValueClass);
        }
        job.setClass(OUTPUT_CONVERTER_CLASS_PREFIX_CONFIG + i, converterClass, Converter.class);
    }

    public static Converter getInputConverter(JobConf job, byte input) {
        Converter inputConverter;
        try {
            inputConverter = (Converter)job.getClass(INPUT_CONVERTER_CLASS_PREFIX_CONFIG + input, IdenticalConverter.class).newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return inputConverter;
    }

    public static Converter getOuputConverter(JobConf job, int i) {
        Converter outputConverter;
        try {
            outputConverter = (Converter)job.getClass(OUTPUT_CONVERTER_CLASS_PREFIX_CONFIG + i, IdenticalConverter.class).newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return outputConverter;
    }

    public static MRInstruction[] getInstructionsInReducer(JobConf job) throws DMLRuntimeException {
        String str = job.get(INSTRUCTIONS_IN_REDUCER_CONFIG);
        MRInstruction[] mixed_ops = MRInstructionParser.parseMixedInstructions(str);
        return mixed_ops;
    }

    public static ReblockInstruction[] getReblockInstructions(JobConf job) throws DMLRuntimeException {
        String str = job.get(REBLOCK_INSTRUCTIONS_CONFIG);
        ReblockInstruction[] reblock_instructions = MRInstructionParser.parseReblockInstructions(str);
        return reblock_instructions;
    }

    public static CSVReblockInstruction[] getCSVReblockInstructions(JobConf job) throws DMLRuntimeException {
        String str = job.get(CSV_REBLOCK_INSTRUCTIONS_CONFIG);
        CSVReblockInstruction[] reblock_instructions = MRInstructionParser.parseCSVReblockInstructions(str);
        return reblock_instructions;
    }

    public static CSVWriteInstruction[] getCSVWriteInstructions(JobConf job) throws DMLRuntimeException {
        String str = job.get(CSV_WRITE_INSTRUCTIONS_CONFIG);
        CSVWriteInstruction[] reblock_instructions = MRInstructionParser.parseCSVWriteInstructions(str);
        return reblock_instructions;
    }

    public static AggregateInstruction[] getAggregateInstructions(JobConf job) throws DMLRuntimeException {
        String str = job.get(AGGREGATE_INSTRUCTIONS_CONFIG);
        AggregateInstruction[] agg_instructions = MRInstructionParser.parseAggregateInstructions(str);
        return agg_instructions;
    }

    public static MRInstruction[] getCombineInstruction(JobConf job) throws DMLRuntimeException {
        String str = job.get(COMBINE_INSTRUCTIONS_CONFIG);
        MRInstruction[] comb_instructions = MRInstructionParser.parseCombineInstructions(str);
        return comb_instructions;
    }

    public static MRInstruction[] getInstructionsInMapper(JobConf job) throws DMLRuntimeException {
        String str = job.get(INSTRUCTIONS_IN_MAPPER_CONFIG);
        MRInstruction[] instructions = MRInstructionParser.parseMixedInstructions(str);
        return instructions;
    }

    public static void setProgramBlocks(JobConf job, String sProgramBlocks) {
        job.set(PARFOR_PROGRAMBLOCKS_CONFIG, sProgramBlocks);
    }

    public static String getProgramBlocks(JobConf job) {
        String str = job.get(PARFOR_PROGRAMBLOCKS_CONFIG);
        return str;
    }

    public static void setParforCachingConfig(JobConf job, boolean flag) {
        job.setBoolean(PARFOR_CACHING_CONFIG, flag);
    }

    public static boolean getParforCachingConfig(JobConf job) {
        return job.getBoolean(PARFOR_CACHING_CONFIG, true);
    }

    public static void setPartitioningInfo(JobConf job, long rlen, long clen, int brlen, int bclen, InputInfo ii, OutputInfo oi, ParForProgramBlock.PDataPartitionFormat dpf, int n, String fnameNew) throws DMLRuntimeException {
        job.set(PARTITIONING_INPUT_MATRIX_NUM_ROW_CONFIG, String.valueOf(rlen));
        job.set(PARTITIONING_INPUT_MATRIX_NUM_COLUMN_CONFIG, String.valueOf(clen));
        job.set(PARTITIONING_INPUT_BLOCK_NUM_ROW_CONFIG, String.valueOf(brlen));
        job.set(PARTITIONING_INPUT_BLOCK_NUM_COLUMN_CONFIG, String.valueOf(bclen));
        job.set(PARTITIONING_INPUT_INFO_CONFIG, InputInfo.inputInfoToString(ii));
        job.set(PARTITIONING_OUTPUT_INFO_CONFIG, OutputInfo.outputInfoToString(oi));
        job.set(PARTITIONING_OUTPUT_FORMAT_CONFIG, dpf.toString());
        job.set(PARTITIONING_OUTPUT_N_CONFIG, String.valueOf(n));
        job.set(PARTITIONING_OUTPUT_FILENAME_CONFIG, fnameNew);
    }

    public static void setPartitioningInfo(JobConf job, long rlen, long clen, int brlen, int bclen, InputInfo ii, OutputInfo oi, ParForProgramBlock.PDataPartitionFormat dpf, int n, String fnameNew, String itervar, String matrixvar, boolean tSparseCol) throws DMLRuntimeException {
        MRJobConfiguration.setPartitioningInfo(job, rlen, clen, brlen, bclen, ii, oi, dpf, n, fnameNew);
        job.set(PARTITIONING_ITERVAR_CONFIG, itervar);
        job.set(PARTITIONING_MATRIXVAR_CONFIG, matrixvar);
        job.setBoolean(PARTITIONING_TRANSPOSE_COL_CONFIG, tSparseCol);
    }

    public static void setPartitioningInfo(JobConf job, long rlen, long clen, int brlen, int bclen, InputInfo ii, OutputInfo oi, ParForProgramBlock.PDataPartitionFormat dpf, int n, String fnameNew, boolean keepIndexes) throws DMLRuntimeException {
        MRJobConfiguration.setPartitioningInfo(job, rlen, clen, brlen, bclen, ii, oi, dpf, n, fnameNew);
        job.setBoolean(PARTITIONING_OUTPUT_KEEP_INDEXES_CONFIG, keepIndexes);
    }

    public static MatrixCharacteristics getPartitionedMatrixSize(JobConf job) {
        return new MatrixCharacteristics(Long.parseLong(job.get(PARTITIONING_INPUT_MATRIX_NUM_ROW_CONFIG)), Long.parseLong(job.get(PARTITIONING_INPUT_MATRIX_NUM_COLUMN_CONFIG)), Integer.parseInt(job.get(PARTITIONING_INPUT_BLOCK_NUM_ROW_CONFIG)), Integer.parseInt(job.get(PARTITIONING_INPUT_BLOCK_NUM_COLUMN_CONFIG)));
    }

    public static void setPartitioningBlockNumRows(JobConf job, int brlen) {
        job.set(PARTITIONING_INPUT_BLOCK_NUM_ROW_CONFIG, String.valueOf(brlen));
    }

    public static void setPartitioningBlockNumCols(JobConf job, int bclen) {
        job.set(PARTITIONING_INPUT_BLOCK_NUM_COLUMN_CONFIG, String.valueOf(bclen));
    }

    public static InputInfo getPartitioningInputInfo(JobConf job) {
        return InputInfo.stringToInputInfo(job.get(PARTITIONING_INPUT_INFO_CONFIG));
    }

    public static OutputInfo getPartitioningOutputInfo(JobConf job) {
        return OutputInfo.stringToOutputInfo(job.get(PARTITIONING_OUTPUT_INFO_CONFIG));
    }

    public static void setPartitioningFormat(JobConf job, ParForProgramBlock.PDataPartitionFormat dpf) {
        job.set(PARTITIONING_OUTPUT_FORMAT_CONFIG, dpf.toString());
    }

    public static ParForProgramBlock.PDataPartitionFormat getPartitioningFormat(JobConf job) {
        return ParForProgramBlock.PDataPartitionFormat.valueOf(job.get(PARTITIONING_OUTPUT_FORMAT_CONFIG));
    }

    public static int getPartitioningSizeN(JobConf job) {
        return Integer.parseInt(job.get(PARTITIONING_OUTPUT_N_CONFIG));
    }

    public static boolean getPartitioningIndexFlag(JobConf job) {
        return Boolean.parseBoolean(job.get(PARTITIONING_OUTPUT_KEEP_INDEXES_CONFIG));
    }

    public static void setPartitioningFilename(JobConf job, String fname) {
        job.set(PARTITIONING_OUTPUT_FILENAME_CONFIG, fname);
    }

    public static String getPartitioningFilename(JobConf job) {
        return job.get(PARTITIONING_OUTPUT_FILENAME_CONFIG);
    }

    public static String getPartitioningItervar(JobConf job) {
        return job.get(PARTITIONING_ITERVAR_CONFIG);
    }

    public static String getPartitioningMatrixvar(JobConf job) {
        return job.get(PARTITIONING_MATRIXVAR_CONFIG);
    }

    public static boolean getPartitioningTransposedCol(JobConf job) {
        return job.getBoolean(PARTITIONING_TRANSPOSE_COL_CONFIG, false);
    }

    public static void setResultMergeInfo(JobConf job, String fnameNew, InputInfo ii, String stagingDir, long rlen, long clen, int brlen, int bclen) throws DMLRuntimeException {
        job.set(RESULTMERGE_COMPARE_FILENAME_CONFIG, fnameNew);
        job.set(RESULTMERGE_INPUT_INFO_CONFIG, InputInfo.inputInfoToString(ii));
        job.set(RESULTMERGE_STAGING_DIR_CONFIG, stagingDir);
        job.set(RESULTMERGE_MATRIX_NUM_ROW_CONFIG, String.valueOf(rlen));
        job.set(RESULTMERGE_MATRIX_NUM_COLUMN_CONFIG, String.valueOf(clen));
        job.set(RESULTMERGE_BLOCK_NUM_ROW_CONFIG, String.valueOf(brlen));
        job.set(RESULTMERGE_BLOCK_NUM_COLUMN_CONFIG, String.valueOf(bclen));
    }

    public static String getResultMergeInfoCompareFilename(JobConf job) {
        return job.get(RESULTMERGE_COMPARE_FILENAME_CONFIG);
    }

    public static InputInfo getResultMergeInputInfo(JobConf job) {
        return InputInfo.stringToInputInfo(job.get(RESULTMERGE_INPUT_INFO_CONFIG));
    }

    public static long[] getResultMergeMatrixCharacteristics(JobConf job) {
        long[] ret = new long[]{Long.parseLong(job.get(RESULTMERGE_MATRIX_NUM_ROW_CONFIG)), Long.parseLong(job.get(RESULTMERGE_MATRIX_NUM_COLUMN_CONFIG)), Long.parseLong(job.get(RESULTMERGE_BLOCK_NUM_ROW_CONFIG)), Long.parseLong(job.get(RESULTMERGE_BLOCK_NUM_COLUMN_CONFIG))};
        return ret;
    }

    public static byte[] getInputIndexesInMapper(JobConf job) {
        String[] istrs = job.get(MAPFUNC_INPUT_MATRICIES_INDEXES_CONFIG).split("\u2021");
        return MRJobConfiguration.stringArrayToByteArray(istrs);
    }

    public static byte[] getOutputIndexesInMapper(JobConf job) {
        String[] istrs = job.get(OUTPUT_INDEXES_IN_MAPPER_CONFIG).split("\u2021");
        return MRJobConfiguration.stringArrayToByteArray(istrs);
    }

    public static ArrayList<Byte> getInputMatrixIndexesInMapper(JobConf job) throws IOException {
        int numMatrices;
        int i;
        byte[] indexes;
        String[] matrices = job.getStrings(INPUT_MATRICIES_DIRS_CONFIG);
        String str = job.get(MAPFUNC_INPUT_MATRICIES_INDEXES_CONFIG);
        if (str == null || str.isEmpty()) {
            indexes = new byte[matrices.length];
            for (int i2 = 0; i2 < indexes.length; ++i2) {
                indexes[i2] = (byte)i2;
            }
        } else {
            String[] strs = str.split("\u2021");
            indexes = new byte[strs.length];
            for (i = 0; i < strs.length; ++i) {
                indexes[i] = Byte.parseByte(strs[i]);
            }
        }
        if ((numMatrices = matrices.length) > 127) {
            throw new RuntimeException("number of matrices is too large > 127");
        }
        for (i = 0; i < matrices.length; ++i) {
            matrices[i] = new Path(matrices[i]).toString();
        }
        Path thisFile = new Path(job.get(MRConfigurationNames.MR_MAP_INPUT_FILE));
        FileSystem fs = IOUtilFunctions.getFileSystem(thisFile, (Configuration)job);
        thisFile = thisFile.makeQualified(fs);
        Path thisDir = thisFile.getParent().makeQualified(fs);
        ArrayList<Byte> representativeMatrixes = new ArrayList<Byte>();
        for (int i3 = 0; i3 < matrices.length; ++i3) {
            Path p = new Path(matrices[i3]).makeQualified(fs);
            if (!thisFile.toUri().equals(p.toUri()) && !thisDir.toUri().equals(p.toUri())) continue;
            representativeMatrixes.add(indexes[i3]);
        }
        return representativeMatrixes;
    }

    public static void setInstructionsInMapper(JobConf job, String instructionsInMapper) {
        job.set(INSTRUCTIONS_IN_MAPPER_CONFIG, instructionsInMapper);
    }

    public static void setAggregateInstructions(JobConf job, String aggInstructionsInReducer) {
        job.set(AGGREGATE_INSTRUCTIONS_CONFIG, aggInstructionsInReducer);
    }

    public static void setReblockInstructions(JobConf job, String reblockInstructions) {
        job.set(REBLOCK_INSTRUCTIONS_CONFIG, reblockInstructions);
    }

    public static void setCSVReblockInstructions(JobConf job, String reblockInstructions) {
        job.set(CSV_REBLOCK_INSTRUCTIONS_CONFIG, reblockInstructions);
    }

    public static void setCSVWriteInstructions(JobConf job, String csvWriteInstructions) {
        job.set(CSV_WRITE_INSTRUCTIONS_CONFIG, csvWriteInstructions);
    }

    public static void setCombineInstructions(JobConf job, String combineInstructions) {
        job.set(COMBINE_INSTRUCTIONS_CONFIG, combineInstructions);
    }

    public static void setInstructionsInReducer(JobConf job, String instructionsInReducer) {
        if (instructionsInReducer != null) {
            job.set(INSTRUCTIONS_IN_REDUCER_CONFIG, instructionsInReducer);
        }
    }

    public static void setAggregateBinaryInstructions(JobConf job, String aggBinInstrctions) {
        job.set(AGGREGATE_BINARY_INSTRUCTIONS_CONFIG, aggBinInstrctions);
    }

    public static void setCM_N_COMInstructions(JobConf job, String cmInstrctions) {
        job.set(CM_N_COV_INSTRUCTIONS_CONFIG, cmInstrctions);
    }

    public static void setGroupedAggInstructions(JobConf job, String grpaggInstructions) {
        job.set(GROUPEDAGG_INSTRUCTIONS_CONFIG, grpaggInstructions);
    }

    public static void setRandInstructions(JobConf job, String randInstrctions) {
        job.set(RAND_INSTRUCTIONS_CONFIG, randInstrctions);
    }

    public static DataGenMRInstruction[] getDataGenInstructions(JobConf job) throws DMLRuntimeException {
        String str = job.get(RAND_INSTRUCTIONS_CONFIG);
        return MRInstructionParser.parseDataGenInstructions(str);
    }

    public static AggregateBinaryInstruction[] getAggregateBinaryInstructions(JobConf job) throws DMLRuntimeException {
        String str = job.get(AGGREGATE_BINARY_INSTRUCTIONS_CONFIG);
        return MRInstructionParser.parseAggregateBinaryInstructions(str);
    }

    public static CM_N_COVInstruction[] getCM_N_COVInstructions(JobConf job) throws DMLRuntimeException {
        String str = job.get(CM_N_COV_INSTRUCTIONS_CONFIG);
        return MRInstructionParser.parseCM_N_COVInstructions(str);
    }

    public static GroupedAggregateInstruction[] getGroupedAggregateInstructions(JobConf job) throws DMLRuntimeException {
        String str = job.get(GROUPEDAGG_INSTRUCTIONS_CONFIG);
        GroupedAggregateInstruction[] tmp = MRInstructionParser.parseGroupedAggInstructions(str);
        for (int i = 0; i < tmp.length; ++i) {
            byte tag = tmp[i].input;
            tmp[i].setBclen(MRJobConfiguration.getMatrixCharacteristicsForInput(job, tag).getColsPerBlock());
        }
        return tmp;
    }

    public static String[] getOutputs(JobConf job) {
        return job.getStrings(OUTPUT_MATRICES_DIRS_CONFIG);
    }

    private static byte[] stringArrayToByteArray(String[] istrs) {
        byte[] ret = new byte[istrs.length];
        for (int i = 0; i < istrs.length; ++i) {
            ret[i] = Byte.parseByte(istrs[i]);
        }
        return ret;
    }

    public static byte[] getResultIndexes(JobConf job) {
        String[] istrs = job.get(RESULT_INDEXES_CONFIG).split("\u2021");
        return MRJobConfiguration.stringArrayToByteArray(istrs);
    }

    public static byte[] getResultDimsUnknown(JobConf job) {
        String str = job.get(RESULT_DIMS_UNKNOWN_CONFIG);
        if (str == null || str.isEmpty()) {
            return null;
        }
        String[] istrs = str.split("\u2021");
        return MRJobConfiguration.stringArrayToByteArray(istrs);
    }

    public static byte[] getIntermediateMatrixIndexes(JobConf job) {
        String str = job.get(INTERMEDIATE_INDEXES_CONFIG);
        if (str == null || str.isEmpty()) {
            return null;
        }
        String[] istrs = str.split("\u2021");
        return MRJobConfiguration.stringArrayToByteArray(istrs);
    }

    public static void setIntermediateMatrixIndexes(JobConf job, HashSet<Byte> indexes) {
        job.set(INTERMEDIATE_INDEXES_CONFIG, MRJobConfiguration.getIndexesString(indexes));
    }

    public static void setDimsUnknownFilePrefix(JobConf job, String prefix) {
        job.setStrings(DIMS_UNKNOWN_FILE_PREFIX, new String[]{prefix});
    }

    public static void setMatricesDimensions(JobConf job, byte[] inputIndexes, long[] rlens, long[] clens) {
        if (rlens.length != clens.length) {
            throw new RuntimeException("rlens.length should be clens.length");
        }
        for (int i = 0; i < rlens.length; ++i) {
            MRJobConfiguration.setMatrixDimension(job, inputIndexes[i], rlens[i], clens[i]);
        }
    }

    public static void setMatricesDimensions(JobConf job, byte[] inputIndexes, long[] rlens, long[] clens, long[] nnz) {
        if (rlens.length != clens.length) {
            throw new RuntimeException("rlens.length should be clens.length");
        }
        for (int i = 0; i < rlens.length; ++i) {
            MRJobConfiguration.setMatrixDimension(job, inputIndexes[i], rlens[i], clens[i], nnz[i]);
        }
    }

    public static void setMatrixDimension(JobConf job, byte matrixIndex, long rlen, long clen) {
        job.setLong(INPUT_MATRIX_NUM_ROW_PREFIX_CONFIG + matrixIndex, rlen);
        job.setLong(INPUT_MATRIX_NUM_COLUMN_PREFIX_CONFIG + matrixIndex, clen);
    }

    public static void setMatrixDimension(JobConf job, byte matrixIndex, long rlen, long clen, long nnz) {
        job.setLong(INPUT_MATRIX_NUM_ROW_PREFIX_CONFIG + matrixIndex, rlen);
        job.setLong(INPUT_MATRIX_NUM_COLUMN_PREFIX_CONFIG + matrixIndex, clen);
        job.setLong(INPUT_MATRIX_NUM_NNZ_PREFIX_CONFIG + matrixIndex, nnz);
    }

    public static String[] getInputPaths(JobConf job) {
        return job.getStrings(INPUT_MATRICIES_DIRS_CONFIG);
    }

    public static long getNumRows(JobConf job, byte matrixIndex) {
        return job.getLong(INPUT_MATRIX_NUM_ROW_PREFIX_CONFIG + matrixIndex, 0L);
    }

    public static long getNumColumns(JobConf job, byte matrixIndex) {
        return job.getLong(INPUT_MATRIX_NUM_COLUMN_PREFIX_CONFIG + matrixIndex, 0L);
    }

    public static void setBlocksSizes(JobConf job, byte[] inputIndexes, int[] brlens, int[] bclens) {
        if (brlens.length != bclens.length) {
            throw new RuntimeException("brlens.length should be bclens.length");
        }
        for (int i = 0; i < brlens.length; ++i) {
            MRJobConfiguration.setBlockSize(job, inputIndexes[i], brlens[i], bclens[i]);
        }
    }

    public static void setBlockSize(JobConf job, byte matrixIndex, int brlen, int bclen) {
        job.setInt(INPUT_BLOCK_NUM_ROW_PREFIX_CONFIG + matrixIndex, brlen);
        job.setInt(INPUT_BLOCK_NUM_COLUMN_PREFIX_CONFIG + matrixIndex, bclen);
    }

    public static int getNumRowsPerBlock(JobConf job, byte matrixIndex) {
        return job.getInt(INPUT_BLOCK_NUM_ROW_PREFIX_CONFIG + matrixIndex, 1);
    }

    public static int getNumColumnsPerBlock(JobConf job, byte matrixIndex) {
        return job.getInt(INPUT_BLOCK_NUM_COLUMN_PREFIX_CONFIG + matrixIndex, 1);
    }

    public static long getNumNonZero(JobConf job, byte matrixIndex) {
        return job.getLong(INPUT_MATRIX_NUM_NNZ_PREFIX_CONFIG + matrixIndex, 1L);
    }

    public static void setupDistCacheInputs(JobConf job, String indices, String pathsString, ArrayList<String> paths) {
        job.set(DISTCACHE_INPUT_INDICES, indices);
        job.set(DISTCACHE_INPUT_PATHS, pathsString);
        Path p = null;
        for (String spath : paths) {
            p = new Path(spath);
            DistributedCache.addCacheFile((URI)p.toUri(), (Configuration)job);
            DistributedCache.createSymlink((Configuration)job);
        }
    }

    public static String getDistCacheInputIndices(JobConf job) {
        return job.get(DISTCACHE_INPUT_INDICES);
    }

    private static String getCSVString(ParForProgramBlock.PDataPartitionFormat[] formats) {
        if (formats == null || formats.length == 0) {
            return "";
        }
        StringBuilder s = new StringBuilder();
        s.append((Object)formats[0]);
        for (int i = 1; i < formats.length; ++i) {
            s.append(",");
            s.append((Object)formats[i]);
        }
        return s.toString();
    }

    public static void setInputPartitioningInfo(JobConf job, ParForProgramBlock.PDataPartitionFormat[] pformats) {
        job.set(PARTITIONING_OUTPUT_FORMAT_CONFIG, MRJobConfiguration.getCSVString(pformats));
    }

    private static ParForProgramBlock.PDataPartitionFormat[] csv2PFormat(String s) {
        String[] parts = s.split(",");
        ParForProgramBlock.PDataPartitionFormat[] pformats = new ParForProgramBlock.PDataPartitionFormat[parts.length];
        for (int i = 0; i < parts.length; ++i) {
            pformats[i] = ParForProgramBlock.PDataPartitionFormat.parsePDataPartitionFormat(parts[i]);
        }
        return pformats;
    }

    public static ParForProgramBlock.PDataPartitionFormat[] getInputPartitionFormats(JobConf job) {
        return MRJobConfiguration.csv2PFormat(job.get(PARTITIONING_OUTPUT_FORMAT_CONFIG));
    }

    public static void setUpMultipleInputs(JobConf job, byte[] inputIndexes, String[] inputs, InputInfo[] inputInfos, int[] brlens, int[] bclens, boolean setConverter, ConvertTarget target) throws Exception {
        boolean[] distCacheOnly = new boolean[inputIndexes.length];
        Arrays.fill(distCacheOnly, false);
        MRJobConfiguration.setUpMultipleInputs(job, inputIndexes, inputs, inputInfos, brlens, bclens, distCacheOnly, setConverter, target);
    }

    public static void setUpMultipleInputs(JobConf job, byte[] inputIndexes, String[] inputs, InputInfo[] inputInfos, int[] brlens, int[] bclens, boolean[] distCacheOnly, boolean setConverter, ConvertTarget target) throws Exception {
        if (inputs.length != inputInfos.length) {
            throw new Exception("number of inputs and inputInfos does not match");
        }
        job.setStrings(INPUT_MATRICIES_DIRS_CONFIG, inputs);
        MRJobConfiguration.setMapFunctionInputMatrixIndexes(job, inputIndexes);
        if (setConverter) {
            for (int i = 0; i < inputs.length; ++i) {
                MRJobConfiguration.setInputInfo(job, inputIndexes[i], inputInfos[i], brlens[i], bclens[i], target);
            }
        }
        ArrayList<Path> lpaths = new ArrayList<Path>();
        ArrayList<InputInfo> liinfos = new ArrayList<InputInfo>();
        for (int i = 0; i < inputs.length; ++i) {
            Path p = new Path(inputs[i]);
            if (lpaths.contains(p) || distCacheOnly[i]) continue;
            lpaths.add(p);
            liinfos.add(inputInfos[i]);
        }
        boolean combineInputFormat = false;
        double totalInputSize = 0.0;
        for (int i = 0; i < inputs.length; ++i) {
            totalInputSize += (double)MapReduceTool.getFilesizeOnHDFS(new Path(inputs[i]));
        }
        long sizeSortBuff = InfrastructureAnalyzer.getRemoteMaxMemorySortBuffer();
        long sizeHDFSBlk = InfrastructureAnalyzer.getHDFSBlockSize();
        long newSplitSize = sizeHDFSBlk * 2L;
        double spillPercent = Double.parseDouble(job.get(MRConfigurationNames.MR_MAP_SORT_SPILL_PERCENT, "1.0"));
        int numPMap = OptimizerUtils.getNumMappers();
        if ((double)numPMap < totalInputSize / (double)newSplitSize && (double)sizeSortBuff * spillPercent >= (double)newSplitSize && lpaths.size() == 1) {
            job.setLong(MRConfigurationNames.MR_INPUT_FILEINPUTFORMAT_SPLIT_MAXSIZE, newSplitSize);
            combineInputFormat = true;
        }
        for (int i = 0; i < lpaths.size(); ++i) {
            if (combineInputFormat && liinfos.get(i) == InputInfo.BinaryBlockInputInfo) {
                MultipleInputs.addInputPath(job, (Path)lpaths.get(i), CombineSequenceFileInputFormat.class);
                continue;
            }
            MultipleInputs.addInputPath(job, (Path)lpaths.get(i), ((InputInfo)liinfos.get((int)i)).inputFormatClass);
        }
    }

    public static void setUpMultipleInputsReblock(JobConf job, byte[] inputIndexes, String[] inputs, InputInfo[] inputInfos, int[] brlens, int[] bclens) throws Exception {
        if (inputs.length != inputInfos.length) {
            throw new Exception("number of inputs and inputInfos does not match");
        }
        job.setStrings(INPUT_MATRICIES_DIRS_CONFIG, inputs);
        MRJobConfiguration.setMapFunctionInputMatrixIndexes(job, inputIndexes);
        for (int i = 0; i < inputs.length; ++i) {
            ConvertTarget target = ConvertTarget.CELL;
            if (inputInfos[i] == InputInfo.BinaryBlockInputInfo) {
                target = ConvertTarget.BLOCK;
            }
            MRJobConfiguration.setInputInfo(job, inputIndexes[i], inputInfos[i], brlens[i], bclens[i], target);
        }
        ArrayList<Path> paths = new ArrayList<Path>();
        for (int i = 0; i < inputs.length; ++i) {
            String name = inputs[i];
            Path p = new Path(name);
            boolean redundant = false;
            for (Path ep : paths) {
                if (!ep.equals((Object)p)) continue;
                redundant = true;
                break;
            }
            if (redundant) continue;
            MultipleInputs.addInputPath(job, p, inputInfos[i].inputFormatClass);
            paths.add(p);
        }
    }

    public static void setUpMultipleOutputs(JobConf job, byte[] resultIndexes, byte[] resultDimsUnknown, String[] outputs, OutputInfo[] outputInfos, boolean inBlockRepresentation, boolean mayContainCtable) throws Exception {
        if (resultIndexes.length != outputs.length) {
            throw new Exception("number of outputs and result indexes does not match");
        }
        if (outputs.length != outputInfos.length) {
            throw new Exception("number of outputs and outputInfos indexes does not match");
        }
        job.set(RESULT_INDEXES_CONFIG, MRJobConfiguration.getIndexesString(resultIndexes));
        job.set(RESULT_DIMS_UNKNOWN_CONFIG, MRJobConfiguration.getIndexesString(resultDimsUnknown));
        job.setStrings(OUTPUT_MATRICES_DIRS_CONFIG, outputs);
        job.setOutputCommitter(MultipleOutputCommitter.class);
        for (int i = 0; i < outputs.length; ++i) {
            MapReduceTool.deleteFileIfExistOnHDFS(new Path(outputs[i]), job);
            if (mayContainCtable && resultDimsUnknown[i] == 1) {
                MRJobConfiguration.setOutputInfo(job, i, outputInfos[i], false);
            } else {
                MRJobConfiguration.setOutputInfo(job, i, outputInfos[i], inBlockRepresentation);
            }
            MultipleOutputs.addNamedOutput((JobConf)job, (String)Integer.toString(i), outputInfos[i].outputFormatClass, outputInfos[i].outputKeyClass, outputInfos[i].outputValueClass);
        }
        job.setOutputFormat(NullOutputFormat.class);
        Path tempOutputPath = new Path(MRJobConfiguration.constructTempOutputFilename());
        FileOutputFormat.setOutputPath((JobConf)job, (Path)tempOutputPath);
        MapReduceTool.deleteFileIfExistOnHDFS(tempOutputPath, job);
    }

    public static void setUpMultipleOutputs(JobConf job, byte[] resultIndexes, byte[] resultDimsUnknwon, String[] outputs, OutputInfo[] outputInfos, boolean inBlockRepresentation) throws Exception {
        MRJobConfiguration.setUpMultipleOutputs(job, resultIndexes, resultDimsUnknwon, outputs, outputInfos, inBlockRepresentation, false);
    }

    public static String setUpSortPartitionFilename(JobConf job) {
        String pfname = MRJobConfiguration.constructPartitionFilename();
        job.set(SORT_PARTITION_FILENAME, pfname);
        return pfname;
    }

    public static String getSortPartitionFilename(JobConf job) {
        return job.get(SORT_PARTITION_FILENAME);
    }

    public static MatrixChar_N_ReducerGroups computeMatrixCharacteristics(JobConf job, byte[] inputIndexes, String instructionsInMapper, String aggInstructionsInReducer, String aggBinInstructions, String otherInstructionsInReducer, byte[] resultIndexes, HashSet<Byte> mapOutputIndexes, boolean forMMCJ) throws DMLRuntimeException {
        return MRJobConfiguration.computeMatrixCharacteristics(job, inputIndexes, null, instructionsInMapper, null, aggInstructionsInReducer, aggBinInstructions, otherInstructionsInReducer, resultIndexes, mapOutputIndexes, forMMCJ);
    }

    public static MatrixChar_N_ReducerGroups computeMatrixCharacteristics(JobConf job, byte[] inputIndexes, String instructionsInMapper, String reblockInstructions, String aggInstructionsInReducer, String aggBinInstructions, String otherInstructionsInReducer, byte[] resultIndexes, HashSet<Byte> mapOutputIndexes, boolean forMMCJ) throws DMLRuntimeException {
        return MRJobConfiguration.computeMatrixCharacteristics(job, inputIndexes, null, instructionsInMapper, reblockInstructions, aggInstructionsInReducer, aggBinInstructions, otherInstructionsInReducer, resultIndexes, mapOutputIndexes, forMMCJ);
    }

    public static void setNumReducers(JobConf job, long numReducerGroups, int numFromCompiler) throws IOException {
        JobClient client = new JobClient(job);
        int n = client.getClusterStatus().getMaxReduceTasks();
        if (InfrastructureAnalyzer.isYarnEnabled()) {
            n = (int)Math.max((long)n, YarnClusterAnalyzer.getNumCores() / 2L);
        }
        n = Math.min(n, ConfigurationManager.getNumReducers());
        n = Math.min(n, numFromCompiler);
        if (numReducerGroups > 0L) {
            n = (int)Math.min((long)n, numReducerGroups);
        }
        job.setNumReduceTasks(n);
    }

    /*
     * WARNING - void declaration
     */
    public static MatrixChar_N_ReducerGroups computeMatrixCharacteristics(JobConf job, byte[] inputIndexes, String dataGenInstructions, String instructionsInMapper, String reblockInstructions, String aggInstructionsInReducer, String aggBinInstructions, String otherInstructionsInReducer, byte[] resultIndexes, HashSet<Byte> mapOutputIndexes, boolean forMMCJ) throws DMLRuntimeException {
        MRInstruction[] mRInstructionArray;
        AggregateInstruction[] aggregateInstructionArray;
        ReblockInstruction[] reblockIns;
        MRInstruction[] insMapper;
        HashSet<Byte> intermediateMatrixIndexes = new HashSet<Byte>();
        HashMap<Byte, MatrixCharacteristics> dims = new HashMap<Byte, MatrixCharacteristics>();
        for (byte by : inputIndexes) {
            MatrixCharacteristics dim = new MatrixCharacteristics(MRJobConfiguration.getNumRows(job, by), MRJobConfiguration.getNumColumns(job, by), MRJobConfiguration.getNumRowsPerBlock(job, by), MRJobConfiguration.getNumColumnsPerBlock(job, by), MRJobConfiguration.getNumNonZero(job, by));
            dims.put(by, dim);
        }
        DataGenMRInstruction[] dataGenIns = null;
        dataGenIns = MRInstructionParser.parseDataGenInstructions(dataGenInstructions);
        if (dataGenIns != null) {
            void var16_22;
            DataGenMRInstruction[] dataGenMRInstructionArray = dataGenIns;
            int n = dataGenMRInstructionArray.length;
            boolean bl = false;
            while (var16_22 < n) {
                DataGenMRInstruction ins = dataGenMRInstructionArray[var16_22];
                MatrixCharacteristics.computeDimension(dims, ins);
                ++var16_22;
            }
        }
        if ((insMapper = MRInstructionParser.parseMixedInstructions(instructionsInMapper)) != null) {
            for (MRInstruction ins : insMapper) {
                MRInstruction tempIns;
                MatrixCharacteristics.computeDimension(dims, ins);
                if (ins instanceof UnaryMRInstructionBase) {
                    tempIns = (UnaryMRInstructionBase)ins;
                    MRJobConfiguration.setIntermediateMatrixCharactristics(job, ((UnaryMRInstructionBase)tempIns).input, dims.get(((UnaryMRInstructionBase)tempIns).input));
                    intermediateMatrixIndexes.add(((UnaryMRInstructionBase)tempIns).input);
                    continue;
                }
                if (ins instanceof AppendMInstruction) {
                    tempIns = (AppendMInstruction)ins;
                    MRJobConfiguration.setIntermediateMatrixCharactristics(job, ((AppendMInstruction)tempIns).input1, dims.get(((AppendMInstruction)tempIns).input1));
                    intermediateMatrixIndexes.add(((AppendMInstruction)tempIns).input1);
                    continue;
                }
                if (ins instanceof AppendGInstruction) {
                    tempIns = (AppendGInstruction)ins;
                    MRJobConfiguration.setIntermediateMatrixCharactristics(job, ((AppendGInstruction)tempIns).input1, dims.get(((AppendGInstruction)tempIns).input1));
                    intermediateMatrixIndexes.add(((AppendGInstruction)tempIns).input1);
                    continue;
                }
                if (ins instanceof BinaryMInstruction) {
                    tempIns = (BinaryMInstruction)ins;
                    MRJobConfiguration.setIntermediateMatrixCharactristics(job, ((BinaryMInstruction)tempIns).input1, dims.get(((BinaryMInstruction)tempIns).input1));
                    intermediateMatrixIndexes.add(((BinaryMInstruction)tempIns).input1);
                    continue;
                }
                if (ins instanceof AggregateBinaryInstruction) {
                    tempIns = (AggregateBinaryInstruction)ins;
                    MRJobConfiguration.setIntermediateMatrixCharactristics(job, ((AggregateBinaryInstruction)tempIns).input1, dims.get(((AggregateBinaryInstruction)tempIns).input1));
                    intermediateMatrixIndexes.add(((AggregateBinaryInstruction)tempIns).input1);
                    continue;
                }
                if (ins instanceof MapMultChainInstruction) {
                    tempIns = (MapMultChainInstruction)ins;
                    MRJobConfiguration.setIntermediateMatrixCharactristics(job, ((MapMultChainInstruction)tempIns).getInput1(), dims.get(((MapMultChainInstruction)tempIns).getInput2()));
                    intermediateMatrixIndexes.add(((MapMultChainInstruction)tempIns).getInput1());
                    continue;
                }
                if (!(ins instanceof PMMJMRInstruction)) continue;
                tempIns = (PMMJMRInstruction)ins;
                MRJobConfiguration.setIntermediateMatrixCharactristics(job, ((PMMJMRInstruction)tempIns).input2, dims.get(((PMMJMRInstruction)tempIns).input2));
                intermediateMatrixIndexes.add(((PMMJMRInstruction)tempIns).input2);
            }
        }
        if ((reblockIns = MRInstructionParser.parseReblockInstructions(reblockInstructions)) != null) {
            for (ReblockInstruction ins : reblockIns) {
                MatrixCharacteristics.computeDimension(dims, ins);
                MRJobConfiguration.setMatrixCharactristicsForReblock(job, ins.output, dims.get(ins.output));
            }
        }
        if ((aggregateInstructionArray = MRInstructionParser.parseAggregateInstructions(aggInstructionsInReducer)) != null) {
            for (AggregateInstruction aggregateInstruction : aggregateInstructionArray) {
                MatrixCharacteristics.computeDimension(dims, aggregateInstruction);
                MRInstruction mrins = aggregateInstruction;
                int found = 0;
                for (byte b : resultIndexes) {
                    if (b != mrins.output) continue;
                    found = 1;
                    break;
                }
                if (found != 0) continue;
                MRJobConfiguration.setIntermediateMatrixCharactristics(job, mrins.output, dims.get(mrins.output));
                intermediateMatrixIndexes.add(mrins.output);
            }
        }
        long numReduceGroups = 0L;
        AggregateBinaryInstruction[] aggBinIns = MRJobConfiguration.getAggregateBinaryInstructions(job);
        if (aggBinIns != null) {
            for (AggregateBinaryInstruction ins : aggBinIns) {
                MatrixCharacteristics dim1 = dims.get(ins.input1);
                MatrixCharacteristics dim2 = dims.get(ins.input2);
                MRJobConfiguration.setMatrixCharactristicsForBinAgg(job, ins.input1, dim1);
                MRJobConfiguration.setMatrixCharactristicsForBinAgg(job, ins.input2, dim2);
                MatrixCharacteristics.computeDimension(dims, ins);
                if (!forMMCJ) continue;
                numReduceGroups = (long)Math.ceil((double)dim1.getCols() / (double)dim1.getColsPerBlock());
            }
        }
        if (!forMMCJ) {
            ArrayList<Long> arrayList = new ArrayList<Long>(mapOutputIndexes.size());
            ArrayList<Long> ys = new ArrayList<Long>(mapOutputIndexes.size());
            for (byte idx : mapOutputIndexes) {
                MatrixCharacteristics dim = dims.get(idx);
                long x = (long)Math.ceil((double)dim.getRows() / (double)dim.getRowsPerBlock());
                long y = (long)Math.ceil((double)dim.getCols() / (double)dim.getColsPerBlock());
                int i = 0;
                boolean toadd = true;
                while (i < arrayList.size()) {
                    if (x >= (Long)arrayList.get(i) && y > (Long)ys.get(i) || x > (Long)arrayList.get(i) && y >= (Long)ys.get(i)) {
                        arrayList.remove(i);
                        ys.remove(i);
                        continue;
                    }
                    if (x <= (Long)arrayList.get(i) && y <= (Long)ys.get(i)) {
                        toadd = false;
                        break;
                    }
                    ++i;
                }
                if (!toadd) continue;
                arrayList.add(x);
                ys.add(y);
            }
            TreeMap map = new TreeMap();
            for (int i = 0; i < arrayList.size(); ++i) {
                map.put(arrayList.get(i), ys.get(i));
            }
            numReduceGroups = 0L;
            long prev = 0L;
            for (Map.Entry e : map.entrySet()) {
                numReduceGroups += ((Long)e.getKey() - prev) * (Long)e.getValue();
                prev = (Long)e.getKey();
            }
        }
        if ((mRInstructionArray = MRInstructionParser.parseMixedInstructions(otherInstructionsInReducer)) != null) {
            for (MRInstruction ins : mRInstructionArray) {
                MatrixCharacteristics.computeDimension(dims, ins);
                if (ins instanceof UnaryMRInstructionBase) {
                    UnaryMRInstructionBase tempIns = (UnaryMRInstructionBase)ins;
                    MRJobConfiguration.setIntermediateMatrixCharactristics(job, tempIns.input, dims.get(tempIns.input));
                    intermediateMatrixIndexes.add(tempIns.input);
                } else if (ins instanceof RemoveEmptyMRInstruction) {
                    RemoveEmptyMRInstruction tempIns = (RemoveEmptyMRInstruction)ins;
                    MRJobConfiguration.setIntermediateMatrixCharactristics(job, tempIns.input1, dims.get(tempIns.input1));
                    intermediateMatrixIndexes.add(tempIns.input1);
                }
                boolean found = false;
                for (byte b : resultIndexes) {
                    if (b != ins.output) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                MRJobConfiguration.setIntermediateMatrixCharactristics(job, ins.output, dims.get(ins.output));
                intermediateMatrixIndexes.add(ins.output);
            }
        }
        MRJobConfiguration.setIntermediateMatrixIndexes(job, intermediateMatrixIndexes);
        for (byte tag : mapOutputIndexes) {
            MRJobConfiguration.setMatrixCharactristicsForMapperOutput(job, tag, dims.get(tag));
        }
        MatrixCharacteristics[] stats = new MatrixCharacteristics[resultIndexes.length];
        for (int i = 0; i < resultIndexes.length; ++i) {
            MatrixCharacteristics resultDims;
            stats[i] = resultDims = dims.get(resultIndexes[i]);
            MRJobConfiguration.setMatrixCharactristicsForOutput(job, resultIndexes[i], stats[i]);
        }
        return new MatrixChar_N_ReducerGroups(stats, numReduceGroups);
    }

    public static void setIntermediateMatrixCharactristics(JobConf job, byte tag, MatrixCharacteristics dim) {
        job.setLong(INTERMEDIATE_MATRIX_NUM_ROW_PREFIX_CONFIG + tag, dim.getRows());
        job.setLong(INTERMEDIATE_MATRIX_NUM_COLUMN_PREFIX_CONFIG + tag, dim.getCols());
        job.setInt(INTERMEDIATE_BLOCK_NUM_ROW_PREFIX_CONFIG + tag, dim.getRowsPerBlock());
        job.setInt(INTERMEDIATE_BLOCK_NUM_COLUMN_PREFIX_CONFIG + tag, dim.getColsPerBlock());
    }

    public static MatrixCharacteristics getIntermediateMatrixCharactristics(JobConf job, byte tag) {
        MatrixCharacteristics dim = new MatrixCharacteristics();
        dim.setDimension(job.getLong(INTERMEDIATE_MATRIX_NUM_ROW_PREFIX_CONFIG + tag, 0L), job.getLong(INTERMEDIATE_MATRIX_NUM_COLUMN_PREFIX_CONFIG + tag, 0L));
        dim.setBlockSize(job.getInt(INTERMEDIATE_BLOCK_NUM_ROW_PREFIX_CONFIG + tag, 1), job.getInt(INTERMEDIATE_BLOCK_NUM_COLUMN_PREFIX_CONFIG + tag, 1));
        return dim;
    }

    public static void setMatrixCharactristicsForOutput(JobConf job, byte tag, MatrixCharacteristics dim) {
        job.setLong(OUTPUT_MATRIX_NUM_ROW_PREFIX_CONFIG + tag, dim.getRows());
        job.setLong(OUTPUT_MATRIX_NUM_COLUMN_PREFIX_CONFIG + tag, dim.getCols());
        job.setInt(OUTPUT_BLOCK_NUM_ROW_PREFIX_CONFIG + tag, dim.getRowsPerBlock());
        job.setInt(OUTPUT_BLOCK_NUM_COLUMN_PREFIX_CONFIG + tag, dim.getColsPerBlock());
    }

    public static MatrixCharacteristics getMatrixCharacteristicsForOutput(JobConf job, byte tag) {
        MatrixCharacteristics dim = new MatrixCharacteristics();
        dim.setDimension(job.getLong(OUTPUT_MATRIX_NUM_ROW_PREFIX_CONFIG + tag, 0L), job.getLong(OUTPUT_MATRIX_NUM_COLUMN_PREFIX_CONFIG + tag, 0L));
        dim.setBlockSize(job.getInt(OUTPUT_BLOCK_NUM_ROW_PREFIX_CONFIG + tag, 1), job.getInt(OUTPUT_BLOCK_NUM_COLUMN_PREFIX_CONFIG + tag, 1));
        return dim;
    }

    public static MatrixCharacteristics getMatrixCharacteristicsForInput(JobConf job, byte tag) {
        MatrixCharacteristics dim = new MatrixCharacteristics();
        dim.setDimension(job.getLong(INPUT_MATRIX_NUM_ROW_PREFIX_CONFIG + tag, 0L), job.getLong(INPUT_MATRIX_NUM_COLUMN_PREFIX_CONFIG + tag, 0L));
        dim.setBlockSize(job.getInt(INPUT_BLOCK_NUM_ROW_PREFIX_CONFIG + tag, 1), job.getInt(INPUT_BLOCK_NUM_COLUMN_PREFIX_CONFIG + tag, 1));
        return dim;
    }

    public static void setMatrixCharactristicsForMapperOutput(JobConf job, byte tag, MatrixCharacteristics dim) {
        job.setLong(MAPOUTPUT_MATRIX_NUM_ROW_PREFIX_CONFIG + tag, dim.getRows());
        job.setLong(MAPOUTPUT_MATRIX_NUM_COLUMN_PREFIX_CONFIG + tag, dim.getCols());
        job.setInt(MAPOUTPUT_BLOCK_NUM_ROW_PREFIX_CONFIG + tag, dim.getRowsPerBlock());
        job.setInt(MAPOUTPUT_BLOCK_NUM_COLUMN_PREFIX_CONFIG + tag, dim.getColsPerBlock());
    }

    public static MatrixCharacteristics getMatrixCharacteristicsForMapOutput(JobConf job, byte tag) {
        MatrixCharacteristics dim = new MatrixCharacteristics();
        dim.setDimension(job.getLong(MAPOUTPUT_MATRIX_NUM_ROW_PREFIX_CONFIG + tag, 0L), job.getLong(MAPOUTPUT_MATRIX_NUM_COLUMN_PREFIX_CONFIG + tag, 0L));
        dim.setBlockSize(job.getInt(MAPOUTPUT_BLOCK_NUM_ROW_PREFIX_CONFIG + tag, 1), job.getInt(MAPOUTPUT_BLOCK_NUM_COLUMN_PREFIX_CONFIG + tag, 1));
        return dim;
    }

    public static void setMatrixCharactristicsForReblock(JobConf job, byte tag, MatrixCharacteristics dim) {
        job.setLong(REBLOCK_MATRIX_NUM_ROW_PREFIX_CONFIG + tag, dim.getRows());
        job.setLong(REBLOCK_MATRIX_NUM_COLUMN_PREFIX_CONFIG + tag, dim.getCols());
        job.setInt(REBLOCK_BLOCK_NUM_ROW_PREFIX_CONFIG + tag, dim.getRowsPerBlock());
        job.setInt(REBLOCK_BLOCK_NUM_COLUMN_PREFIX_CONFIG + tag, dim.getColsPerBlock());
        job.setLong(REBLOCK_MATRIX_NUM_NNZ_PREFIX_CONFIG + tag, dim.getNonZeros());
    }

    public static MatrixCharacteristics getMatrixCharactristicsForReblock(JobConf job, byte tag) {
        MatrixCharacteristics dim = new MatrixCharacteristics();
        dim.setDimension(job.getLong(REBLOCK_MATRIX_NUM_ROW_PREFIX_CONFIG + tag, 0L), job.getLong(REBLOCK_MATRIX_NUM_COLUMN_PREFIX_CONFIG + tag, 0L));
        dim.setBlockSize(job.getInt(REBLOCK_BLOCK_NUM_ROW_PREFIX_CONFIG + tag, 1), job.getInt(REBLOCK_BLOCK_NUM_COLUMN_PREFIX_CONFIG + tag, 1));
        long nnz = job.getLong(REBLOCK_MATRIX_NUM_NNZ_PREFIX_CONFIG + tag, -1L);
        if (nnz >= 0L) {
            dim.setNonZeros(nnz);
        }
        return dim;
    }

    public static void setMatrixCharactristicsForBinAgg(JobConf job, byte tag, MatrixCharacteristics dim) {
        job.setLong(AGGBIN_MATRIX_NUM_ROW_PREFIX_CONFIG + tag, dim.getRows());
        job.setLong(AGGBIN_MATRIX_NUM_COLUMN_PREFIX_CONFIG + tag, dim.getCols());
        job.setInt(AGGBIN_BLOCK_NUM_ROW_PREFIX_CONFIG + tag, dim.getRowsPerBlock());
        job.setInt(AGGBIN_BLOCK_NUM_COLUMN_PREFIX_CONFIG + tag, dim.getColsPerBlock());
    }

    public static MatrixCharacteristics getMatrixCharactristicsForBinAgg(JobConf job, byte tag) {
        MatrixCharacteristics dim = new MatrixCharacteristics();
        dim.setDimension(job.getLong(AGGBIN_MATRIX_NUM_ROW_PREFIX_CONFIG + tag, 0L), job.getLong(AGGBIN_MATRIX_NUM_COLUMN_PREFIX_CONFIG + tag, 0L));
        dim.setBlockSize(job.getInt(AGGBIN_BLOCK_NUM_ROW_PREFIX_CONFIG + tag, 1), job.getInt(AGGBIN_BLOCK_NUM_COLUMN_PREFIX_CONFIG + tag, 1));
        return dim;
    }

    public static HashSet<Byte> setUpOutputIndexesForMapper(JobConf job, byte[] inputIndexes, String instructionsInMapper, String aggInstructionsInReducer, String otherInstructionsInReducer, byte[] resultIndexes) throws DMLRuntimeException {
        return MRJobConfiguration.setUpOutputIndexesForMapper(job, inputIndexes, null, instructionsInMapper, null, aggInstructionsInReducer, otherInstructionsInReducer, resultIndexes);
    }

    public static HashSet<Byte> setUpOutputIndexesForMapper(JobConf job, byte[] inputIndexes, String instructionsInMapper, String reblockInstructions, String aggInstructionsInReducer, String otherInstructionsInReducer, byte[] resultIndexes) throws DMLRuntimeException {
        return MRJobConfiguration.setUpOutputIndexesForMapper(job, inputIndexes, null, instructionsInMapper, reblockInstructions, aggInstructionsInReducer, otherInstructionsInReducer, resultIndexes);
    }

    public static HashSet<Byte> setUpOutputIndexesForMapper(JobConf job, byte[] inputIndexes, String randInstructions, String instructionsInMapper, String reblockInstructions, String aggInstructionsInReducer, String otherInstructionsInReducer, byte[] resultIndexes) throws DMLRuntimeException {
        HashSet<Byte> indexesInMapper = new HashSet<Byte>();
        for (byte b : inputIndexes) {
            indexesInMapper.add(b);
        }
        MRInstruction[] dataGenIns = null;
        dataGenIns = MRInstructionParser.parseDataGenInstructions(randInstructions);
        MRJobConfiguration.getIndexes(dataGenIns, indexesInMapper);
        MRInstruction[] insMapper = MRInstructionParser.parseMixedInstructions(instructionsInMapper);
        MRJobConfiguration.getIndexes(insMapper, indexesInMapper);
        MRInstruction[] reblockIns = null;
        reblockIns = MRInstructionParser.parseReblockInstructions(reblockInstructions);
        MRJobConfiguration.getIndexes(reblockIns, indexesInMapper);
        MRInstruction[] insReducer = MRInstructionParser.parseAggregateInstructions(aggInstructionsInReducer);
        HashSet<Byte> indexesInReducer = new HashSet<Byte>();
        MRJobConfiguration.getIndexes(insReducer, indexesInReducer);
        insReducer = MRInstructionParser.parseMixedInstructions(otherInstructionsInReducer);
        MRJobConfiguration.getIndexes(insReducer, indexesInReducer);
        for (byte ind : resultIndexes) {
            indexesInReducer.add(ind);
        }
        indexesInMapper.retainAll(indexesInReducer);
        job.set(OUTPUT_INDEXES_IN_MAPPER_CONFIG, MRJobConfiguration.getIndexesString(indexesInMapper));
        return indexesInMapper;
    }

    public static CollectMultipleConvertedOutputs getMultipleConvertedOutputs(JobConf job) {
        byte[] resultIndexes = MRJobConfiguration.getResultIndexes(job);
        Converter[] outputConverters = new Converter[resultIndexes.length];
        MatrixCharacteristics[] stats = new MatrixCharacteristics[resultIndexes.length];
        HashMap<Byte, ArrayList<Integer>> tagMapping = new HashMap<Byte, ArrayList<Integer>>();
        for (int i = 0; i < resultIndexes.length; ++i) {
            byte output = resultIndexes[i];
            ArrayList<Integer> vec = (ArrayList<Integer>)tagMapping.get(output);
            if (vec == null) {
                vec = new ArrayList<Integer>();
                tagMapping.put(output, vec);
            }
            vec.add(i);
            outputConverters[i] = MRJobConfiguration.getOuputConverter(job, i);
            stats[i] = MRJobConfiguration.getMatrixCharacteristicsForOutput(job, output);
        }
        MultipleOutputs multipleOutputs = new MultipleOutputs(job);
        return new CollectMultipleConvertedOutputs(outputConverters, stats, multipleOutputs);
    }

    private static void getIndexes(MRInstruction[] instructions, HashSet<Byte> indexes) throws DMLRuntimeException {
        if (instructions == null) {
            return;
        }
        for (MRInstruction ins : instructions) {
            for (byte i : ins.getAllIndexes()) {
                indexes.add(i);
            }
        }
    }

    private static String getIndexesString(HashSet<Byte> indexes) {
        if (indexes == null || indexes.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (Byte ind : indexes) {
            sb.append(ind);
            sb.append("\u2021");
        }
        return sb.substring(0, sb.length() - 1);
    }

    private static String getIndexesString(byte[] indexes) {
        if (indexes == null || indexes.length == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        byte[] byArray = indexes;
        int n = byArray.length;
        for (int i = 0; i < n; ++i) {
            Byte ind = byArray[i];
            sb.append(ind);
            sb.append("\u2021");
        }
        return sb.substring(0, sb.length() - 1);
    }

    public static void setMapFunctionInputMatrixIndexes(JobConf job, byte[] realIndexes) {
        job.set(MAPFUNC_INPUT_MATRICIES_INDEXES_CONFIG, MRJobConfiguration.getIndexesString(realIndexes));
    }

    public static boolean deriveRepresentation(InputInfo[] inputInfos) {
        for (InputInfo input : inputInfos) {
            if (input.inputValueClass == MatrixBlock.class) continue;
            return false;
        }
        return true;
    }

    public static String constructTempOutputFilename() {
        StringBuilder sb = new StringBuilder();
        sb.append(ConfigurationManager.getScratchSpace());
        sb.append("/");
        sb.append("_p");
        sb.append(DMLScript.getUUID());
        sb.append("/");
        sb.append("TmpOutput" + seq.getNextID());
        return sb.toString();
    }

    private static String constructPartitionFilename() {
        StringBuilder sb = new StringBuilder();
        sb.append(ConfigurationManager.getScratchSpace());
        sb.append("/");
        sb.append("_p");
        sb.append(DMLScript.getUUID());
        sb.append("/");
        sb.append("_partition.lst" + seq.getNextID());
        return sb.toString();
    }

    public static void setSystemMLLocalTmpDir(JobConf job, String dir) {
        job.set(SYSTEMML_LOCAL_TMP_DIR, dir);
    }

    public static String getSystemMLLocalTmpDir(JobConf job) {
        return job.get(SYSTEMML_LOCAL_TMP_DIR);
    }

    public static void addBinaryBlockSerializationFramework(Configuration job) {
        String frameworkList = job.get("io.serializations");
        String frameworkClassBB = BinaryBlockSerialization.class.getCanonicalName();
        job.set("io.serializations", frameworkClassBB + "," + frameworkList);
    }

    public static void setupCustomMRConfigurations(JobConf job, DMLConfig config) {
        Map<String, String> map = config.getCustomMRConfig();
        for (Map.Entry<String, String> e : map.entrySet()) {
            job.set(e.getKey(), e.getValue());
        }
    }

    public static class MatrixChar_N_ReducerGroups {
        public MatrixCharacteristics[] stats;
        public long numReducerGroups = 0L;

        public MatrixChar_N_ReducerGroups(MatrixCharacteristics[] sts, long ng) {
            this.stats = sts;
            this.numReducerGroups = ng;
        }
    }

    public static enum ConvertTarget {
        CELL,
        BLOCK,
        WEIGHTEDCELL,
        CSVWRITE;

    }
}

