/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.instructions.mr;

import java.util.ArrayList;
import org.apache.sysml.runtime.DMLRuntimeException;
import org.apache.sysml.runtime.instructions.InstructionUtils;
import org.apache.sysml.runtime.instructions.mr.UnaryInstruction;
import org.apache.sysml.runtime.matrix.MatrixCharacteristics;
import org.apache.sysml.runtime.matrix.data.MatrixBlock;
import org.apache.sysml.runtime.matrix.data.MatrixIndexes;
import org.apache.sysml.runtime.matrix.data.MatrixValue;
import org.apache.sysml.runtime.matrix.mapred.CachedValueMap;
import org.apache.sysml.runtime.matrix.mapred.IndexedMatrixValue;

public class CumulativeSplitInstruction
extends UnaryInstruction {
    private MatrixCharacteristics _mcIn = null;
    private long _lastRowBlockIndex = -1L;
    private double _initValue = 0.0;

    private CumulativeSplitInstruction(byte in, byte out, double init, String istr) {
        super(null, in, out, istr);
        this._initValue = init;
    }

    public void setMatrixCharacteristics(MatrixCharacteristics mcIn) {
        this._mcIn = mcIn;
        this._lastRowBlockIndex = (long)Math.ceil((double)this._mcIn.getRows() / (double)this._mcIn.getRowsPerBlock());
    }

    public static CumulativeSplitInstruction parseInstruction(String str) throws DMLRuntimeException {
        InstructionUtils.checkNumFields(str, 3);
        String[] parts = InstructionUtils.getInstructionParts(str);
        byte in = Byte.parseByte(parts[1]);
        byte out = Byte.parseByte(parts[2]);
        double init = Double.parseDouble(parts[3]);
        return new CumulativeSplitInstruction(in, out, init, str);
    }

    @Override
    public void processInstruction(Class<? extends MatrixValue> valueClass, CachedValueMap cachedValues, IndexedMatrixValue tempValue, IndexedMatrixValue zeroInput, int blockRowFactor, int blockColFactor) throws DMLRuntimeException {
        ArrayList<IndexedMatrixValue> blkList = cachedValues.get(this.input);
        if (blkList == null) {
            return;
        }
        for (IndexedMatrixValue in1 : blkList) {
            boolean lastBlk;
            if (in1 == null) continue;
            MatrixIndexes inix = in1.getIndexes();
            MatrixBlock blk = (MatrixBlock)in1.getValue();
            long rixOffset = (inix.getRowIndex() - 1L) * (long)blockRowFactor;
            boolean firstBlk = inix.getRowIndex() == 1L;
            boolean bl = lastBlk = inix.getRowIndex() == this._lastRowBlockIndex;
            if (firstBlk) {
                IndexedMatrixValue out = cachedValues.holdPlace(this.output, valueClass);
                ((MatrixBlock)out.getValue()).reset(1, blk.getNumColumns());
                if (this._initValue != 0.0) {
                    for (int j = 0; j < blk.getNumColumns(); ++j) {
                        ((MatrixBlock)out.getValue()).appendValue(0, j, this._initValue);
                    }
                }
                out.getIndexes().setIndexes(1L, inix.getColumnIndex());
            }
            for (int i = 0; i < blk.getNumRows(); ++i) {
                if (lastBlk && i == blk.getNumRows() - 1) continue;
                IndexedMatrixValue out = cachedValues.holdPlace(this.output, valueClass);
                MatrixBlock tmpBlk = (MatrixBlock)out.getValue();
                tmpBlk.reset(1, blk.getNumColumns());
                blk.sliceOperations(i, i, 0, blk.getNumColumns() - 1, tmpBlk);
                out.getIndexes().setIndexes(rixOffset + (long)i + 2L, inix.getColumnIndex());
            }
        }
    }
}

