/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.instructions.mr;

import org.apache.sysml.runtime.DMLRuntimeException;
import org.apache.sysml.runtime.instructions.InstructionUtils;
import org.apache.sysml.runtime.instructions.mr.MRInstruction;
import org.apache.sysml.runtime.instructions.mr.UnaryMRInstructionBase;
import org.apache.sysml.runtime.matrix.data.MatrixValue;
import org.apache.sysml.runtime.matrix.mapred.CachedValueMap;
import org.apache.sysml.runtime.matrix.mapred.IndexedMatrixValue;
import org.apache.sysml.runtime.matrix.operators.Operator;

public class CombineUnaryInstruction
extends UnaryMRInstructionBase {
    private CombineUnaryInstruction(Operator op, byte in, byte out, String istr) {
        super(op, in, out);
        this.mrtype = MRInstruction.MRINSTRUCTION_TYPE.CombineUnary;
        this.instString = istr;
    }

    public static CombineUnaryInstruction parseInstruction(String str) throws DMLRuntimeException {
        InstructionUtils.checkNumFields(str, 2);
        String[] parts = InstructionUtils.getInstructionParts(str);
        String opcode = parts[0];
        byte in = Byte.parseByte(parts[1]);
        byte out = Byte.parseByte(parts[2]);
        if (opcode.equalsIgnoreCase("combineunary")) {
            return new CombineUnaryInstruction(null, in, out, str);
        }
        return null;
    }

    @Override
    public void processInstruction(Class<? extends MatrixValue> valueClass, CachedValueMap cachedValues, IndexedMatrixValue tempValue, IndexedMatrixValue zeroInput, int blockRowFactor, int blockColFactor) throws DMLRuntimeException {
        throw new DMLRuntimeException("CombineInstruction.processInstruction should never be called!");
    }
}

