/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.instructions.cp;

import java.util.StringTokenizer;
import org.apache.sysml.runtime.DMLRuntimeException;
import org.apache.sysml.runtime.controlprogram.context.ExecutionContext;
import org.apache.sysml.runtime.instructions.InstructionUtils;
import org.apache.sysml.runtime.instructions.cp.CPOperand;
import org.apache.sysml.runtime.instructions.cp.UnaryCPInstruction;
import org.apache.sysml.runtime.matrix.data.MatrixBlock;
import org.apache.sysml.runtime.matrix.operators.Operator;

public class StringInitCPInstruction
extends UnaryCPInstruction {
    private static final String DELIM = " ";
    private long _rlen = -1L;
    private long _clen = -1L;
    private String _data = null;

    private StringInitCPInstruction(Operator op, CPOperand in, CPOperand out, long rows, long cols, int rpb, int cpb, String data, String opcode, String inst) {
        super(op, in, out, opcode, inst);
        this._rlen = rows;
        this._clen = cols;
        this._data = data;
    }

    public long getRows() {
        return this._rlen;
    }

    public long getCols() {
        return this._clen;
    }

    public static StringInitCPInstruction parseInstruction(String str) throws DMLRuntimeException {
        String opcode = InstructionUtils.getOpCode(str);
        if (!opcode.equals("sinit")) {
            throw new DMLRuntimeException("Unsupported opcode: " + opcode);
        }
        String[] s = InstructionUtils.getInstructionPartsWithValueType(str);
        InstructionUtils.checkNumFields(s, 6);
        CPOperand out = new CPOperand(s[s.length - 1]);
        long rows = s[1].contains("\u00b6") ? -1L : Double.valueOf(s[1]).longValue();
        long cols = s[2].contains("\u00b6") ? -1L : Double.valueOf(s[2]).longValue();
        int rpb = Integer.parseInt(s[3]);
        int cpb = Integer.parseInt(s[4]);
        String data = s[5];
        return new StringInitCPInstruction(null, null, out, rows, cols, rpb, cpb, data, opcode, str);
    }

    @Override
    public void processInstruction(ExecutionContext ec) throws DMLRuntimeException {
        String outName = this.output.getName();
        MatrixBlock outBlk = new MatrixBlock((int)this._rlen, (int)this._clen, false);
        StringTokenizer st = new StringTokenizer(this._data, DELIM);
        int len = st.countTokens();
        if ((long)len != this._rlen * this._clen) {
            throw new DMLRuntimeException("Invalid matrix string intialization: dimensions=[" + this._rlen + "x" + this._clen + "] vs numValues=" + len);
        }
        for (int i = 0; i < len; ++i) {
            String sval = st.nextToken();
            Double dval = Double.parseDouble(sval);
            int rix = (int)((long)i / this._clen);
            int cix = (int)((long)i % this._clen);
            outBlk.quickSetValue(rix, cix, dval);
        }
        outBlk.recomputeNonZeros();
        outBlk.examSparsity();
        ec.setMatrixOutput(outName, outBlk, this.getExtendedOpcode());
    }
}

