/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.instructions.cp;

import org.apache.sysml.parser.Expression;
import org.apache.sysml.runtime.DMLRuntimeException;
import org.apache.sysml.runtime.controlprogram.context.ExecutionContext;
import org.apache.sysml.runtime.instructions.InstructionUtils;
import org.apache.sysml.runtime.instructions.cp.BooleanObject;
import org.apache.sysml.runtime.instructions.cp.CPInstruction;
import org.apache.sysml.runtime.instructions.cp.CPOperand;
import org.apache.sysml.runtime.instructions.cp.UnaryCPInstruction;
import org.apache.sysml.runtime.matrix.data.LibMatrixReorg;
import org.apache.sysml.runtime.matrix.data.MatrixBlock;
import org.apache.sysml.runtime.matrix.operators.Operator;

public class MatrixReshapeCPInstruction
extends UnaryCPInstruction {
    private CPOperand _opRows = null;
    private CPOperand _opCols = null;
    private CPOperand _opByRow = null;

    private MatrixReshapeCPInstruction(Operator op, CPOperand in1, CPOperand in2, CPOperand in3, CPOperand in4, CPOperand out, String opcode, String istr) {
        super(op, in1, out, opcode, istr);
        this._cptype = CPInstruction.CPINSTRUCTION_TYPE.MatrixReshape;
        this._opRows = in2;
        this._opCols = in3;
        this._opByRow = in4;
    }

    public static MatrixReshapeCPInstruction parseInstruction(String str) throws DMLRuntimeException {
        String[] parts = InstructionUtils.getInstructionPartsWithValueType(str);
        InstructionUtils.checkNumFields(parts, 5);
        String opcode = parts[0];
        CPOperand in1 = new CPOperand(parts[1]);
        CPOperand in2 = new CPOperand(parts[2]);
        CPOperand in3 = new CPOperand(parts[3]);
        CPOperand in4 = new CPOperand(parts[4]);
        CPOperand out = new CPOperand(parts[5]);
        if (!opcode.equalsIgnoreCase("rshape")) {
            throw new DMLRuntimeException("Unknown opcode while parsing an MatrixReshapeInstruction: " + str);
        }
        return new MatrixReshapeCPInstruction(new Operator(true), in1, in2, in3, in4, out, opcode, str);
    }

    @Override
    public void processInstruction(ExecutionContext ec) throws DMLRuntimeException {
        MatrixBlock in = ec.getMatrixInput(this.input1.getName(), this.getExtendedOpcode());
        int rows = (int)ec.getScalarInput(this._opRows.getName(), this._opRows.getValueType(), this._opRows.isLiteral()).getLongValue();
        int cols = (int)ec.getScalarInput(this._opCols.getName(), this._opCols.getValueType(), this._opCols.isLiteral()).getLongValue();
        BooleanObject byRow = (BooleanObject)ec.getScalarInput(this._opByRow.getName(), Expression.ValueType.BOOLEAN, this._opByRow.isLiteral());
        MatrixBlock out = new MatrixBlock();
        out = LibMatrixReorg.reshape(in, out, rows, cols, byRow.getBooleanValue());
        ec.setMatrixOutput(this.output.getName(), out, this.getExtendedOpcode());
        ec.releaseMatrixInput(this.input1.getName(), this.getExtendedOpcode());
    }
}

