/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.instructions.cp;

import org.apache.sysml.parser.Expression;
import org.apache.sysml.runtime.DMLRuntimeException;
import org.apache.sysml.runtime.instructions.InstructionUtils;
import org.apache.sysml.runtime.instructions.cp.BinaryCPInstruction;
import org.apache.sysml.runtime.instructions.cp.CPInstruction;
import org.apache.sysml.runtime.instructions.cp.CPOperand;
import org.apache.sysml.runtime.instructions.cp.MatrixMatrixArithmeticCPInstruction;
import org.apache.sysml.runtime.instructions.cp.ScalarMatrixArithmeticCPInstruction;
import org.apache.sysml.runtime.instructions.cp.ScalarScalarArithmeticCPInstruction;
import org.apache.sysml.runtime.matrix.operators.BinaryOperator;
import org.apache.sysml.runtime.matrix.operators.Operator;

public abstract class ArithmeticBinaryCPInstruction
extends BinaryCPInstruction {
    protected ArithmeticBinaryCPInstruction(Operator op, CPOperand in1, CPOperand in2, CPOperand out, String opcode, String istr) {
        super(op, in1, in2, out, opcode, istr);
        this._cptype = CPInstruction.CPINSTRUCTION_TYPE.ArithmeticBinary;
    }

    public static ArithmeticBinaryCPInstruction parseInstruction(String str) throws DMLRuntimeException {
        BinaryOperator operator;
        CPOperand in1 = new CPOperand("", Expression.ValueType.UNKNOWN, Expression.DataType.UNKNOWN);
        CPOperand in2 = new CPOperand("", Expression.ValueType.UNKNOWN, Expression.DataType.UNKNOWN);
        CPOperand out = new CPOperand("", Expression.ValueType.UNKNOWN, Expression.DataType.UNKNOWN);
        String opcode = ArithmeticBinaryCPInstruction.parseBinaryInstruction(str, in1, in2, out);
        ArithmeticBinaryCPInstruction.checkOutputDataType(in1, in2, out);
        Operator operator2 = in1.getDataType() != in2.getDataType() ? InstructionUtils.parseScalarBinaryOperator(opcode, in1.getDataType() == Expression.DataType.SCALAR) : (operator = InstructionUtils.parseBinaryOperator(opcode));
        if (in1.getDataType() == Expression.DataType.SCALAR && in2.getDataType() == Expression.DataType.SCALAR) {
            return new ScalarScalarArithmeticCPInstruction(operator, in1, in2, out, opcode, str);
        }
        if (in1.getDataType() == Expression.DataType.MATRIX && in2.getDataType() == Expression.DataType.MATRIX) {
            return new MatrixMatrixArithmeticCPInstruction(operator, in1, in2, out, opcode, str);
        }
        return new ScalarMatrixArithmeticCPInstruction(operator, in1, in2, out, opcode, str);
    }
}

