/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.controlprogram.caching;

import java.io.File;
import java.io.IOException;
import java.lang.ref.SoftReference;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.lang.mutable.MutableBoolean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.fs.Path;
import org.apache.sysml.api.DMLScript;
import org.apache.sysml.conf.ConfigurationManager;
import org.apache.sysml.hops.OptimizerUtils;
import org.apache.sysml.parser.Expression;
import org.apache.sysml.runtime.DMLRuntimeException;
import org.apache.sysml.runtime.controlprogram.caching.CacheBlock;
import org.apache.sysml.runtime.controlprogram.caching.CacheException;
import org.apache.sysml.runtime.controlprogram.caching.CacheStatistics;
import org.apache.sysml.runtime.controlprogram.caching.LazyWriteBuffer;
import org.apache.sysml.runtime.controlprogram.parfor.util.IDSequence;
import org.apache.sysml.runtime.instructions.cp.Data;
import org.apache.sysml.runtime.instructions.gpu.context.GPUContext;
import org.apache.sysml.runtime.instructions.gpu.context.GPUObject;
import org.apache.sysml.runtime.instructions.spark.data.BroadcastObject;
import org.apache.sysml.runtime.instructions.spark.data.RDDObject;
import org.apache.sysml.runtime.io.IOUtilFunctions;
import org.apache.sysml.runtime.matrix.MatrixCharacteristics;
import org.apache.sysml.runtime.matrix.MatrixDimensionsMetaData;
import org.apache.sysml.runtime.matrix.MatrixFormatMetaData;
import org.apache.sysml.runtime.matrix.MetaData;
import org.apache.sysml.runtime.matrix.data.FileFormatProperties;
import org.apache.sysml.runtime.matrix.data.InputInfo;
import org.apache.sysml.runtime.matrix.data.MatrixBlock;
import org.apache.sysml.runtime.matrix.data.NumItemsByEachReducerMetaData;
import org.apache.sysml.runtime.matrix.data.OutputInfo;
import org.apache.sysml.runtime.util.LocalFileUtils;
import org.apache.sysml.runtime.util.MapReduceTool;
import org.apache.sysml.utils.GPUStatistics;

public abstract class CacheableData<T extends CacheBlock>
extends Data {
    private static final long serialVersionUID = -413810592207212835L;
    protected static final Log LOG = LogFactory.getLog((String)CacheableData.class.getName());
    public static final long CACHING_THRESHOLD = 4096L;
    public static final double CACHING_BUFFER_SIZE = 0.15;
    public static final LazyWriteBuffer.RPolicy CACHING_BUFFER_POLICY = LazyWriteBuffer.RPolicy.FIFO;
    public static final boolean CACHING_BUFFER_PAGECACHE = false;
    public static final boolean CACHING_WRITE_CACHE_ON_READ = false;
    public static final String CACHING_COUNTER_GROUP_NAME = "SystemML Caching Counters";
    public static final String CACHING_EVICTION_FILEEXTENSION = ".dat";
    public static final boolean CACHING_ASYNC_FILECLEANUP = true;
    private static boolean _activeFlag = false;
    private static IDSequence _seq = null;
    public static String cacheEvictionLocalFilePath = null;
    public static String cacheEvictionLocalFilePrefix = "cache";
    private static ThreadLocal<Long> sizePinned = new ThreadLocal<Long>(){

        @Override
        protected Long initialValue() {
            return 0L;
        }
    };
    private static AtomicLong _refBCs = new AtomicLong(0L);
    private final int _uniqueID = (int)_seq.getNextID();
    private CacheStatus _cacheStatus = CacheStatus.EMPTY;
    protected SoftReference<T> _cache = null;
    protected T _data = null;
    protected MetaData _metaData = null;
    protected String _hdfsFileName = null;
    private boolean _hdfsFileExists = false;
    private FileFormatProperties _formatProps = null;
    private boolean _dirtyFlag = false;
    private int _numReadThreads = 0;
    private boolean _cleanupFlag = true;
    private String _varName = "";
    private String _cacheFileName = null;
    private boolean _requiresLocalWrite = false;
    private boolean _isAcquireFromEmpty = false;
    private RDDObject _rddHandle = null;
    private BroadcastObject<T> _bcHandle = null;
    protected HashMap<GPUContext, GPUObject> _gpuObjects = new HashMap();

    protected CacheableData(Expression.DataType dt, Expression.ValueType vt) {
        super(dt, vt);
    }

    protected CacheableData(CacheableData<T> that) {
        this(that.getDataType(), that.getValueType());
        this._cleanupFlag = that._cleanupFlag;
        this._hdfsFileName = that._hdfsFileName;
        this._hdfsFileExists = that._hdfsFileExists;
        this._varName = that._varName;
        this._gpuObjects = that._gpuObjects;
    }

    public void enableCleanup(boolean flag) {
        this._cleanupFlag = flag;
    }

    public boolean isCleanupEnabled() {
        return this._cleanupFlag;
    }

    public void setVarName(String s) {
        this._varName = s;
    }

    public String getVarName() {
        return this._varName;
    }

    public boolean isHDFSFileExists() {
        return this._hdfsFileExists;
    }

    public void setHDFSFileExists(boolean flag) {
        this._hdfsFileExists = flag;
    }

    public String getFileName() {
        return this._hdfsFileName;
    }

    public synchronized void setFileName(String file) {
        if (this._hdfsFileName != null && !this._hdfsFileName.equals(file) && !this.isEmpty(true)) {
            this._dirtyFlag = true;
        }
        this._hdfsFileName = file;
    }

    public boolean isDirty() {
        return this._dirtyFlag;
    }

    public void setDirty(boolean flag) {
        this._dirtyFlag = flag;
    }

    public FileFormatProperties getFileFormatProperties() {
        return this._formatProps;
    }

    public void setFileFormatProperties(FileFormatProperties props) {
        this._formatProps = props;
    }

    @Override
    public void setMetaData(MetaData md) {
        this._metaData = md;
    }

    @Override
    public MetaData getMetaData() {
        return this._metaData;
    }

    @Override
    public void removeMetaData() {
        this._metaData = null;
    }

    public MatrixCharacteristics getMatrixCharacteristics() {
        MatrixDimensionsMetaData meta = (MatrixDimensionsMetaData)this._metaData;
        return meta.getMatrixCharacteristics();
    }

    public abstract void refreshMetaData() throws CacheException;

    public RDDObject getRDDHandle() {
        return this._rddHandle;
    }

    public void setRDDHandle(RDDObject rdd) {
        if (this._rddHandle != null) {
            this._rddHandle.setBackReference(null);
        }
        this._rddHandle = rdd;
        if (this._rddHandle != null) {
            rdd.setBackReference(this);
        }
    }

    public BroadcastObject<T> getBroadcastHandle() {
        return this._bcHandle;
    }

    public void setBroadcastHandle(BroadcastObject bc) {
        if (this._bcHandle != null) {
            this._bcHandle.setBackReference(null);
        }
        this._bcHandle = bc;
        if (this._bcHandle != null) {
            bc.setBackReference(this);
        }
    }

    public synchronized GPUObject getGPUObject(GPUContext gCtx) {
        return this._gpuObjects.get(gCtx);
    }

    public synchronized void setGPUObject(GPUContext gCtx, GPUObject gObj) throws DMLRuntimeException {
        GPUObject old = this._gpuObjects.put(gCtx, gObj);
        if (old != null) {
            throw new DMLRuntimeException("GPU : Inconsistent internal state - this CacheableData already has a GPUObject assigned to the current GPUContext (" + gCtx + ")");
        }
    }

    public synchronized T acquireRead() throws CacheException {
        long t0;
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("Acquire read " + this.getVarName()));
        }
        long l = t0 = DMLScript.STATISTICS ? System.nanoTime() : 0L;
        if (!this.isAvailableToRead()) {
            throw new CacheException("MatrixObject not available to read.");
        }
        if (this._data == null) {
            this.getCache();
        }
        boolean copiedFromGPU = false;
        for (Map.Entry<GPUContext, GPUObject> kv : this._gpuObjects.entrySet()) {
            GPUObject gObj = kv.getValue();
            if (gObj != null && copiedFromGPU && gObj.isDirty()) {
                LOG.error((Object)"Inconsistent internal state - A copy of this CacheableData was dirty on more than 1 GPU");
                throw new CacheException("Internal Error : Inconsistent internal state, A copy of this CacheableData was dirty on more than 1 GPU");
            }
            if (gObj == null) continue;
            copiedFromGPU = gObj.acquireHostRead();
            if (this._data != null) continue;
            this.getCache();
        }
        if (this.isEmpty(true) && this._data == null) {
            try {
                if (DMLScript.STATISTICS) {
                    CacheStatistics.incrementHDFSHits();
                }
                if (this.getRDDHandle() == null || this.getRDDHandle().allowsShortCircuitRead()) {
                    if (this._hdfsFileName == null) {
                        throw new CacheException("Cannot read matrix for empty filename.");
                    }
                    this._data = this.readBlobFromHDFS(this._hdfsFileName);
                    this._requiresLocalWrite = false;
                } else {
                    MutableBoolean writeStatus = new MutableBoolean();
                    this._data = this.readBlobFromRDD(this.getRDDHandle(), writeStatus);
                    this._requiresLocalWrite = !writeStatus.booleanValue();
                }
                this.setDirty(false);
            }
            catch (IOException e) {
                throw new CacheException("Reading of " + this._hdfsFileName + " (" + this.getVarName() + ") failed.", e);
            }
            this._isAcquireFromEmpty = true;
        } else if (DMLScript.STATISTICS && this._data != null) {
            CacheStatistics.incrementMemHits();
        }
        this.acquire(false, this._data == null);
        this.updateStatusPinned(true);
        if (DMLScript.STATISTICS) {
            long t1 = System.nanoTime();
            CacheStatistics.incrementAcquireRTime(t1 - t0);
        }
        return this._data;
    }

    public synchronized T acquireModify() throws CacheException {
        long t0;
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("Acquire modify " + this.getVarName()));
        }
        long l = t0 = DMLScript.STATISTICS ? System.nanoTime() : 0L;
        if (!this.isAvailableToModify()) {
            throw new CacheException("MatrixObject not available to modify.");
        }
        if (this._data == null) {
            this.getCache();
        }
        if (this.isEmpty(true) && this._data == null) {
            if (this._hdfsFileName == null) {
                throw new CacheException("Cannot read matrix for empty filename.");
            }
            try {
                this._data = this.readBlobFromHDFS(this._hdfsFileName);
            }
            catch (IOException e) {
                throw new CacheException("Reading of " + this._hdfsFileName + " (" + this.getVarName() + ") failed.", e);
            }
        }
        this.acquire(true, this._data == null);
        this.updateStatusPinned(true);
        this.setDirty(true);
        this._isAcquireFromEmpty = false;
        if (DMLScript.STATISTICS) {
            long t1 = System.nanoTime();
            CacheStatistics.incrementAcquireMTime(t1 - t0);
        }
        return this._data;
    }

    public T acquireModify(T newData) throws DMLRuntimeException {
        return this.acquireModify(newData, null);
    }

    public synchronized T acquireModify(T newData, String opcode) throws DMLRuntimeException {
        long t0;
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("Acquire modify newdata " + this.getVarName()));
        }
        long l = t0 = DMLScript.STATISTICS ? System.nanoTime() : 0L;
        if (!this.isAvailableToModify()) {
            throw new CacheException("CacheableData not available to modify.");
        }
        this.clearData();
        this.acquire(true, false);
        this.setDirty(true);
        this._isAcquireFromEmpty = false;
        if (newData == null) {
            throw new CacheException("acquireModify with empty cache block.");
        }
        this._data = newData;
        this.updateStatusPinned(true);
        if (DMLScript.STATISTICS) {
            long t1 = System.nanoTime();
            CacheStatistics.incrementAcquireMTime(t1 - t0);
            if (DMLScript.FINEGRAINED_STATISTICS && opcode != null && this._data instanceof MatrixBlock) {
                MatrixBlock currObject = (MatrixBlock)this._data;
                if (currObject.isInSparseFormat()) {
                    GPUStatistics.maintainCPMiscTimes(opcode, "aqms", t1 - t0);
                } else {
                    GPUStatistics.maintainCPMiscTimes(opcode, "aqmd", t1 - t0);
                }
            }
        }
        return this._data;
    }

    public void release() throws CacheException {
        this.release(null);
    }

    public synchronized void release(String opcode) throws CacheException {
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("Release " + this.getVarName()));
        }
        long t0 = DMLScript.STATISTICS ? System.nanoTime() : 0L;
        boolean write = false;
        if (this.isModify()) {
            write = true;
            this.setDirty(true);
            this.refreshMetaData();
        }
        this._data.compactEmptyBlock();
        this.release(this._isAcquireFromEmpty && !this._requiresLocalWrite);
        this.updateStatusPinned(false);
        if (CacheableData.isCachingActive() && this.isCached(true) && !this.isBelowCachingThreshold()) {
            if (write || this._requiresLocalWrite) {
                String filePath = this.getCacheFilePathAndName();
                try {
                    long t1 = DMLScript.STATISTICS && DMLScript.FINEGRAINED_STATISTICS ? System.nanoTime() : 0L;
                    int numEvicted = LazyWriteBuffer.writeBlock(filePath, this._data);
                    if (DMLScript.STATISTICS && DMLScript.FINEGRAINED_STATISTICS && opcode != null) {
                        long t2 = DMLScript.STATISTICS && DMLScript.FINEGRAINED_STATISTICS ? System.nanoTime() : 0L;
                        GPUStatistics.maintainCPMiscTimes(opcode, "rlswr", t2 - t1, numEvicted);
                    }
                }
                catch (Exception e) {
                    throw new CacheException("Eviction to local path " + filePath + " (" + this.getVarName() + ") failed.", e);
                }
                this._requiresLocalWrite = false;
            }
            this.createCache();
            this._data = null;
        } else if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("Var " + this.getVarName() + " not subject to caching, state=" + this.getStatusAsString()));
        }
        if (DMLScript.STATISTICS) {
            long t1 = System.nanoTime();
            CacheStatistics.incrementReleaseTime(t1 - t0);
        }
    }

    protected void clearReusableData() {
    }

    public synchronized void clearData() throws DMLRuntimeException {
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("Clear data " + this.getVarName()));
        }
        if (!this.isCleanupEnabled()) {
            return;
        }
        if (!this.isAvailableToModify()) {
            throw new CacheException("CacheableData (" + this.getDebugName() + ") not available to modify. Status = " + this.getStatusAsString() + ".");
        }
        if (!(this.isEmpty(true) || this._data != null && this.isBelowCachingThreshold() || this._data != null && !CacheableData.isCachingActive())) {
            this.freeEvictedBlob();
        }
        this.clearReusableData();
        this._data = null;
        this.clearCache();
        if (this._rddHandle != null) {
            this._rddHandle.setBackReference(null);
        }
        if (this._bcHandle != null) {
            this._bcHandle.setBackReference(null);
        }
        if (this._gpuObjects != null) {
            for (GPUObject gObj : this._gpuObjects.values()) {
                if (gObj == null) continue;
                gObj.clearData();
            }
        }
        this.setDirty(false);
        this.setEmpty();
    }

    public synchronized void exportData() throws CacheException {
        this.exportData(-1);
    }

    public synchronized void exportData(int replication) throws CacheException {
        this.exportData(this._hdfsFileName, null, replication, null);
        this._hdfsFileExists = true;
    }

    public synchronized void exportData(String fName, String outputFormat) throws CacheException {
        this.exportData(fName, outputFormat, -1, null);
    }

    public synchronized void exportData(String fName, String outputFormat, FileFormatProperties formatProperties) throws CacheException {
        this.exportData(fName, outputFormat, -1, formatProperties);
    }

    public synchronized void exportData(String fName, String outputFormat, int replication, FileFormatProperties formatProperties) throws CacheException {
        this.exportData(fName, outputFormat, replication, formatProperties, null);
    }

    /*
     * Unable to fully structure code
     */
    public synchronized void exportData(String fName, String outputFormat, int replication, FileFormatProperties formatProperties, String opcode) throws CacheException {
        if (CacheableData.LOG.isTraceEnabled()) {
            CacheableData.LOG.trace((Object)("Export data " + this.getVarName() + " " + fName));
        }
        v0 = t0 = DMLScript.STATISTICS != false ? System.nanoTime() : 0L;
        if (!this.isAvailableToRead()) {
            throw new CacheException("MatrixObject not available to read.");
        }
        CacheableData.LOG.trace((Object)("Exporting " + this.getDebugName() + " to " + fName + " in format " + outputFormat));
        copiedFromGPU = false;
        for (Map.Entry<GPUContext, GPUObject> kv : this._gpuObjects.entrySet()) {
            gObj = kv.getValue();
            if (gObj != null && copiedFromGPU && gObj.isDirty()) {
                CacheableData.LOG.error((Object)"Inconsistent internal state - A copy of this CacheableData was dirty on more than 1 GPU");
                throw new CacheException("Internal Error : Inconsistent internal state, A copy of this CacheableData was dirty on more than 1 GPU");
            }
            if (gObj == null) continue;
            copiedFromGPU = gObj.acquireHostRead();
            if (this._data != null) continue;
            this.getCache();
        }
        v1 = pWrite = fName.equals(this._hdfsFileName) == false;
        if (!pWrite) {
            this.setHDFSFileExists(true);
        }
        eqScheme = IOUtilFunctions.isSameFileScheme(new Path(this._hdfsFileName), new Path(fName));
        if (this.isDirty() || !eqScheme || pWrite && !this.isEqualOutputFormat(outputFormat)) {
            if (this.isEmpty(true)) {
                try {
                    this._data = this.getRDDHandle() == null || this.getRDDHandle().allowsShortCircuitRead() != false ? this.readBlobFromHDFS(this._hdfsFileName) : this.readBlobFromRDD(this.getRDDHandle(), new MutableBoolean());
                    this.setDirty(false);
                }
                catch (IOException e) {
                    throw new CacheException("Reading of " + this._hdfsFileName + " (" + this.getVarName() + ") failed.", e);
                }
            }
            if (this._data == null) {
                this.getCache();
            }
            this.acquire(false, this._data == null);
            try {
                this.writeMetaData(fName, outputFormat, formatProperties);
                this.writeBlobToHDFS(fName, outputFormat, replication, formatProperties);
                if (pWrite) ** GOTO lbl65
                this.setDirty(false);
            }
            catch (Exception e) {
                throw new CacheException("Export to " + fName + " failed.", e);
            }
            finally {
                this.release(opcode);
            }
        } else if (pWrite) {
            try {
                MapReduceTool.deleteFileIfExistOnHDFS(fName);
                MapReduceTool.deleteFileIfExistOnHDFS(fName + ".mtd");
                if (this.getRDDHandle() == null || this.getRDDHandle().allowsShortCircuitRead()) {
                    MapReduceTool.copyFileOnHDFS(this._hdfsFileName, fName);
                } else {
                    this.writeBlobFromRDDtoHDFS(this.getRDDHandle(), fName, outputFormat);
                }
                this.writeMetaData(fName, outputFormat, formatProperties);
            }
            catch (Exception e) {
                throw new CacheException("Export to " + fName + " failed.", e);
            }
        } else if (this.getRDDHandle() != null && this.getRDDHandle().isPending() && !this.getRDDHandle().isHDFSFile() && !this.getRDDHandle().allowsShortCircuitRead()) {
            try {
                this.writeBlobFromRDDtoHDFS(this.getRDDHandle(), fName, outputFormat);
                this.writeMetaData(fName, outputFormat, formatProperties);
                this.getRDDHandle().setPending(false);
            }
            catch (Exception e) {
                throw new CacheException("Export to " + fName + " failed.", e);
            }
        } else {
            CacheableData.LOG.trace((Object)(this.getDebugName() + ": Skip export to hdfs since data already exists."));
        }
lbl65:
        // 5 sources

        if (DMLScript.STATISTICS) {
            t1 = System.nanoTime();
            CacheStatistics.incrementExportTime(t1 - t0);
        }
    }

    protected boolean isBlobPresent() {
        return this._data != null;
    }

    protected void restoreBlobIntoMemory() throws CacheException {
        long begin;
        String cacheFilePathAndName = this.getCacheFilePathAndName();
        long l = begin = LOG.isTraceEnabled() ? System.currentTimeMillis() : 0L;
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("CACHE: Restoring matrix...  " + this.getVarName() + "  HDFS path: " + (this._hdfsFileName == null ? "null" : this._hdfsFileName) + ", Restore from path: " + cacheFilePathAndName));
        }
        if (this._data != null) {
            throw new CacheException(cacheFilePathAndName + " : Cannot restore on top of existing in-memory data.");
        }
        try {
            this._data = this.readBlobFromCache(cacheFilePathAndName);
        }
        catch (IOException e) {
            throw new CacheException(cacheFilePathAndName + " : Restore failed.", e);
        }
        if (this._data == null) {
            throw new CacheException(cacheFilePathAndName + " : Restore failed.");
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("Restoring matrix - COMPLETED ... " + (System.currentTimeMillis() - begin) + " msec."));
        }
    }

    protected abstract T readBlobFromCache(String var1) throws IOException;

    protected void freeEvictedBlob() {
        long begin;
        String cacheFilePathAndName = this.getCacheFilePathAndName();
        long l = begin = LOG.isTraceEnabled() ? System.currentTimeMillis() : 0L;
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("CACHE: Freeing evicted matrix...  " + this.getVarName() + "  HDFS path: " + (this._hdfsFileName == null ? "null" : this._hdfsFileName) + " Eviction path: " + cacheFilePathAndName));
        }
        LazyWriteBuffer.deleteBlock(cacheFilePathAndName);
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("Freeing evicted matrix - COMPLETED ... " + (System.currentTimeMillis() - begin) + " msec."));
        }
    }

    protected boolean isBelowCachingThreshold() {
        return this._data.getInMemorySize() <= 4096L;
    }

    protected Expression.ValueType[] getSchema() {
        return null;
    }

    @Override
    public synchronized String getDebugName() {
        int maxLength = 23;
        String debugNameEnding = this._hdfsFileName == null ? "null" : (this._hdfsFileName.length() < maxLength ? this._hdfsFileName : "..." + this._hdfsFileName.substring(this._hdfsFileName.length() - maxLength + 3));
        return this.getVarName() + " " + debugNameEnding;
    }

    protected T readBlobFromHDFS(String fname) throws IOException {
        MatrixFormatMetaData iimd = (MatrixFormatMetaData)this._metaData;
        MatrixCharacteristics mc = iimd.getMatrixCharacteristics();
        return this.readBlobFromHDFS(fname, mc.getRows(), mc.getCols());
    }

    protected abstract T readBlobFromHDFS(String var1, long var2, long var4) throws IOException;

    protected abstract T readBlobFromRDD(RDDObject var1, MutableBoolean var2) throws IOException;

    protected abstract void writeBlobToHDFS(String var1, String var2, int var3, FileFormatProperties var4) throws IOException, DMLRuntimeException;

    protected abstract void writeBlobFromRDDtoHDFS(RDDObject var1, String var2, String var3) throws IOException, DMLRuntimeException;

    protected void writeMetaData(String filePathAndName, String outputFormat, FileFormatProperties formatProperties) throws DMLRuntimeException, IOException {
        OutputInfo oinfo;
        MatrixFormatMetaData iimd = (MatrixFormatMetaData)this._metaData;
        if (iimd == null) {
            throw new DMLRuntimeException("Unexpected error while writing mtd file (" + filePathAndName + ") -- metadata is null.");
        }
        OutputInfo outputInfo = oinfo = outputFormat != null ? OutputInfo.stringToOutputInfo(outputFormat) : InputInfo.getMatchingOutputInfo(iimd.getInputInfo());
        if (oinfo != OutputInfo.MatrixMarketOutputInfo) {
            MatrixCharacteristics mc = iimd.getMatrixCharacteristics();
            if (oinfo == OutputInfo.BinaryBlockOutputInfo && DMLScript.rtplatform == DMLScript.RUNTIME_PLATFORM.SINGLE_NODE && (mc.getRowsPerBlock() != ConfigurationManager.getBlocksize() || mc.getColsPerBlock() != ConfigurationManager.getBlocksize())) {
                mc = new MatrixCharacteristics(mc.getRows(), mc.getCols(), ConfigurationManager.getBlocksize(), ConfigurationManager.getBlocksize(), mc.getNonZeros());
            }
            MapReduceTool.writeMetaDataFile(filePathAndName + ".mtd", this.valueType, this.getSchema(), this.dataType, mc, oinfo, formatProperties);
        }
    }

    protected boolean isEqualOutputFormat(String outputFormat) {
        boolean ret = true;
        if (outputFormat != null) {
            try {
                MatrixFormatMetaData iimd = (MatrixFormatMetaData)this._metaData;
                OutputInfo oi1 = InputInfo.getMatchingOutputInfo(iimd.getInputInfo());
                OutputInfo oi2 = OutputInfo.stringToOutputInfo(outputFormat);
                if (oi1 != oi2) {
                    ret = false;
                }
            }
            catch (Exception ex) {
                ret = false;
            }
        }
        return ret;
    }

    protected int getUniqueCacheID() {
        return this._uniqueID;
    }

    protected String getCacheFilePathAndName() {
        if (this._cacheFileName == null) {
            StringBuilder sb = new StringBuilder();
            sb.append(cacheEvictionLocalFilePath);
            sb.append(cacheEvictionLocalFilePrefix);
            sb.append(String.format("%09d", this.getUniqueCacheID()));
            sb.append(CACHING_EVICTION_FILEEXTENSION);
            this._cacheFileName = sb.toString();
        }
        return this._cacheFileName;
    }

    protected void acquire(boolean isModify, boolean restore) throws CacheException {
        switch (this._cacheStatus) {
            case CACHED: {
                if (restore) {
                    this.restoreBlobIntoMemory();
                }
            }
            case CACHED_NOWRITE: 
            case EMPTY: {
                if (isModify) {
                    this.setModify();
                    break;
                }
                this.addOneRead();
                break;
            }
            case READ: {
                if (isModify) {
                    throw new CacheException("READ-MODIFY not allowed.");
                }
                this.addOneRead();
                break;
            }
            case MODIFY: {
                throw new CacheException("MODIFY-MODIFY not allowed.");
            }
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("Acquired lock on " + this.getDebugName() + ", status: " + this.getStatusAsString()));
        }
    }

    protected void release(boolean cacheNoWrite) throws CacheException {
        switch (this._cacheStatus) {
            case CACHED: 
            case CACHED_NOWRITE: 
            case EMPTY: {
                throw new CacheException("Redundant release.");
            }
            case READ: {
                this.removeOneRead(this.isBlobPresent(), cacheNoWrite);
                break;
            }
            case MODIFY: {
                if (this.isBlobPresent()) {
                    this.setCached();
                    break;
                }
                this.setEmpty();
            }
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("Released lock on " + this.getDebugName() + ", status: " + this.getStatusAsString()));
        }
    }

    public String getStatusAsString() {
        return this._cacheStatus.toString();
    }

    public boolean isCached(boolean inclCachedNoWrite) {
        if (inclCachedNoWrite) {
            return this._cacheStatus == CacheStatus.CACHED || this._cacheStatus == CacheStatus.CACHED_NOWRITE;
        }
        return this._cacheStatus == CacheStatus.CACHED;
    }

    public void setEmptyStatus() {
        this.setEmpty();
    }

    protected boolean isEmpty(boolean inclCachedNoWrite) {
        if (inclCachedNoWrite) {
            return this._cacheStatus == CacheStatus.EMPTY || this._cacheStatus == CacheStatus.CACHED_NOWRITE;
        }
        return this._cacheStatus == CacheStatus.EMPTY;
    }

    protected boolean isModify() {
        return this._cacheStatus == CacheStatus.MODIFY;
    }

    protected void setEmpty() {
        this._cacheStatus = CacheStatus.EMPTY;
    }

    protected void setModify() {
        this._cacheStatus = CacheStatus.MODIFY;
    }

    protected void setCached() {
        this._cacheStatus = CacheStatus.CACHED;
    }

    protected void addOneRead() {
        ++this._numReadThreads;
        this._cacheStatus = CacheStatus.READ;
    }

    protected void removeOneRead(boolean doesBlobExist, boolean cacheNoWrite) {
        --this._numReadThreads;
        if (this._numReadThreads == 0) {
            this._cacheStatus = cacheNoWrite ? (doesBlobExist ? CacheStatus.CACHED_NOWRITE : CacheStatus.EMPTY) : (doesBlobExist ? CacheStatus.CACHED : CacheStatus.EMPTY);
        }
    }

    protected boolean isAvailableToRead() {
        return this._cacheStatus == CacheStatus.EMPTY || this._cacheStatus == CacheStatus.CACHED || this._cacheStatus == CacheStatus.CACHED_NOWRITE || this._cacheStatus == CacheStatus.READ;
    }

    protected boolean isAvailableToModify() {
        return this._cacheStatus == CacheStatus.EMPTY || this._cacheStatus == CacheStatus.CACHED || this._cacheStatus == CacheStatus.CACHED_NOWRITE;
    }

    protected void createCache() {
        this._cache = new SoftReference<T>(this._data);
    }

    protected void getCache() {
        if (this._cache != null) {
            this._data = (CacheBlock)this._cache.get();
            this.clearCache();
        }
    }

    protected void clearCache() {
        if (this._cache != null) {
            this._cache.clear();
            this._cache = null;
        }
    }

    protected void updateStatusPinned(boolean add) {
        if (this._data == null || !OptimizerUtils.isHybridExecutionMode()) {
            return;
        }
        long size = sizePinned.get();
        sizePinned.set(Math.max(size += (long)(add ? 1 : -1) * this._data.getInMemorySize(), 0L));
    }

    protected long getPinnedSize() {
        return sizePinned.get();
    }

    public static void addBroadcastSize(long size) {
        _refBCs.addAndGet(size);
    }

    public static long getBroadcastSize() {
        return _refBCs.longValue();
    }

    public static synchronized void cleanupCacheDir() {
        LazyWriteBuffer.cleanup();
        CacheableData.cleanupCacheDir(true);
    }

    public static synchronized void cleanupCacheDir(boolean withDir) {
        File fdir;
        String dir = cacheEvictionLocalFilePath;
        if (dir != null && (fdir = new File(dir)).exists()) {
            File[] files;
            for (File f : files = fdir.listFiles()) {
                if (!f.getName().startsWith(cacheEvictionLocalFilePrefix)) continue;
                f.delete();
            }
            if (withDir) {
                fdir.delete();
            }
        }
        _activeFlag = false;
    }

    public static synchronized void initCaching() throws IOException {
        CacheableData.initCaching(DMLScript.getUUID());
    }

    public static synchronized void initCaching(String uuid) throws IOException {
        try {
            String dir = LocalFileUtils.getWorkingDir("cache");
            LocalFileUtils.createLocalFileIfNotExist(dir);
            cacheEvictionLocalFilePath = dir;
        }
        catch (DMLRuntimeException e) {
            throw new IOException(e);
        }
        LazyWriteBuffer.init();
        _refBCs.set(0L);
        _activeFlag = true;
    }

    public static synchronized boolean isCachingActive() {
        return _activeFlag;
    }

    public static synchronized void disableCaching() {
        _activeFlag = false;
    }

    public static synchronized void enableCaching() {
        _activeFlag = true;
    }

    public synchronized boolean moveData(String fName, String outputFormat) throws CacheException {
        boolean ret = false;
        try {
            boolean eqScheme = IOUtilFunctions.isSameFileScheme(new Path(this._hdfsFileName), new Path(fName));
            if (this.isDirty() || !eqScheme || !this.isEqualOutputFormat(outputFormat) && this.isEmpty(true) || this.getRDDHandle() != null && !MapReduceTool.existsFileOnHDFS(this._hdfsFileName)) {
                this.exportData(fName, outputFormat);
                ret = true;
            } else if (this.isEqualOutputFormat(outputFormat)) {
                MapReduceTool.deleteFileIfExistOnHDFS(fName);
                MapReduceTool.deleteFileIfExistOnHDFS(fName + ".mtd");
                MapReduceTool.renameFileOnHDFS(this._hdfsFileName, fName);
                this.writeMetaData(fName, outputFormat, null);
                ret = true;
            }
        }
        catch (Exception e) {
            throw new CacheException("Move to " + fName + " failed.", e);
        }
        return ret;
    }

    public String toString() {
        StringBuilder str = new StringBuilder();
        str.append(this.getClass().getSimpleName());
        str.append(": ");
        str.append(this._hdfsFileName + ", ");
        if (this._metaData instanceof NumItemsByEachReducerMetaData) {
            str.append("NumItemsByEachReducerMetaData");
        } else {
            try {
                MatrixFormatMetaData md = (MatrixFormatMetaData)this._metaData;
                if (md != null) {
                    MatrixCharacteristics mc = ((MatrixDimensionsMetaData)this._metaData).getMatrixCharacteristics();
                    str.append(mc.toString());
                    InputInfo ii = md.getInputInfo();
                    if (ii == null) {
                        str.append("null");
                    } else {
                        str.append(", ");
                        str.append(InputInfo.inputInfoToString(ii));
                    }
                } else {
                    str.append("null, null");
                }
            }
            catch (Exception ex) {
                LOG.error((Object)ex);
            }
        }
        str.append(", ");
        str.append(this.isDirty() ? "dirty" : "not-dirty");
        return str.toString();
    }

    static {
        _seq = new IDSequence();
    }

    protected static enum CacheStatus {
        EMPTY,
        READ,
        MODIFY,
        CACHED,
        CACHED_NOWRITE;

    }
}

