/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.compress.cocode;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang.ArrayUtils;
import org.apache.sysml.runtime.compress.cocode.ColumnGroupPartitioner;
import org.apache.sysml.runtime.compress.cocode.PlanningCoCoder;
import org.apache.sysml.runtime.util.SortUtils;

public class ColumnGroupPartitionerBinPacking
extends ColumnGroupPartitioner {
    private static final boolean FIRST_FIT_DEC = true;
    private static final int MAX_COL_PER_GROUP = Integer.MAX_VALUE;
    public static double BIN_CAPACITY = 3.2E-5;

    @Override
    public List<List<Integer>> partitionColumns(List<Integer> groupCols, HashMap<Integer, PlanningCoCoder.GroupableColInfo> groupColsInfo) {
        int[] items = new int[groupCols.size()];
        double[] itemWeights = new double[groupCols.size()];
        for (int i = 0; i < groupCols.size(); ++i) {
            int col;
            items[i] = col = groupCols.get(i).intValue();
            itemWeights[i] = groupColsInfo.get((Object)Integer.valueOf((int)col)).cardRatio;
        }
        SortUtils.sortByValue(0, items.length, itemWeights, items);
        ArrayUtils.reverse((int[])items);
        ArrayUtils.reverse((double[])itemWeights);
        return this.packFirstFit(items, itemWeights);
    }

    private List<List<Integer>> packFirstFit(int[] items, double[] itemWeights) {
        ArrayList<List<Integer>> bins = new ArrayList<List<Integer>>();
        ArrayList<Double> binWeights = new ArrayList<Double>();
        for (int i = 0; i < items.length; ++i) {
            boolean assigned = false;
            for (int j = 0; j < bins.size(); ++j) {
                double newBinWeight = (Double)binWeights.get(j) - itemWeights[i];
                if (!(newBinWeight >= 0.0) || ((List)bins.get(j)).size() >= 0x7FFFFFFE) continue;
                ((List)bins.get(j)).add(items[i]);
                binWeights.set(j, newBinWeight);
                assigned = true;
                break;
            }
            if (assigned) continue;
            bins.add(new ArrayList<Integer>(Arrays.asList(items[i])));
            binWeights.add(BIN_CAPACITY - itemWeights[i]);
        }
        return bins;
    }
}

