/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.parser.dml;

import java.util.HashSet;
import java.util.Set;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.tree.ErrorNode;
import org.antlr.v4.runtime.tree.TerminalNode;
import org.apache.sysml.parser.common.CustomErrorListener;
import org.apache.sysml.parser.dml.DmlListener;
import org.apache.sysml.parser.dml.DmlParser;

public class DmlPreprocessor
implements DmlListener {
    protected final CustomErrorListener errorListener;
    protected Set<String> functions;

    public DmlPreprocessor(CustomErrorListener errorListener) {
        this.errorListener = errorListener;
        this.functions = new HashSet<String>();
    }

    public Set<String> getFunctionDefs() {
        return this.functions;
    }

    @Override
    public void enterExternalFunctionDefExpression(DmlParser.ExternalFunctionDefExpressionContext ctx) {
        this.validateFunctionName(ctx.name.getText(), ctx);
    }

    @Override
    public void exitExternalFunctionDefExpression(DmlParser.ExternalFunctionDefExpressionContext ctx) {
    }

    @Override
    public void enterInternalFunctionDefExpression(DmlParser.InternalFunctionDefExpressionContext ctx) {
        this.validateFunctionName(ctx.name.getText(), ctx);
    }

    @Override
    public void exitInternalFunctionDefExpression(DmlParser.InternalFunctionDefExpressionContext ctx) {
    }

    protected void validateFunctionName(String name, ParserRuleContext ctx) {
        if (!this.functions.contains(name)) {
            this.functions.add(name);
        } else {
            this.notifyErrorListeners("Function Name Conflict: '" + name + "' already defined in " + this.errorListener.getCurrentFileName(), ctx.start);
        }
    }

    protected void notifyErrorListeners(String message, Token op) {
        this.errorListener.validationError(op.getLine(), op.getCharPositionInLine(), message);
    }

    @Override
    public void visitTerminal(TerminalNode node) {
    }

    @Override
    public void visitErrorNode(ErrorNode node) {
    }

    @Override
    public void enterEveryRule(ParserRuleContext ctx) {
    }

    @Override
    public void exitEveryRule(ParserRuleContext ctx) {
    }

    @Override
    public void enterFunctionCallMultiAssignmentStatement(DmlParser.FunctionCallMultiAssignmentStatementContext ctx) {
    }

    @Override
    public void exitFunctionCallMultiAssignmentStatement(DmlParser.FunctionCallMultiAssignmentStatementContext ctx) {
    }

    @Override
    public void enterMatrixDataTypeCheck(DmlParser.MatrixDataTypeCheckContext ctx) {
    }

    @Override
    public void exitMatrixDataTypeCheck(DmlParser.MatrixDataTypeCheckContext ctx) {
    }

    @Override
    public void enterStrictParameterizedKeyValueString(DmlParser.StrictParameterizedKeyValueStringContext ctx) {
    }

    @Override
    public void exitStrictParameterizedKeyValueString(DmlParser.StrictParameterizedKeyValueStringContext ctx) {
    }

    @Override
    public void enterPathStatement(DmlParser.PathStatementContext ctx) {
    }

    @Override
    public void exitPathStatement(DmlParser.PathStatementContext ctx) {
    }

    @Override
    public void enterConstTrueExpression(DmlParser.ConstTrueExpressionContext ctx) {
    }

    @Override
    public void exitConstTrueExpression(DmlParser.ConstTrueExpressionContext ctx) {
    }

    @Override
    public void enterTypedArgNoAssign(DmlParser.TypedArgNoAssignContext ctx) {
    }

    @Override
    public void exitTypedArgNoAssign(DmlParser.TypedArgNoAssignContext ctx) {
    }

    @Override
    public void enterWhileStatement(DmlParser.WhileStatementContext ctx) {
    }

    @Override
    public void exitWhileStatement(DmlParser.WhileStatementContext ctx) {
    }

    @Override
    public void enterConstStringIdExpression(DmlParser.ConstStringIdExpressionContext ctx) {
    }

    @Override
    public void exitConstStringIdExpression(DmlParser.ConstStringIdExpressionContext ctx) {
    }

    @Override
    public void enterDataIdExpression(DmlParser.DataIdExpressionContext ctx) {
    }

    @Override
    public void exitDataIdExpression(DmlParser.DataIdExpressionContext ctx) {
    }

    @Override
    public void enterAtomicExpression(DmlParser.AtomicExpressionContext ctx) {
    }

    @Override
    public void exitAtomicExpression(DmlParser.AtomicExpressionContext ctx) {
    }

    @Override
    public void enterPowerExpression(DmlParser.PowerExpressionContext ctx) {
    }

    @Override
    public void exitPowerExpression(DmlParser.PowerExpressionContext ctx) {
    }

    @Override
    public void enterFunctionCallAssignmentStatement(DmlParser.FunctionCallAssignmentStatementContext ctx) {
    }

    @Override
    public void exitFunctionCallAssignmentStatement(DmlParser.FunctionCallAssignmentStatementContext ctx) {
    }

    @Override
    public void enterMatrixMulExpression(DmlParser.MatrixMulExpressionContext ctx) {
    }

    @Override
    public void exitMatrixMulExpression(DmlParser.MatrixMulExpressionContext ctx) {
    }

    @Override
    public void enterModIntDivExpression(DmlParser.ModIntDivExpressionContext ctx) {
    }

    @Override
    public void exitModIntDivExpression(DmlParser.ModIntDivExpressionContext ctx) {
    }

    @Override
    public void enterSimpleDataIdentifierExpression(DmlParser.SimpleDataIdentifierExpressionContext ctx) {
    }

    @Override
    public void exitSimpleDataIdentifierExpression(DmlParser.SimpleDataIdentifierExpressionContext ctx) {
    }

    @Override
    public void enterBuiltinFunctionExpression(DmlParser.BuiltinFunctionExpressionContext ctx) {
    }

    @Override
    public void exitBuiltinFunctionExpression(DmlParser.BuiltinFunctionExpressionContext ctx) {
    }

    @Override
    public void enterConstIntIdExpression(DmlParser.ConstIntIdExpressionContext ctx) {
    }

    @Override
    public void exitConstIntIdExpression(DmlParser.ConstIntIdExpressionContext ctx) {
    }

    @Override
    public void enterForStatement(DmlParser.ForStatementContext ctx) {
    }

    @Override
    public void exitForStatement(DmlParser.ForStatementContext ctx) {
    }

    @Override
    public void enterValueType(DmlParser.ValueTypeContext ctx) {
    }

    @Override
    public void exitValueType(DmlParser.ValueTypeContext ctx) {
    }

    @Override
    public void enterParameterizedExpression(DmlParser.ParameterizedExpressionContext ctx) {
    }

    @Override
    public void exitParameterizedExpression(DmlParser.ParameterizedExpressionContext ctx) {
    }

    @Override
    public void enterConstFalseExpression(DmlParser.ConstFalseExpressionContext ctx) {
    }

    @Override
    public void exitConstFalseExpression(DmlParser.ConstFalseExpressionContext ctx) {
    }

    @Override
    public void enterBooleanOrExpression(DmlParser.BooleanOrExpressionContext ctx) {
    }

    @Override
    public void exitBooleanOrExpression(DmlParser.BooleanOrExpressionContext ctx) {
    }

    @Override
    public void enterAssignmentStatement(DmlParser.AssignmentStatementContext ctx) {
    }

    @Override
    public void exitAssignmentStatement(DmlParser.AssignmentStatementContext ctx) {
    }

    @Override
    public void enterIterablePredicateColonExpression(DmlParser.IterablePredicateColonExpressionContext ctx) {
    }

    @Override
    public void exitIterablePredicateColonExpression(DmlParser.IterablePredicateColonExpressionContext ctx) {
    }

    @Override
    public void enterParForStatement(DmlParser.ParForStatementContext ctx) {
    }

    @Override
    public void exitParForStatement(DmlParser.ParForStatementContext ctx) {
    }

    @Override
    public void enterStrictParameterizedExpression(DmlParser.StrictParameterizedExpressionContext ctx) {
    }

    @Override
    public void exitStrictParameterizedExpression(DmlParser.StrictParameterizedExpressionContext ctx) {
    }

    @Override
    public void enterCommandlineParamExpression(DmlParser.CommandlineParamExpressionContext ctx) {
    }

    @Override
    public void exitCommandlineParamExpression(DmlParser.CommandlineParamExpressionContext ctx) {
    }

    @Override
    public void enterMultDivExpression(DmlParser.MultDivExpressionContext ctx) {
    }

    @Override
    public void exitMultDivExpression(DmlParser.MultDivExpressionContext ctx) {
    }

    @Override
    public void enterAddSubExpression(DmlParser.AddSubExpressionContext ctx) {
    }

    @Override
    public void exitAddSubExpression(DmlParser.AddSubExpressionContext ctx) {
    }

    @Override
    public void enterImportStatement(DmlParser.ImportStatementContext ctx) {
    }

    @Override
    public void exitImportStatement(DmlParser.ImportStatementContext ctx) {
    }

    @Override
    public void enterProgramroot(DmlParser.ProgramrootContext ctx) {
    }

    @Override
    public void exitProgramroot(DmlParser.ProgramrootContext ctx) {
    }

    @Override
    public void enterIterablePredicateSeqExpression(DmlParser.IterablePredicateSeqExpressionContext ctx) {
    }

    @Override
    public void exitIterablePredicateSeqExpression(DmlParser.IterablePredicateSeqExpressionContext ctx) {
    }

    @Override
    public void enterIfdefAssignmentStatement(DmlParser.IfdefAssignmentStatementContext ctx) {
    }

    @Override
    public void exitIfdefAssignmentStatement(DmlParser.IfdefAssignmentStatementContext ctx) {
    }

    @Override
    public void enterBooleanAndExpression(DmlParser.BooleanAndExpressionContext ctx) {
    }

    @Override
    public void exitBooleanAndExpression(DmlParser.BooleanAndExpressionContext ctx) {
    }

    @Override
    public void enterIndexedExpression(DmlParser.IndexedExpressionContext ctx) {
    }

    @Override
    public void exitIndexedExpression(DmlParser.IndexedExpressionContext ctx) {
    }

    @Override
    public void enterBooleanNotExpression(DmlParser.BooleanNotExpressionContext ctx) {
    }

    @Override
    public void exitBooleanNotExpression(DmlParser.BooleanNotExpressionContext ctx) {
    }

    @Override
    public void enterIfStatement(DmlParser.IfStatementContext ctx) {
    }

    @Override
    public void exitIfStatement(DmlParser.IfStatementContext ctx) {
    }

    @Override
    public void enterRelationalExpression(DmlParser.RelationalExpressionContext ctx) {
    }

    @Override
    public void exitRelationalExpression(DmlParser.RelationalExpressionContext ctx) {
    }

    @Override
    public void enterCommandlinePositionExpression(DmlParser.CommandlinePositionExpressionContext ctx) {
    }

    @Override
    public void exitCommandlinePositionExpression(DmlParser.CommandlinePositionExpressionContext ctx) {
    }

    @Override
    public void enterConstDoubleIdExpression(DmlParser.ConstDoubleIdExpressionContext ctx) {
    }

    @Override
    public void exitConstDoubleIdExpression(DmlParser.ConstDoubleIdExpressionContext ctx) {
    }

    @Override
    public void enterUnaryExpression(DmlParser.UnaryExpressionContext ctx) {
    }

    @Override
    public void exitUnaryExpression(DmlParser.UnaryExpressionContext ctx) {
    }

    @Override
    public void enterMl_type(DmlParser.Ml_typeContext ctx) {
    }

    @Override
    public void exitMl_type(DmlParser.Ml_typeContext ctx) {
    }

    @Override
    public void enterMultiIdExpression(DmlParser.MultiIdExpressionContext ctx) {
    }

    @Override
    public void exitMultiIdExpression(DmlParser.MultiIdExpressionContext ctx) {
    }
}

