/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.lops;

import org.apache.sysml.hops.AggBinaryOp;
import org.apache.sysml.lops.Lop;
import org.apache.sysml.lops.LopProperties;
import org.apache.sysml.lops.LopsException;
import org.apache.sysml.lops.compile.JobType;
import org.apache.sysml.parser.Expression;

public class MapMult
extends Lop {
    public static final String OPCODE = "mapmm";
    private CacheType _cacheType = null;
    private boolean _outputEmptyBlocks = true;
    private AggBinaryOp.SparkAggType _aggtype = AggBinaryOp.SparkAggType.MULTI_BLOCK;

    public MapMult(Lop input1, Lop input2, Expression.DataType dt, Expression.ValueType vt, boolean rightCache, boolean partitioned, boolean emptyBlocks) throws LopsException {
        super(Lop.Type.MapMult, dt, vt);
        this.addInput(input1);
        this.addInput(input2);
        input1.addOutput(this);
        input2.addOutput(this);
        this._cacheType = rightCache ? (partitioned ? CacheType.RIGHT_PART : CacheType.RIGHT) : (partitioned ? CacheType.LEFT_PART : CacheType.LEFT);
        this._outputEmptyBlocks = emptyBlocks;
        boolean breaksAlignment = true;
        boolean aligner = false;
        boolean definesMRJob = false;
        this.lps.addCompatibility(JobType.GMR);
        this.lps.addCompatibility(JobType.DATAGEN);
        this.lps.setProperties(this.inputs, LopProperties.ExecType.MR, LopProperties.ExecLocation.Map, breaksAlignment, aligner, definesMRJob);
    }

    public MapMult(Lop input1, Lop input2, Expression.DataType dt, Expression.ValueType vt, boolean rightCache, boolean partitioned, boolean emptyBlocks, AggBinaryOp.SparkAggType aggtype) throws LopsException {
        super(Lop.Type.MapMult, dt, vt);
        this.addInput(input1);
        this.addInput(input2);
        input1.addOutput(this);
        input2.addOutput(this);
        this._cacheType = rightCache ? (partitioned ? CacheType.RIGHT_PART : CacheType.RIGHT) : (partitioned ? CacheType.LEFT_PART : CacheType.LEFT);
        this._outputEmptyBlocks = emptyBlocks;
        this._aggtype = aggtype;
        boolean breaksAlignment = false;
        boolean aligner = false;
        boolean definesMRJob = false;
        this.lps.addCompatibility(JobType.INVALID);
        this.lps.setProperties(this.inputs, LopProperties.ExecType.SPARK, LopProperties.ExecLocation.ControlProgram, breaksAlignment, aligner, definesMRJob);
    }

    @Override
    public String toString() {
        return "Operation = MapMM";
    }

    @Override
    public String getInstructions(int input_index1, int input_index2, int output_index) {
        return this.getInstructions(String.valueOf(input_index1), String.valueOf(input_index2), String.valueOf(output_index));
    }

    @Override
    public String getInstructions(String input1, String input2, String output) {
        StringBuilder sb = new StringBuilder();
        sb.append((Object)this.getExecType());
        sb.append("\u00b0");
        sb.append(OPCODE);
        sb.append("\u00b0");
        sb.append(this.getInputs().get(0).prepInputOperand(input1));
        sb.append("\u00b0");
        sb.append(this.getInputs().get(1).prepInputOperand(input2));
        sb.append("\u00b0");
        sb.append(this.prepOutputOperand(output));
        sb.append("\u00b0");
        sb.append((Object)this._cacheType);
        sb.append("\u00b0");
        sb.append(this._outputEmptyBlocks);
        if (this.getExecType() == LopProperties.ExecType.SPARK) {
            sb.append("\u00b0");
            sb.append(this._aggtype.toString());
        }
        return sb.toString();
    }

    @Override
    public boolean usesDistributedCache() {
        return true;
    }

    @Override
    public int[] distributedCacheInputIndex() {
        int[] nArray;
        if (this._cacheType.isRight()) {
            int[] nArray2 = new int[1];
            nArray = nArray2;
            nArray2[0] = 2;
        } else {
            int[] nArray3 = new int[1];
            nArray = nArray3;
            nArray3[0] = 1;
        }
        return nArray;
    }

    public static enum CacheType {
        RIGHT,
        RIGHT_PART,
        LEFT,
        LEFT_PART;


        public boolean isRight() {
            return this == RIGHT || this == RIGHT_PART;
        }

        public CacheType getFlipped() {
            switch (this) {
                case RIGHT: {
                    return LEFT;
                }
                case RIGHT_PART: {
                    return LEFT_PART;
                }
                case LEFT: {
                    return RIGHT;
                }
                case LEFT_PART: {
                    return RIGHT_PART;
                }
            }
            return null;
        }
    }
}

