/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.io;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.JobConf;
import org.apache.sysml.hops.OptimizerUtils;
import org.apache.sysml.runtime.controlprogram.parfor.stat.InfrastructureAnalyzer;
import org.apache.sysml.runtime.io.IOUtilFunctions;
import org.apache.sysml.runtime.io.WriterTextCSV;
import org.apache.sysml.runtime.matrix.data.CSVFileFormatProperties;
import org.apache.sysml.runtime.matrix.data.MatrixBlock;
import org.apache.sysml.runtime.matrix.data.OutputInfo;
import org.apache.sysml.runtime.util.MapReduceTool;

public class WriterTextCSVParallel
extends WriterTextCSV {
    public WriterTextCSVParallel(CSVFileFormatProperties props) {
        super(props);
    }

    @Override
    protected void writeCSVMatrixToHDFS(Path path, JobConf job, FileSystem fs, MatrixBlock src, CSVFileFormatProperties csvprops) throws IOException {
        int numPartFiles = (int)(OptimizerUtils.estimateSizeTextOutput(src.getNumRows(), src.getNumColumns(), src.getNonZeros(), OutputInfo.CSVOutputInfo) / InfrastructureAnalyzer.getHDFSBlockSize());
        numPartFiles = Math.max(numPartFiles, 1);
        int numThreads = OptimizerUtils.getParallelTextWriteParallelism();
        if ((numThreads = Math.min(numThreads, numPartFiles)) <= 1) {
            super.writeCSVMatrixToHDFS(path, job, fs, src, csvprops);
            return;
        }
        MapReduceTool.createDirIfNotExistOnHDFS(path, "777");
        try {
            ExecutorService pool = Executors.newFixedThreadPool(numThreads);
            ArrayList<WriteCSVTask> tasks = new ArrayList<WriteCSVTask>();
            int rlen = src.getNumRows();
            int blklen = (int)Math.ceil((double)rlen / (double)numThreads);
            int i = 0;
            while (i < numThreads & i * blklen < rlen) {
                Path newPath = new Path(path, IOUtilFunctions.getPartFileName(i));
                tasks.add(new WriteCSVTask(newPath, job, fs, src, i * blklen, Math.min((i + 1) * blklen, rlen), csvprops));
                ++i;
            }
            List rt = pool.invokeAll(tasks);
            pool.shutdown();
            for (Future future : rt) {
                future.get();
            }
            if (fs instanceof LocalFileSystem) {
                int i2 = 0;
                while (i2 < numThreads & i2 * blklen < rlen) {
                    IOUtilFunctions.deleteCrcFilesFromLocalFileSystem(fs, new Path(path, IOUtilFunctions.getPartFileName(i2)));
                    ++i2;
                }
            }
        }
        catch (Exception e) {
            throw new IOException("Failed parallel write of csv output.", e);
        }
    }

    private class WriteCSVTask
    implements Callable<Object> {
        private JobConf _job = null;
        private FileSystem _fs = null;
        private MatrixBlock _src = null;
        private Path _path = null;
        private int _rl = -1;
        private int _ru = -1;
        private CSVFileFormatProperties _props = null;

        public WriteCSVTask(Path path, JobConf job, FileSystem fs, MatrixBlock src, int rl, int ru, CSVFileFormatProperties props) {
            this._path = path;
            this._job = job;
            this._fs = fs;
            this._src = src;
            this._rl = rl;
            this._ru = ru;
            this._props = props;
        }

        @Override
        public Object call() throws Exception {
            WriterTextCSVParallel.this.writeCSVMatrixToFile(this._path, this._job, this._fs, this._src, this._rl, this._ru, this._props);
            return null;
        }
    }
}

